/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.graph;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import soot.toolkits.graph.DirectedGraph;
import soot.toolkits.graph.DominatorsFinder;
import soot.toolkits.graph.SimpleDominatorsAnalysis;
import soot.toolkits.scalar.FlowSet;

public class SimpleDominatorsFinder
implements DominatorsFinder {
    protected DirectedGraph graph;
    protected Map<Object, FlowSet> nodeToDominators;

    public SimpleDominatorsFinder(DirectedGraph graph) {
        this.graph = graph;
        SimpleDominatorsAnalysis analysis = new SimpleDominatorsAnalysis(graph);
        this.nodeToDominators = new HashMap<Object, FlowSet>(graph.size() * 2 + 1, 0.7f);
        for (Object node : graph) {
            FlowSet set = (FlowSet)analysis.getFlowAfter(node);
            this.nodeToDominators.put(node, set);
        }
    }

    public DirectedGraph getGraph() {
        return this.graph;
    }

    public List getDominators(Object node) {
        return this.nodeToDominators.get(node).toList();
    }

    public Object getImmediateDominator(Object node) {
        if (this.getGraph().getHeads().contains(node)) {
            return null;
        }
        List dominatorsList = this.getDominators(node);
        dominatorsList.remove(node);
        Iterator dominatorsIt = dominatorsList.iterator();
        Object immediateDominator = null;
        while (immediateDominator == null && dominatorsIt.hasNext()) {
            Object dominator = dominatorsIt.next();
            if (!this.isDominatedByAll(dominator, (Collection)dominatorsList)) continue;
            immediateDominator = dominator;
        }
        if (immediateDominator == null) {
            throw new RuntimeException("Assertion failed.");
        }
        return immediateDominator;
    }

    public boolean isDominatedBy(Object node, Object dominator) {
        return this.getDominators(node).contains(dominator);
    }

    public boolean isDominatedByAll(Object node, Collection dominators) {
        return this.getDominators(node).containsAll(dominators);
    }
}

