/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.graph;

import java.util.Set;
import soot.Body;
import soot.Trap;
import soot.Unit;
import soot.toolkits.graph.BlockGraph;
import soot.toolkits.graph.BriefUnitGraph;
import soot.toolkits.graph.UnitGraph;

public class ZonedBlockGraph
extends BlockGraph {
    public ZonedBlockGraph(Body body) {
        this(new BriefUnitGraph(body));
    }

    public ZonedBlockGraph(BriefUnitGraph unitGraph) {
        super(unitGraph);
    }

    @Override
    protected Set<Unit> computeLeaders(UnitGraph unitGraph) {
        Body body = unitGraph.getBody();
        if (body != this.mBody) {
            throw new RuntimeException("ZonedBlockGraph.computeLeaders() called with a UnitGraph that doesn't match its mBody.");
        }
        Set<Unit> leaders = super.computeLeaders(unitGraph);
        for (Trap trap : body.getTraps()) {
            leaders.add(trap.getBeginUnit());
            leaders.add(trap.getEndUnit());
        }
        return leaders;
    }
}

