/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.scalar;

import java.util.Iterator;
import java.util.List;
import soot.toolkits.scalar.FlowSet;

public abstract class AbstractFlowSet
implements FlowSet,
Iterable {
    @Override
    public abstract AbstractFlowSet clone();

    @Override
    public Object emptySet() {
        AbstractFlowSet t = this.clone();
        t.clear();
        return t;
    }

    @Override
    public void copy(FlowSet dest) {
        List elements = this.toList();
        Iterator it = elements.iterator();
        dest.clear();
        while (it.hasNext()) {
            dest.add(it.next());
        }
    }

    @Override
    public void clear() {
        Iterator it = this.toList().iterator();
        while (it.hasNext()) {
            this.remove(it.next());
        }
    }

    @Override
    public void union(FlowSet other) {
        this.union(other, this);
    }

    @Override
    public void union(FlowSet other, FlowSet dest) {
        if (dest != this && dest != other) {
            dest.clear();
        }
        if (dest != this) {
            Iterator thisIt = this.toList().iterator();
            while (thisIt.hasNext()) {
                dest.add(thisIt.next());
            }
        }
        if (dest != other) {
            Iterator otherIt = other.toList().iterator();
            while (otherIt.hasNext()) {
                dest.add(otherIt.next());
            }
        }
    }

    @Override
    public void intersection(FlowSet other) {
        this.intersection(other, this);
    }

    @Override
    public void intersection(FlowSet other, FlowSet dest) {
        if (dest == this && dest == other) {
            return;
        }
        List elements = null;
        FlowSet flowSet = null;
        if (dest == this) {
            elements = this.toList();
            flowSet = other;
        } else {
            elements = other.toList();
            flowSet = this;
        }
        dest.clear();
        for (Object o : elements) {
            if (!flowSet.contains(o)) continue;
            dest.add(o);
        }
    }

    @Override
    public void difference(FlowSet other) {
        this.difference(other, this);
    }

    @Override
    public void difference(FlowSet other, FlowSet dest) {
        if (dest == this && dest == other) {
            dest.clear();
            return;
        }
        Iterator it = this.toList().iterator();
        FlowSet flowSet = other == dest ? other.clone() : other;
        dest.clear();
        while (it.hasNext()) {
            Object o = it.next();
            if (flowSet.contains(o)) continue;
            dest.add(o);
        }
    }

    @Override
    public abstract boolean isEmpty();

    @Override
    public abstract int size();

    @Override
    public abstract void add(Object var1);

    @Override
    public void add(Object obj, FlowSet dest) {
        if (dest != this) {
            this.copy(dest);
        }
        dest.add(obj);
    }

    @Override
    public abstract void remove(Object var1);

    @Override
    public void remove(Object obj, FlowSet dest) {
        if (dest != this) {
            this.copy(dest);
        }
        dest.remove(obj);
    }

    @Override
    public abstract boolean contains(Object var1);

    @Override
    public Iterator iterator() {
        return this.toList().iterator();
    }

    @Override
    public abstract List toList();

    public boolean equals(Object o) {
        if (!(o instanceof FlowSet)) {
            return false;
        }
        FlowSet other = (FlowSet)o;
        if (this.size() != other.size()) {
            return false;
        }
        Iterator it = this.toList().iterator();
        while (it.hasNext()) {
            if (other.contains(it.next())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        for (Object o : this) {
            result = 31 * result + o.hashCode();
        }
        return result;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("{");
        Iterator it = this.toList().iterator();
        if (it.hasNext()) {
            buffer.append(it.next());
            while (it.hasNext()) {
                buffer.append(", " + it.next());
            }
        }
        buffer.append("}");
        return buffer.toString();
    }
}

