/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.scalar;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import soot.Unit;
import soot.toolkits.graph.DirectedGraph;
import soot.toolkits.scalar.AbstractFlowAnalysis;

public abstract class BranchedFlowAnalysis<N extends Unit, A>
extends AbstractFlowAnalysis<N, A> {
    protected Map<Unit, ArrayList<A>> unitToAfterFallFlow;
    protected Map<Unit, ArrayList<A>> unitToAfterBranchFlow;

    public BranchedFlowAnalysis(DirectedGraph<N> graph) {
        super(graph);
        this.unitToAfterFallFlow = new HashMap<Unit, ArrayList<A>>(graph.size() * 2 + 1, 0.7f);
        this.unitToAfterBranchFlow = new HashMap<Unit, ArrayList<A>>(graph.size() * 2 + 1, 0.7f);
    }

    protected abstract void flowThrough(A var1, Unit var2, List<A> var3, List<A> var4);

    public A getFallFlowAfter(Unit s) {
        List fl = this.unitToAfterFallFlow.get(s);
        if (fl.isEmpty()) {
            return this.newInitialFlow();
        }
        return (A)fl.get(0);
    }

    public List<A> getBranchFlowAfter(Unit s) {
        return this.unitToAfterBranchFlow.get(s);
    }

    @Override
    public A getFlowBefore(Unit s) {
        return (A)this.unitToBeforeFlow.get(s);
    }
}

