/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.scalar;

import java.util.HashMap;
import java.util.Map;
import soot.Local;
import soot.Timers;
import soot.Unit;
import soot.ValueBox;
import soot.options.Options;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.scalar.ArraySparseSet;
import soot.toolkits.scalar.BackwardFlowAnalysis;
import soot.toolkits.scalar.FlowSet;

class SimpleLiveLocalsAnalysis
extends BackwardFlowAnalysis {
    FlowSet emptySet;
    Map<Unit, FlowSet> unitToGenerateSet;
    Map<Unit, FlowSet> unitToKillSet;

    SimpleLiveLocalsAnalysis(UnitGraph g) {
        super(g);
        if (Options.v().time()) {
            Timers.v().liveSetupTimer.start();
        }
        this.emptySet = new ArraySparseSet();
        this.unitToKillSet = new HashMap<Unit, FlowSet>(g.size() * 2 + 1, 0.7f);
        for (Unit s : g) {
            FlowSet killSet = this.emptySet.clone();
            for (ValueBox box : s.getDefBoxes()) {
                if (!(box.getValue() instanceof Local)) continue;
                killSet.add(box.getValue(), killSet);
            }
            this.unitToKillSet.put(s, killSet);
        }
        this.unitToGenerateSet = new HashMap<Unit, FlowSet>(g.size() * 2 + 1, 0.7f);
        for (Unit s : g) {
            FlowSet genSet = this.emptySet.clone();
            for (ValueBox box : s.getUseBoxes()) {
                if (!(box.getValue() instanceof Local)) continue;
                genSet.add(box.getValue(), genSet);
            }
            this.unitToGenerateSet.put(s, genSet);
        }
        if (Options.v().time()) {
            Timers.v().liveSetupTimer.end();
        }
        if (Options.v().time()) {
            Timers.v().liveAnalysisTimer.start();
        }
        this.doAnalysis();
        if (Options.v().time()) {
            Timers.v().liveAnalysisTimer.end();
        }
    }

    @Override
    protected Object newInitialFlow() {
        return this.emptySet.clone();
    }

    @Override
    protected Object entryInitialFlow() {
        return this.emptySet.clone();
    }

    @Override
    protected void flowThrough(Object inValue, Object unit, Object outValue) {
        FlowSet in = (FlowSet)inValue;
        FlowSet out = (FlowSet)outValue;
        in.difference(this.unitToKillSet.get(unit), out);
        out.union(this.unitToGenerateSet.get(unit), out);
    }

    @Override
    protected void merge(Object in1, Object in2, Object out) {
        FlowSet inSet1 = (FlowSet)in1;
        FlowSet inSet2 = (FlowSet)in2;
        FlowSet outSet = (FlowSet)out;
        inSet1.union(inSet2, outSet);
    }

    @Override
    protected void copy(Object source, Object dest) {
        FlowSet sourceSet = (FlowSet)source;
        FlowSet destSet = (FlowSet)dest;
        sourceSet.copy(destSet);
    }
}

