/*
 * Decompiled with CFR 0.152.
 */
package com.mobilefuse.sdk;

import com.mobilefuse.sdk.ExtendedAdType;
import com.mobilefuse.sdk.config.ObservableConfig;

public class AdRendererConfig {
    private String sdkName;
    private String sdkVersion;
    private String advertisingId;
    private boolean limitTrackingEnabled;
    private boolean subjectToCoppa;
    private boolean testMode;
    private boolean fullscreenAd;
    private boolean closeButtonEnabled;
    private boolean thumbnailSize;
    private boolean transparentBackground;
    private int adWidth = -1;
    private int adHeight = -1;
    private String deviceIp;
    private ExtendedAdType extendedAdType;
    private ObservableConfig observableConfig;

    AdRendererConfig() {
    }

    public boolean isFullscreenAd() {
        return this.fullscreenAd;
    }

    public boolean isThumbnailSize() {
        return this.thumbnailSize;
    }

    public boolean isCloseButtonEnabled() {
        return this.closeButtonEnabled;
    }

    public String getSdkName() {
        return this.sdkName;
    }

    public String getSdkVersion() {
        return this.sdkVersion;
    }

    public String getAdvertisingId() {
        return this.advertisingId;
    }

    public boolean isLimitTrackingEnabled() {
        return this.limitTrackingEnabled;
    }

    public boolean isSubjectToCoppa() {
        return this.subjectToCoppa;
    }

    public boolean isTestMode() {
        return this.testMode;
    }

    public int getAdWidth() {
        return this.adWidth;
    }

    public int getAdHeight() {
        return this.adHeight;
    }

    public String getDeviceIp() {
        return this.deviceIp;
    }

    public boolean isTransparentBackground() {
        return this.transparentBackground;
    }

    public ExtendedAdType getExtendedAdType() {
        return this.extendedAdType;
    }

    public ObservableConfig getObservableConfig() {
        return this.observableConfig;
    }

    public static class Builder {
        private AdRendererConfig config = new AdRendererConfig();

        public String getSdkName() {
            return this.config.sdkName;
        }

        public String getSdkVersion() {
            return this.config.sdkVersion;
        }

        public String getAdvertisingId() {
            return this.config.advertisingId;
        }

        public boolean isLimitTrackingEnabled() {
            return this.config.limitTrackingEnabled;
        }

        public boolean isSubjectToCoppa() {
            return this.config.subjectToCoppa;
        }

        public boolean isTestMode() {
            return this.config.testMode;
        }

        public boolean isFullscreenAd() {
            return this.config.fullscreenAd;
        }

        public Builder setFullscreenAd(boolean fullscreenAd) {
            this.config.fullscreenAd = fullscreenAd;
            return this;
        }

        public boolean isThumbnailSize() {
            return this.config.thumbnailSize;
        }

        public Builder setThumbnailSize(boolean thumbnailSize) {
            this.config.thumbnailSize = thumbnailSize;
            return this;
        }

        public boolean isCloseButtonEnabled() {
            return this.config.closeButtonEnabled;
        }

        public Builder setCloseButtonEnabled(boolean closeButtonEnabled) {
            this.config.closeButtonEnabled = closeButtonEnabled;
            return this;
        }

        public Builder setSdkName(String sdkName) {
            this.config.sdkName = sdkName;
            return this;
        }

        public Builder setSdkVersion(String sdkVersion) {
            this.config.sdkVersion = sdkVersion;
            return this;
        }

        public Builder setAdvertisingId(String advertisingId) {
            this.config.advertisingId = advertisingId;
            return this;
        }

        public Builder setLimitTrackingEnabled(boolean limitTrackingEnabled) {
            this.config.limitTrackingEnabled = limitTrackingEnabled;
            return this;
        }

        public Builder setSubjectToCoppa(boolean coppa) {
            this.config.subjectToCoppa = coppa;
            return this;
        }

        public Builder setTestMode(boolean testMode) {
            this.config.testMode = testMode;
            return this;
        }

        public Builder setAdHeight(int adHeight) {
            this.config.adHeight = adHeight;
            return this;
        }

        public Builder setAdWidth(int adWidth) {
            this.config.adWidth = adWidth;
            return this;
        }

        public String getDeviceIp() {
            return this.config.deviceIp;
        }

        public Builder setDeviceIp(String deviceIp) {
            this.config.deviceIp = deviceIp;
            return this;
        }

        public Builder setTransparentBackground(boolean transparentBackground) {
            this.config.transparentBackground = transparentBackground;
            return this;
        }

        public boolean isTransparentBackground() {
            return this.config.transparentBackground;
        }

        public ExtendedAdType getExtendedAdType() {
            return this.config.extendedAdType;
        }

        public Builder setExtendedAdType(ExtendedAdType extendedAdType) {
            this.config.extendedAdType = extendedAdType;
            return this;
        }

        public ObservableConfig getObservableConfig() {
            return this.config.observableConfig;
        }

        public Builder setObservableConfig(ObservableConfig observableConfig) {
            this.config.observableConfig = observableConfig;
            return this;
        }

        public AdRendererConfig build() {
            return this.config;
        }
    }
}

