/*
 * Decompiled with CFR 0.152.
 */
package com.mobilefuse.sdk;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.mobilefuse.sdk.StabilityHelper;

public class AdRendererContainer
extends RelativeLayout {
    private ProgressBar progressBar;
    private Handler handler = new Handler(Looper.getMainLooper());
    private Runnable delayedProgressBarTask = () -> {
        try {
            this.showProgressBar();
        }
        catch (Throwable e) {
            StabilityHelper.logException((Object)this, e);
        }
    };
    private Runnable attachedToWindowCallback;
    private Runnable detachedFromWindowCallback;

    public AdRendererContainer(@NonNull Context context) {
        super(context);
    }

    public AdRendererContainer(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public AdRendererContainer(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @RequiresApi(api=21)
    public AdRendererContainer(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    public void showProgressBarWithDelay(long delayMillis) throws Throwable {
        this.handler.postDelayed(this.delayedProgressBarTask, delayMillis);
    }

    public void showProgressBar() throws Throwable {
        this.handler.removeCallbacks(this.delayedProgressBarTask);
        if (this.progressBar != null) {
            return;
        }
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
        params.addRule(13);
        this.progressBar = new ProgressBar(this.getContext());
        this.addView((View)this.progressBar, (ViewGroup.LayoutParams)params);
    }

    public void hideProgressBar() throws Throwable {
        this.handler.removeCallbacks(this.delayedProgressBarTask);
        if (this.progressBar == null) {
            return;
        }
        this.removeView((View)this.progressBar);
        this.progressBar = null;
    }

    protected void onAttachedToWindow() {
        Log.d((String)"MF sdk", (String)"onAttachedToWindow");
        super.onAttachedToWindow();
        try {
            if (this.attachedToWindowCallback != null) {
                this.attachedToWindowCallback.run();
            }
        }
        catch (Throwable e) {
            StabilityHelper.logException((Object)this, e);
        }
    }

    protected void onDetachedFromWindow() {
        Log.d((String)"MF sdk", (String)"onDetachedFromWindow");
        try {
            if (this.detachedFromWindowCallback != null) {
                this.detachedFromWindowCallback.run();
            }
        }
        catch (Throwable e) {
            StabilityHelper.logException((Object)this, e);
        }
        super.onDetachedFromWindow();
    }

    public Runnable getAttachedToWindowCallback() {
        return this.attachedToWindowCallback;
    }

    public void setAttachedToWindowCallback(Runnable attachedToWindowCallback) throws Throwable {
        this.attachedToWindowCallback = attachedToWindowCallback;
    }

    public Runnable getDetachedFromWindowCallback() {
        return this.detachedFromWindowCallback;
    }

    public void setDetachedFromWindowCallback(Runnable detachedFromWindowCallback) {
        this.detachedFromWindowCallback = detachedFromWindowCallback;
    }
}

