/*
 * Decompiled with CFR 0.152.
 */
package com.mobilefuse.sdk;

import android.app.Activity;
import android.content.Context;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mobilefuse.sdk.AdLifecycleEvent;
import com.mobilefuse.sdk.AdLifecycleEventListener;
import com.mobilefuse.sdk.AdRendererConfig;
import com.mobilefuse.sdk.AdRendererContainer;
import com.mobilefuse.sdk.AdRendererListener;
import com.mobilefuse.sdk.AppLifecycleHelper;
import com.mobilefuse.sdk.BaseAdLifecycleEvent;
import com.mobilefuse.sdk.BaseExtendedAdType;
import com.mobilefuse.sdk.ExtendedAdType;
import com.mobilefuse.sdk.StabilityHelper;
import com.mobilefuse.sdk.Utils;
import com.mobilefuse.sdk.ad.rendering.ExtendedController;
import com.mobilefuse.sdk.config.ObservableConfig;
import com.mobilefuse.sdk.config.ObservableConfigKey;
import com.mobilefuse.sdk.config.Observer;
import com.mobilefuse.sdk.internal.RtbLossReason;
import com.mobilefuse.sdk.omid.OmidBridge;
import java.util.Map;

public abstract class BaseAdRenderer<T extends OmidBridge> {
    protected String adm;
    protected State state = State.IDLE;
    protected AdRendererContainer contentContainer;
    protected AdRendererConfig config;
    protected Context context;
    @Nullable
    protected Activity renderingActivity;
    protected AdRendererListener listener;
    protected boolean impressionCallbackCalled = false;
    protected int adBackgroundColor = -16777216;
    protected T omidBridge;
    protected AdLifecycleEventListener adLifecycleEventListener;
    protected ExtendedAdType extendedAdType = BaseExtendedAdType.NORMAL;
    protected ObservableConfig observableConfig;
    protected Observer configObserver;
    private AppLifecycleHelper.ActivityLifecycleObserver activityLifecycleObserver;
    protected ExtendedController extendedController;
    @Nullable
    private View layoutChangeListenerOwner;
    @Nullable
    private View.OnLayoutChangeListener layoutChangeListener;

    public BaseAdRenderer(Context context, AdRendererConfig config, AdRendererListener listener) throws Throwable {
        this.context = context;
        this.config = config;
        this.listener = listener;
        if (config.getExtendedAdType() != null) {
            this.extendedAdType = config.getExtendedAdType();
        }
        this.observableConfig = config.getObservableConfig();
        if (this.observableConfig != null) {
            this.observableConfig.setValue(ObservableConfigKey.SKIP_AD_AVAILABLE, false);
            this.configObserver = this::onConfigPropertyChanged;
            this.observableConfig.registerObserver(this.configObserver);
        }
    }

    public final void preloadAd(String adm) throws Throwable {
        this.adm = adm;
        this.onAdLifecycleEvent(BaseAdLifecycleEvent.AD_PRELOAD_STARTED);
        this.preloadAdmImpl(adm);
    }

    public final void renderAd() throws Throwable {
        this.state = State.RENDERING;
        this.onAdLifecycleEvent(BaseAdLifecycleEvent.AD_RENDERED);
        this.renderAdmImpl();
        this.stopListeningLayoutChange();
        this.startListeningLayoutChange();
    }

    protected void onAdPreloaded() throws Throwable {
        this.state = State.PRELOADED;
        this.onAdLifecycleEvent(BaseAdLifecycleEvent.AD_PRELOAD_COMPLETE);
        this.listener.onPreloadStatusChange(true);
    }

    protected void onAdLifecycleEvent(AdLifecycleEvent event) throws Throwable {
        this.onAdLifecycleEvent(event, null);
    }

    protected void onAdLifecycleEvent(AdLifecycleEvent event, Map<String, String> extraParams) throws Throwable {
        ExtendedAdType extendedAdType = this.getExtendedAdType();
        if (this.adLifecycleEventListener != null) {
            this.adLifecycleEventListener.onAdLifecycleEvent(event, extendedAdType, extraParams);
        }
    }

    protected void startActivityLifecycleChecking() throws Throwable {
        if (this.activityLifecycleObserver == null) {
            this.activityLifecycleObserver = new AppLifecycleHelper.ActivityLifecycleObserver(){

                @Override
                public void onActivityResumed(@NonNull Activity activity) {
                    try {
                        if (BaseAdRenderer.this.renderingActivity == null) {
                            return;
                        }
                        if (BaseAdRenderer.this.renderingActivity != activity) {
                            return;
                        }
                        BaseAdRenderer.this.onActivityResumeImpl();
                    }
                    catch (Throwable e) {
                        StabilityHelper.logException(this, e);
                    }
                }

                @Override
                public void onActivityPaused(@NonNull Activity activity) {
                    try {
                        if (BaseAdRenderer.this.renderingActivity == null) {
                            return;
                        }
                        if (BaseAdRenderer.this.renderingActivity != activity) {
                            return;
                        }
                        BaseAdRenderer.this.onActivityPauseImpl();
                    }
                    catch (Throwable e) {
                        StabilityHelper.logException(this, e);
                    }
                }
            };
        }
        AppLifecycleHelper.addActivityLifecycleObserver(this.activityLifecycleObserver);
    }

    protected void onActivityResumeImpl() throws Throwable {
    }

    protected void onActivityPauseImpl() throws Throwable {
    }

    private void stopActivityLifecycleChecking() throws Throwable {
        if (this.activityLifecycleObserver == null) {
            return;
        }
        AppLifecycleHelper.removeActivityLifecycleObserver(this.activityLifecycleObserver);
        this.activityLifecycleObserver = null;
    }

    public boolean isTransparentBackground() throws Throwable {
        return this.config.isTransparentBackground();
    }

    public final ExtendedAdType getExtendedAdType() {
        return this.extendedAdType;
    }

    public void setOmidBridge(T omidBridge) throws Throwable {
        this.omidBridge = omidBridge;
    }

    public boolean hasOmidBridge() {
        return this.omidBridge != null;
    }

    protected boolean isOmidBridgeAvailable() {
        return this.omidBridge != null;
    }

    public abstract View getAdView() throws Throwable;

    protected abstract void preloadAdmImpl(String var1) throws Throwable;

    protected abstract void renderAdmImpl() throws Throwable;

    protected void onConfigPropertyChanged(ObservableConfigKey key, Object value) throws Throwable {
    }

    protected void destroyOmidBridge() throws Throwable {
        if (this.hasOmidBridge()) {
            this.omidBridge.finishAdSession();
            this.omidBridge = null;
        }
    }

    public void destroy() throws Throwable {
        this.stopActivityLifecycleChecking();
        this.stopListeningLayoutChange();
        if (this.configObserver != null && this.observableConfig != null) {
            this.observableConfig.unregisterObserver(this.configObserver);
            this.observableConfig = null;
        }
        this.destroyOmidBridge();
        this.renderingActivity = null;
    }

    public AdLifecycleEventListener getAdLifecycleEventListener() {
        return this.adLifecycleEventListener;
    }

    public void setAdLifecycleEventListener(AdLifecycleEventListener adLifecycleEventListener) throws Throwable {
        this.adLifecycleEventListener = adLifecycleEventListener;
        if (this.extendedController != null) {
            this.extendedController.setAdLifecycleEventListener(adLifecycleEventListener);
        }
    }

    public boolean isAdPreloaded() {
        return this.state == State.PRELOADED;
    }

    public final void setRenderingActivity(@NonNull Activity activity) throws Throwable {
        this.renderingActivity = activity;
    }

    public boolean isVisibleOnScreen() {
        try {
            View adView = this.getAdView();
            if (adView == null) {
                return false;
            }
            return Utils.isAttachedToWindow(adView);
        }
        catch (Throwable e) {
            StabilityHelper.logException(this, e);
            return false;
        }
    }

    public void onActivityStart() throws Throwable {
    }

    public void onActivityResume() throws Throwable {
    }

    public void onActivityPause() throws Throwable {
    }

    public void onActivityStop() throws Throwable {
    }

    public void onActivityDestroy() throws Throwable {
    }

    void requestAdClose() throws Throwable {
        if (this.onAdCloseRequested()) {
            this.onAdClosed();
        }
    }

    protected boolean onAdCloseRequested() {
        return true;
    }

    protected void onAdClosed() throws Throwable {
        this.onAdLifecycleEvent(BaseAdLifecycleEvent.AD_CLOSED);
        this.listener.onAdClosed();
        this.state = State.IDLE;
    }

    protected void dispatchSkipAdAvailability() {
        try {
            ObservableConfig config = this.observableConfig;
            if (config == null) {
                return;
            }
            if (config.getBooleanValue(ObservableConfigKey.SKIP_AD_AVAILABLE)) {
                return;
            }
            config.setValue(ObservableConfigKey.SKIP_AD_AVAILABLE, true);
        }
        catch (Throwable e) {
            StabilityHelper.logException(this, e);
        }
    }

    protected void onAdRuntimeError(RtbLossReason error) throws Throwable {
        this.listener.onAdRuntimeError(error);
    }

    protected void startListeningLayoutChange() throws Throwable {
        try {
            View viewToObserve = this.contentContainer.getRootView();
            if (this.renderingActivity != null) {
                viewToObserve = this.renderingActivity.getWindow().getDecorView().getRootView();
            }
            if (viewToObserve == null) {
                return;
            }
            if (this.layoutChangeListenerOwner == viewToObserve) {
                return;
            }
            this.layoutChangeListener = this.getOnLayoutChangeListener(this.context);
            this.layoutChangeListenerOwner = viewToObserve;
            viewToObserve.addOnLayoutChangeListener(this.layoutChangeListener);
        }
        catch (Throwable ex) {
            StabilityHelper.logException(this, ex);
        }
    }

    protected void stopListeningLayoutChange() throws Throwable {
        try {
            if (this.layoutChangeListenerOwner != null) {
                this.layoutChangeListenerOwner.removeOnLayoutChangeListener(this.layoutChangeListener);
                this.layoutChangeListenerOwner = null;
                this.layoutChangeListener = null;
            }
        }
        catch (Throwable ex) {
            StabilityHelper.logException(this, ex);
        }
    }

    protected abstract View.OnLayoutChangeListener getOnLayoutChangeListener(Context var1) throws Throwable;

    protected void reportAdImpression() {
        if (this.impressionCallbackCalled) {
            return;
        }
        this.impressionCallbackCalled = true;
        try {
            if (this.listener != null) {
                this.listener.onAdImpression();
            }
        }
        catch (Throwable e) {
            StabilityHelper.logException(this, e);
        }
    }

    public int getAdBackgroundColor() {
        return this.adBackgroundColor;
    }

    public void setAdBackgroundColor(int adBackgroundColor) throws Throwable {
        if (adBackgroundColor == -1) {
            return;
        }
        if (this.adBackgroundColor == adBackgroundColor) {
            return;
        }
        this.adBackgroundColor = adBackgroundColor;
        this.applyCurrentBackgroundColor();
    }

    protected void applyCurrentBackgroundColor() throws Throwable {
    }

    public static enum State {
        IDLE,
        PRELOADED,
        RENDERING;

    }
}

