/*
 * Decompiled with CFR 0.152.
 */
package com.mobilefuse.sdk;

import android.annotation.SuppressLint;
import android.content.Context;
import android.location.Location;
import android.location.LocationManager;
import androidx.annotation.Nullable;
import com.mobilefuse.sdk.AppLifecycleHelper;
import com.mobilefuse.sdk.StabilityHelper;
import com.mobilefuse.sdk.Utils;

@SuppressLint(value={"MissingPermission"})
public class LocationService {
    private static boolean enabled = true;
    private static final long locationValidTime = 900000L;
    @Nullable
    private static Location lastLocation;
    private static long lastLocationRefreshTimestamp;

    @Nullable
    public static synchronized Location getLastKnownLocation() throws Throwable {
        Context context = AppLifecycleHelper.getGlobalContext();
        if (!enabled) {
            return null;
        }
        if (AppLifecycleHelper.getCurrentActivity() == null) {
            return null;
        }
        if (!AppLifecycleHelper.isAppInForeground()) {
            return null;
        }
        long timestamp = System.currentTimeMillis();
        if (timestamp - lastLocationRefreshTimestamp <= 900000L && lastLocation != null) {
            return lastLocation;
        }
        try {
            LocationManager locationManager = (LocationManager)context.getSystemService("location");
            Location location = LocationService.getLocationFromGpsProvider(context, locationManager);
            if (location == null) {
                location = LocationService.getLocationFromNetworkProvider(context, locationManager);
            }
            if (location == null) {
                return null;
            }
            lastLocation = location;
            lastLocationRefreshTimestamp = timestamp;
            return location;
        }
        catch (Throwable ex) {
            StabilityHelper.logException(LocationService.class, ex);
            return null;
        }
    }

    private static Location getLocationFromGpsProvider(Context context, LocationManager locationManager) throws Throwable {
        if (!Utils.hasManifestPermission(context, "android.permission.ACCESS_FINE_LOCATION")) {
            return null;
        }
        return locationManager.getLastKnownLocation("gps");
    }

    private static Location getLocationFromNetworkProvider(Context context, LocationManager locationManager) throws Throwable {
        boolean hasPermission = Utils.hasManifestPermission(context, "android.permission.ACCESS_COARSE_LOCATION");
        if (!hasPermission) {
            hasPermission = Utils.hasManifestPermission(context, "android.permission.ACCESS_FINE_LOCATION");
        }
        if (!hasPermission) {
            return null;
        }
        return locationManager.getLastKnownLocation("network");
    }

    static boolean isEnabled() {
        return enabled;
    }

    static void setEnabled(boolean enabled) {
        LocationService.enabled = enabled;
        if (!enabled) {
            lastLocation = null;
            lastLocationRefreshTimestamp = 0L;
        }
    }
}

