/*
 * Decompiled with CFR 0.152.
 */
package com.mobilefuse.sdk.ad.rendering;

import android.app.Activity;
import android.view.View;
import com.mobilefuse.sdk.AdLifecycleEvent;
import com.mobilefuse.sdk.AdLifecycleEventListener;
import com.mobilefuse.sdk.ExtendedAdType;
import java.util.Map;
import org.json.JSONObject;

public abstract class ExtendedController {
    protected int adWidth = -1;
    protected int adHeight = -1;
    protected View adContent;
    protected Activity activity;
    private AdCloseListener adCloseListener;
    protected AdLifecycleEventListener adLifecycleEventListener;

    public void setConfig(JSONObject configJson) throws Throwable {
        if (configJson.has("adWidth")) {
            this.adWidth = configJson.getInt("adWidth");
        }
        if (configJson.has("adHeight")) {
            this.adHeight = configJson.getInt("adHeight");
        }
    }

    public void bindContent(View adContent, Activity activity) throws Throwable {
        this.adContent = adContent;
        this.activity = activity;
        this.bindContentImpl(adContent, activity);
    }

    protected abstract void bindContentImpl(View var1, Activity var2) throws Throwable;

    public void unbindContent() throws Throwable {
        this.unbindContentImpl();
    }

    protected abstract void unbindContentImpl() throws Throwable;

    public int getAdWidth() {
        return this.adWidth;
    }

    public void setAdWidth(int adWidth) {
        this.adWidth = adWidth;
    }

    public int getAdHeight() {
        return this.adHeight;
    }

    public void setAdHeight(int adHeight) {
        this.adHeight = adHeight;
    }

    public void invalidateLayout() throws Throwable {
    }

    public void onAdmLoaded() throws Throwable {
    }

    public final void requestAdClose(AdCloseListener adCloseListener) throws Throwable {
        this.adCloseListener = adCloseListener;
        this.onAdCloseRequested();
    }

    protected abstract void onAdCloseRequested() throws Throwable;

    protected final void onAdReadyToClose() throws Throwable {
        if (this.adCloseListener != null) {
            this.adCloseListener.onAdClosed();
            this.adCloseListener = null;
        }
    }

    protected void onAdLifecycleEvent(AdLifecycleEvent event) throws Throwable {
        this.onAdLifecycleEvent(event, null);
    }

    protected void onAdLifecycleEvent(AdLifecycleEvent event, Map<String, String> extraParams) throws Throwable {
        ExtendedAdType extendedAdType = this.getExtendedAdType();
        if (this.adLifecycleEventListener != null) {
            this.adLifecycleEventListener.onAdLifecycleEvent(event, extendedAdType, extraParams);
        }
    }

    public abstract ExtendedAdType getExtendedAdType() throws Throwable;

    public AdLifecycleEventListener getAdLifecycleEventListener() {
        return this.adLifecycleEventListener;
    }

    public void setAdLifecycleEventListener(AdLifecycleEventListener adLifecycleEventListener) {
        this.adLifecycleEventListener = adLifecycleEventListener;
    }

    public static interface AdCloseListener {
        public void onAdClosed() throws Throwable;
    }
}

