/*
 * Decompiled with CFR 0.152.
 */
package com.mobilefuse.sdk.ad.rendering;

import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.RelativeLayout;
import androidx.annotation.RequiresApi;
import com.mobilefuse.sdk.StabilityHelper;
import com.mobilefuse.sdk.internal.Callback;

public class FloatingContainer
extends RelativeLayout {
    private View.OnTouchListener floatingTouchListener;
    private boolean touchInteractionEnabled = true;
    private Callback<Boolean> onTouchInteractionEnabledChanged = null;

    public FloatingContainer(Context context) throws Throwable {
        super(context);
    }

    public FloatingContainer(Context context, AttributeSet attrs) throws Throwable {
        super(context, attrs);
    }

    public FloatingContainer(Context context, AttributeSet attrs, int defStyleAttr) throws Throwable {
        super(context, attrs, defStyleAttr);
    }

    @RequiresApi(api=21)
    public FloatingContainer(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) throws Throwable {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        if (!this.touchInteractionEnabled) {
            return false;
        }
        return super.dispatchTouchEvent(ev);
    }

    public boolean onInterceptTouchEvent(MotionEvent event) {
        try {
            if (this.floatingTouchListener != null) {
                this.floatingTouchListener.onTouch((View)this, event);
            }
        }
        catch (Throwable e) {
            StabilityHelper.logException((Object)this, e);
        }
        return false;
    }

    public void setFloatingTouchListener(View.OnTouchListener floatingTouchListener) {
        this.floatingTouchListener = floatingTouchListener;
    }

    public boolean isTouchInteractionEnabled() {
        return this.touchInteractionEnabled;
    }

    public void setTouchInteractionEnabled(boolean touchInteractionEnabled) {
        this.touchInteractionEnabled = touchInteractionEnabled;
        if (this.onTouchInteractionEnabledChanged != null) {
            try {
                this.onTouchInteractionEnabledChanged.call(touchInteractionEnabled);
            }
            catch (Throwable e) {
                StabilityHelper.logException((Object)this, e);
            }
        }
    }

    public void setOnTouchInteractionEnabledChanged(Callback<Boolean> onTouchInteractionEnabledChanged) {
        this.onTouchInteractionEnabledChanged = onTouchInteractionEnabledChanged;
    }
}

