/*
 * Decompiled with CFR 0.152.
 */
package com.mobilefuse.sdk.assetsmanager;

import androidx.annotation.VisibleForTesting;
import com.mobilefuse.sdk.AppLifecycleHelper;
import com.mobilefuse.sdk.DebuggingKt;
import com.mobilefuse.sdk.StabilityHelper;
import com.mobilefuse.sdk.assetsmanager.AssetManager;
import com.mobilefuse.sdk.assetsmanager.AssetSharedPrefsResolver;
import com.mobilefuse.sdk.assetsmanager.MobileFuseAssetManager;
import com.mobilefuse.sdk.assetsmanager.MobileFuseAssetManager$requestAssetsManifest$;
import com.mobilefuse.sdk.assetsmanager.MobileFuseAssetManager$runOn$;
import com.mobilefuse.sdk.assetsmanager.MobileFuseAssetManagerService;
import com.mobilefuse.sdk.assetsmanager.MobileFuseAssetManifestResponse;
import com.mobilefuse.sdk.concurrency.Schedulers;
import com.mobilefuse.sdk.concurrency.SchedulersKt;
import com.mobilefuse.sdk.exception.BaseError;
import com.mobilefuse.sdk.exception.Either;
import com.mobilefuse.sdk.exception.ErrorResult;
import com.mobilefuse.sdk.exception.ExceptionHandlingStrategy;
import com.mobilefuse.sdk.exception.SuccessResult;
import com.mobilefuse.sdk.exception.TryKt$WhenMappings;
import com.mobilefuse.sdk.network.client.HttpGetRequest;
import com.mobilefuse.sdk.rx.Flow;
import com.mobilefuse.sdk.rx.FlowCollector;
import com.mobilefuse.sdk.rx.FlowKt;
import com.mobilefuse.sdk.utils.TestableLazy;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0016J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0017\u001a\u00020\u0016H\u0016J\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0016J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0017\u001a\u00020\u0016H\u0002J\u0010\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0016H\u0002J\u001d\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020\u00162\u0006\u0010 \u001a\u00020\u0016H\u0001\u00a2\u0006\u0002\b!J\b\u0010\"\u001a\u00020\u0014H\u0016J\u0016\u0010#\u001a\u00020\u00142\u0006\u0010$\u001a\u00020\u00042\u0006\u0010%\u001a\u00020\fJ\u0015\u0010&\u001a\u00020\u00142\u0006\u0010'\u001a\u00020(H\u0001\u00a2\u0006\u0002\b)R+\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00048B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\n\u0010\u000b\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR+\u0010\r\u001a\u00020\f2\u0006\u0010\u0003\u001a\u00020\f8B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0012\u0010\u000b\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006*"}, d2={"Lcom/mobilefuse/sdk/assetsmanager/MobileFuseAssetManager;", "Lcom/mobilefuse/sdk/assetsmanager/AssetManager;", "()V", "<set-?>", "Lcom/mobilefuse/sdk/assetsmanager/MobileFuseAssetManagerService;", "assetService", "getAssetService", "()Lcom/mobilefuse/sdk/assetsmanager/MobileFuseAssetManagerService;", "setAssetService", "(Lcom/mobilefuse/sdk/assetsmanager/MobileFuseAssetManagerService;)V", "assetService$delegate", "Lcom/mobilefuse/sdk/utils/TestableLazy;", "Lcom/mobilefuse/sdk/assetsmanager/AssetSharedPrefsResolver;", "sharedPrefsResolver", "getSharedPrefsResolver", "()Lcom/mobilefuse/sdk/assetsmanager/AssetSharedPrefsResolver;", "setSharedPrefsResolver", "(Lcom/mobilefuse/sdk/assetsmanager/AssetSharedPrefsResolver;)V", "sharedPrefsResolver$delegate", "deleteAllCacheFiles", "", "getSpecificAssetAbsolutePath", "", "fileName", "getSpecificAssetBytes", "", "getSpecificAssetContent", "getSpecificAssetFile", "Ljava/io/File;", "removeAssetFile", "requestAndSaveSpecificAsset", "key", "value", "requestAndSaveSpecificAsset$mobilefuse_sdk_common_release", "requestAssetsManifest", "updateDependencies", "service", "sharedPrefs", "validateUnixTimeAndSave", "response", "Lcom/mobilefuse/sdk/assetsmanager/MobileFuseAssetManifestResponse;", "validateUnixTimeAndSave$mobilefuse_sdk_common_release", "mobilefuse-sdk-common_release"})
public final class MobileFuseAssetManager
implements AssetManager {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private static final TestableLazy assetService$delegate;
    private static final TestableLazy sharedPrefsResolver$delegate;
    @NotNull
    public static final MobileFuseAssetManager INSTANCE;

    static {
        MobileFuseAssetManager mobileFuseAssetManager;
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl(MobileFuseAssetManager.class, "assetService", "getAssetService()Lcom/mobilefuse/sdk/assetsmanager/MobileFuseAssetManagerService;", 0)), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl(MobileFuseAssetManager.class, "sharedPrefsResolver", "getSharedPrefsResolver()Lcom/mobilefuse/sdk/assetsmanager/AssetSharedPrefsResolver;", 0))};
        INSTANCE = mobileFuseAssetManager = new MobileFuseAssetManager();
        assetService$delegate = new TestableLazy(assetService.2.INSTANCE);
        sharedPrefsResolver$delegate = new TestableLazy(sharedPrefsResolver.2.INSTANCE);
    }

    private final MobileFuseAssetManagerService getAssetService() {
        return (MobileFuseAssetManagerService)assetService$delegate.getValue(this, $$delegatedProperties[0]);
    }

    private final void setAssetService(MobileFuseAssetManagerService mobileFuseAssetManagerService) {
        assetService$delegate.setValue(this, $$delegatedProperties[0], mobileFuseAssetManagerService);
    }

    private final AssetSharedPrefsResolver getSharedPrefsResolver() {
        return (AssetSharedPrefsResolver)sharedPrefsResolver$delegate.getValue(this, $$delegatedProperties[1]);
    }

    private final void setSharedPrefsResolver(AssetSharedPrefsResolver assetSharedPrefsResolver) {
        sharedPrefsResolver$delegate.setValue(this, $$delegatedProperties[1], assetSharedPrefsResolver);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void requestAssetsManifest() {
        void $this$runOn$iv;
        String request = "https://cdn.mobilefuse.com/sdk/assets/android/1.8.0/manifest.json";
        HttpGetRequest httpRequest = new HttpGetRequest(request, null, false, false, 0L, 26, null);
        Flow<Either<BaseError, MobileFuseAssetManifestResponse>> flow = this.getAssetService().getAssetManifestJson(httpRequest);
        Schedulers scheduler$iv = Schedulers.IO;
        boolean $i$f$runOn = false;
        void $this$transformForConcurrency$iv$iv = $this$runOn$iv;
        boolean $i$f$transformForConcurrency = false;
        Flow $this$map$iv = FlowKt.flow((Function1)new Function1<FlowCollector<? super T>, Unit>((Flow)$this$transformForConcurrency$iv$iv, scheduler$iv){
            final /* synthetic */ Flow $this_transformForConcurrency;
            final /* synthetic */ Schedulers $scheduler$inlined;
            {
                this.$this_transformForConcurrency = flow;
                this.$scheduler$inlined = schedulers;
                super(1);
            }

            public final void invoke(@NotNull FlowCollector<? super T> $this$flow) {
                Intrinsics.checkNotNullParameter($this$flow, (String)"$this$flow");
                this.$this_transformForConcurrency.collect(new FlowCollector(this, $this$flow){
                    final /* synthetic */ runOn$$inlined$transformForConcurrency$1 this$0;
                    final /* synthetic */ FlowCollector $this_flow;
                    {
                        this.this$0 = var1_1;
                        this.$this_flow = flowCollector;
                    }

                    public final void emit(@NotNull Either<? extends Throwable, ? extends T> value) {
                        Intrinsics.checkNotNullParameter(value, (String)"value");
                        Either<? extends Throwable, ? extends T> value2 = value;
                        FlowCollector $this$transformForConcurrency = this.$this_flow;
                        boolean bl = false;
                        SchedulersKt.runOnScheduler(this.this$0.$scheduler$inlined, (Function0<Unit>)((Function0)new Function0<Unit>($this$transformForConcurrency, value2){
                            final /* synthetic */ FlowCollector $this_transformForConcurrency;
                            final /* synthetic */ Either $value;
                            {
                                this.$this_transformForConcurrency = flowCollector;
                                this.$value = either;
                                super(0);
                            }

                            public final void invoke() {
                                this.$this_transformForConcurrency.emit(this.$value);
                            }
                        }));
                    }

                    public void emitSuccess(T value) {
                        FlowCollector.DefaultImpls.emitSuccess(this, value);
                    }

                    public void emitError(@NotNull Throwable error) {
                        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                        FlowCollector.DefaultImpls.emitError(this, error);
                    }
                });
            }
        });
        boolean $i$f$map = false;
        Flow $this$transform$iv$iv = $this$map$iv;
        boolean $i$f$transform = false;
        Flow $this$collectResult$iv = FlowKt.flow((Function1)new Function1<FlowCollector<? super Either<? extends BaseError, ? extends MobileFuseAssetManifestResponse>>, Unit>($this$transform$iv$iv){
            final /* synthetic */ Flow $this_transform;
            {
                this.$this_transform = flow;
                super(1);
            }

            public final void invoke(@NotNull FlowCollector<? super Either<? extends BaseError, ? extends MobileFuseAssetManifestResponse>> $this$flow) {
                Intrinsics.checkNotNullParameter($this$flow, (String)"$this$flow");
                this.$this_transform.collect(new FlowCollector(this, $this$flow){
                    final /* synthetic */ requestAssetsManifest$$inlined$map$1 this$0;
                    final /* synthetic */ FlowCollector $this_flow;
                    {
                        this.this$0 = var1_1;
                        this.$this_flow = flowCollector;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void emit(@NotNull Either<? extends Throwable, ? extends T> value) {
                        Intrinsics.checkNotNullParameter(value, (String)"value");
                        Either<? extends Throwable, ? extends T> either = value;
                        if (either instanceof SuccessResult) {
                            T t = ((SuccessResult)value).getValue();
                            FlowCollector $this$transform = this.$this_flow;
                            boolean bl = false;
                            try {
                                void var11_10;
                                void it;
                                void value2;
                                Either either2 = (Either)value2;
                                FlowCollector flowCollector = $this$transform;
                                boolean bl2 = false;
                                void var8_9 = it;
                                if (var8_9 instanceof SuccessResult) {
                                    DebuggingKt.logDebug$default(MobileFuseAssetManager.INSTANCE, "Successfully fetched assets manifest JSON. Response: " + (MobileFuseAssetManifestResponse)((SuccessResult)it).getValue(), null, 2, null);
                                    MobileFuseAssetManager.INSTANCE.validateUnixTimeAndSave$mobilefuse_sdk_common_release((MobileFuseAssetManifestResponse)((SuccessResult)it).getValue());
                                } else if (var8_9 instanceof ErrorResult) {
                                    DebuggingKt.logError$default(MobileFuseAssetManager.INSTANCE, "Error requesting the assets manifest json", null, 2, null);
                                    MobileFuseAssetManager.access$deleteAllCacheFiles(MobileFuseAssetManager.INSTANCE);
                                }
                                void var12_11 = var11_10 = it;
                                flowCollector.emit((Either)new SuccessResult<void>(var12_11));
                            }
                            catch (Throwable e) {
                                $this$transform.emit((Either)new ErrorResult<Throwable>(e));
                            }
                        } else if (either instanceof ErrorResult) {
                            this.$this_flow.emit(value);
                        }
                    }

                    public void emitSuccess(T value) {
                        FlowCollector.DefaultImpls.emitSuccess(this, value);
                    }

                    public void emitError(@NotNull Throwable error) {
                        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                        FlowCollector.DefaultImpls.emitError(this, error);
                    }
                });
            }
        });
        boolean $i$f$collectResult = false;
        $this$collectResult$iv.collect(new FlowCollector(){

            public final void emit(@NotNull Either<? extends Throwable, ? extends T> result) {
                Intrinsics.checkNotNullParameter(result, (String)"result");
                if (result instanceof SuccessResult) {
                    Either it = (Either)((SuccessResult)result).getValue();
                    boolean bl = false;
                }
            }

            public void emitSuccess(T value) {
                FlowCollector.DefaultImpls.emitSuccess(this, value);
            }

            public void emitError(@NotNull Throwable error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                FlowCollector.DefaultImpls.emitError(this, error);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    public final void requestAndSaveSpecificAsset$mobilefuse_sdk_common_release(@NotNull String key, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        boolean $i$f$handleExceptions = false;
        String string = "[Automatically caught]";
        ExceptionHandlingStrategy strategy$iv$iv = ExceptionHandlingStrategy.LogAndIgnore;
        boolean $i$f$handleExceptions2 = false;
        try {
            void $this$collectResult$iv;
            boolean bl = false;
            Flow<Boolean> flow = INSTANCE.getAssetService().resolveAssetPath("https://cdn.mobilefuse.com/sdk/assets/android/1.8.0/" + key, key);
            boolean $i$f$collectResult = false;
            $this$collectResult$iv.collect(new FlowCollector(key, value){
                final /* synthetic */ String $key$inlined;
                final /* synthetic */ String $value$inlined;
                {
                    this.$key$inlined = string;
                    this.$value$inlined = string2;
                }

                public final void emit(@NotNull Either<? extends Throwable, ? extends T> result) {
                    Intrinsics.checkNotNullParameter(result, (String)"result");
                    if (result instanceof SuccessResult) {
                        boolean result2 = (Boolean)((SuccessResult)result).getValue();
                        boolean bl = false;
                        if (result2) {
                            MobileFuseAssetManager.access$getSharedPrefsResolver$p(MobileFuseAssetManager.INSTANCE).saveAssetsPreferences(this.$key$inlined, this.$value$inlined);
                            DebuggingKt.logDebug$default(MobileFuseAssetManager.INSTANCE, "Save preference for specific asset file: " + this.$key$inlined, null, 2, null);
                        }
                    }
                }

                public void emitSuccess(T value) {
                    FlowCollector.DefaultImpls.emitSuccess(this, value);
                }

                public void emitError(@NotNull Throwable error) {
                    Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                    FlowCollector.DefaultImpls.emitError(this, error);
                }
            });
        }
        catch (Throwable e$iv$iv) {
            switch (TryKt$WhenMappings.$EnumSwitchMapping$0[strategy$iv$iv.ordinal()]) {
                case 1: {
                    void source$iv$iv;
                    StabilityHelper.logException(source$iv$iv, e$iv$iv);
                    break;
                }
                case 2: {
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
    }

    @VisibleForTesting
    public final void validateUnixTimeAndSave$mobilefuse_sdk_common_release(@NotNull MobileFuseAssetManifestResponse response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        try {
            Map<String, String> paths = response.getPaths();
            Iterable $this$forEach$iv = this.getAssetService().getDEFAULT_ASSETS_LIST();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String assetName = (String)element$iv;
                boolean bl = false;
                if (paths.containsKey(assetName)) {
                    String resultSaved;
                    CharSequence charSequence;
                    String string;
                    long lastTimeModified = paths.get(assetName) != null ? Long.parseLong(string) : 0L;
                    String string2 = INSTANCE.getSharedPrefsResolver().resolveAssetsPreferences(assetName);
                    if (!(string2 instanceof String)) {
                        string2 = null;
                    }
                    if (!((charSequence = (CharSequence)(resultSaved = string2)) == null || StringsKt.isBlank((CharSequence)charSequence)) && lastTimeModified <= Long.parseLong((String)(charSequence = resultSaved))) continue;
                    INSTANCE.requestAndSaveSpecificAsset$mobilefuse_sdk_common_release(assetName, String.valueOf(lastTimeModified));
                    continue;
                }
                INSTANCE.removeAssetFile(assetName);
            }
        }
        catch (Throwable t) {
            StabilityHelper.logException(this, t);
        }
    }

    @Override
    @NotNull
    public String getSpecificAssetAbsolutePath(@NotNull String fileName) {
        String string;
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        String localAssetFile = "file:///android_asset/mobilefuse/" + fileName;
        try {
            File file = this.getSpecificAssetFile(fileName);
            string = file != null ? "file:///" + file.getAbsolutePath() : localAssetFile;
        }
        catch (Throwable e) {
            StabilityHelper.logException(this, e);
            string = localAssetFile;
        }
        return string;
    }

    @Override
    @Nullable
    public byte[] getSpecificAssetBytes(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        try {
            File file;
            File file2 = file = this.getSpecificAssetFile(fileName);
            if (file2 != null) {
                File file3;
                File it = file3 = file2;
                boolean bl = false;
                return FilesKt.readBytes((File)it);
            }
            return null;
        }
        catch (Throwable e) {
            StabilityHelper.logException(this, e);
            return null;
        }
    }

    @Nullable
    public final String getSpecificAssetContent(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        try {
            File file;
            File file2 = file = this.getSpecificAssetFile(fileName);
            if (file2 != null) {
                File file3;
                File it = file3 = file2;
                boolean bl = false;
                return FilesKt.readText((File)it, (Charset)Charsets.UTF_8);
            }
            return null;
        }
        catch (Throwable e) {
            StabilityHelper.logException(this, e);
            return null;
        }
    }

    private final File getSpecificAssetFile(String fileName) {
        File file;
        try {
            File folder = new File(AppLifecycleHelper.getGlobalContext().getFilesDir(), this.getAssetService().getASSET_FOLDER_NAME());
            File file2 = new File(folder, fileName);
            file = file2.exists() ? file2 : null;
        }
        catch (Throwable e) {
            StabilityHelper.logException(this, e);
            file = null;
        }
        return file;
    }

    private final void removeAssetFile(String fileName) {
        block0: {
            File file = this.getSpecificAssetFile(fileName);
            if (file == null) break block0;
            file.delete();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void deleteAllCacheFiles() {
        boolean $i$f$handleExceptions = false;
        String string = "[Automatically caught]";
        ExceptionHandlingStrategy strategy$iv$iv = ExceptionHandlingStrategy.LogAndIgnore;
        boolean $i$f$handleExceptions2 = false;
        try {
            boolean bl = false;
            File folder = new File(AppLifecycleHelper.getGlobalContext().getFilesDir(), INSTANCE.getAssetService().getASSET_FOLDER_NAME());
            if (folder.exists()) {
                FilesKt.deleteRecursively((File)folder);
            }
            INSTANCE.getSharedPrefsResolver().removeAssetPreference();
        }
        catch (Throwable e$iv$iv) {
            switch (TryKt$WhenMappings.$EnumSwitchMapping$0[strategy$iv$iv.ordinal()]) {
                case 1: {
                    void source$iv$iv;
                    StabilityHelper.logException(source$iv$iv, e$iv$iv);
                    break;
                }
                case 2: {
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
    }

    public final void updateDependencies(@NotNull MobileFuseAssetManagerService service, @NotNull AssetSharedPrefsResolver sharedPrefs) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Intrinsics.checkNotNullParameter((Object)sharedPrefs, (String)"sharedPrefs");
        this.setAssetService(service);
        this.setSharedPrefsResolver(sharedPrefs);
    }

    private MobileFuseAssetManager() {
    }

    public static final /* synthetic */ void access$deleteAllCacheFiles(MobileFuseAssetManager $this) {
        $this.deleteAllCacheFiles();
    }

    public static final /* synthetic */ AssetSharedPrefsResolver access$getSharedPrefsResolver$p(MobileFuseAssetManager $this) {
        return $this.getSharedPrefsResolver();
    }

    public static final /* synthetic */ void access$setSharedPrefsResolver$p(MobileFuseAssetManager $this, AssetSharedPrefsResolver assetSharedPrefsResolver) {
        $this.setSharedPrefsResolver(assetSharedPrefsResolver);
    }
}

