/*
 * Decompiled with CFR 0.152.
 */
package com.mobilefuse.sdk.network.client;

import com.mobilefuse.sdk.StabilityHelper;
import com.mobilefuse.sdk.concurrency.Schedulers;
import com.mobilefuse.sdk.concurrency.SchedulersKt;
import com.mobilefuse.sdk.encoding.Gzip;
import com.mobilefuse.sdk.exception.Either;
import com.mobilefuse.sdk.exception.ErrorResult;
import com.mobilefuse.sdk.exception.ExceptionHandlingStrategy;
import com.mobilefuse.sdk.exception.SuccessResult;
import com.mobilefuse.sdk.exception.TryKt$WhenMappings;
import com.mobilefuse.sdk.network.client.AndroidHttpClient;
import com.mobilefuse.sdk.network.client.HttpClient;
import com.mobilefuse.sdk.network.client.HttpError;
import com.mobilefuse.sdk.network.client.HttpGetRequest;
import com.mobilefuse.sdk.network.client.HttpPostBody;
import com.mobilefuse.sdk.network.client.HttpPostRequest;
import com.mobilefuse.sdk.network.client.HttpResponse;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u001e\u0010\u0007\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u0012\u0004\u0012\u00020\u00040\bH\u0016J$\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J6\u0010\u0011\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u001e\u0010\u0007\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u0012\u0004\u0012\u00020\u00040\bH\u0016\u00a8\u0006\u0014"}, d2={"Lcom/mobilefuse/sdk/network/client/AndroidHttpClient;", "Lcom/mobilefuse/sdk/network/client/HttpClient;", "()V", "get", "", "request", "Lcom/mobilefuse/sdk/network/client/HttpGetRequest;", "completeBlock", "Lkotlin/Function1;", "Lcom/mobilefuse/sdk/exception/Either;", "Lcom/mobilefuse/sdk/network/client/HttpError;", "Lcom/mobilefuse/sdk/network/client/HttpResponse;", "headSync", "requestUrl", "", "timeoutMillis", "", "post", "Lcom/mobilefuse/sdk/network/client/HttpPostRequest;", "Lcom/mobilefuse/sdk/network/client/HttpPostBody;", "mobilefuse-sdk-common_release"})
final class AndroidHttpClient
implements HttpClient {
    @Override
    public void get(@NotNull HttpGetRequest request, @NotNull Function1<? super Either<? extends HttpError, HttpResponse>, Unit> completeBlock) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(completeBlock, (String)"completeBlock");
        SchedulersKt.runOnScheduler(Schedulers.IO, (Function0<Unit>)((Function0)new Function0<Unit>(request, completeBlock){
            final /* synthetic */ HttpGetRequest $request;
            final /* synthetic */ Function1 $completeBlock;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                try {
                    Either either;
                    Object object;
                    Object entry;
                    HttpURLConnection httpURLConnection;
                    long requestTimestamp = System.currentTimeMillis();
                    URL url = new URL(this.$request.getUrl());
                    URLConnection uRLConnection = url.openConnection();
                    if (uRLConnection == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.net.HttpURLConnection");
                    }
                    HttpURLConnection $this$apply = httpURLConnection = (HttpURLConnection)uRLConnection;
                    boolean bl = false;
                    $this$apply.setRequestMethod("GET");
                    $this$apply.setConnectTimeout((int)this.$request.getTimeoutMillis());
                    $this$apply.setReadTimeout((int)this.$request.getTimeoutMillis());
                    if (this.$request.getEmptyUserAgent()) {
                        $this$apply.setRequestProperty("User-Agent", "");
                    }
                    if (this.$request.getGzipEncoding()) {
                        $this$apply.setRequestProperty("Accept-Encoding", "gzip");
                        $this$apply.setRequestProperty("Content-Encoding", "gzip");
                    }
                    Map<String, String> $this$forEach$iv = this.$request.getHeaders();
                    boolean $i$f$forEach = false;
                    for (Map.Entry<String, String> element$iv : $this$forEach$iv.entrySet()) {
                        entry = element$iv;
                        boolean bl2 = false;
                        $this$apply.setRequestProperty(entry.getKey(), entry.getValue());
                    }
                    HttpURLConnection urlConnection = httpURLConnection;
                    int responseCode = urlConnection.getResponseCode();
                    long responseTimestamp = System.currentTimeMillis();
                    if (responseCode == 200) {
                        InputStream inputStream;
                        InputStream inputStream2 = inputStream = this.$request.getGzipEncoding() ? (InputStream)new GZIPInputStream(urlConnection.getInputStream()) : urlConnection.getInputStream();
                        Intrinsics.checkNotNullExpressionValue((Object)inputStream2, (String)"inputStream");
                        object = inputStream2;
                        entry = Charsets.UTF_8;
                        Reader bl2 = new InputStreamReader((InputStream)object, (Charset)entry);
                        int n = 8192;
                        object = bl2 instanceof BufferedReader ? (BufferedReader)bl2 : new BufferedReader(bl2, n);
                        entry = null;
                        try {
                            Object it = (BufferedReader)object;
                            boolean bl3 = false;
                            it = TextStreamsKt.readText((Reader)((Reader)it));
                        }
                        catch (Throwable it) {
                            entry = it;
                            throw it;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)object, (Throwable)entry);
                        }
                        Object responseBody = it;
                        inputStream.close();
                        either = new SuccessResult<HttpResponse>(new HttpResponse((String)responseBody, responseCode, requestTimestamp, responseTimestamp));
                    } else {
                        String string;
                        BufferedReader bufferedReader;
                        Object object2;
                        InputStream inputStream = urlConnection.getErrorStream();
                        if (inputStream != null) {
                            object2 = inputStream;
                            object = Charsets.UTF_8;
                            entry = new InputStreamReader((InputStream)object2, (Charset)object);
                            int it = 8192;
                            bufferedReader = entry instanceof BufferedReader ? (BufferedReader)entry : new BufferedReader((Reader)entry, it);
                        } else {
                            bufferedReader = null;
                        }
                        object2 = bufferedReader;
                        object = null;
                        try {
                            BufferedReader reader = (BufferedReader)object2;
                            boolean bl4 = false;
                            BufferedReader bufferedReader2 = reader;
                            string = bufferedReader2 != null ? TextStreamsKt.readText((Reader)bufferedReader2) : null;
                        }
                        catch (Throwable throwable) {
                            object = throwable;
                            throw throwable;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)object2, (Throwable)object);
                        }
                        String errorMsg = string;
                        either = new ErrorResult<HttpError.ConnectionError>(new HttpError.ConnectionError(responseCode, errorMsg));
                    }
                    Either result = either;
                    SchedulersKt.runOnScheduler(Schedulers.MAIN, (Function0<Unit>)((Function0)new Function0<Unit>(this, result){
                        final /* synthetic */ get.1 this$0;
                        final /* synthetic */ Either $result;

                        public final void invoke() {
                            this.this$0.$completeBlock.invoke((Object)this.$result);
                        }
                        {
                            this.this$0 = var1_1;
                            this.$result = either;
                            super(0);
                        }
                    }));
                }
                catch (Throwable e) {
                    String errorMsg = e.getMessage();
                    Throwable throwable = e;
                    HttpError error = throwable instanceof FileNotFoundException ? (HttpError)new HttpError.ConnectionError(404, errorMsg) : (throwable instanceof UnknownHostException ? (HttpError)new HttpError.ConnectionError(-1, errorMsg) : (HttpError)new HttpError.UnknownError(errorMsg));
                    e.printStackTrace();
                    SchedulersKt.runOnScheduler(Schedulers.MAIN, (Function0<Unit>)((Function0)new Function0<Unit>(this, error){
                        final /* synthetic */ get.1 this$0;
                        final /* synthetic */ HttpError $error;

                        public final void invoke() {
                            this.this$0.$completeBlock.invoke(new ErrorResult<HttpError>(this.$error));
                        }
                        {
                            this.this$0 = var1_1;
                            this.$error = httpError;
                            super(0);
                        }
                    }));
                }
            }
            {
                this.$request = httpGetRequest;
                this.$completeBlock = function1;
                super(0);
            }
        }));
    }

    @Override
    public void post(@NotNull HttpPostRequest<? extends HttpPostBody> request, @NotNull Function1<? super Either<? extends HttpError, HttpResponse>, Unit> completeBlock) {
        Intrinsics.checkNotNullParameter(request, (String)"request");
        Intrinsics.checkNotNullParameter(completeBlock, (String)"completeBlock");
        SchedulersKt.runOnScheduler(Schedulers.IO, (Function0<Unit>)((Function0)new Function0<Unit>(this, request, completeBlock){
            final /* synthetic */ AndroidHttpClient this$0;
            final /* synthetic */ HttpPostRequest $request;
            final /* synthetic */ Function1 $completeBlock;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                try {
                    Either either;
                    Object object;
                    Object object2;
                    Map mergedHeaders;
                    long requestTimestamp = System.currentTimeMillis();
                    URL url = new URL(this.$request.getUrl());
                    URLConnection uRLConnection = url.openConnection();
                    if (uRLConnection == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.net.HttpURLConnection");
                    }
                    HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                    Object $this$apply = httpURLConnection;
                    boolean bl = false;
                    ((URLConnection)$this$apply).setConnectTimeout((int)this.$request.getTimeoutMillis());
                    ((URLConnection)$this$apply).setReadTimeout((int)this.$request.getTimeoutMillis());
                    ((HttpURLConnection)$this$apply).setRequestMethod("POST");
                    ((URLConnection)$this$apply).setDoOutput(true);
                    ((URLConnection)$this$apply).setDoInput(true);
                    if (this.$request.getEmptyUserAgent()) {
                        ((URLConnection)$this$apply).setRequestProperty("User-Agent", "");
                    }
                    if (this.$request.getGzipEncoding()) {
                        ((URLConnection)$this$apply).setRequestProperty("Accept-Encoding", "gzip");
                        ((URLConnection)$this$apply).setRequestProperty("Content-Encoding", "gzip");
                    }
                    ((URLConnection)$this$apply).setRequestProperty("Content-Type", this.$request.getBody().getContentType());
                    Map $this$forEach$iv = mergedHeaders = MapsKt.plus(this.$request.getHeaders(), this.$request.getBody().getHeaders());
                    boolean $i$f$forEach = false;
                    Iterator<Map.Entry<K, V>> iterator = $this$forEach$iv.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<K, V> element$iv;
                        Map.Entry<K, V> entry = element$iv = iterator.next();
                        boolean bl2 = false;
                        ((URLConnection)$this$apply).setRequestProperty((String)entry.getKey(), (String)entry.getValue());
                    }
                    HttpURLConnection urlConnection = httpURLConnection;
                    byte[] byArray = this.$request.getBody().getContent();
                    if (byArray == null) {
                        Object it = $this$apply = this.this$0;
                        boolean bl3 = false;
                        SchedulersKt.runOnScheduler(Schedulers.MAIN, (Function0<Unit>)((Function0)new Function0<Unit>(this){
                            final /* synthetic */ post.1 this$0;
                            {
                                this.this$0 = var1_1;
                                super(0);
                            }

                            public final void invoke() {
                                this.this$0.$completeBlock.invoke(new ErrorResult<HttpError.UnknownError>(new HttpError.UnknownError("Error with request body: content was null")));
                            }
                        }));
                        return;
                    }
                    byte[] requestBody = byArray;
                    DataOutputStream dataOutputStream = new DataOutputStream(urlConnection.getOutputStream());
                    byte[] postData = this.$request.getGzipEncoding() ? Gzip.gzip(requestBody) : requestBody;
                    dataOutputStream.write(postData);
                    dataOutputStream.close();
                    int responseCode = urlConnection.getResponseCode();
                    long responseTimestamp = System.currentTimeMillis();
                    if (responseCode == 200) {
                        InputStream inputStream;
                        InputStream inputStream2 = inputStream = this.$request.getGzipEncoding() ? (InputStream)new GZIPInputStream(urlConnection.getInputStream()) : urlConnection.getInputStream();
                        Intrinsics.checkNotNullExpressionValue((Object)inputStream2, (String)"inputStream");
                        object2 = inputStream2;
                        object = Charsets.UTF_8;
                        Reader reader = new InputStreamReader((InputStream)object2, (Charset)object);
                        int n = 8192;
                        object2 = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n);
                        object = null;
                        try {
                            Object it = (BufferedReader)object2;
                            boolean bl4 = false;
                            it = TextStreamsKt.readText((Reader)((Reader)it));
                        }
                        catch (Throwable it) {
                            object = it;
                            throw it;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)object2, (Throwable)object);
                        }
                        Object responseBody = it;
                        inputStream.close();
                        either = new SuccessResult<HttpResponse>(new HttpResponse((String)responseBody, responseCode, requestTimestamp, responseTimestamp));
                    } else {
                        BufferedReader bufferedReader;
                        Closeable closeable;
                        InputStream inputStream = urlConnection.getErrorStream();
                        if (inputStream != null) {
                            closeable = inputStream;
                            Charset charset = Charsets.UTF_8;
                            object = new InputStreamReader((InputStream)closeable, charset);
                            int it = 8192;
                            bufferedReader = object instanceof BufferedReader ? (BufferedReader)object : new BufferedReader((Reader)object, it);
                        } else {
                            bufferedReader = null;
                        }
                        closeable = bufferedReader;
                        object2 = null;
                        try {
                            BufferedReader reader = (BufferedReader)closeable;
                            boolean bl5 = false;
                            BufferedReader bufferedReader2 = reader;
                            object = bufferedReader2 != null ? TextStreamsKt.readText((Reader)bufferedReader2) : null;
                        }
                        catch (Throwable throwable) {
                            object2 = throwable;
                            throw throwable;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object2);
                        }
                        Object errorMsg = object;
                        either = new ErrorResult<HttpError.ConnectionError>(new HttpError.ConnectionError(responseCode, (String)errorMsg));
                    }
                    Either result = either;
                    SchedulersKt.runOnScheduler(Schedulers.MAIN, (Function0<Unit>)((Function0)new Function0<Unit>(this, result){
                        final /* synthetic */ post.1 this$0;
                        final /* synthetic */ Either $result;

                        public final void invoke() {
                            this.this$0.$completeBlock.invoke((Object)this.$result);
                        }
                        {
                            this.this$0 = var1_1;
                            this.$result = either;
                            super(0);
                        }
                    }));
                }
                catch (Throwable e) {
                    Throwable throwable = e;
                    HttpError error = throwable instanceof FileNotFoundException ? (HttpError)new HttpError.ConnectionError(404, null, 2, null) : (HttpError)new HttpError.UnknownError(e.getMessage());
                    e.printStackTrace();
                    SchedulersKt.runOnScheduler(Schedulers.MAIN, (Function0<Unit>)((Function0)new Function0<Unit>(this, error){
                        final /* synthetic */ post.1 this$0;
                        final /* synthetic */ HttpError $error;

                        public final void invoke() {
                            this.this$0.$completeBlock.invoke(new ErrorResult<HttpError>(this.$error));
                        }
                        {
                            this.this$0 = var1_1;
                            this.$error = httpError;
                            super(0);
                        }
                    }));
                }
            }
            {
                this.this$0 = androidHttpClient;
                this.$request = httpPostRequest;
                this.$completeBlock = function1;
                super(0);
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Either<HttpError, HttpResponse> headSync(@NotNull String requestUrl, long timeoutMillis) {
        Object object;
        void $this$withErrorFallback$iv;
        Either either;
        Intrinsics.checkNotNullParameter((Object)requestUrl, (String)"requestUrl");
        boolean $i$f$gracefullyHandleException22 = false;
        String string = "[Automatically caught]";
        ExceptionHandlingStrategy strategy$iv$iv = ExceptionHandlingStrategy.LogAndIgnore;
        boolean $i$f$gracefullyHandleException = false;
        try {
            Either result;
            Either either2;
            Either either3;
            HttpURLConnection httpURLConnection;
            boolean bl = false;
            long requestTimestamp = System.currentTimeMillis();
            URL url = new URL(requestUrl);
            URLConnection uRLConnection = url.openConnection();
            if (uRLConnection == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.net.HttpURLConnection");
            }
            HttpURLConnection $this$apply = httpURLConnection = (HttpURLConnection)uRLConnection;
            boolean bl2 = false;
            $this$apply.setRequestMethod("HEAD");
            $this$apply.setConnectTimeout((int)timeoutMillis);
            $this$apply.setReadTimeout((int)timeoutMillis);
            HttpURLConnection urlConnection = httpURLConnection;
            int responseCode = urlConnection.getResponseCode();
            long responseTimestamp = System.currentTimeMillis();
            if (responseCode == 200) {
                either3 = new SuccessResult<HttpResponse>(new HttpResponse("", responseCode, requestTimestamp, responseTimestamp));
            } else {
                BufferedReader bufferedReader;
                Object object2;
                Object object3;
                Closeable closeable;
                InputStream inputStream = urlConnection.getErrorStream();
                if (inputStream != null) {
                    closeable = inputStream;
                    object3 = Charsets.UTF_8;
                    object2 = new InputStreamReader((InputStream)closeable, (Charset)object3);
                    int n = 8192;
                    bufferedReader = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
                } else {
                    bufferedReader = null;
                }
                closeable = bufferedReader;
                object3 = null;
                try {
                    BufferedReader reader = (BufferedReader)closeable;
                    boolean bl3 = false;
                    BufferedReader bufferedReader2 = reader;
                    object2 = bufferedReader2 != null ? TextStreamsKt.readText((Reader)bufferedReader2) : null;
                }
                catch (Throwable throwable) {
                    object3 = throwable;
                    throw throwable;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)object3);
                }
                Object errorMsg = object2;
                either3 = new ErrorResult<HttpError.ConnectionError>(new HttpError.ConnectionError(responseCode, (String)errorMsg));
            }
            Either either4 = either2 = (result = either3);
            either = new SuccessResult<Either>(either4);
        }
        catch (Throwable e$iv$iv) {
            switch (TryKt$WhenMappings.$EnumSwitchMapping$1[strategy$iv$iv.ordinal()]) {
                case 1: {
                    void source$iv$iv;
                    StabilityHelper.logException(source$iv$iv, e$iv$iv);
                }
            }
            either = new ErrorResult<Throwable>(e$iv$iv);
        }
        Either $i$f$gracefullyHandleException22 = either;
        boolean $i$f$withErrorFallback = false;
        void var6_7 = $this$withErrorFallback$iv;
        if (var6_7 instanceof ErrorResult) {
            Throwable e = (Throwable)((ErrorResult)$this$withErrorFallback$iv).getValue();
            boolean bl = false;
            String errorMsg = e.getMessage();
            Throwable throwable = e;
            HttpError error = throwable instanceof FileNotFoundException ? (HttpError)new HttpError.ConnectionError(404, errorMsg) : (throwable instanceof UnknownHostException ? (HttpError)new HttpError.ConnectionError(-1, errorMsg) : (HttpError)new HttpError.UnknownError(errorMsg));
            e.printStackTrace();
            object = new ErrorResult<HttpError>(error);
        } else if (var6_7 instanceof SuccessResult) {
            object = ((SuccessResult)$this$withErrorFallback$iv).getValue();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return (Either)object;
    }
}

