/*
 * Decompiled with CFR 0.152.
 */
package com.mobilefuse.sdk.omid.viewtree;

import android.graphics.Rect;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import androidx.annotation.NonNull;
import com.mobilefuse.sdk.StabilityHelper;
import java.util.ArrayList;
import java.util.List;

public class ViewTreeInspector {
    private static final int MAX_DETECTION_LEVELS = 100;
    private static final long OBSTRUCTIONS_CHECKING_DELAY = 200L;
    private static int NEXT_INSTANCE_ID = 1;
    private static final String LOG_TAG = "mfsdk.ViewTreeInspector";
    @NonNull
    private final Handler handler = new Handler(Looper.getMainLooper());
    private final boolean logsEnabled;
    private final int instanceId;
    @NonNull
    private final Runnable checkObstructionsRunnable = () -> {
        try {
            this.revealObstructions();
            this.scheduleNextObstructionChecking();
        }
        catch (Throwable e) {
            StabilityHelper.logException(this, e);
        }
    };
    @NonNull
    private final View adView;
    @NonNull
    private final ObstructionsChangeListener changeListener;
    @NonNull
    private final Rect adViewVisibleRect;
    private int currentDetectionLevel = 0;
    private boolean checkingEnabled;
    @NonNull
    private final List<View> lastFriendlyObstructions;

    public ViewTreeInspector(@NonNull View adView, @NonNull ObstructionsChangeListener changeListener) throws Throwable {
        this.adView = adView;
        this.changeListener = changeListener;
        this.instanceId = NEXT_INSTANCE_ID++;
        this.adViewVisibleRect = new Rect();
        this.lastFriendlyObstructions = new ArrayList<View>();
        this.logsEnabled = Log.isLoggable((String)LOG_TAG, (int)2);
    }

    public void startObstructionsChecking() throws Throwable {
        if (this.checkingEnabled) {
            return;
        }
        this.logDebug("Start friendly obstructions checking");
        this.handler.removeCallbacks(this.checkObstructionsRunnable);
        this.checkingEnabled = true;
        this.checkObstructionsRunnable.run();
    }

    private void scheduleNextObstructionChecking() throws Throwable {
        if (!this.checkingEnabled) {
            return;
        }
        this.handler.postDelayed(this.checkObstructionsRunnable, 200L);
    }

    public void stopObstructionsChecking() throws Throwable {
        if (!this.checkingEnabled) {
            return;
        }
        this.logDebug("Stop friendly obstructions checking");
        this.checkingEnabled = false;
        this.handler.removeCallbacks(this.checkObstructionsRunnable);
    }

    private void revealObstructions() throws Throwable {
        this.logDebug("Check friendly obstructions");
        long startTimestamp = System.currentTimeMillis();
        List<View> obstructions = this.detectAdViewTree();
        boolean changed = this.obstructionsChanged(obstructions);
        if (changed) {
            this.lastFriendlyObstructions.clear();
            this.lastFriendlyObstructions.addAll(obstructions);
        }
        long endTimestamp = System.currentTimeMillis();
        this.logDebug("Completed friendly obstruction detection:");
        this.logDebug("    * processing time: " + (endTimestamp - startTimestamp) + " ms");
        this.logDebug("    * found friendly obstructions count: " + obstructions.size());
        this.logDebug("    * found friendly obstructions:");
        int index = 1;
        for (View view : obstructions) {
            this.logDebug("        #" + index++ + " - " + view.toString());
        }
        if (changed) {
            this.changeListener.onChanged(obstructions);
        } else {
            this.logDebug("    *** Friendly obstructions are the same as last time. Don't dispatch change event.");
        }
    }

    private boolean obstructionsChanged(List<View> obstructions) throws Throwable {
        if (obstructions.size() != this.lastFriendlyObstructions.size()) {
            return true;
        }
        for (View view : obstructions) {
            if (this.lastFriendlyObstructions.contains(view)) continue;
            return true;
        }
        return false;
    }

    @NonNull
    private List<View> detectAdViewTree() throws Throwable {
        this.currentDetectionLevel = 0;
        ArrayList<View> obstructions = new ArrayList<View>();
        this.adView.getGlobalVisibleRect(this.adViewVisibleRect);
        ViewParent viewParent = this.adView.getParent();
        if (viewParent instanceof ViewGroup) {
            ViewGroup viewParentGroup = (ViewGroup)viewParent;
            this.detectViewGroup(obstructions, this.adView, viewParentGroup);
        }
        return obstructions;
    }

    private void detectViewGroup(List<View> obstructions, View requestingView, ViewGroup viewGroupToCheck) throws Throwable {
        if (this.currentDetectionLevel > 100) {
            return;
        }
        ++this.currentDetectionLevel;
        int childCount = viewGroupToCheck.getChildCount();
        int requestingViewIndex = viewGroupToCheck.indexOfChild(requestingView);
        for (int i = 0; i < childCount; ++i) {
            View view = viewGroupToCheck.getChildAt(i);
            if (view == requestingView) continue;
            Rect viewRect = new Rect();
            view.getGlobalVisibleRect(viewRect);
            Rect intersectedRect = new Rect(this.adViewVisibleRect);
            if (!intersectedRect.intersect(viewRect) || !this.viewIsOver(view, i, requestingView, requestingViewIndex) || !this.verifyView(view)) continue;
            obstructions.add(view);
        }
        ViewParent viewParent = viewGroupToCheck.getParent();
        if (viewParent instanceof ViewGroup) {
            this.detectViewGroup(obstructions, (View)viewGroupToCheck, (ViewGroup)viewParent);
        }
    }

    private boolean verifyView(View view) throws Throwable {
        if (!view.isShown()) {
            return false;
        }
        if (view.getAlpha() == 0.0f) {
            return false;
        }
        if (!this.viewHasTransparentBackground(view)) {
            return false;
        }
        if (Build.VERSION.SDK_INT >= 19 && !view.isAttachedToWindow()) {
            return false;
        }
        if (view.hasOnClickListeners()) {
            return false;
        }
        if (Build.VERSION.SDK_INT >= 30 && view.hasOnLongClickListeners()) {
            return false;
        }
        return !(view instanceof ViewGroup) || !this.viewGroupObstructionOverlapping((ViewGroup)view);
    }

    private boolean viewGroupObstructionOverlapping(ViewGroup viewGroup) throws Throwable {
        int childCount = viewGroup.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View view = viewGroup.getChildAt(i);
            Rect viewRect = new Rect();
            view.getGlobalVisibleRect(viewRect);
            Rect intersectedRect = new Rect(this.adViewVisibleRect);
            if (!intersectedRect.intersect(viewRect)) continue;
            if (view.hasOnClickListeners()) {
                return true;
            }
            if (Build.VERSION.SDK_INT >= 30 && view.hasOnLongClickListeners()) {
                return true;
            }
            if (!this.viewHasTransparentBackground(view)) {
                return true;
            }
            if (!(view instanceof ViewGroup) || !this.viewGroupObstructionOverlapping((ViewGroup)view)) continue;
            return true;
        }
        return false;
    }

    private boolean viewIsOver(View view1, int view1Index, View view2, int view2Index) throws Throwable {
        if (Build.VERSION.SDK_INT >= 21 && view1.getZ() > view2.getZ()) {
            return true;
        }
        return view1Index > view2Index;
    }

    private boolean viewHasTransparentBackground(View view) throws Throwable {
        ColorDrawable colorDrawable;
        Drawable background = view.getBackground();
        if (background == null) {
            return true;
        }
        if (Build.VERSION.SDK_INT >= 19 && background.getAlpha() == 0) {
            return true;
        }
        if (background.getOpacity() == -2) {
            return true;
        }
        return background instanceof ColorDrawable && (colorDrawable = (ColorDrawable)background).getAlpha() == 0;
    }

    public void logDebug(String msg) {
        if (!this.logsEnabled) {
            return;
        }
        Log.d((String)"ViewTreeInspector", (String)("[" + this.instanceId + "]: " + msg));
    }

    public static interface ObstructionsChangeListener {
        public void onChanged(List<View> var1) throws Throwable;
    }
}

