/*
 * Decompiled with CFR 0.152.
 */
package com.mobilefuse.sdk;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Process;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.Display;
import android.view.View;
import android.view.WindowManager;
import androidx.annotation.NonNull;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Calendar;
import java.util.Locale;

public class Utils {
    @NonNull
    public static Handler getHandler() {
        return new Handler(Looper.getMainLooper());
    }

    public static int[] getDeviceScreenSize() {
        DisplayMetrics displayMetrics = Resources.getSystem().getDisplayMetrics();
        return new int[]{displayMetrics.widthPixels, displayMetrics.heightPixels};
    }

    public static int[] getScreenSizeAsPixels(Context context) throws Throwable {
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        int screenWidth = displayMetrics.widthPixels;
        int screenHeight = displayMetrics.heightPixels;
        return new int[]{screenWidth, screenHeight};
    }

    public static int[] getScreenSizeAsDp(Activity activity) throws Throwable {
        int[] screenSize = Utils.getScreenSizeAsPixels((Context)activity);
        Utils.convertFromPixelsToDp(activity, screenSize);
        return screenSize;
    }

    public static int convertDpToPx(Context context, int dpValue) throws Throwable {
        Resources r = context.getResources();
        int px = (int)TypedValue.applyDimension((int)1, (float)dpValue, (DisplayMetrics)r.getDisplayMetrics());
        return px;
    }

    public static int convertPxToDp(Context context, int pixels) throws Throwable {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)((float)pixels / scale + 0.5f);
    }

    public static void convertFromPixelsToDp(Activity activity, int[] pixels) throws Throwable {
        float scale = activity.getResources().getDisplayMetrics().density;
        for (int i = 0; i < pixels.length; ++i) {
            pixels[i] = (int)((float)pixels[i] / scale + 0.5f);
        }
    }

    public static void convertFromDpToPixels(Activity activity, int[] pixels) throws Throwable {
        float scale = activity.getResources().getDisplayMetrics().density;
        for (int i = 0; i < pixels.length; ++i) {
            pixels[i] = (int)((float)pixels[i] * scale + 0.5f);
        }
    }

    public static Activity getActivityForView(View view) throws Throwable {
        Context context = view.getContext();
        while (context instanceof ContextWrapper) {
            if (context instanceof Activity) {
                return (Activity)context;
            }
            context = ((ContextWrapper)context).getBaseContext();
        }
        return null;
    }

    public static PackageInfo getPackageInfo(Context context) throws Throwable {
        return context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
    }

    public static boolean hasIntent(Context context, Intent i) throws Throwable {
        PackageManager pm = context.getPackageManager();
        return pm.queryIntentActivities(i, 0).size() > 0;
    }

    public static void setActivityOrientation(Activity activity, int orientation) throws Throwable {
        boolean isKindleFireHd = false;
        String device = Build.MODEL.toUpperCase(Locale.US);
        String make = Build.MANUFACTURER.toUpperCase(Locale.US);
        if (make.equals("AMAZON") && (device.equals("KFTT") || device.equals("KFJWI") || device.equals("KFJWA"))) {
            isKindleFireHd = true;
        }
        if (activity != null && !activity.isFinishing()) {
            Display display = ((WindowManager)activity.getSystemService("window")).getDefaultDisplay();
            int rotation = display.getRotation();
            if (orientation == 1) {
                if (Build.VERSION.SDK_INT < 9) {
                    activity.setRequestedOrientation(1);
                } else if (rotation == 2) {
                    activity.setRequestedOrientation(9);
                } else {
                    activity.setRequestedOrientation(1);
                }
            } else if (orientation == 2) {
                if (Build.VERSION.SDK_INT < 9) {
                    activity.setRequestedOrientation(0);
                } else if (isKindleFireHd) {
                    if (rotation == 0 || rotation == 1) {
                        activity.setRequestedOrientation(8);
                    } else {
                        activity.setRequestedOrientation(0);
                    }
                } else if (rotation == 0 || rotation == 1) {
                    activity.setRequestedOrientation(0);
                } else {
                    activity.setRequestedOrientation(8);
                }
            }
        }
    }

    public static void lockOrientationFromExpand(Activity activity, boolean allowOrientationChange, String forceOrientation) throws Throwable {
        if (forceOrientation == null) {
            return;
        }
        if (!forceOrientation.equals("none")) {
            Utils.lockToMraidOrientation(activity, forceOrientation);
        }
        if (allowOrientationChange) {
            Utils.unlockOrientation(activity);
        } else if (forceOrientation.equals("none")) {
            Utils.lockToCurrentOrientation(activity);
        }
    }

    public static void lockToMraidOrientation(Activity activity, String requestedOrientation) throws Throwable {
        int orientation = activity.getResources().getConfiguration().orientation;
        switch (requestedOrientation) {
            case "none": {
                activity.setRequestedOrientation(-1);
                return;
            }
            case "landscape": {
                orientation = 2;
                break;
            }
            case "portrait": {
                orientation = 1;
            }
        }
        Utils.setActivityOrientation(activity, orientation);
    }

    public static void unlockOrientation(Activity activity) throws Throwable {
        activity.setRequestedOrientation(-1);
    }

    protected static void lockToCurrentOrientation(Activity activity) throws Throwable {
        int orientation = activity.getResources().getConfiguration().orientation;
        Utils.setActivityOrientation(activity, orientation);
    }

    public static String getApplicationName(Context context) throws Throwable {
        ApplicationInfo applicationInfo = context.getApplicationInfo();
        int stringId = applicationInfo.labelRes;
        return stringId == 0 ? applicationInfo.nonLocalizedLabel.toString() : context.getString(stringId);
    }

    public static boolean isDeviceTypeTablet() throws Throwable {
        int height;
        float heightDp;
        DisplayMetrics metrics = Resources.getSystem().getDisplayMetrics();
        int width = Math.min(metrics.widthPixels, metrics.heightPixels);
        float widthDp = (float)width / metrics.density;
        float smallerEdgeDp = Math.min(widthDp, heightDp = (float)(height = Math.max(metrics.widthPixels, metrics.heightPixels)) / metrics.density);
        return smallerEdgeDp >= 600.0f;
    }

    public static boolean isAttachedToWindow(@NonNull View view) {
        if (Build.VERSION.SDK_INT >= 19) {
            return view.isAttachedToWindow();
        }
        return view.getWindowToken() != null;
    }

    public static boolean hasManifestPermission(Context context, String permission2) throws Throwable {
        if (context == null) {
            return false;
        }
        return context.checkPermission(permission2, Process.myPid(), Process.myUid()) == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getAssetContent(Context context, String assetFilename) throws Throwable {
        StringBuilder content2 = new StringBuilder();
        try (InputStream inputStream = context.getAssets().open(assetFilename);){
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            while ((line = reader.readLine()) != null) {
                content2.append(line + "\n");
            }
        }
        return content2.toString();
    }

    public static boolean isJavaVersionSupported() {
        try {
            String result = String.join((CharSequence)" ", "java", "test");
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static int getCurrentYear() {
        return Calendar.getInstance().get(1);
    }
}

