/*
 * Decompiled with CFR 0.152.
 */
package com.mobilefuse.sdk.ad.rendering.omniad.service;

import android.content.Context;
import android.graphics.Point;
import android.graphics.Rect;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import com.mobilefuse.sdk.ad.rendering.omniad.service.OmniAdAnchorService;
import com.mobilefuse.sdk.utils.DimConversionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0005"}, d2={"anchorPosition", "Landroid/graphics/Point;", "Lcom/mobilefuse/sdk/ad/rendering/omniad/service/OmniAdAnchorService;", "getAnchorPosition", "(Lcom/mobilefuse/sdk/ad/rendering/omniad/service/OmniAdAnchorService;)Landroid/graphics/Point;", "mobilefuse-sdk-common_release"})
public final class OmniAdAnchorServiceKt {
    @NotNull
    public static final Point getAnchorPosition(@NotNull OmniAdAnchorService $this$anchorPosition) {
        Intrinsics.checkNotNullParameter((Object)$this$anchorPosition, (String)"$this$anchorPosition");
        Point position = new Point(0, 0);
        Window window = $this$anchorPosition.getPropertyService().getActivity().getWindow();
        Intrinsics.checkNotNullExpressionValue((Object)window, (String)"propertyService.activity.window");
        View view = window.getDecorView();
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"propertyService.activity.window.decorView");
        View view2 = view.getRootView().findViewById(0x1020002);
        if (view2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup");
        }
        ViewGroup androidContentView = (ViewGroup)view2;
        Rect androidContentRect = new Rect();
        int[] androidContentScreenLocation = new int[2];
        androidContentView.getLocationOnScreen(androidContentScreenLocation);
        androidContentView.getGlobalVisibleRect(androidContentRect, new Point(androidContentScreenLocation[0], androidContentScreenLocation[1]));
        int adWidthDp = $this$anchorPosition.getPropertyService().getSizePx().x;
        int adHeightDp = $this$anchorPosition.getPropertyService().getSizePx().y;
        int margin = DimConversionsKt.dpToPx($this$anchorPosition.getMarginDp(), (Context)$this$anchorPosition.getPropertyService().getActivity());
        if ($this$anchorPosition.getAnchor() == 0 || $this$anchorPosition.getAnchor() == 2) {
            position.x = androidContentRect.left + margin;
        } else if ($this$anchorPosition.getAnchor() == 1 || $this$anchorPosition.getAnchor() == 3) {
            position.x = androidContentRect.left + androidContentRect.width() - adWidthDp - margin;
        }
        if ($this$anchorPosition.getAnchor() == 0 || $this$anchorPosition.getAnchor() == 1) {
            position.y = androidContentRect.top + margin;
        } else if ($this$anchorPosition.getAnchor() == 2 || $this$anchorPosition.getAnchor() == 3) {
            position.y = androidContentRect.top + androidContentRect.height() - adHeightDp - margin;
        }
        return position;
    }
}

