/*
 * Decompiled with CFR 0.152.
 */
package com.mobilefuse.sdk.config;

import com.mobilefuse.sdk.config.ObservableConfigKey;
import com.mobilefuse.sdk.config.Observer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ObservableConfig {
    private Set<Observer> observers = new HashSet<Observer>();
    private Map<ObservableConfigKey, Object> configMap = new HashMap<ObservableConfigKey, Object>();

    public void setValue(ObservableConfigKey key, Object value) throws Throwable {
        this.configMap.put(key, value);
        this.notifyChange(key, value);
    }

    public boolean hasValue(ObservableConfigKey key) throws Throwable {
        return this.configMap.containsKey((Object)key);
    }

    public Object getValue(ObservableConfigKey key) throws Throwable {
        return this.configMap.get((Object)key);
    }

    public void clearValue(ObservableConfigKey key) throws Throwable {
        if (!this.configMap.containsKey((Object)key)) {
            return;
        }
        this.configMap.remove((Object)key);
    }

    public boolean getBooleanValue(ObservableConfigKey key) throws Throwable {
        return this.getBooleanValue(key, false);
    }

    public boolean getBooleanValue(ObservableConfigKey key, boolean defaultValue) throws Throwable {
        Object value = this.getValue(key);
        if (!(value instanceof Boolean)) {
            return defaultValue;
        }
        return (Boolean)value;
    }

    public int getIntValue(ObservableConfigKey key, int defaultValue) throws Throwable {
        Object value = this.getValue(key);
        if (!(value instanceof Integer)) {
            return defaultValue;
        }
        return (Integer)value;
    }

    public long getLongValue(ObservableConfigKey key, long defaultValue) throws Throwable {
        Object value = this.getValue(key);
        if (!(value instanceof Long)) {
            return defaultValue;
        }
        return (Long)value;
    }

    public float getFloatValue(ObservableConfigKey key, float defaultValue) throws Throwable {
        Object value = this.getValue(key);
        if (!(value instanceof Float)) {
            return defaultValue;
        }
        return ((Float)value).floatValue();
    }

    private void notifyChange(ObservableConfigKey key, Object value) throws Throwable {
        HashSet<Observer> observersCopy = new HashSet<Observer>(this.observers);
        for (Observer observer : observersCopy) {
            observer.onChanged(key, value);
        }
    }

    public void registerObserver(Observer observer) throws Throwable {
        this.observers.add(observer);
    }

    public void unregisterObserver(Observer observer) throws Throwable {
        this.observers.remove(observer);
    }

    public void unregisterAll() throws Throwable {
        this.observers.clear();
    }
}

