/*
 * Decompiled with CFR 0.152.
 */
package com.mobilefuse.sdk.logging;

import com.mobilefuse.sdk.DebuggingKt;
import com.mobilefuse.sdk.logging.HttpRequestEvent;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0007J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u0011H\u0007J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0007R$\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\r\u0010\u0002\u00a8\u0006\u0015"}, d2={"Lcom/mobilefuse/sdk/logging/HttpRequestTracker;", "", "()V", "enabled", "", "getEnabled$annotations", "getEnabled", "()Z", "setEnabled", "(Z)V", "logs", "", "Lcom/mobilefuse/sdk/logging/HttpRequestEvent;", "getLogs$annotations", "clearLogs", "", "getLogs", "", "logHttpRequest", "url", "", "mobilefuse-sdk-common_release"})
public final class HttpRequestTracker {
    private static final List<HttpRequestEvent> logs;
    private static boolean enabled;
    @NotNull
    public static final HttpRequestTracker INSTANCE;

    @JvmStatic
    private static /* synthetic */ void getLogs$annotations() {
    }

    @JvmStatic
    public static /* synthetic */ void getEnabled$annotations() {
    }

    public static final boolean getEnabled() {
        return enabled;
    }

    public static final void setEnabled(boolean bl) {
        enabled = bl;
    }

    @JvmStatic
    public static final void logHttpRequest(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        if (!enabled) {
            return;
        }
        logs.add(new HttpRequestEvent(new Date(), url));
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-dd-MM HH:mm:ss.SSS", Locale.getDefault());
        String dateString = dateFormat.format(new Date());
        DebuggingKt.logDebug(INSTANCE, "TimeStamp: " + dateString + " URL: " + url, "[HttpRequestTracker]");
    }

    @JvmStatic
    @NotNull
    public static final List<HttpRequestEvent> getLogs() {
        return CollectionsKt.toList((Iterable)logs);
    }

    @JvmStatic
    public static final void clearLogs() {
        logs.clear();
    }

    private HttpRequestTracker() {
    }

    static {
        HttpRequestTracker httpRequestTracker;
        INSTANCE = httpRequestTracker = new HttpRequestTracker();
        logs = new ArrayList();
    }
}

