/*
 * Decompiled with CFR 0.152.
 */
package com.mobilefuse.sdk.mraid;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.RenderProcessGoneDetail;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.PopupWindow;
import android.widget.RelativeLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.mobilefuse.sdk.AdLifecycleEvent;
import com.mobilefuse.sdk.AdLifecycleEventListener;
import com.mobilefuse.sdk.AdRendererConfig;
import com.mobilefuse.sdk.AdRendererListener;
import com.mobilefuse.sdk.BaseAdRenderer;
import com.mobilefuse.sdk.ExtendedAdType;
import com.mobilefuse.sdk.StabilityHelper;
import com.mobilefuse.sdk.Utils;
import com.mobilefuse.sdk.ad.rendering.splashad.SplashAdController;
import com.mobilefuse.sdk.ad.view.CloseButton;
import com.mobilefuse.sdk.assetsmanager.MobileFuseAssetManager;
import com.mobilefuse.sdk.config.ObservableConfigKey;
import com.mobilefuse.sdk.device.GetLastKnownLocationDataKt;
import com.mobilefuse.sdk.device.LocationData;
import com.mobilefuse.sdk.internal.RtbLossReason;
import com.mobilefuse.sdk.logging.HttpRequestTracker;
import com.mobilefuse.sdk.mraid.MraidAdRendererContainer;
import com.mobilefuse.sdk.mraid.MraidFeatureDetection;
import com.mobilefuse.sdk.mraid.R;
import com.mobilefuse.sdk.omid.MraidOmidBridge;
import com.mobilefuse.sdk.omid.OmidFriendlyObstructionPurpose;
import com.mobilefuse.sdk.omid.OmidWebViewReleaser;
import com.mobilefuse.sdk.omid.viewtree.ViewTreeInspector;
import com.mobilefuse.sdk.rtb.ApiFramework;
import com.mobilefuse.sdk.telemetry.Telemetry;
import com.mobilefuse.sdk.utils.WebViewUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import org.json.JSONException;
import org.json.JSONObject;

public class MraidAdRenderer
extends BaseAdRenderer<MraidOmidBridge> {
    private static final long PROGRESS_BAR_SHOW_DELAY = 3000L;
    public static boolean webViewCrashTestAllowed = false;
    private static String WEB_VIEW_BASE_URL = "https://sdk-webview.mobilefuse.com";
    private WebView webView;
    @NonNull
    private WebViewLoadContentType webViewLoadContentType = WebViewLoadContentType.ADM;
    private RelativeLayout webViewContainer;
    private PopupWindow bannerExpandedWindow;
    private RelativeLayout.LayoutParams bannerInlineLayoutParams;
    private final Handler handler = new Handler(Looper.getMainLooper());
    private boolean expanded;
    private boolean showingAd;
    private boolean closingAd;
    private boolean activityOrientationChanged;
    private int notModifiedActivityOrientation = -1;
    private double lastExposurePrcnt = -1.0;
    @Nullable
    private ViewTreeInspector viewTreeInspector;
    private CloseButton closeBtn;
    private Boolean isMraidBridgeLoaded = false;
    private int screenWidth = 0;
    private int screenHeight = 0;

    public MraidAdRenderer(Context context, AdRendererConfig config, AdRendererListener listener) throws Throwable {
        super(context, config, listener);
        MraidFeatureDetection.initialize(context);
        this.createContainer();
        this.startActivityLifecycleChecking();
    }

    private int convertPxToDp(int value) {
        try {
            return Utils.convertPxToDp((Context)this.context, (int)value);
        }
        catch (Throwable t) {
            StabilityHelper.logException((Object)((Object)this), (Throwable)t);
            return 0;
        }
    }

    private void createContainer() throws Throwable {
        this.webViewContainer = new RelativeLayout(this.context);
        RelativeLayout.LayoutParams webViewContainerParams = new RelativeLayout.LayoutParams(-1, -1);
        this.webViewContainer.setLayoutParams((ViewGroup.LayoutParams)webViewContainerParams);
        this.webViewContainer.setGravity(0x800033);
        this.contentContainer = new MraidAdRendererContainer(this.context);
        ((MraidAdRendererContainer)this.contentContainer).setViewableChangeListener(new MraidAdRendererContainer.ViewableChangeListener(){

            @Override
            public void onViewableChange(int left, int top, int width, int height, double exposedPercentage, Rect localClippedArea) throws Throwable {
                if (MraidAdRenderer.this.expanded) {
                    exposedPercentage = 100.0;
                }
                if (MraidAdRenderer.this.lastExposurePrcnt != exposedPercentage && exposedPercentage > 0.0) {
                    MraidAdRenderer.this.setCurrentPosition(MraidAdRenderer.this.convertPxToDp(width), MraidAdRenderer.this.convertPxToDp(height), MraidAdRenderer.this.convertPxToDp(left), MraidAdRenderer.this.convertPxToDp(top));
                }
                MraidAdRenderer.this.lastExposurePrcnt = exposedPercentage;
                MraidAdRenderer.this.dispatchAdmExposureChangeEvent(MraidAdRenderer.this.lastExposurePrcnt, left, top, localClippedArea);
            }
        });
        ViewGroup.LayoutParams inlineContainerParams = new ViewGroup.LayoutParams(-1, -1);
        this.contentContainer.addView((View)this.webViewContainer);
        this.contentContainer.setLayoutParams(inlineContainerParams);
        this.contentContainer.setAttachedToWindowCallback(() -> {
            try {
                if (this.viewTreeInspector != null) {
                    this.viewTreeInspector.startObstructionsChecking();
                }
            }
            catch (Throwable e) {
                StabilityHelper.logException((Object)((Object)this), (Throwable)e);
            }
        });
        this.contentContainer.setDetachedFromWindowCallback(() -> {
            try {
                if (this.viewTreeInspector != null) {
                    this.viewTreeInspector.stopObstructionsChecking();
                }
            }
            catch (Throwable e) {
                StabilityHelper.logException((Object)((Object)this), (Throwable)e);
            }
        });
        if (this.config.isFullscreenAd() || this.config.isCloseButtonEnabled()) {
            this.addCloseButton(false);
        }
    }

    private void dispatchAdmExposureChangeEvent(double exposedPercentage, double left, double top, Rect currentView) throws Throwable {
        if (this.webView == null) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 19) {
            String formattedPercentage = String.format(Locale.US, "%.2f", exposedPercentage);
            String exposureObject = "";
            exposureObject = currentView == null ? "null" : "{  \"x\": " + this.convertPxToDp((int)left) + ",  \"y\": " + this.convertPxToDp((int)top) + ",  \"width\": " + this.convertPxToDp(currentView.width()) + ",  \"height\": " + this.convertPxToDp(currentView.height()) + "}";
            String occlusionRectangles = "null";
            this.webView.evaluateJavascript("mraid.bridge.setExposureChange(" + formattedPercentage + "," + exposureObject + "," + occlusionRectangles + ");", null);
            boolean isViewable = false;
            if (exposedPercentage > 50.0) {
                isViewable = true;
            }
            this.webView.evaluateJavascript("mraid.bridge.setIsViewable(" + isViewable + ");", null);
        }
    }

    private void createWebView() throws Throwable {
        if (this.webView != null) {
            return;
        }
        this.webView = new WebView(this.context);
        WebSettings settings = this.webView.getSettings();
        settings.setJavaScriptEnabled(true);
        settings.setAllowContentAccess(true);
        settings.setUseWideViewPort(false);
        if (Build.VERSION.SDK_INT >= 21) {
            settings.setMixedContentMode(0);
        }
        if (Build.VERSION.SDK_INT >= 17) {
            settings.setMediaPlaybackRequiresUserGesture(false);
        }
        this.webView.setHorizontalScrollbarOverlay(false);
        this.webView.setHorizontalScrollBarEnabled(false);
        this.webView.setVerticalScrollbarOverlay(false);
        this.webView.setVerticalScrollBarEnabled(false);
        this.webView.setOverScrollMode(2);
        if (this.isTransparentBackground()) {
            this.webView.setBackgroundColor(0);
            this.webView.setLayerType(2, null);
        } else {
            this.updateWebViewBackgroundColor();
        }
        this.webView.setWebViewClient(new WebViewClient(){

            @RequiresApi(api=19)
            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                try {
                    Uri parsed = Uri.parse((String)url);
                    String scheme = parsed.getScheme();
                    if (scheme == null) {
                        return true;
                    }
                    if (scheme.equals("mraid")) {
                        MraidAdRenderer.this.handleBridgeCall(parsed);
                        return true;
                    }
                    MraidAdRenderer.this.onClickThrough(MraidAdRenderer.this.context, url);
                }
                catch (Throwable e) {
                    StabilityHelper.logException((Object)((Object)this), (Throwable)e);
                }
                return true;
            }

            @RequiresApi(api=19)
            public void onPageFinished(WebView view, String url) {
                try {
                    if (url != null && url.equals("about:blank")) {
                        return;
                    }
                    MraidAdRenderer.this.onAdmLoaded();
                    if (MraidAdRenderer.this.hasOmidBridge()) {
                        ((MraidOmidBridge)MraidAdRenderer.this.omidBridge).initAdSession(MraidAdRenderer.this.context, view);
                        MraidAdRenderer.this.updateCloseBtnAsOmidFriendlyObstruction();
                        ((MraidOmidBridge)MraidAdRenderer.this.omidBridge).startAdSession();
                        ((MraidOmidBridge)MraidAdRenderer.this.omidBridge).signalAdLoadedEvent();
                        MraidAdRenderer.this.viewTreeInspector = new ViewTreeInspector((View)MraidAdRenderer.this.webView, friendlyObstructions -> {
                            if (MraidAdRenderer.this.omidBridge == null) {
                                return;
                            }
                            ((MraidOmidBridge)MraidAdRenderer.this.omidBridge).removeAllFriendlyObstructions();
                            for (View friendlyObstruction : friendlyObstructions) {
                                if (friendlyObstruction == MraidAdRenderer.this.closeBtn) continue;
                                ((MraidOmidBridge)MraidAdRenderer.this.omidBridge).addFriendlyObstruction(friendlyObstruction, OmidFriendlyObstructionPurpose.NOT_VISIBLE, null);
                            }
                            MraidAdRenderer.this.updateCloseBtnAsOmidFriendlyObstruction();
                        });
                        MraidAdRenderer.this.viewTreeInspector.startObstructionsChecking();
                        MraidAdRenderer.this.signalOmidAdImpression();
                    }
                    MraidAdRenderer.this.reportAdImpression();
                    Log.d((String)"MF", (String)"onPageFinished | init mraid.js");
                    if (MraidAdRenderer.this.extendedController instanceof SplashAdController) {
                        ((SplashAdController)MraidAdRenderer.this.extendedController).onWebViewPageFinished();
                    }
                }
                catch (Throwable e) {
                    StabilityHelper.logException((Object)((Object)this), (Throwable)e);
                }
                super.onPageFinished(view, url);
            }

            @Nullable
            public WebResourceResponse shouldInterceptRequest(WebView view, String url) {
                try {
                    Uri requestUri = Uri.parse((String)url);
                    WebResourceResponse mraidBridgeResponse = MraidAdRenderer.this.handleBridgeCallFromFetch(requestUri);
                    if (mraidBridgeResponse != null) {
                        return mraidBridgeResponse;
                    }
                    return WebViewUtils.shouldInterceptRequest(MraidAdRenderer.this.context, requestUri);
                }
                catch (Throwable e) {
                    StabilityHelper.logException((Object)((Object)this), (Throwable)e);
                    return super.shouldInterceptRequest(view, url);
                }
            }

            @RequiresApi(api=21)
            public WebResourceResponse shouldInterceptRequest(WebView view, WebResourceRequest request) {
                try {
                    if (request == null) {
                        return null;
                    }
                    WebResourceResponse mraidBridgeResponse = MraidAdRenderer.this.handleBridgeCallFromFetch(request.getUrl());
                    if (mraidBridgeResponse != null) {
                        return mraidBridgeResponse;
                    }
                    return WebViewUtils.shouldInterceptRequest(MraidAdRenderer.this.context, request.getUrl());
                }
                catch (Throwable e) {
                    StabilityHelper.logException((Object)((Object)this), (Throwable)e);
                    return super.shouldInterceptRequest(view, request);
                }
            }

            public void onLoadResource(WebView view, String url) {
                try {
                    HttpRequestTracker.logHttpRequest((String)url);
                }
                catch (Throwable e) {
                    StabilityHelper.logException((Object)((Object)this), (Throwable)e);
                }
                super.onLoadResource(view, url);
            }

            public boolean onRenderProcessGone(WebView view, RenderProcessGoneDetail detail) {
                try {
                    if (view != MraidAdRenderer.this.webView) {
                        return true;
                    }
                    Log.w((String)"Mraid Ad Renderer", (String)"WebView Render Process has gone.");
                    MraidAdRenderer.this.onAdRuntimeError(RtbLossReason.INTERNAL_ERROR);
                }
                catch (Throwable e) {
                    StabilityHelper.logException((Object)((Object)this), (Throwable)e);
                }
                return true;
            }
        });
        this.webView.setWebChromeClient(new WebChromeClient(){

            @Nullable
            public Bitmap getDefaultVideoPoster() {
                try {
                    Bitmap poster = super.getDefaultVideoPoster();
                    if (poster != null) {
                        return poster;
                    }
                }
                catch (Throwable poster) {
                    // empty catch block
                }
                try {
                    return Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                }
                catch (Throwable e) {
                    StabilityHelper.logException((Object)((Object)this), (Throwable)e);
                    return null;
                }
            }
        });
    }

    private void signalOmidAdImpression() {
        this.handler.postDelayed(() -> {
            try {
                if (this.hasOmidBridge()) {
                    ((MraidOmidBridge)this.omidBridge).signalAdImpressionEvent();
                }
            }
            catch (Throwable e) {
                StabilityHelper.logException((Object)((Object)this), (Throwable)e);
            }
        }, 200L);
    }

    private WebResourceResponse handleBridgeCallFromFetch(Uri uri) {
        try {
            if (uri == null) {
                return null;
            }
            String url = uri.toString();
            if (url == null) {
                return null;
            }
            String bridgeBaseUrl = WEB_VIEW_BASE_URL + "/mraid/";
            if (!url.startsWith(bridgeBaseUrl)) {
                return null;
            }
            url = url.replace(bridgeBaseUrl, "mraid://");
            final Uri mraidUri = Uri.parse((String)url);
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        MraidAdRenderer.this.handleBridgeCall(mraidUri);
                    }
                    catch (Throwable ex) {
                        StabilityHelper.logException((Object)this, (Throwable)ex);
                    }
                }
            });
            return new WebResourceResponse("text/plain", "utf-8", (InputStream)new ByteArrayInputStream("".getBytes()));
        }
        catch (Throwable ex) {
            StabilityHelper.logException((Object)((Object)this), (Throwable)ex);
            return null;
        }
    }

    private void onAdmLoaded() {
        try {
            if (this.webView == null) {
                return;
            }
            if (this.extendedController != null) {
                this.extendedController.onAdmLoaded();
            }
            this.contentContainer.hideProgressBar();
        }
        catch (Throwable e) {
            StabilityHelper.logException((Object)((Object)this), (Throwable)e);
        }
    }

    protected void preloadAdmImpl(String adm) throws Throwable {
        this.handler.postDelayed(() -> {
            try {
                this.onAdPreloaded();
            }
            catch (Throwable e) {
                StabilityHelper.logException((Object)((Object)this), (Throwable)e);
            }
        }, 200L);
    }

    private long getCloseButtonShowDelay() {
        try {
            String logMsg = "MraidRenderer skipOffset:\n";
            float skipAdSeconds = -1.0f;
            if (this.observableConfig.hasValue(ObservableConfigKey.FORCE_SKIP_SECONDS)) {
                skipAdSeconds = this.observableConfig.getFloatValue(ObservableConfigKey.FORCE_SKIP_SECONDS, -1.0f);
                logMsg = logMsg + "* use value from MFX bid response \"skipAdSeconds\"=" + skipAdSeconds + "\n";
            } else if (this.observableConfig.hasValue(ObservableConfigKey.MRAID_AD_SKIPOFFSET_SECONDS)) {
                skipAdSeconds = this.observableConfig.getFloatValue(ObservableConfigKey.MRAID_AD_SKIPOFFSET_SECONDS, -1.0f);
                logMsg = logMsg + "* use SDK hardcoded \"skipAdSeconds\"=" + skipAdSeconds + "\n";
            }
            if (skipAdSeconds < 0.0f) {
                skipAdSeconds = 0.0f;
                logMsg = logMsg + "* \"skipAdSeconds\" is less than 0, set it to 0";
            }
            Log.d((String)"MRAID", (String)logMsg);
            return (long)skipAdSeconds * 1000L;
        }
        catch (Throwable e) {
            StabilityHelper.logException((Object)((Object)this), (Throwable)e);
            return 0L;
        }
    }

    private void createExternalController() throws Throwable {
        if (this.extendedAdType == MraidExtendedAdType.SPLASH) {
            if (this.renderingActivity == null) {
                return;
            }
            this.extendedController = new SplashAdController(this.renderingActivity, (View)this.contentContainer, this.webView, this.omidBridge, (Function0<Unit>)((Function0)() -> {
                try {
                    this.requestAdClose();
                }
                catch (Throwable e) {
                    StabilityHelper.logException((Object)((Object)this), (Throwable)e);
                }
                return Unit.INSTANCE;
            }), (Function1<? super Throwable, Unit>)((Function1)e -> {
                try {
                    this.closeAd(true);
                }
                catch (Throwable ex) {
                    StabilityHelper.logException((Object)((Object)this), (Throwable)e);
                }
                return Unit.INSTANCE;
            }), (Function1<? super Boolean, Unit>)((Function1)closeBtnVisible -> {
                if (this.closeBtn != null) {
                    if (closeBtnVisible.booleanValue()) {
                        this.closeBtn.show();
                    } else {
                        this.closeBtn.hide();
                    }
                }
                return Unit.INSTANCE;
            }));
            if (this.observableConfig != null && this.observableConfig.hasValue(ObservableConfigKey.POSITION) && this.extendedAdType == MraidExtendedAdType.SPLASH) {
                ((SplashAdController)this.extendedController).setAnchor(this.observableConfig.getIntValue(ObservableConfigKey.POSITION, 3));
            }
            if (this.closeBtn != null) {
                this.closeBtn.setThumbnailMode(true);
            }
        }
    }

    public void renderAdmImpl() throws Throwable {
        if (this.extendedAdType == MraidExtendedAdType.INTERSTITIAL_TRANSPARENT) {
            this.contentContainer.showProgressBarWithDelay(3000L);
        }
        if ((this.config.isFullscreenAd() || this.config.isCloseButtonEnabled()) && this.closeBtn != null) {
            this.closeBtn.showWithDelay(this.getCloseButtonShowDelay());
        }
        this.createWebView();
        this.createExternalController();
        if (this.adm.indexOf("http") == 0) {
            this.webViewLoadContentType = WebViewLoadContentType.URL;
            this.webView.loadUrl(this.adm);
        } else if (this.adm.indexOf("chrome://crash") == 0 && webViewCrashTestAllowed) {
            this.webViewLoadContentType = WebViewLoadContentType.URL;
            this.webView.loadUrl(this.adm);
        } else {
            this.webViewLoadContentType = WebViewLoadContentType.ADM;
            String fullAdTag = this.createFullAdTag(this.adm);
            this.webView.loadDataWithBaseURL(WEB_VIEW_BASE_URL, fullAdTag, "text/html", "UTF-8", null);
        }
        if (this.extendedController != null) {
            this.extendedController.bindContent((View)this.contentContainer, this.renderingActivity);
        }
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -1);
        this.webViewContainer.addView((View)this.webView, 0, (ViewGroup.LayoutParams)params);
        this.showingAd = true;
    }

    protected void applyCurrentBackgroundColor() throws Throwable {
        this.updateWebViewBackgroundColor();
    }

    private void updateWebViewBackgroundColor() throws Throwable {
        if (this.isTransparentBackground()) {
            return;
        }
        if (this.webView == null) {
            return;
        }
        this.webView.setBackgroundColor(this.adBackgroundColor);
        this.webViewContainer.setBackgroundColor(this.adBackgroundColor);
        this.contentContainer.setBackgroundColor(this.adBackgroundColor);
    }

    private void addCloseButton(boolean transparent) throws Throwable {
        if (this.closeBtn == null) {
            this.closeBtn = new CloseButton(this.context, 60, R.id.closeBtn, (Function0<Unit>)((Function0)() -> {
                this.dispatchSkipAdAvailability();
                return Unit.INSTANCE;
            }), (Function0<Unit>)((Function0)() -> {
                try {
                    Log.d((String)"MRAID", (String)"Close button clicked");
                    this.requestAdClose();
                }
                catch (Throwable e) {
                    StabilityHelper.logException((Object)((Object)this), (Throwable)e);
                }
                return Unit.INSTANCE;
            }));
            this.closeBtn.setOnVisibilityChange((Function1<? super Boolean, Unit>)((Function1)visible -> {
                this.updateCloseBtnAsOmidFriendlyObstruction();
                return Unit.INSTANCE;
            }));
            RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(this.closeBtn.getInteractionSizePx(), this.closeBtn.getInteractionSizePx());
            params.alignWithParent = true;
            params.addRule(11);
            params.addRule(10);
            this.webViewContainer.addView((View)this.closeBtn, (ViewGroup.LayoutParams)params);
        }
        this.closeBtn.setTransparent(transparent);
        if (this.extendedController instanceof SplashAdController) {
            ((SplashAdController)this.extendedController).setExpandedCloseBtnTransparent(transparent);
            this.closeBtn.setThumbnailMode(true);
        } else {
            this.closeBtn.setThumbnailMode(this.config.isThumbnailSize());
        }
    }

    private void removeCloseBtnOmidFriendlyObstruction() {
        try {
            if (this.hasOmidBridge()) {
                CloseButton button = this.closeBtn;
                if (button == null) {
                    return;
                }
                ((MraidOmidBridge)this.omidBridge).removeFriendlyObstruction((View)button);
            }
        }
        catch (Throwable e) {
            StabilityHelper.logException((Object)((Object)this), (Throwable)e);
        }
    }

    private void updateCloseBtnAsOmidFriendlyObstruction() {
        try {
            if (this.hasOmidBridge()) {
                CloseButton button = this.closeBtn;
                if (button == null) {
                    return;
                }
                this.removeCloseBtnOmidFriendlyObstruction();
                if (button.isVisible()) {
                    ((MraidOmidBridge)this.omidBridge).addFriendlyObstruction((View)button, OmidFriendlyObstructionPurpose.CLOSE_AD, null);
                }
            }
        }
        catch (Throwable e) {
            StabilityHelper.logException((Object)((Object)this), (Throwable)e);
        }
    }

    private void removeCloseButton() throws Throwable {
        if (this.closeBtn == null) {
            return;
        }
        try {
            ((ViewGroup)this.closeBtn.getParent()).removeView((View)this.closeBtn);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.closeBtn.destroy();
        this.closeBtn = null;
    }

    private void requestAdPositionUpdate() throws Throwable {
        ((MraidAdRendererContainer)this.contentContainer).checkPosition();
    }

    private String createFullAdTag(String admTag) throws Throwable {
        String mraidEnvString = "{}";
        try {
            JSONObject mraidEnvironment = new JSONObject().put("version", (Object)"3.0").put("sdk", (Object)"mfx").put("sdkVersion", (Object)this.config.getSdkVersion()).put("appId", (Object)this.context.getPackageName()).put("ifa", (Object)this.config.getAdvertisingId()).put("limitAdTracking", this.config.isLimitTrackingEnabled()).put("coppa", this.config.isSubjectToCoppa()).put("debug", this.config.isTestMode());
            mraidEnvString = mraidEnvironment.toString();
        }
        catch (JSONException e) {
            StabilityHelper.logException((Object)((Object)this), (Throwable)e);
        }
        String environmentSetup = "<script>window.MRAID_ENV = " + mraidEnvString + ";</script>";
        String webViewInitCall = "";
        String fullTag = admTag + webViewInitCall;
        try {
            String adTemplate;
            String localFile = MobileFuseAssetManager.INSTANCE.getSpecificAssetContent("ad_template.html");
            String string = adTemplate = localFile == null ? Utils.getAssetContent((Context)this.context, (String)"mobilefuse/ad_template.html") : localFile;
            if (adTemplate != null) {
                fullTag = adTemplate.replace("{ADM_CONTENT}", fullTag);
                fullTag = fullTag.replace("{MRAID_ENV_CONFIG}", environmentSetup);
                String mraidBridgeInitScript = "<script>mraid.bridge.init(MRAID_ENV);</script>";
                fullTag = fullTag.replace("{MRAID_BRIDGE_INIT}", mraidBridgeInitScript);
            }
        }
        catch (Throwable ex) {
            StabilityHelper.logException((Object)((Object)this), (Throwable)ex);
        }
        if (this.hasOmidBridge()) {
            fullTag = ((MraidOmidBridge)this.omidBridge).injectOmidScriptContentIntoAdm(fullTag);
        }
        return fullTag;
    }

    public View getAdView() throws Throwable {
        return this.contentContainer;
    }

    @RequiresApi(api=19)
    private void handleBridgeCall(Uri callUri) throws Throwable {
        block33: {
            String command = callUri.getHost();
            Log.d((String)"MRAID", (String)("Call: " + command));
            if (this.closingAd) {
                return;
            }
            try {
                switch (command) {
                    case "open": {
                        String openUrl = callUri.getQueryParameter("url");
                        this.onClickThrough(this.context, openUrl);
                        break;
                    }
                    case "expand": {
                        if (this.config.isFullscreenAd() || this.expanded) {
                            return;
                        }
                        this.bannerInlineLayoutParams = (RelativeLayout.LayoutParams)this.webView.getLayoutParams();
                        this.contentContainer.removeView((View)this.webViewContainer);
                        this.webView.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
                        boolean allowOrientationChange = Boolean.parseBoolean(callUri.getQueryParameter("allowOrientationChange"));
                        String forceOrientation = callUri.getQueryParameter("forceOrientation");
                        if (this.renderingActivity != null && forceOrientation != null) {
                            this.notModifiedActivityOrientation = this.context.getResources().getConfiguration().orientation;
                            this.activityOrientationChanged = true;
                            Utils.lockOrientationFromExpand((Activity)this.renderingActivity, (boolean)allowOrientationChange, (String)forceOrientation);
                        }
                        View rootView = this.contentContainer.getRootView();
                        this.webView.setScaleX(1.0f);
                        this.webView.setScaleY(1.0f);
                        this.bannerExpandedWindow = new PopupWindow((View)this.webViewContainer, -1, -1, true);
                        this.bannerExpandedWindow.showAtLocation(rootView, 48, 0, 0);
                        this.bridge_SetState("EXPANDED");
                        this.expanded = true;
                        boolean useCustomClose = callUri.getBooleanQueryParameter("useCustomClose", false);
                        this.addCloseButton(useCustomClose);
                        this.closeBtn.show();
                        this.listener.onFullscreenChanged(true);
                        this.bridge_NotifySizeChangeEvent(this.screenWidth, this.screenHeight);
                        this.setCurrentPosition(this.screenWidth, this.screenHeight, 0, 0);
                        break;
                    }
                    case "close": {
                        this.requestAdClose();
                        break;
                    }
                    case "initBridge": {
                        this.isMraidBridgeLoaded = true;
                        this.startListeningLayoutChange();
                        String jsAdType = this.config.isFullscreenAd() ? "Mraid.PlacementType.INTERSTITIAL" : "Mraid.PlacementType.INLINE";
                        this.webView.evaluateJavascript("mraid.bridge.setPlacementType(" + jsAdType + ");", null);
                        this.setSupports();
                        this.setAdProperties(true);
                        this.bridge_SetState("DEFAULT");
                        this.bridge_NotifyReadyEvents();
                        break;
                    }
                    case "useCustomClose": {
                        boolean shouldUseCustomClose = callUri.getBooleanQueryParameter("shouldUseCustomClose", false);
                        this.addCloseButton(shouldUseCustomClose);
                        break;
                    }
                    case "setOrientationProperties": {
                        this.setOrientationProperties(callUri);
                        break;
                    }
                    case "unload": {
                        if (this.showingAd) {
                            this.requestAdClose();
                            break;
                        }
                        this.onAdRuntimeError(RtbLossReason.INTERNAL_ERROR);
                        break;
                    }
                    case "splashAdTransition": {
                        if (this.extendedController instanceof SplashAdController) {
                            ((SplashAdController)this.extendedController).requestTransition();
                        }
                        break;
                    }
                    case "splashAdExpand": {
                        if (this.extendedController instanceof SplashAdController) {
                            this.removeCloseBtnOmidFriendlyObstruction();
                            ((SplashAdController)this.extendedController).requestExpand();
                        }
                        break;
                    }
                    case "eventListenerWasAdded": {
                        this.verifyEventAdded(callUri);
                        break;
                    }
                    default: {
                        Log.w((String)"Mraid", (String)("Unimplemented command called: " + command));
                        break;
                    }
                }
            }
            catch (Throwable ex) {
                StabilityHelper.logException((Object)((Object)this), (Throwable)ex);
                if (this.listener == null) break block33;
                this.listener.onAdRuntimeError(RtbLossReason.INTERNAL_ERROR);
            }
        }
        if (this.webView != null) {
            this.webView.evaluateJavascript("mraid.bridge.nativeCallComplete();", null);
        }
    }

    private void verifyEventAdded(Uri callUri) {
        try {
            String event = callUri.getQueryParameter("event");
            if (event == null) {
                return;
            }
            switch (event) {
                case "exposureChange": {
                    this.requestAdPositionUpdate();
                    break;
                }
                case "sizeChange": {
                    int width = this.convertPxToDp(this.webView.getWidth());
                    int height = this.convertPxToDp(this.webView.getHeight());
                    this.bridge_NotifySizeChangeEvent(width, height);
                }
            }
        }
        catch (Throwable t) {
            StabilityHelper.logException((Object)((Object)this), (Throwable)t);
        }
    }

    protected void onActivityResumeImpl() throws Throwable {
        this.requestAdPositionUpdate();
        if (this.viewTreeInspector != null) {
            this.viewTreeInspector.startObstructionsChecking();
        }
    }

    protected void onActivityPauseImpl() throws Throwable {
        this.dispatchAdmExposureChangeEvent(0.0, 0.0, 0.0, null);
        if (this.viewTreeInspector != null) {
            this.viewTreeInspector.stopObstructionsChecking();
        }
    }

    private void onClickThrough(Context context, String url) {
        try {
            if (url == null || url.isEmpty() || context == null) {
                String msg = "onClickThrough called but URL or context are null" + url;
                Log.e((String)"Mraid", (String)msg);
                Telemetry.logException((Object)((Object)this), (Throwable)new Throwable(msg));
                return;
            }
            Uri uri = Uri.parse((String)url);
            Intent intent = new Intent("android.intent.action.VIEW", uri);
            intent.addFlags(0x10000000);
            if (intent.resolveActivity(context.getPackageManager()) != null) {
                context.startActivity(intent);
                this.listener.onAdClicked();
            }
        }
        catch (Throwable e) {
            StabilityHelper.logException((Object)((Object)this), (Throwable)e);
        }
    }

    protected boolean onAdCloseRequested() {
        try {
            if (this.extendedController instanceof SplashAdController) {
                this.requestAdClose();
                return false;
            }
        }
        catch (Throwable e) {
            StabilityHelper.logException((Object)((Object)this), (Throwable)e);
        }
        return true;
    }

    private void requestAdClose() throws Throwable {
        this.closingAd = true;
        if (this.expanded) {
            this.bridge_SetState("DEFAULT");
        } else if (this.config.isFullscreenAd()) {
            this.bridge_SetState("HIDDEN");
        }
        if (this.extendedController != null) {
            this.extendedController.requestAdClose(() -> this.closeAd(false));
        } else {
            this.closeAd(false);
        }
    }

    private void dismissBannerExpandedWindow() {
        try {
            PopupWindow window = this.bannerExpandedWindow;
            this.bannerExpandedWindow = null;
            if (window == null) {
                return;
            }
            window.dismiss();
        }
        catch (Throwable e) {
            StabilityHelper.logException((Object)((Object)this), (Throwable)e);
        }
    }

    private void closeAd(boolean runtimeError) throws Throwable {
        if (!this.showingAd) {
            return;
        }
        if (this.config.isFullscreenAd() || runtimeError) {
            this.showingAd = false;
        }
        this.dismissBannerExpandedWindow();
        if (this.activityOrientationChanged) {
            if (!this.config.isFullscreenAd() && this.renderingActivity != null) {
                this.renderingActivity.setRequestedOrientation(this.notModifiedActivityOrientation);
                Utils.unlockOrientation((Activity)this.renderingActivity);
            }
            this.notModifiedActivityOrientation = -1;
            this.activityOrientationChanged = false;
        }
        if (this.expanded) {
            this.expanded = false;
            this.closingAd = false;
            if (!runtimeError) {
                this.removeCloseButton();
                this.bridge_SetState("DEFAULT");
                this.webView.setLayoutParams((ViewGroup.LayoutParams)this.bannerInlineLayoutParams);
                this.contentContainer.addView((View)this.webViewContainer, (ViewGroup.LayoutParams)this.bannerInlineLayoutParams);
                this.listener.onFullscreenChanged(false);
            }
        } else {
            this.webView.stopLoading();
            this.onAdClosed();
        }
        if (runtimeError && this.webView != null) {
            if (this.webView.getParent() != null) {
                ((ViewGroup)this.webView.getParent()).removeView((View)this.webView);
            }
            this.webView.loadUrl("about:blank");
        }
        if (this.extendedController != null) {
            this.extendedController.unbindContent();
            this.extendedController = null;
        }
    }

    private void bridge_SetState(String state) throws Throwable {
        if (this.webView == null) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 19) {
            this.webView.evaluateJavascript("mraid.bridge.setState(Mraid.State." + state + ");", null);
        }
    }

    private void bridge_NotifyReadyEvents() throws Throwable {
        if (this.webView == null) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 19) {
            this.webView.evaluateJavascript("mraid.bridge.notifyReadyEvent();", null);
        }
    }

    private void bridge_NotifySizeChangeEvent(int width, int height) throws Throwable {
        if (this.webView == null) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 19) {
            this.webView.evaluateJavascript("mraid.bridge.notifySizeChangeEvent(" + width + ", " + height + ");", null);
        }
    }

    protected View.OnLayoutChangeListener getOnLayoutChangeListener(Context context) throws Throwable {
        return new View.OnLayoutChangeListener(){

            @RequiresApi(api=19)
            public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                try {
                    if (right == oldRight && bottom == oldBottom) {
                        return;
                    }
                    MraidAdRenderer.this.setAdProperties(false);
                    Log.d((String)"MF", (String)("onLayoutChange [left: " + left + ", top: " + top + ", right: " + right + ", bottom: " + bottom + "]"));
                    if (MraidAdRenderer.this.extendedController != null) {
                        MraidAdRenderer.this.extendedController.invalidateLayout();
                    }
                }
                catch (Throwable e) {
                    StabilityHelper.logException((Object)this, (Throwable)e);
                }
            }
        };
    }

    @RequiresApi(api=19)
    private void setSupports() throws Throwable {
        if (this.webView == null) {
            return;
        }
        try {
            JSONObject supportsJson = new JSONObject();
            supportsJson.put("sms", MraidFeatureDetection.getSmsSupport());
            supportsJson.put("tel", MraidFeatureDetection.getTelSupport());
            supportsJson.put("calendar", false);
            supportsJson.put("storePicture", false);
            supportsJson.put("inlineVideo", true);
            supportsJson.put("ar", true);
            supportsJson.put("barometricPressure", true);
            supportsJson.put("vpaid", MraidFeatureDetection.getVpaidSupported());
            supportsJson.put("location", MraidFeatureDetection.getLocationSupport());
            if (this.extendedAdType == MraidExtendedAdType.SPLASH) {
                supportsJson.put("splashAd", true);
            }
            if (this.config.isFullscreenAd()) {
                supportsJson.put("transparentBackground", true);
            }
            String supportsJsParams = supportsJson.toString();
            this.webView.evaluateJavascript("mraid.bridge.setSupports(" + supportsJsParams + ");", null);
            if (MraidFeatureDetection.getLocationSupport()) {
                this.setLocation();
            }
        }
        catch (Throwable ex) {
            StabilityHelper.logException((Object)((Object)this), (Throwable)ex);
        }
    }

    @RequiresApi(api=19)
    private void setCurrentAppOrientation() throws Throwable {
        if (this.webView == null) {
            return;
        }
        try {
            String orientationString = "none";
            boolean orientationLocked = false;
            if (this.renderingActivity != null) {
                int orientation = this.renderingActivity.getResources().getConfiguration().orientation;
                orientationString = orientation == 1 ? "portrait" : "landscape";
            }
            JSONObject paramsJson = new JSONObject();
            paramsJson.put("orientation", (Object)orientationString);
            paramsJson.put("locked", orientationLocked);
            String paramsJsonString = paramsJson.toString();
            this.webView.evaluateJavascript("mraid.bridge.setCurrentAppOrientation(" + paramsJsonString + ");", null);
        }
        catch (Throwable ex) {
            StabilityHelper.logException((Object)((Object)this), (Throwable)ex);
        }
    }

    private void setOrientationProperties(Uri callUri) throws Throwable {
        if (this.renderingActivity == null) {
            return;
        }
        boolean allowOrientationChange = true;
        String forceOrientation = "none";
        allowOrientationChange = Boolean.parseBoolean(callUri.getQueryParameter("allowOrientationChange"));
        forceOrientation = callUri.getQueryParameter("forceOrientation");
        if (this.expanded || this.config.isFullscreenAd()) {
            if (allowOrientationChange) {
                this.renderingActivity.setRequestedOrientation(-1);
            } else {
                int androidOrientation = 0;
                int currentOrientation = this.context.getResources().getConfiguration().orientation;
                switch (forceOrientation) {
                    case "landscape": {
                        androidOrientation = 2;
                        break;
                    }
                    case "portrait": {
                        androidOrientation = 1;
                        break;
                    }
                    case "none": {
                        androidOrientation = currentOrientation;
                        break;
                    }
                }
                Utils.setActivityOrientation((Activity)this.renderingActivity, (int)androidOrientation);
            }
        }
    }

    public void destroy() throws Throwable {
        try {
            super.destroy();
            if (this.viewTreeInspector != null) {
                this.viewTreeInspector.stopObstructionsChecking();
                this.viewTreeInspector = null;
            }
            if (this.webView != null) {
                if (this.webView.getParent() != null) {
                    ((ViewGroup)this.webView.getParent()).removeView((View)this.webView);
                }
                OmidWebViewReleaser.scheduleWebViewRelease((WebView)this.webView);
                this.webView = null;
            }
            this.removeCloseButton();
            if (this.handler != null) {
                this.handler.removeCallbacksAndMessages(null);
            }
            this.dismissBannerExpandedWindow();
            if (this.contentContainer != null) {
                ((MraidAdRendererContainer)this.contentContainer).setViewableChangeListener(null);
                if (this.contentContainer.getParent() != null) {
                    ((ViewGroup)this.contentContainer.getParent()).removeView((View)this.contentContainer);
                }
                this.contentContainer = null;
            }
            if (this.extendedController != null) {
                this.extendedController.unbindContent();
                this.extendedController = null;
            }
        }
        catch (Throwable ex) {
            StabilityHelper.logException((Object)((Object)this), (Throwable)ex);
        }
    }

    public void setMaxSizeAndPosition(final Boolean setDefaultPosition) {
        try {
            this.webViewContainer.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (MraidAdRenderer.this.webView == null) {
                            return;
                        }
                        int width = MraidAdRenderer.this.convertPxToDp(MraidAdRenderer.this.webView.getWidth());
                        int height = MraidAdRenderer.this.convertPxToDp(MraidAdRenderer.this.webView.getHeight());
                        int[] position = new int[2];
                        MraidAdRenderer.this.webView.getLocationOnScreen(position);
                        int posX = MraidAdRenderer.this.convertPxToDp(position[0]);
                        int posY = MraidAdRenderer.this.convertPxToDp(position[1]);
                        MraidAdRenderer.this.setCurrentPosition(width, height, posX, posY);
                        if (setDefaultPosition.booleanValue()) {
                            MraidAdRenderer.this.webView.evaluateJavascript("mraid.bridge.setDefaultPosition({\"x\": " + posX + ", \"y\": " + posY + ", \"width\": " + width + ", \"height\": " + height + "});", null);
                        } else {
                            MraidAdRenderer.this.bridge_NotifySizeChangeEvent(width, height);
                        }
                        int maxSizeWidth = MraidAdRenderer.this.screenWidth;
                        int maxSizeHeight = MraidAdRenderer.this.screenHeight;
                        if (MraidAdRenderer.this.renderingActivity != null) {
                            Rect rect = new Rect();
                            MraidAdRenderer.this.renderingActivity.getWindow().getDecorView().getWindowVisibleDisplayFrame(rect);
                            maxSizeWidth = MraidAdRenderer.this.convertPxToDp(rect.width());
                            maxSizeHeight = MraidAdRenderer.this.convertPxToDp(rect.height());
                        }
                        MraidAdRenderer.this.webView.evaluateJavascript("mraid.bridge.setMaxSize({\"width\": " + maxSizeWidth + ", \"height\": " + maxSizeHeight + "});", null);
                    }
                    catch (Throwable e) {
                        StabilityHelper.logException((Object)this, (Throwable)e);
                    }
                }
            });
        }
        catch (Throwable e) {
            StabilityHelper.logException((Object)((Object)this), (Throwable)e);
        }
    }

    private void setCurrentPosition(int width, int height, int posX, int posY) {
        this.webView.evaluateJavascript("mraid.bridge.setCurrentPosition({\"x\": " + posX + ", \"y\": " + posY + ", \"width\": " + width + ", \"height\": " + height + "});", null);
    }

    private void setScreenDimensions() {
        try {
            if (this.webView == null) {
                return;
            }
            int[] screenSize = Utils.getScreenSizeAsPixels((Context)this.context);
            this.screenWidth = this.convertPxToDp(screenSize[0]);
            this.screenHeight = this.convertPxToDp(screenSize[1]);
            this.webView.evaluateJavascript("mraid.bridge.setScreenSize({\"width\": " + this.screenWidth + ", \"height\": " + this.screenHeight + "});", null);
        }
        catch (Throwable t) {
            StabilityHelper.logException((Object)((Object)this), (Throwable)t);
        }
    }

    private void setAdProperties(Boolean setDefaultPosition) {
        try {
            if (!this.isMraidBridgeLoaded.booleanValue()) {
                return;
            }
            this.setCurrentAppOrientation();
            this.setScreenDimensions();
            this.setMaxSizeAndPosition(setDefaultPosition);
        }
        catch (Throwable e) {
            StabilityHelper.logException((Object)((Object)this), (Throwable)e);
        }
    }

    private void setLocation() {
        try {
            if (this.config.isLimitTrackingEnabled()) {
                return;
            }
            LocationData locationData = GetLastKnownLocationDataKt.getLastKnownLocationData();
            if (locationData != null) {
                this.webView.evaluateJavascript("mraid.bridge.setLocation({\"lat\": " + locationData.getLatitude() + ", \"lon\": " + locationData.getLongitude() + ", \"type\": " + 1 + ", \"accuracy\": " + locationData.getAccuracy() + ", \"lastfix\": " + locationData.getLastFixSeconds() + "});", null);
            }
        }
        catch (Throwable e) {
            StabilityHelper.logException((Object)((Object)this), (Throwable)e);
        }
    }

    public void setAdLifecycleEventListener(AdLifecycleEventListener adLifecycleEventListener) throws Throwable {
        super.setAdLifecycleEventListener(adLifecycleEventListener);
    }

    public static List<ApiFramework> getSupportedApiFrameworks() {
        ArrayList<ApiFramework> list = new ArrayList<ApiFramework>();
        list.add(ApiFramework.MRAID1);
        list.add(ApiFramework.MRAID2);
        list.add(ApiFramework.MRAID3);
        list.add(ApiFramework.OMID1);
        return list;
    }

    static enum WebViewLoadContentType {
        URL,
        ADM;

    }

    public static enum MraidExtendedAdType implements ExtendedAdType
    {
        INTERSTITIAL_TRANSPARENT,
        SPLASH;

    }

    public static enum MraidAdLifecycleEvent implements AdLifecycleEvent
    {
        MRAID_CREATE_CALENDAR_EVENT;

    }
}

