/*
 * Decompiled with CFR 0.152.
 */
package com.mobilefuse.sdk.mraid;

import android.content.Context;
import android.graphics.Rect;
import android.os.Handler;
import android.os.Looper;
import android.util.AttributeSet;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.mobilefuse.sdk.AdRendererContainer;
import com.mobilefuse.sdk.StabilityHelper;
import com.mobilefuse.sdk.Utils;
import java.util.Date;

public class MraidAdRendererContainer
extends AdRendererContainer {
    private boolean attachedToWindow;
    private boolean isOnscreen = false;
    private boolean isVideoOnScreen = false;
    private boolean isVisible = false;
    private Handler handler = new Handler(Looper.getMainLooper());
    private boolean viewableCheckPaused = false;
    private int checkPositionTimeInterval = 1000;
    private static final int MIN_MS_BETWEEN_CHECKPOSITION = 50;
    private Date timeOfLastCheckPosition = new Date();
    private ViewableChangeListener viewableChangeListener;
    @Nullable
    private OnLayoutListener onLayoutListener;

    public MraidAdRendererContainer(@NonNull Context context) throws Throwable {
        super(context);
    }

    public MraidAdRendererContainer(@NonNull Context context, @Nullable AttributeSet attrs) throws Throwable {
        super(context, attrs);
    }

    public MraidAdRendererContainer(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) throws Throwable {
        super(context, attrs, defStyleAttr);
    }

    @RequiresApi(api=21)
    public MraidAdRendererContainer(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) throws Throwable {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    public double checkPosition() throws Throwable {
        if (!this.attachedToWindow) {
            return 0.0;
        }
        if (this.tooManyCheckPositionRequests()) {
            return -1.0;
        }
        int[] viewLocation = new int[2];
        this.getLocationOnScreen(viewLocation);
        Rect globalClippedArea = new Rect();
        boolean visible = this.getGlobalVisibleRect(globalClippedArea);
        if (!visible) {
            globalClippedArea = new Rect(0, 0, 0, 0);
        }
        int left = viewLocation[0];
        int right = viewLocation[0] + this.getWidth();
        int top = viewLocation[1];
        int bottom = viewLocation[1] + this.getHeight();
        double visibleViewArea = globalClippedArea.height() * globalClippedArea.width();
        double totalArea = this.getHeight() * this.getWidth();
        double exposedPercentage = totalArea == 0.0 ? 0.0 : visibleViewArea / totalArea * 100.0;
        Context context = this.getContext();
        int[] screenSize = Utils.getScreenSizeAsPixels((Context)context);
        boolean bl = this.isOnscreen = right > 0 && left < screenSize[0] && bottom > 0 && top < screenSize[1];
        if (this.viewableChangeListener != null) {
            Rect localClippedArea = null;
            if (visible) {
                localClippedArea = new Rect();
                this.getLocalVisibleRect(localClippedArea);
            }
            this.viewableChangeListener.onViewableChange(left, top, this.getWidth(), this.getHeight(), exposedPercentage, localClippedArea);
        }
        this.timeOfLastCheckPosition = new Date();
        return exposedPercentage;
    }

    private boolean tooManyCheckPositionRequests() throws Throwable {
        Date now = new Date();
        long deltaT = now.getTime() - this.timeOfLastCheckPosition.getTime();
        return deltaT < 50L;
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        try {
            if (this.onLayoutListener != null) {
                this.onLayoutListener.onLayout(changed, left, top, right, bottom);
            }
            this.handler.postDelayed(() -> {
                try {
                    this.checkPosition();
                }
                catch (Throwable e) {
                    StabilityHelper.logException((Object)((Object)this), (Throwable)e);
                }
            }, 50L);
        }
        catch (Throwable e) {
            StabilityHelper.logException((Object)((Object)this), (Throwable)e);
        }
    }

    boolean isViewable() {
        return this.isOnscreen && this.isVisible;
    }

    public void setViewableChangeListener(ViewableChangeListener viewableChangeListener) {
        this.viewableChangeListener = viewableChangeListener;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.attachedToWindow = true;
        try {
            this.getViewTreeObserver().addOnScrollChangedListener(() -> {
                try {
                    this.checkPosition();
                }
                catch (Throwable e) {
                    StabilityHelper.logException((Object)((Object)this), (Throwable)e);
                }
            });
        }
        catch (Throwable e) {
            StabilityHelper.logException((Object)((Object)this), (Throwable)e);
        }
    }

    protected void onDetachedFromWindow() {
        this.attachedToWindow = false;
        try {
            this.getViewTreeObserver().removeOnScrollChangedListener(() -> {
                try {
                    this.checkPosition();
                }
                catch (Throwable e) {
                    StabilityHelper.logException((Object)((Object)this), (Throwable)e);
                }
            });
        }
        catch (Throwable e) {
            StabilityHelper.logException((Object)((Object)this), (Throwable)e);
        }
        super.onDetachedFromWindow();
    }

    @Nullable
    public OnLayoutListener getOnLayoutListener() {
        return this.onLayoutListener;
    }

    public void setOnLayoutListener(@Nullable OnLayoutListener onLayoutListener) {
        this.onLayoutListener = onLayoutListener;
    }

    public static interface ViewableChangeListener {
        public void onViewableChange(int var1, int var2, int var3, int var4, double var5, Rect var7) throws Throwable;
    }

    public static interface OnLayoutListener {
        public void onLayout(boolean var1, int var2, int var3, int var4, int var5);
    }
}

