/*
 * Decompiled with CFR 0.152.
 */
package com.mobilefuse.sdk.utils;

import android.content.Context;
import android.net.Uri;
import android.webkit.WebResourceResponse;
import com.mobilefuse.sdk.StabilityHelper;
import com.mobilefuse.sdk.Utils;
import com.mobilefuse.sdk.assetsmanager.MobileFuseAssetManager;
import com.mobilefuse.sdk.logging.HttpRequestTracker;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class WebViewUtils {
    private static Map<String, String> interceptionMap = new HashMap<String, String>();

    public static WebResourceResponse shouldInterceptRequest(Context context, Uri uri) throws Throwable {
        if (uri == null || uri.getPath() == null) {
            return null;
        }
        HttpRequestTracker.logHttpRequest((String)uri.getPath());
        Iterator<String> iterator = interceptionMap.keySet().iterator();
        String matchedResource = null;
        byte[] localFile = new byte[]{};
        while (iterator.hasNext()) {
            String key = iterator.next();
            if (!uri.getPath().contains(key)) continue;
            localFile = MobileFuseAssetManager.INSTANCE.getSpecificAssetBytes(key);
            matchedResource = interceptionMap.get(key);
            break;
        }
        if (matchedResource == null) {
            return null;
        }
        String resourceContent = null;
        if (localFile != null && localFile.length > 0) {
            return new WebResourceResponse("", "", (InputStream)new ByteArrayInputStream(localFile));
        }
        try {
            resourceContent = Utils.getAssetContent((Context)context, matchedResource);
        }
        catch (Throwable ex) {
            StabilityHelper.logException(WebViewUtils.class, (Throwable)ex);
        }
        if (resourceContent == null) {
            return null;
        }
        return new WebResourceResponse("", "", (InputStream)new ByteArrayInputStream(resourceContent.getBytes()));
    }

    static {
        interceptionMap.put("mraid.js", "mobilefuse/mraid.js");
        interceptionMap.put("vast.js", "mobilefuse/vast.js");
        interceptionMap.put("ad_close_controls.js", "mobilefuse/ad_close_controls.js");
        interceptionMap.put("close_button.js", "mobilefuse/close_button.js");
    }
}

