/*
 * Decompiled with CFR 0.152.
 */
package com.mobilefuse.sdk.utils;

import android.content.Context;
import android.net.Uri;
import android.webkit.WebResourceResponse;
import com.mobilefuse.sdk.StabilityHelper;
import com.mobilefuse.sdk.assetsmanager.MobileFuseAssetManager;
import com.mobilefuse.sdk.logging.HttpRequestTracker;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class WebViewUtils {
    private static Map<String, String> interceptionMap = new HashMap<String, String>();

    public static WebResourceResponse shouldInterceptRequest(Context context, Uri uri) throws Throwable {
        if (uri == null || uri.getPath() == null) {
            return null;
        }
        HttpRequestTracker.logHttpRequest((String)uri.getPath());
        try {
            Iterator<String> iterator = interceptionMap.keySet().iterator();
            String matchedResource = null;
            byte[] localFile = new byte[]{};
            while (iterator.hasNext()) {
                String key = iterator.next();
                if (!uri.getPath().contains(key)) continue;
                localFile = MobileFuseAssetManager.INSTANCE.getSpecificAssetBytes(key, context);
                matchedResource = interceptionMap.get(key);
                break;
            }
            if (matchedResource == null) {
                return null;
            }
            if (localFile != null && localFile.length > 0) {
                return new WebResourceResponse("", "", (InputStream)new ByteArrayInputStream(localFile));
            }
        }
        catch (Throwable t) {
            StabilityHelper.logException(WebViewUtils.class, (Throwable)t);
        }
        return null;
    }

    static {
        interceptionMap.put("mraid.js", "mobilefuse/mraid.js");
        interceptionMap.put("vast.js", "mobilefuse/vast.js");
        interceptionMap.put("ad_close_controls.js", "mobilefuse/ad_close_controls.js");
        interceptionMap.put("close_button.js", "mobilefuse/close_button.js");
    }
}

