/*
 * Decompiled with CFR 0.152.
 */
package com.mobilefuse.sdk.telemetry;

import android.util.Log;
import com.mobilefuse.sdk.telemetry.ExceptionHandler;
import com.mobilefuse.sdk.telemetry.TelemetryBreadcrumb;
import com.mobilefuse.sdk.telemetry.TelemetryService;
import com.mobilefuse.sdk.telemetry.implementations.SentryService;
import com.mobilefuse.sdk.telemetry.implementations.sentry.SentryHelpersKt;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.KotlinVersion;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/mobilefuse/sdk/telemetry/ExceptionHandler;", "", "()V", "Companion", "mobilefuse-sdk-telemetry_release"})
public final class ExceptionHandler {
    private static final List<TelemetryBreadcrumb> breadcrumbs;
    private static final Map<String, String> modules;
    private static final Map<String, String> variables;
    private static TelemetryService instance;
    @NotNull
    private static String releaseVersion;
    private static double sampleRate;
    @NotNull
    public static final Companion Companion;

    static {
        Companion = new Companion(null);
        breadcrumbs = new ArrayList();
        modules = new LinkedHashMap();
        variables = new LinkedHashMap();
        instance = new SentryService();
        releaseVersion = "Unset";
        try {
            Companion.registerModule("com.mobilefuse.sdk.telemetry", "1.8.0");
            Companion.registerModule("kotlin", KotlinVersion.CURRENT.toString());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @NotNull
    public static final String getReleaseVersion() {
        Companion companion = Companion;
        return releaseVersion;
    }

    public static final void setReleaseVersion(@NotNull String string) {
        Companion companion = Companion;
        releaseVersion = string;
    }

    public static final double getSampleRate() {
        Companion companion = Companion;
        return sampleRate;
    }

    public static final void setSampleRate(double value) {
        Companion.setSampleRate(value);
    }

    @JvmStatic
    public static final void setTelemetryService(@NotNull TelemetryService service) {
        Companion.setTelemetryService(service);
    }

    @JvmStatic
    public static final void captureException(@NotNull Throwable e, @NotNull String sender) {
        Companion.captureException(e, sender);
    }

    @JvmStatic
    public static final void logBreadcrumb(@NotNull String category, @NotNull String message, @Nullable Map<String, String> data) {
        Companion.logBreadcrumb(category, message, data);
    }

    @JvmStatic
    public static final void registerModule(@NotNull String module, @NotNull String version) {
        Companion.registerModule(module, version);
    }

    @JvmStatic
    public static final void registerVariable(@NotNull String variable, @NotNull String value) {
        Companion.registerVariable(variable, value);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\nH\u0007J0\u0010#\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020\n2\u0006\u0010%\u001a\u00020\n2\u0016\b\u0002\u0010&\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n\u0018\u00010'H\u0007J\u0018\u0010(\u001a\u00020\u001f2\u0006\u0010)\u001a\u00020\n2\u0006\u0010*\u001a\u00020\nH\u0007J\u0018\u0010+\u001a\u00020\u001f2\u0006\u0010,\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\nH\u0007J\u0010\u0010-\u001a\u00020\u001f2\u0006\u0010.\u001a\u00020\u0007H\u0007J\u0006\u0010/\u001a\u00020\u001fR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u000b\u001a\u00020\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\f\u0010\u0002\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R,\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u00128\u0006@FX\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0014\u0010\u0002\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/mobilefuse/sdk/telemetry/ExceptionHandler$Companion;", "", "()V", "breadcrumbs", "", "Lcom/mobilefuse/sdk/telemetry/TelemetryBreadcrumb;", "instance", "Lcom/mobilefuse/sdk/telemetry/TelemetryService;", "modules", "", "", "releaseVersion", "getReleaseVersion$annotations", "getReleaseVersion", "()Ljava/lang/String;", "setReleaseVersion", "(Ljava/lang/String;)V", "value", "", "sampleRate", "getSampleRate$annotations", "getSampleRate", "()D", "setSampleRate", "(D)V", "shouldTransmitToServer", "", "getShouldTransmitToServer", "()Z", "variables", "captureException", "", "e", "", "sender", "logBreadcrumb", "category", "message", "data", "", "registerModule", "module", "version", "registerVariable", "variable", "setTelemetryService", "service", "updateSampleRateFromServer", "mobilefuse-sdk-telemetry_release"})
    public static final class Companion {
        private final boolean getShouldTransmitToServer() {
            Companion companion;
            Companion $this$run = companion = Companion;
            boolean bl = false;
            return $this$run.getSampleRate() > 0.0 && Math.random() <= $this$run.getSampleRate();
        }

        @JvmStatic
        public static /* synthetic */ void getReleaseVersion$annotations() {
        }

        @NotNull
        public final String getReleaseVersion() {
            return releaseVersion;
        }

        public final void setReleaseVersion(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            releaseVersion = string;
        }

        @JvmStatic
        public static /* synthetic */ void getSampleRate$annotations() {
        }

        public final double getSampleRate() {
            return sampleRate;
        }

        public final void setSampleRate(double value) {
            sampleRate = value;
            Companion.logBreadcrumb("telemetry", "Adjusted sample rate", MapsKt.mapOf((Pair)TuplesKt.to((Object)"rate", (Object)String.valueOf(Companion.getSampleRate()))));
        }

        public final void updateSampleRateFromServer() {
            try {
                new Thread(updateSampleRateFromServer.1.INSTANCE).start();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        @JvmStatic
        public final void setTelemetryService(@NotNull TelemetryService service) {
            Intrinsics.checkNotNullParameter((Object)service, (String)"service");
            instance = service;
        }

        @JvmStatic
        public final void captureException(@NotNull Throwable e, @NotNull String sender) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
            try {
                Log.w((String)"MobileFuse.Stability", (String)"Gracefully handling an exception:");
                e.printStackTrace();
                if (this.getShouldTransmitToServer()) {
                    instance.captureException(e, sender, breadcrumbs, modules, variables);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        @JvmStatic
        public final void logBreadcrumb(@NotNull String category, @NotNull String message, @Nullable Map<String, String> data) {
            Intrinsics.checkNotNullParameter((Object)category, (String)"category");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            try {
                breadcrumbs.add(new TelemetryBreadcrumb(message, category, data, 0L, 8, null));
                if (data != null) {
                    Log.d((String)"MobileFuse.Telemetry", (String)('[' + category + "] " + message + ' ' + SentryHelpersKt.getJson(data)));
                } else {
                    Log.d((String)"MobileFuse.Telemetry", (String)('[' + category + "] " + message));
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        public static /* synthetic */ void logBreadcrumb$default(Companion companion, String string, String string2, Map map, int n, Object object) {
            if ((n & 4) != 0) {
                map = null;
            }
            companion.logBreadcrumb(string, string2, map);
        }

        @JvmStatic
        public final void registerModule(@NotNull String module, @NotNull String version) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            try {
                modules.put(module, version);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        @JvmStatic
        public final void registerVariable(@NotNull String variable, @NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            try {
                variables.put(variable, value);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

