/*
 * Decompiled with CFR 0.152.
 */
package com.mobilefuse.sdk.telemetry.implementations;

import android.util.Log;
import com.mobilefuse.sdk.encoding.Gzip;
import com.mobilefuse.sdk.telemetry.ExceptionHandler;
import com.mobilefuse.sdk.telemetry.TelemetryBreadcrumb;
import com.mobilefuse.sdk.telemetry.TelemetryService;
import com.mobilefuse.sdk.telemetry.implementations.sentry.SentryBreadcrumbs;
import com.mobilefuse.sdk.telemetry.implementations.sentry.SentryDataModelToJsonKt;
import com.mobilefuse.sdk.telemetry.implementations.sentry.SentryEvent;
import com.mobilefuse.sdk.telemetry.implementations.sentry.SentryException;
import com.mobilefuse.sdk.telemetry.implementations.sentry.SentryHelpersKt;
import com.mobilefuse.sdk.telemetry.implementations.sentry.SentryStackFrame;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002JN\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00122\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0012H\u0016J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0004H\u0002J\u0018\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/mobilefuse/sdk/telemetry/implementations/SentryService;", "Lcom/mobilefuse/sdk/telemetry/TelemetryService;", "()V", "host", "", "key", "projectId", "serviceSdkName", "serviceVersion", "captureException", "", "e", "", "sender", "breadcrumbs", "", "Lcom/mobilefuse/sdk/telemetry/TelemetryBreadcrumb;", "modules", "", "variables", "getStackFrameForCulprit", "Lcom/mobilefuse/sdk/telemetry/implementations/sentry/SentryStackFrame;", "exception", "Lcom/mobilefuse/sdk/telemetry/implementations/sentry/SentryException;", "culprit", "sendApiRequest", "endpoint", "jsonContent", "mobilefuse-sdk-telemetry_release"})
public final class SentryService
implements TelemetryService {
    private final String key;
    private final String projectId;
    private final String host;
    private final String serviceSdkName;
    private final String serviceVersion;

    @Override
    public void captureException(@NotNull Throwable e, @NotNull String sender, @NotNull List<TelemetryBreadcrumb> breadcrumbs, @NotNull Map<String, String> modules, @NotNull Map<String, String> variables) {
        Object culpritFunction;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
        Intrinsics.checkNotNullParameter(breadcrumbs, (String)"breadcrumbs");
        Intrinsics.checkNotNullParameter(modules, (String)"modules");
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        try {
            Object object = this.getStackFrameForCulprit(SentryHelpersKt.getSentryException(e), sender);
            if (object == null || (object = ((SentryStackFrame)object).getFunction()) == null) {
                object = "Unknown Function";
            }
            culpritFunction = object;
            StringBuilder stringBuilder = new StringBuilder().append(SentryHelpersKt.getSentryException(e).getType()).append(" in SDK ").append(ExceptionHandler.Companion.getReleaseVersion()).append(" (").append(sender).append('.').append((String)culpritFunction).append(") ").append("for '").append(variables.get("app.bundle")).append("': ");
            String string = e.getMessage();
            if (string == null) {
                string = e.toString();
            }
            culpritFunction = stringBuilder.append(string).toString();
        }
        catch (Throwable e2) {
            String string = e2.getMessage();
            if (string == null) {
                string = e2.toString();
            }
            culpritFunction = string;
        }
        String errorMessage = culpritFunction;
        SentryEvent event = new SentryEvent(errorMessage, SentryHelpersKt.getSentryException(e), modules, variables, ExceptionHandler.Companion.getReleaseVersion(), sender, new SentryBreadcrumbs(breadcrumbs), null, 0L, null, 896, null);
        String string = SentryDataModelToJsonKt.getJson(event).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"event.json.toString()");
        String payload = string;
        Log.d((String)"MobileFuse.Telemetry", (String)("Transmitting exception with eventId " + event.getEventId()));
        Log.d((String)"MobileFuse.Telemetry", (String)payload);
        this.sendApiRequest("store/", payload);
    }

    private final SentryStackFrame getStackFrameForCulprit(SentryException exception, String culprit) {
        for (SentryStackFrame frame : exception.getStacktrace().getFrames()) {
            if (Intrinsics.areEqual((Object)frame.getModule(), (Object)culprit) ^ true) continue;
            return frame;
        }
        return null;
    }

    private final void sendApiRequest(String endpoint, String jsonContent) {
        new Thread(new Runnable(this, endpoint, jsonContent){
            final /* synthetic */ SentryService this$0;
            final /* synthetic */ String $endpoint;
            final /* synthetic */ String $jsonContent;

            public final void run() {
                try {
                    OutputStream outputStream;
                    Object object;
                    URL url = new URL("https://" + SentryService.access$getKey$p(this.this$0) + '@' + SentryService.access$getHost$p(this.this$0) + "/api/" + SentryService.access$getProjectId$p(this.this$0) + '/' + this.$endpoint);
                    boolean isGzipped = false;
                    try {
                        object = Gzip.toGzipByteArray((String)this.$jsonContent);
                        byte[] it = object;
                        boolean bl = false;
                        isGzipped = true;
                    }
                    catch (Throwable e) {
                        String bl = this.$jsonContent;
                        Charset charset = Charsets.UTF_8;
                        byte[] byArray = bl.getBytes(charset);
                        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
                        object = byArray;
                    }
                    byte[] payload = object;
                    URLConnection uRLConnection = url.openConnection();
                    if (uRLConnection == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.net.HttpURLConnection");
                    }
                    Object $this$with = object = (Object)((HttpURLConnection)uRLConnection);
                    boolean bl = false;
                    ((HttpURLConnection)$this$with).setRequestMethod("POST");
                    long ts = System.currentTimeMillis() / (long)1000;
                    ((URLConnection)$this$with).setRequestProperty("User-Agent", SentryService.access$getServiceSdkName$p(this.this$0) + '/' + SentryService.access$getServiceVersion$p(this.this$0));
                    ((URLConnection)$this$with).setRequestProperty("Content-Type", "application/json");
                    ((URLConnection)$this$with).setRequestProperty("Content-Length", String.valueOf(payload.length));
                    ((URLConnection)$this$with).setRequestProperty("X-Sentry-Auth", "Sentry sentry_version=7,sentry_timestamp=" + ts + ",sentry_key=" + SentryService.access$getKey$p(this.this$0) + ",sentry_client=" + SentryService.access$getServiceSdkName$p(this.this$0) + '/' + SentryService.access$getServiceVersion$p(this.this$0));
                    if (isGzipped) {
                        ((URLConnection)$this$with).setRequestProperty("Content-Encoding", "gzip");
                    }
                    ((URLConnection)$this$with).connect();
                    OutputStream $this$with2 = outputStream = ((URLConnection)$this$with).getOutputStream();
                    boolean bl2 = false;
                    $this$with2.write(payload);
                    $this$with2.flush();
                    Log.d((String)"MobileFuse.Telemetry", (String)("Server Response: [" + ((HttpURLConnection)$this$with).getResponseCode() + '/' + ((HttpURLConnection)$this$with).getResponseMessage() + ']'));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            {
                this.this$0 = sentryService;
                this.$endpoint = string;
                this.$jsonContent = string2;
            }
        }).start();
    }

    public SentryService() {
        this.key = "24b4a64987c44acda8bf1f536d1a6ae8";
        this.projectId = "6512411";
        this.host = "o861477.ingest.sentry.io";
        this.serviceSdkName = "sentry-mf-kotlin";
        this.serviceVersion = "1.8.0";
    }

    public static final /* synthetic */ String access$getKey$p(SentryService $this) {
        return $this.key;
    }

    public static final /* synthetic */ String access$getHost$p(SentryService $this) {
        return $this.host;
    }

    public static final /* synthetic */ String access$getProjectId$p(SentryService $this) {
        return $this.projectId;
    }

    public static final /* synthetic */ String access$getServiceSdkName$p(SentryService $this) {
        return $this.serviceSdkName;
    }

    public static final /* synthetic */ String access$getServiceVersion$p(SentryService $this) {
        return $this.serviceVersion;
    }
}

