/*
 * Decompiled with CFR 0.152.
 */
package com.mobilefuse.sdk.telemetry;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import androidx.annotation.VisibleForTesting;
import com.mobilefuse.sdk.DebuggingKt;
import com.mobilefuse.sdk.StabilityHelperBridge;
import com.mobilefuse.sdk.info.GetAppInstallSourceKt;
import com.mobilefuse.sdk.telemetry.ExceptionHandler;
import com.mobilefuse.sdk.telemetry.TelemetryAction;
import com.mobilefuse.sdk.telemetry.TelemetryActionFactory;
import com.mobilefuse.sdk.telemetry.TelemetryActionReceiver;
import com.mobilefuse.sdk.telemetry.TelemetryAgent;
import com.mobilefuse.sdk.telemetry.TelemetryBaseActionType;
import com.mobilefuse.sdk.telemetry.TelemetryHelpersKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/mobilefuse/sdk/telemetry/Telemetry;", "", "()V", "Companion", "mobilefuse-sdk-telemetry_release"})
public final class Telemetry {
    private static boolean initialized;
    private static boolean enabled;
    private static boolean exceptionHandlerEnabled;
    private static boolean storeActionsEnabled;
    private static final Map<Integer, TelemetryAgent> agents;
    private static final List<TelemetryAction> mutableActions;
    private static final TelemetryAction defaultAppLaunchAction;
    @NotNull
    private static TelemetryAction appLaunchAction;
    @NotNull
    public static final Companion Companion;

    static {
        Companion = new Companion(null);
        enabled = true;
        exceptionHandlerEnabled = true;
        agents = new LinkedHashMap();
        mutableActions = Collections.synchronizedList(new ArrayList());
        appLaunchAction = defaultAppLaunchAction = new TelemetryAction(TelemetryHelpersKt.getTelemetryActionSender(Companion), TelemetryBaseActionType.APP_LAUNCHED, null, null, 0L, 28, null);
    }

    public static final boolean getInitialized() {
        Companion companion = Companion;
        return initialized;
    }

    private static final void setInitialized(boolean bl) {
        Companion companion = Companion;
        initialized = bl;
    }

    public static final boolean getEnabled() {
        Companion companion = Companion;
        return enabled;
    }

    public static final void setEnabled(boolean value) {
        Companion.setEnabled(value);
    }

    public static final boolean getExceptionHandlerEnabled() {
        Companion companion = Companion;
        return exceptionHandlerEnabled;
    }

    public static final void setExceptionHandlerEnabled(boolean bl) {
        Companion companion = Companion;
        exceptionHandlerEnabled = bl;
    }

    public static final boolean getStoreActionsEnabled() {
        Companion companion = Companion;
        return storeActionsEnabled;
    }

    public static final void setStoreActionsEnabled(boolean bl) {
        Companion companion = Companion;
        storeActionsEnabled = bl;
    }

    @JvmStatic
    @Nullable
    public static final TelemetryAgent getAgent(@NotNull Object owner) {
        return Companion.getAgent(owner);
    }

    @JvmStatic
    public static final synchronized void onAction(@NotNull TelemetryAction action) {
        Companion.onAction(action);
    }

    @JvmStatic
    public static final void onAppLaunch(@NotNull Object sender) {
        Companion.onAppLaunch(sender);
    }

    @JvmStatic
    public static final void onAppLaunchInternally(@NotNull Object sender) {
        Companion.onAppLaunchInternally(sender);
    }

    @JvmStatic
    public static final void logException(@NotNull Object sender, @NotNull Throwable exception) {
        Companion.logException(sender, exception);
    }

    @JvmStatic
    public static final void logException(@NotNull String sender, @NotNull Throwable exception) {
        Companion.logException(sender, exception);
    }

    @JvmStatic
    public static final void initialize(@NotNull Context context, @NotNull String releaseVersion) {
        Companion.initialize(context, releaseVersion);
    }

    @JvmStatic
    public static final void clear() {
        Companion.clear();
    }

    @JvmStatic
    @VisibleForTesting
    public static final void reset() {
        Companion.reset();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010!\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010*\u001a\u00020+H\u0007J\u0012\u0010,\u001a\u0004\u0018\u00010\u000b2\u0006\u0010-\u001a\u00020.H\u0007J\u0018\u0010/\u001a\u00020+2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u000203H\u0007J\u0018\u00104\u001a\u00020+2\u0006\u00105\u001a\u00020.2\u0006\u00106\u001a\u000207H\u0007J\u0018\u00104\u001a\u00020+2\u0006\u00105\u001a\u0002032\u0006\u00106\u001a\u000207H\u0007J\u0010\u00108\u001a\u00020+2\u0006\u00109\u001a\u00020\u0005H\u0007J\u0010\u0010:\u001a\u00020+2\u0006\u00105\u001a\u00020.H\u0007J\u0010\u0010;\u001a\u00020+2\u0006\u00105\u001a\u00020.H\u0007J\u0015\u0010<\u001a\u00020+2\u0006\u0010=\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b>J\b\u0010?\u001a\u00020+H\u0007R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\r\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u00148\u0006@FX\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0016\u0010\u0002\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR$\u0010\u001b\u001a\u00020\u00148\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u001c\u0010\u0002\u001a\u0004\b\u001d\u0010\u0018\"\u0004\b\u001e\u0010\u001aR,\u0010\u001f\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\u00148\u0006@BX\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b \u0010\u0002\u001a\u0004\b!\u0010\u0018\"\u0004\b\"\u0010\u001aR2\u0010#\u001a&\u0012\f\u0012\n %*\u0004\u0018\u00010\u00050\u0005 %*\u0012\u0012\f\u0012\n %*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010&\u001a\u00020\u00148\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b'\u0010\u0002\u001a\u0004\b(\u0010\u0018\"\u0004\b)\u0010\u001a\u00a8\u0006@"}, d2={"Lcom/mobilefuse/sdk/telemetry/Telemetry$Companion;", "Lcom/mobilefuse/sdk/telemetry/TelemetryActionReceiver;", "()V", "actions", "", "Lcom/mobilefuse/sdk/telemetry/TelemetryAction;", "getActions", "()Ljava/util/List;", "agents", "", "", "Lcom/mobilefuse/sdk/telemetry/TelemetryAgent;", "<set-?>", "appLaunchAction", "getAppLaunchAction", "()Lcom/mobilefuse/sdk/telemetry/TelemetryAction;", "setAppLaunchAction", "(Lcom/mobilefuse/sdk/telemetry/TelemetryAction;)V", "defaultAppLaunchAction", "value", "", "enabled", "getEnabled$annotations", "getEnabled", "()Z", "setEnabled", "(Z)V", "exceptionHandlerEnabled", "getExceptionHandlerEnabled$annotations", "getExceptionHandlerEnabled", "setExceptionHandlerEnabled", "initialized", "getInitialized$annotations", "getInitialized", "setInitialized", "mutableActions", "", "kotlin.jvm.PlatformType", "storeActionsEnabled", "getStoreActionsEnabled$annotations", "getStoreActionsEnabled", "setStoreActionsEnabled", "clear", "", "getAgent", "owner", "", "initialize", "context", "Landroid/content/Context;", "releaseVersion", "", "logException", "sender", "exception", "", "onAction", "action", "onAppLaunch", "onAppLaunchInternally", "registerAgent", "agent", "registerAgent$mobilefuse_sdk_telemetry_release", "reset", "mobilefuse-sdk-telemetry_release"})
    public static final class Companion
    implements TelemetryActionReceiver {
        @JvmStatic
        public static /* synthetic */ void getInitialized$annotations() {
        }

        public final boolean getInitialized() {
            return initialized;
        }

        private final void setInitialized(boolean bl) {
            initialized = bl;
        }

        @JvmStatic
        public static /* synthetic */ void getEnabled$annotations() {
        }

        public final boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(boolean value) {
            Companion.setExceptionHandlerEnabled(value);
            Companion.setStoreActionsEnabled(value);
            enabled = value;
        }

        @JvmStatic
        public static /* synthetic */ void getExceptionHandlerEnabled$annotations() {
        }

        public final boolean getExceptionHandlerEnabled() {
            return exceptionHandlerEnabled;
        }

        public final void setExceptionHandlerEnabled(boolean bl) {
            exceptionHandlerEnabled = bl;
        }

        @JvmStatic
        public static /* synthetic */ void getStoreActionsEnabled$annotations() {
        }

        public final boolean getStoreActionsEnabled() {
            return storeActionsEnabled;
        }

        public final void setStoreActionsEnabled(boolean bl) {
            storeActionsEnabled = bl;
        }

        @Override
        @NotNull
        public List<TelemetryAction> getActions() {
            List list = mutableActions;
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"mutableActions");
            return list;
        }

        @NotNull
        public final TelemetryAction getAppLaunchAction() {
            return appLaunchAction;
        }

        private final void setAppLaunchAction(TelemetryAction telemetryAction) {
            appLaunchAction = telemetryAction;
        }

        public final void registerAgent$mobilefuse_sdk_telemetry_release(@NotNull TelemetryAgent agent) {
            Intrinsics.checkNotNullParameter((Object)agent, (String)"agent");
            agents.put(agent.getOwnerHashCode(), agent);
        }

        @JvmStatic
        @Nullable
        public final TelemetryAgent getAgent(@NotNull Object owner) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            return (TelemetryAgent)agents.get(owner.hashCode());
        }

        @JvmStatic
        public final synchronized void onAction(@NotNull TelemetryAction action) {
            Intrinsics.checkNotNullParameter((Object)action, (String)"action");
            if (this.getStoreActionsEnabled()) {
                Collection collection = mutableActions;
                collection.add(action);
            }
            if (this.getExceptionHandlerEnabled()) {
                TelemetryHelpersKt.logBreadcrumb(action);
            }
        }

        @JvmStatic
        public final void onAppLaunch(@NotNull Object sender) {
            Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
            this.clear();
            this.setAppLaunchAction(TelemetryActionFactory.createAction$default(sender, TelemetryBaseActionType.APP_LAUNCHED, null, null, 12, null));
            this.onAction(this.getAppLaunchAction());
        }

        @JvmStatic
        public final void onAppLaunchInternally(@NotNull Object sender) {
            Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
            if (this.getAppLaunchAction() != defaultAppLaunchAction) {
                return;
            }
            this.onAppLaunch(sender);
        }

        @JvmStatic
        public final void logException(@NotNull Object sender, @NotNull Throwable exception) {
            Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
            Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
            try {
                String string = Reflection.getOrCreateKotlinClass(sender.getClass()).getSimpleName();
                if (string == null) {
                    string = sender.getClass().getSimpleName();
                }
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sender::class.simpleName\u2026er::class.java.simpleName");
                this.logException(string, exception);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        @JvmStatic
        public final void logException(@NotNull String sender, @NotNull Throwable exception) {
            Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
            Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
            if (this.getExceptionHandlerEnabled()) {
                try {
                    this.onAction(TelemetryHelpersKt.getTelemetryAction(exception));
                    ExceptionHandler.Companion.captureException(exception, sender);
                    return;
                }
                catch (Throwable throwable) {
                    DebuggingKt.logDebug$default((Object)this, (String)("Exception caught by " + sender), null, (int)2, null);
                    exception.printStackTrace();
                }
            } else {
                exception.printStackTrace();
                throw exception;
            }
        }

        @JvmStatic
        public final void initialize(@NotNull Context context, @NotNull String releaseVersion) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)releaseVersion, (String)"releaseVersion");
            if (this.getInitialized()) {
                return;
            }
            this.setInitialized(true);
            StabilityHelperBridge.INSTANCE.setLogExceptionFn((Function2)new Function2<Object, Throwable, Unit>(this){

                public final void invoke(@NotNull Object p1, @NotNull Throwable p2) {
                    Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                    Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                    ((Companion)this.receiver).logException(p1, p2);
                }
            });
            StabilityHelperBridge.INSTANCE.setRegisterExceptionHandlerVariableFn((Function2)new Function2<String, String, Unit>(ExceptionHandler.Companion){

                public final void invoke(@NotNull String p1, @NotNull String p2) {
                    Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                    Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                    ((ExceptionHandler.Companion)this.receiver).registerVariable(p1, p2);
                }
            });
            try {
                ExceptionHandler.Companion.setReleaseVersion(releaseVersion);
                Context context2 = context.getApplicationContext();
                Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context.applicationContext");
                String string = context2.getPackageName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.applicationContext.packageName");
                ExceptionHandler.Companion.registerVariable("app.bundle", string);
                PackageManager packageManager = context.getPackageManager();
                Context context3 = context.getApplicationContext();
                Intrinsics.checkNotNullExpressionValue((Object)context3, (String)"context.applicationContext");
                PackageInfo info = packageManager.getPackageInfo(context3.getPackageName(), 0);
                String string2 = info.versionName;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"info.versionName");
                ExceptionHandler.Companion.registerVariable("app.versionName", string2);
                ExceptionHandler.Companion.registerVariable("app.versionCode", "" + info.versionCode);
                ExceptionHandler.Companion.registerVariable("app.installSource", GetAppInstallSourceKt.getAppInstallSource(context));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        @JvmStatic
        public final void clear() {
            mutableActions.clear();
            Iterable $this$forEach$iv = agents.values();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TelemetryAgent it = (TelemetryAgent)element$iv;
                boolean bl = false;
                it.clearActions$mobilefuse_sdk_telemetry_release();
            }
            agents.clear();
        }

        @JvmStatic
        @VisibleForTesting
        public final void reset() {
            this.clear();
        }

        private Companion() {
        }

        public static final /* synthetic */ boolean access$getInitialized$p(Companion $this) {
            return $this.getInitialized();
        }

        public static final /* synthetic */ void access$setInitialized$p(Companion $this, boolean bl) {
            $this.setInitialized(bl);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

