/*
 * Decompiled with CFR 0.152.
 */
package com.mobilefuse.sdk.telemetry;

import com.mobilefuse.sdk.telemetry.LogLevel;
import com.mobilefuse.sdk.telemetry.LogLevelKt;
import com.mobilefuse.sdk.telemetry.Telemetry;
import com.mobilefuse.sdk.telemetry.TelemetryAction;
import com.mobilefuse.sdk.telemetry.TelemetryActionParam;
import com.mobilefuse.sdk.telemetry.TelemetryActionReceiver;
import com.mobilefuse.sdk.telemetry.TelemetryActionType;
import com.mobilefuse.sdk.telemetry.TelemetryBaseActionType;
import com.mobilefuse.sdk.telemetry.TelemetryBaseParamType;
import com.mobilefuse.sdk.telemetry.TelemetryDataModelKt;
import com.mobilefuse.sdk.telemetry.TelemetryHelpers;
import com.mobilefuse.sdk.telemetry.TelemetryHelpersKt;
import com.mobilefuse.sdk.telemetry.TelemetryManager;
import com.mobilefuse.sdk.telemetry.TelemetryParamType;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000t\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0003\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0004\u001a\u000e\u0010&\u001a\u00020\u00072\u0006\u0010'\u001a\u00020\u0007\u001a\u0019\u0010(\u001a\u00020\u00072\f\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*\u00a2\u0006\u0002\u0010,\u001a\u0006\u0010-\u001a\u00020.\u001a\u0016\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020.2\u0006\u00102\u001a\u00020.\u001a&\u00103\u001a\b\u0012\u0004\u0012\u00020\b04*\u00020\u00102\b\b\u0002\u00105\u001a\u0002062\n\b\u0002\u00107\u001a\u0004\u0018\u000108\u001a\u0012\u00109\u001a\u00020.*\u00020\u00102\u0006\u0010:\u001a\u00020\b\u001a\"\u0010;\u001a\u0004\u0018\u00010\b*\u00020\u00102\b\b\u0002\u00105\u001a\u0002062\n\b\u0002\u00107\u001a\u0004\u0018\u000108\u001a\u0014\u0010<\u001a\u0004\u0018\u00010\b*\u00020\u00102\u0006\u0010=\u001a\u00020\f\u001a\u0014\u0010>\u001a\u0004\u0018\u00010\u0002*\u00020\b2\u0006\u0010=\u001a\u00020\f\u001a\n\u0010?\u001a\u00020@*\u00020\b\u001a\u0015\u0010A\u001a\u00020\u0007*\u00020\b2\u0006\u0010B\u001a\u00020\bH\u0086\u0004\u001a\"\u0010C\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006*\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"!\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u0006*\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\"\u0015\u0010\u000b\u001a\u00020\u0007*\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\"\u0017\u0010\u000f\u001a\u0004\u0018\u00010\b*\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\"\u0015\u0010\u0013\u001a\u00020\u0007*\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\"\u0015\u0010\u0016\u001a\u00020\u0007*\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0015\"\u0015\u0010\u0018\u001a\u00020\u0007*\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\"\u0015\u0010\u001c\u001a\u00020\b*\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\"\u0015\u0010\u001f\u001a\u00020\u0007*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b \u0010!\"\u0015\u0010\"\u001a\u00020#*\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010%\u00a8\u0006D"}, d2={"beautifyValue", "", "Lcom/mobilefuse/sdk/telemetry/TelemetryActionParam;", "getBeautifyValue", "(Lcom/mobilefuse/sdk/telemetry/TelemetryActionParam;)Ljava/lang/Object;", "breadcrumbExtras", "", "", "Lcom/mobilefuse/sdk/telemetry/TelemetryAction;", "getBreadcrumbExtras", "(Lcom/mobilefuse/sdk/telemetry/TelemetryAction;)Ljava/util/Map;", "escapedName", "Lcom/mobilefuse/sdk/telemetry/TelemetryParamType;", "getEscapedName", "(Lcom/mobilefuse/sdk/telemetry/TelemetryParamType;)Ljava/lang/String;", "lastHttpResponseAction", "Lcom/mobilefuse/sdk/telemetry/TelemetryActionReceiver;", "getLastHttpResponseAction", "(Lcom/mobilefuse/sdk/telemetry/TelemetryActionReceiver;)Lcom/mobilefuse/sdk/telemetry/TelemetryAction;", "logTime", "getLogTime", "(Lcom/mobilefuse/sdk/telemetry/TelemetryAction;)Ljava/lang/String;", "logs", "getLogs", "stackTraceLog", "", "getStackTraceLog", "(Ljava/lang/Throwable;)Ljava/lang/String;", "telemetryAction", "getTelemetryAction", "(Ljava/lang/Throwable;)Lcom/mobilefuse/sdk/telemetry/TelemetryAction;", "telemetryActionSender", "getTelemetryActionSender", "(Ljava/lang/Object;)Ljava/lang/String;", "timestampDate", "Ljava/util/Date;", "getTimestampDate", "(Lcom/mobilefuse/sdk/telemetry/TelemetryAction;)Ljava/util/Date;", "beautifyJsonValue", "value", "formatStackTrace", "stackTrace", "", "Ljava/lang/StackTraceElement;", "([Ljava/lang/StackTraceElement;)Ljava/lang/String;", "getCurrentTimeMillis", "", "getTimeDiffSeconds", "", "startMillis", "endMillis", "getActions", "", "logLevel", "Lcom/mobilefuse/sdk/telemetry/LogLevel;", "actionType", "Lcom/mobilefuse/sdk/telemetry/TelemetryActionType;", "getHttpActionRequestTime", "responseAction", "getLastAction", "getLastActionWithParamOrNull", "paramType", "getLastParamOrNull", "logBreadcrumb", "", "logTimeSince", "earlierAction", "sanitizeVersionNames", "mobilefuse-sdk-telemetry_release"})
public final class TelemetryHelpersKt {
    @NotNull
    public static final String getLogTime(@NotNull TelemetryAction $this$logTime) {
        Intrinsics.checkNotNullParameter((Object)$this$logTime, (String)"$this$logTime");
        return TelemetryHelpersKt.logTimeSince($this$logTime, Telemetry.Companion.getAppLaunchAction());
    }

    @NotNull
    public static final String logTimeSince(@NotNull TelemetryAction $this$logTimeSince, @NotNull TelemetryAction earlierAction) {
        Intrinsics.checkNotNullParameter((Object)$this$logTimeSince, (String)"$this$logTimeSince");
        Intrinsics.checkNotNullParameter((Object)earlierAction, (String)"earlierAction");
        String string = TelemetryHelpers.Companion.getTimeLogFormat().format(new Date($this$logTimeSince.getTimestamp() - earlierAction.getTimestamp()));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TelemetryHelpers.timeLog\u2026earlierAction.timestamp))");
        return string;
    }

    public static final void logBreadcrumb(@NotNull TelemetryAction $this$logBreadcrumb) {
        Intrinsics.checkNotNullParameter((Object)$this$logBreadcrumb, (String)"$this$logBreadcrumb");
        try {
            if (!$this$logBreadcrumb.getType().getEnabledBreadcrumbSending()) {
                return;
            }
            TelemetryManager.Companion.logBreadcrumb($this$logBreadcrumb.getType().getCategory(), $this$logBreadcrumb.getType().getMessage(), TelemetryHelpersKt.getBreadcrumbExtras($this$logBreadcrumb), $this$logBreadcrumb.getLogLevel(), $this$logBreadcrumb.getType().getLogExtraMessage());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @NotNull
    public static final Map<String, Object> getBreadcrumbExtras(@NotNull TelemetryAction $this$breadcrumbExtras) {
        Intrinsics.checkNotNullParameter((Object)$this$breadcrumbExtras, (String)"$this$breadcrumbExtras");
        Map map = new LinkedHashMap();
        for (TelemetryActionParam param : $this$breadcrumbExtras.getExtras()) {
            if (!param.getIncludeToBreadcrumb()) continue;
            try {
                map.put(param.getType().getValue(), param.getValue());
            }
            catch (Throwable throwable) {}
        }
        return map;
    }

    @NotNull
    public static final Date getTimestampDate(@NotNull TelemetryAction $this$timestampDate) {
        Intrinsics.checkNotNullParameter((Object)$this$timestampDate, (String)"$this$timestampDate");
        return new Date($this$timestampDate.getTimestamp());
    }

    @NotNull
    public static final String getLogs(@NotNull TelemetryAction $this$logs) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)$this$logs, (String)"$this$logs");
        CharSequence charSequence2 = $this$logs.getType().getLogExtraMessage();
        if (charSequence2.length() == 0) {
            boolean bl = false;
            charSequence = $this$logs.getType().getMessage();
        } else {
            charSequence = charSequence2;
        }
        String message = (String)charSequence;
        String notIncludedParamsLogs = "";
        for (TelemetryActionParam param : $this$logs.getExtras()) {
            if (!param.getType().getPrintInLogs()) continue;
            if (StringsKt.indexOf$default((CharSequence)message, (String)TelemetryHelpersKt.getEscapedName(param.getType()), (int)0, (boolean)false, (int)6, null) < 0) {
                if (!$this$logs.getType().getIncludeImplicitParamsInLogs()) continue;
                notIncludedParamsLogs = notIncludedParamsLogs + "\n    + " + param.getType().getValue() + " = " + TelemetryHelpersKt.getBeautifyValue(param);
                continue;
            }
            message = StringsKt.replace$default((String)message, (String)TelemetryHelpersKt.getEscapedName(param.getType()), (String)TelemetryHelpersKt.getBeautifyValue(param).toString(), (boolean)false, (int)4, null);
        }
        CharSequence charSequence3 = message;
        Object object = "\\[\\[(.*?)\\]\\]";
        object = new Regex((String)object);
        String string = "";
        message = object.replace(charSequence3, string);
        charSequence3 = notIncludedParamsLogs;
        if (charSequence3.length() > 0) {
            message = message + notIncludedParamsLogs;
        }
        return message;
    }

    @NotNull
    public static final String getEscapedName(@NotNull TelemetryParamType $this$escapedName) {
        Intrinsics.checkNotNullParameter((Object)$this$escapedName, (String)"$this$escapedName");
        return "[[" + $this$escapedName + "]]";
    }

    @NotNull
    public static final Object getBeautifyValue(@NotNull TelemetryActionParam $this$beautifyValue) {
        Intrinsics.checkNotNullParameter((Object)$this$beautifyValue, (String)"$this$beautifyValue");
        if (!($this$beautifyValue.getValue() instanceof String)) {
            return $this$beautifyValue.getValue();
        }
        if ($this$beautifyValue.getType() == TelemetryBaseParamType.BODY) {
            return TelemetryHelpersKt.beautifyJsonValue($this$beautifyValue.getValue().toString());
        }
        return $this$beautifyValue.getValue();
    }

    @NotNull
    public static final String beautifyJsonValue(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        try {
            CharSequence charSequence = value;
            if (charSequence.length() == 0) {
                return value;
            }
            JSONObject json = new JSONObject(value);
            String string = json.toString(4);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"json.toString(4)");
            return string;
        }
        catch (Throwable throwable) {
            return value;
        }
    }

    @NotNull
    public static final String getStackTraceLog(@NotNull Throwable $this$stackTraceLog) {
        StringWriter stringWriter;
        Intrinsics.checkNotNullParameter((Object)$this$stackTraceLog, (String)"$this$stackTraceLog");
        StringWriter $this$with = stringWriter = new StringWriter();
        boolean bl = false;
        $this$stackTraceLog.printStackTrace(new PrintWriter((Writer)$this$with, true));
        String string = $this$with.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"with(StringWriter()) {\n \u2026\n        toString()\n    }");
        return string;
    }

    @NotNull
    public static final TelemetryAction getTelemetryAction(@NotNull Throwable $this$telemetryAction) {
        Intrinsics.checkNotNullParameter((Object)$this$telemetryAction, (String)"$this$telemetryAction");
        TelemetryActionParam actionParam = new TelemetryActionParam(TelemetryBaseParamType.EXCEPTION_DETAILS, TelemetryHelpersKt.getStackTraceLog($this$telemetryAction), false, 4, null);
        return new TelemetryAction(TelemetryHelpersKt.getTelemetryActionSender($this$telemetryAction), TelemetryBaseActionType.ACTION_EXCEPTION, CollectionsKt.mutableListOf((Object[])new TelemetryActionParam[]{actionParam}), LogLevel.ERROR, 0L, 16, null);
    }

    @NotNull
    public static final List<TelemetryAction> getActions(@NotNull TelemetryActionReceiver $this$getActions, @NotNull LogLevel logLevel, @Nullable TelemetryActionType actionType) {
        Intrinsics.checkNotNullParameter((Object)$this$getActions, (String)"$this$getActions");
        Intrinsics.checkNotNullParameter((Object)((Object)logLevel), (String)"logLevel");
        List list = new ArrayList();
        for (TelemetryAction action : $this$getActions.getActions()) {
            if (!LogLevelKt.contains(action.getLogLevel(), logLevel) || actionType != null && !TelemetryDataModelKt.isTheSameActionType(action.getType(), actionType)) continue;
            Collection collection = list;
            collection.add(action);
        }
        return list;
    }

    public static /* synthetic */ List getActions$default(TelemetryActionReceiver telemetryActionReceiver, LogLevel logLevel, TelemetryActionType telemetryActionType, int n, Object object) {
        if ((n & 1) != 0) {
            logLevel = LogLevel.INFO;
        }
        if ((n & 2) != 0) {
            telemetryActionType = null;
        }
        return TelemetryHelpersKt.getActions(telemetryActionReceiver, logLevel, telemetryActionType);
    }

    @Nullable
    public static final TelemetryAction getLastAction(@NotNull TelemetryActionReceiver $this$getLastAction, @NotNull LogLevel logLevel, @Nullable TelemetryActionType actionType) {
        Intrinsics.checkNotNullParameter((Object)$this$getLastAction, (String)"$this$getLastAction");
        Intrinsics.checkNotNullParameter((Object)((Object)logLevel), (String)"logLevel");
        List<TelemetryAction> actions = TelemetryHelpersKt.getActions($this$getLastAction, logLevel, actionType);
        return (TelemetryAction)CollectionsKt.lastOrNull(actions);
    }

    public static /* synthetic */ TelemetryAction getLastAction$default(TelemetryActionReceiver telemetryActionReceiver, LogLevel logLevel, TelemetryActionType telemetryActionType, int n, Object object) {
        if ((n & 1) != 0) {
            logLevel = LogLevel.INFO;
        }
        if ((n & 2) != 0) {
            telemetryActionType = null;
        }
        return TelemetryHelpersKt.getLastAction(telemetryActionReceiver, logLevel, telemetryActionType);
    }

    @Nullable
    public static final TelemetryAction getLastActionWithParamOrNull(@NotNull TelemetryActionReceiver $this$getLastActionWithParamOrNull, @NotNull TelemetryParamType paramType) {
        Intrinsics.checkNotNullParameter((Object)$this$getLastActionWithParamOrNull, (String)"$this$getLastActionWithParamOrNull");
        Intrinsics.checkNotNullParameter((Object)paramType, (String)"paramType");
        for (TelemetryAction action : CollectionsKt.asReversed($this$getLastActionWithParamOrNull.getActions())) {
            TelemetryActionParam actionParam = TelemetryHelpersKt.getLastParamOrNull(action, paramType);
            if (actionParam == null) continue;
            return action;
        }
        return null;
    }

    public static final long getHttpActionRequestTime(@NotNull TelemetryActionReceiver $this$getHttpActionRequestTime, @NotNull TelemetryAction responseAction) {
        Object requestActionInstance;
        Intrinsics.checkNotNullParameter((Object)$this$getHttpActionRequestTime, (String)"$this$getHttpActionRequestTime");
        Intrinsics.checkNotNullParameter((Object)responseAction, (String)"responseAction");
        TelemetryActionParam telemetryActionParam = TelemetryHelpersKt.getLastParamOrNull(responseAction, TelemetryBaseParamType.REQUEST_ACTION_INSTANCE);
        Object object = requestActionInstance = telemetryActionParam != null ? telemetryActionParam.getValue() : null;
        if (requestActionInstance == null || !(requestActionInstance instanceof TelemetryAction)) {
            return -1L;
        }
        return responseAction.getTimestamp() - ((TelemetryAction)requestActionInstance).getTimestamp();
    }

    @Nullable
    public static final TelemetryAction getLastHttpResponseAction(@NotNull TelemetryActionReceiver $this$lastHttpResponseAction) {
        Intrinsics.checkNotNullParameter((Object)$this$lastHttpResponseAction, (String)"$this$lastHttpResponseAction");
        return TelemetryHelpersKt.getLastActionWithParamOrNull($this$lastHttpResponseAction, TelemetryBaseParamType.REQUEST_ACTION_INSTANCE);
    }

    @Nullable
    public static final TelemetryActionParam getLastParamOrNull(@NotNull TelemetryAction $this$getLastParamOrNull, @NotNull TelemetryParamType paramType) {
        TelemetryActionParam telemetryActionParam;
        block1: {
            List<TelemetryActionParam> list;
            Intrinsics.checkNotNullParameter((Object)$this$getLastParamOrNull, (String)"$this$getLastParamOrNull");
            Intrinsics.checkNotNullParameter((Object)paramType, (String)"paramType");
            List<TelemetryActionParam> list2 = list = $this$getLastParamOrNull.getExtras();
            ListIterator<TelemetryActionParam> listIterator = list2.listIterator(list2.size());
            while (listIterator.hasPrevious()) {
                TelemetryActionParam telemetryActionParam2;
                TelemetryActionParam it = telemetryActionParam2 = listIterator.previous();
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getType(), (Object)paramType)) continue;
                telemetryActionParam = telemetryActionParam2;
                break block1;
            }
            telemetryActionParam = null;
        }
        return telemetryActionParam;
    }

    @NotNull
    public static final String getTelemetryActionSender(@NotNull Object $this$telemetryActionSender) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)$this$telemetryActionSender, (String)"$this$telemetryActionSender");
        try {
            String string;
            if (!Telemetry.Companion.getStoreActionsEnabled()) {
                string = "unknown source";
            } else if ($this$telemetryActionSender instanceof String) {
                string = (String)$this$telemetryActionSender;
            } else if ($this$telemetryActionSender instanceof Class && !((charSequence = (CharSequence)((Class)$this$telemetryActionSender).getSimpleName()) == null || charSequence.length() == 0)) {
                string = ((Class)$this$telemetryActionSender).getSimpleName();
            } else {
                charSequence = $this$telemetryActionSender.getClass().getSimpleName();
                if (!(charSequence == null || charSequence.length() == 0)) {
                    string = $this$telemetryActionSender.getClass().getSimpleName();
                } else {
                    string = $this$telemetryActionSender.getClass().getName();
                    if (string == null) {
                        string = "unknown source";
                    }
                }
            }
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"if (!Telemetry.storeActi\u2026unknown source\"\n        }");
            charSequence = string;
        }
        catch (Throwable e) {
            charSequence = "unknown source";
        }
        return charSequence;
    }

    public static final long getCurrentTimeMillis() {
        return System.currentTimeMillis();
    }

    public static final float getTimeDiffSeconds(long startMillis, long endMillis) {
        return (float)(endMillis - startMillis) / 1000.0f;
    }

    @NotNull
    public static final String formatStackTrace(@NotNull StackTraceElement[] stackTrace) {
        Intrinsics.checkNotNullParameter((Object)stackTrace, (String)"stackTrace");
        return ArraysKt.joinToString$default((Object[])stackTrace, (CharSequence)"\n", null, null, (int)0, null, (Function1)formatStackTrace.1.INSTANCE, (int)30, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<String, String> sanitizeVersionNames(@NotNull Map<String, String> $this$sanitizeVersionNames) {
        void $this$mapValuesTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$sanitizeVersionNames, (String)"$this$sanitizeVersionNames");
        Map<String, String> $this$mapValues$iv = $this$sanitizeVersionNames;
        boolean $i$f$mapValues = false;
        Map<String, String> map = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void $dstr$_u24__u24$value;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl2 = false;
            void var15_15 = $dstr$_u24__u24$value;
            String value = (String)var15_15.getValue();
            String string = StringsKt.startsWith$default((String)value, (String)"v", (boolean)false, (int)2, null) ? StringsKt.removePrefix((String)value, (CharSequence)"v") : value;
            map3.put(k, string);
        }
        return destination$iv$iv;
    }
}

