/*
 * Decompiled with CFR 0.152.
 */
package com.mobilefuse.sdk.telemetry;

import com.mobilefuse.sdk.telemetry.LogLevel;
import com.mobilefuse.sdk.telemetry.Telemetry;
import com.mobilefuse.sdk.telemetry.TelemetryAction;
import com.mobilefuse.sdk.telemetry.TelemetryHelpersKt;
import com.mobilefuse.sdk.telemetry.TimedStampedLog;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/mobilefuse/sdk/telemetry/TelemetryLogger;", "", "()V", "Companion", "mobilefuse-sdk-telemetry_release"})
public final class TelemetryLogger {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String getLogs(@NotNull LogLevel logLevel, @Nullable Function1<? super LogLevel, ? extends List<TelemetryAction>> actionsFactory) {
        return Companion.getLogs(logLevel, actionsFactory);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String getLogs(@NotNull LogLevel logLevel) {
        return com.mobilefuse.sdk.telemetry.TelemetryLogger$Companion.getLogs$default(Companion, logLevel, null, 2, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String getLogs() {
        return com.mobilefuse.sdk.telemetry.TelemetryLogger$Companion.getLogs$default(Companion, null, null, 3, null);
    }

    @JvmStatic
    @NotNull
    public static final List<TimedStampedLog> getTimedStampedLogs(@NotNull LogLevel logLevel, @Nullable Function1<? super LogLevel, ? extends List<TelemetryAction>> actionsFactory) {
        return Companion.getTimedStampedLogs(logLevel, actionsFactory);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\u001c\b\u0002\u0010\u0007\u001a\u0016\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t\u0018\u00010\bH\u0007J\u0016\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002J6\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\t2\b\b\u0002\u0010\u0005\u001a\u00020\u00062\u001c\b\u0002\u0010\u0007\u001a\u0016\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t\u0018\u00010\bH\u0007\u00a8\u0006\u0010"}, d2={"Lcom/mobilefuse/sdk/telemetry/TelemetryLogger$Companion;", "", "()V", "getLogs", "", "logLevel", "Lcom/mobilefuse/sdk/telemetry/LogLevel;", "actionsFactory", "Lkotlin/Function1;", "", "Lcom/mobilefuse/sdk/telemetry/TelemetryAction;", "getLongestActionSenderNameLength", "", "actions", "getTimedStampedLogs", "Lcom/mobilefuse/sdk/telemetry/TimedStampedLog;", "mobilefuse-sdk-telemetry_release"})
    public static final class Companion {
        @JvmStatic
        @JvmOverloads
        @NotNull
        public final String getLogs(@NotNull LogLevel logLevel, @Nullable Function1<? super LogLevel, ? extends List<TelemetryAction>> actionsFactory) {
            Intrinsics.checkNotNullParameter((Object)((Object)logLevel), (String)"logLevel");
            String logs = "";
            Object object = actionsFactory;
            if (object == null || (object = (List)object.invoke((Object)logLevel)) == null) {
                object = TelemetryHelpersKt.getActions$default(Telemetry.Companion, logLevel, null, 2, null);
            }
            Function1<? super LogLevel, ? extends List<TelemetryAction>> actions = object;
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-dd-MM HH:mm:ss.SSS", Locale.getDefault());
            String senderFormat = "%-" + this.getLongestActionSenderNameLength((List<TelemetryAction>)actions) + "s";
            Iterator iterator = actions.iterator();
            while (iterator.hasNext()) {
                TelemetryAction action = (TelemetryAction)iterator.next();
                if (!action.getType().getIncludeInLogsPrinting()) continue;
                StringBuilder stringBuilder = new StringBuilder().append(logs).append(dateFormat.format(TelemetryHelpersKt.getTimestampDate(action))).append(" | ").append((Object)action.getLogLevel()).append(" | ").append(TelemetryHelpersKt.getLogTime(action)).append(" | [");
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                Object[] objectArray = new Object[]{action.getSender()};
                String string = String.format(senderFormat, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(format, *args)");
                logs = stringBuilder.append(string).append("]").append(" ").append(TelemetryHelpersKt.getLogs(action)).append("\n\n").toString();
            }
            return logs;
        }

        public static /* synthetic */ String getLogs$default(Companion companion, LogLevel logLevel, Function1 function1, int n, Object object) {
            if ((n & 1) != 0) {
                logLevel = LogLevel.INFO;
            }
            if ((n & 2) != 0) {
                function1 = null;
            }
            return companion.getLogs(logLevel, (Function1<? super LogLevel, ? extends List<TelemetryAction>>)function1);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final String getLogs(@NotNull LogLevel logLevel) {
            return com.mobilefuse.sdk.telemetry.TelemetryLogger$Companion.getLogs$default(this, logLevel, null, 2, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final String getLogs() {
            return com.mobilefuse.sdk.telemetry.TelemetryLogger$Companion.getLogs$default(this, null, null, 3, null);
        }

        @JvmStatic
        @NotNull
        public final List<TimedStampedLog> getTimedStampedLogs(@NotNull LogLevel logLevel, @Nullable Function1<? super LogLevel, ? extends List<TelemetryAction>> actionsFactory) {
            Intrinsics.checkNotNullParameter((Object)((Object)logLevel), (String)"logLevel");
            List logs = new ArrayList();
            Object object = actionsFactory;
            if (object == null || (object = (List)object.invoke((Object)logLevel)) == null) {
                object = TelemetryHelpersKt.getActions$default(Telemetry.Companion, logLevel, null, 2, null);
            }
            Function1<? super LogLevel, ? extends List<TelemetryAction>> actions = object;
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-dd-MM HH:mm:ss.SSS", Locale.getDefault());
            String senderFormat = "%-" + this.getLongestActionSenderNameLength((List<TelemetryAction>)actions) + "s";
            Iterator iterator = actions.iterator();
            while (iterator.hasNext()) {
                TelemetryAction action = (TelemetryAction)iterator.next();
                if (!action.getType().getIncludeInLogsPrinting()) continue;
                Date date = TelemetryHelpersKt.getTimestampDate(action);
                StringBuilder stringBuilder = new StringBuilder().append(dateFormat.format(TelemetryHelpersKt.getTimestampDate(action))).append(" | ").append((Object)action.getLogLevel()).append(" | ").append(TelemetryHelpersKt.getLogTime(action)).append(" | [");
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                Object[] objectArray = new Object[]{action.getSender()};
                String string = String.format(senderFormat, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(format, *args)");
                logs.add(new TimedStampedLog(date, stringBuilder.append(string).append("]").append(" ").append(TelemetryHelpersKt.getLogs(action)).append("\n\n").toString()));
            }
            return logs;
        }

        public static /* synthetic */ List getTimedStampedLogs$default(Companion companion, LogLevel logLevel, Function1 function1, int n, Object object) {
            if ((n & 1) != 0) {
                logLevel = LogLevel.DEBUG;
            }
            if ((n & 2) != 0) {
                function1 = null;
            }
            return companion.getTimedStampedLogs(logLevel, (Function1<? super LogLevel, ? extends List<TelemetryAction>>)function1);
        }

        private final int getLongestActionSenderNameLength(List<TelemetryAction> actions) {
            int longestLength = 0;
            for (TelemetryAction action : actions) {
                if (action.getSender().length() <= longestLength) continue;
                longestLength = action.getSender().length();
            }
            return longestLength;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

