/*
 * Decompiled with CFR 0.152.
 */
package com.mobilefuse.sdk.telemetry;

import android.util.Log;
import com.mobilefuse.sdk.telemetry.LogLevel;
import com.mobilefuse.sdk.telemetry.TelemetryBreadcrumb;
import com.mobilefuse.sdk.telemetry.implementations.sentry.SentryHelpersKt;
import com.mobilefuse.sdk.telemetry.loggers.ExceptionHandler;
import com.mobilefuse.sdk.telemetry.loggers.LogsHandler;
import com.mobilefuse.sdk.telemetry.loggers.MetricsHandler;
import com.mobilefuse.sdk.telemetry.loggers.SampleRatesManager;
import com.mobilefuse.sdk.telemetry.metricslogging.MetricRecordName;
import com.mobilefuse.sdk.telemetry.metricslogging.TelemetryAdInfo;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.KotlinVersion;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/mobilefuse/sdk/telemetry/TelemetryManager;", "", "()V", "Companion", "mobilefuse-sdk-telemetry_release"})
public final class TelemetryManager {
    @NotNull
    private static String releaseVersion;
    private static final Map<String, String> modules;
    private static final Map<String, String> variables;
    private static final LogsHandler logsHandler;
    private static final MetricsHandler metricsHandler;
    @NotNull
    private static final ExceptionHandler exceptionHandler;
    private static final SampleRatesManager sampleRatesManager;
    @NotNull
    public static final Companion Companion;

    static {
        Companion = new Companion(null);
        releaseVersion = "Unset";
        modules = new LinkedHashMap();
        variables = new LinkedHashMap();
        logsHandler = new LogsHandler();
        metricsHandler = new MetricsHandler();
        exceptionHandler = new ExceptionHandler();
        sampleRatesManager = new SampleRatesManager(exceptionHandler, logsHandler, metricsHandler);
        try {
            Companion.registerModule("com.mobilefuse.sdk.telemetry", "1.9.0");
            Companion.registerModule("kotlin", KotlinVersion.CURRENT.toString());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @NotNull
    public static final String getReleaseVersion() {
        Companion companion = Companion;
        return releaseVersion;
    }

    public static final void setReleaseVersion(@NotNull String string) {
        Companion companion = Companion;
        releaseVersion = string;
    }

    @JvmStatic
    @NotNull
    public static final List<TelemetryBreadcrumb> getTelemetryEventList() {
        return Companion.getTelemetryEventList();
    }

    @JvmStatic
    @NotNull
    public static final Map<String, String> getModules() {
        return Companion.getModules();
    }

    @JvmStatic
    @NotNull
    public static final Map<String, String> getVariables() {
        return Companion.getVariables();
    }

    @JvmStatic
    public static final void logBreadcrumb(@NotNull String category, @NotNull String logType, @Nullable Map<String, ? extends Object> data, @NotNull LogLevel logLevel, @NotNull String message) {
        Companion.logBreadcrumb(category, logType, data, logLevel, message);
    }

    @JvmStatic
    public static final void registerModule(@NotNull String module, @NotNull String version) {
        Companion.registerModule(module, version);
    }

    @JvmStatic
    public static final void registerVariable(@NotNull String variable, @NotNull String value) {
        Companion.registerVariable(variable, value);
    }

    @JvmStatic
    public static final void updateSampleRateFromServer() {
        Companion.updateSampleRateFromServer();
    }

    @JvmStatic
    public static final void reportSessionStarted() {
        Companion.reportSessionStarted();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\fH\u0007J\u0006\u0010\u0018\u001a\u00020\rJ\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0007J\u0014\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\fH\u0007JB\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\r2\u0006\u0010 \u001a\u00020\r2\u0016\b\u0002\u0010!\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u0001\u0018\u00010\"2\b\b\u0002\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\rH\u0007J\u0018\u0010&\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020\r2\u0006\u0010(\u001a\u00020\rH\u0007J\u0018\u0010)\u001a\u00020\u001e2\u0006\u0010*\u001a\u00020\r2\u0006\u0010+\u001a\u00020\rH\u0007J\u0016\u0010,\u001a\u00020\u001e2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200J\b\u00101\u001a\u00020\u001eH\u0007J\b\u00102\u001a\u00020\u001eH\u0007R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u000e\u001a\u00020\r8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u000f\u0010\u0002\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/mobilefuse/sdk/telemetry/TelemetryManager$Companion;", "", "()V", "exceptionHandler", "Lcom/mobilefuse/sdk/telemetry/loggers/ExceptionHandler;", "getExceptionHandler", "()Lcom/mobilefuse/sdk/telemetry/loggers/ExceptionHandler;", "logsHandler", "Lcom/mobilefuse/sdk/telemetry/loggers/LogsHandler;", "metricsHandler", "Lcom/mobilefuse/sdk/telemetry/loggers/MetricsHandler;", "modules", "", "", "releaseVersion", "getReleaseVersion$annotations", "getReleaseVersion", "()Ljava/lang/String;", "setReleaseVersion", "(Ljava/lang/String;)V", "sampleRatesManager", "Lcom/mobilefuse/sdk/telemetry/loggers/SampleRatesManager;", "variables", "getModules", "getSessionId", "getTelemetryEventList", "", "Lcom/mobilefuse/sdk/telemetry/TelemetryBreadcrumb;", "getVariables", "logBreadcrumb", "", "category", "logType", "data", "", "logLevel", "Lcom/mobilefuse/sdk/telemetry/LogLevel;", "message", "registerModule", "module", "version", "registerVariable", "variable", "value", "reportAdMetric", "telemetryAdInfo", "Lcom/mobilefuse/sdk/telemetry/metricslogging/TelemetryAdInfo;", "events", "Lcom/mobilefuse/sdk/telemetry/metricslogging/MetricRecordName;", "reportSessionStarted", "updateSampleRateFromServer", "mobilefuse-sdk-telemetry_release"})
    public static final class Companion {
        @JvmStatic
        public static /* synthetic */ void getReleaseVersion$annotations() {
        }

        @NotNull
        public final String getReleaseVersion() {
            return releaseVersion;
        }

        public final void setReleaseVersion(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            releaseVersion = string;
        }

        @NotNull
        public final ExceptionHandler getExceptionHandler() {
            return exceptionHandler;
        }

        @JvmStatic
        @NotNull
        public final List<TelemetryBreadcrumb> getTelemetryEventList() {
            return logsHandler.getTelemetryEventList();
        }

        @JvmStatic
        @NotNull
        public final Map<String, String> getModules() {
            return modules;
        }

        @JvmStatic
        @NotNull
        public final Map<String, String> getVariables() {
            return variables;
        }

        @JvmStatic
        public final void logBreadcrumb(@NotNull String category, @NotNull String logType, @Nullable Map<String, ? extends Object> data, @NotNull LogLevel logLevel, @NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)category, (String)"category");
            Intrinsics.checkNotNullParameter((Object)logType, (String)"logType");
            Intrinsics.checkNotNullParameter((Object)((Object)logLevel), (String)"logLevel");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            try {
                TelemetryBreadcrumb breadcrumb = new TelemetryBreadcrumb(message, category, data, 0L, logLevel, logType, false, 72, null);
                if (data != null) {
                    Log.d((String)"MobileFuse.Telemetry", (String)('[' + category + "] " + message + ' ' + SentryHelpersKt.getJsonWithStringValues(data)));
                } else {
                    Log.d((String)"MobileFuse.Telemetry", (String)('[' + category + "] " + message));
                }
                logsHandler.reportBreadcrumb(breadcrumb);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }

        public static /* synthetic */ void logBreadcrumb$default(Companion companion, String string, String string2, Map map, LogLevel logLevel, String string3, int n, Object object) {
            if ((n & 4) != 0) {
                map = null;
            }
            if ((n & 8) != 0) {
                logLevel = LogLevel.INFO;
            }
            companion.logBreadcrumb(string, string2, map, logLevel, string3);
        }

        @JvmStatic
        public final void registerModule(@NotNull String module, @NotNull String version) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            try {
                modules.put(module, version);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        @JvmStatic
        public final void registerVariable(@NotNull String variable, @NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            try {
                variables.put(variable, value);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        @JvmStatic
        public final void updateSampleRateFromServer() {
            sampleRatesManager.updateSampleRateFromServer();
        }

        @JvmStatic
        public final void reportSessionStarted() {
            logsHandler.reportSessionStarted(modules, variables);
        }

        public final void reportAdMetric(@NotNull TelemetryAdInfo telemetryAdInfo, @NotNull MetricRecordName events) {
            Intrinsics.checkNotNullParameter((Object)telemetryAdInfo, (String)"telemetryAdInfo");
            Intrinsics.checkNotNullParameter((Object)((Object)events), (String)"events");
            metricsHandler.reportMetric(telemetryAdInfo, events);
        }

        @NotNull
        public final String getSessionId() {
            return logsHandler.getSessionId();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

