/*
 * Decompiled with CFR 0.152.
 */
package com.mobilefuse.sdk.telemetry.loggers;

import android.util.Log;
import com.mobilefuse.sdk.telemetry.LogLevel;
import com.mobilefuse.sdk.telemetry.TelemetryBreadcrumb;
import com.mobilefuse.sdk.telemetry.TelemetryHelpersKt;
import com.mobilefuse.sdk.telemetry.TelemetryManager;
import com.mobilefuse.sdk.telemetry.TelemetryService;
import com.mobilefuse.sdk.telemetry.implementations.SentryService;
import com.mobilefuse.sdk.telemetry.loggers.BaseSampleRate;
import com.mobilefuse.sdk.telemetry.mfxlogs.EventTypes;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJN\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u0010H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/mobilefuse/sdk/telemetry/loggers/ExceptionHandler;", "Lcom/mobilefuse/sdk/telemetry/loggers/BaseSampleRate;", "()V", "sentryService", "Lcom/mobilefuse/sdk/telemetry/TelemetryService;", "captureException", "", "e", "", "sender", "", "reportException", "telemetryBreadcrumbList", "", "Lcom/mobilefuse/sdk/telemetry/TelemetryBreadcrumb;", "modules", "", "variables", "mobilefuse-sdk-telemetry_release"})
public final class ExceptionHandler
extends BaseSampleRate {
    private TelemetryService sentryService = new SentryService();

    public final void captureException(@NotNull Throwable e, @NotNull String sender) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
        try {
            this.reportException(e, sender, TelemetryManager.Companion.getTelemetryEventList(), TelemetryManager.Companion.getModules(), TelemetryManager.Companion.getVariables());
            String message = "An exception occurred: " + e.getMessage();
            Object[] objectArray = e.getStackTrace();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"e.stackTrace");
            StackTraceElement exceptionInfo = (StackTraceElement)ArraysKt.first((Object[])objectArray);
            Pair[] pairArray = new Pair[4];
            pairArray[0] = TuplesKt.to((Object)"message", (Object)String.valueOf(e.getMessage()));
            StackTraceElement stackTraceElement = exceptionInfo;
            Intrinsics.checkNotNullExpressionValue((Object)stackTraceElement, (String)"exceptionInfo");
            pairArray[1] = TuplesKt.to((Object)"file", (Object)stackTraceElement.getFileName());
            pairArray[2] = TuplesKt.to((Object)"line", (Object)exceptionInfo.getLineNumber());
            StackTraceElement[] stackTraceElementArray = e.getStackTrace();
            Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"e.stackTrace");
            pairArray[3] = TuplesKt.to((Object)"trace", (Object)TelemetryHelpersKt.formatStackTrace(stackTraceElementArray));
            Map extras = MapsKt.mutableMapOf((Pair[])pairArray);
            TelemetryManager.Companion.logBreadcrumb("exception", EventTypes.EXCEPTION.getValue(), extras, LogLevel.ERROR, message);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private final void reportException(Throwable e, String sender, List<TelemetryBreadcrumb> telemetryBreadcrumbList, Map<String, String> modules, Map<String, String> variables) {
        Log.w((String)"MobileFuse.Stability", (String)("Gracefully handling an exception: " + e.getMessage()));
        e.printStackTrace();
        if (this.getShouldTransmitToServer()) {
            this.sentryService.captureException(e, sender, telemetryBreadcrumbList, modules, variables);
        }
    }
}

