/*
 * Decompiled with CFR 0.152.
 */
package com.mobilefuse.sdk.telemetry.loggers;

import androidx.annotation.VisibleForTesting;
import com.mobilefuse.sdk.concurrency.SchedulersKt;
import com.mobilefuse.sdk.telemetry.loggers.ExceptionHandler;
import com.mobilefuse.sdk.telemetry.loggers.LogsHandler;
import com.mobilefuse.sdk.telemetry.loggers.MetricsHandler;
import java.net.URL;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\nH\u0002J\u0006\u0010\u0019\u001a\u00020\u0016J \u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001cH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR$\u0010\r\u001a\u00020\u000e8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001f"}, d2={"Lcom/mobilefuse/sdk/telemetry/loggers/SampleRatesManager;", "", "exceptionHandler", "Lcom/mobilefuse/sdk/telemetry/loggers/ExceptionHandler;", "logsHandler", "Lcom/mobilefuse/sdk/telemetry/loggers/LogsHandler;", "metricsHandler", "Lcom/mobilefuse/sdk/telemetry/loggers/MetricsHandler;", "(Lcom/mobilefuse/sdk/telemetry/loggers/ExceptionHandler;Lcom/mobilefuse/sdk/telemetry/loggers/LogsHandler;Lcom/mobilefuse/sdk/telemetry/loggers/MetricsHandler;)V", "sdkVersion", "", "getSdkVersion", "()Ljava/lang/String;", "serverURL", "Ljava/net/URL;", "getServerURL$mobilefuse_sdk_telemetry_release$annotations", "()V", "getServerURL$mobilefuse_sdk_telemetry_release", "()Ljava/net/URL;", "setServerURL$mobilefuse_sdk_telemetry_release", "(Ljava/net/URL;)V", "getSampleRates", "", "parseJsonSampleRateResponse", "response", "updateSampleRateFromServer", "updateSampleRates", "exceptionSampleRate", "", "logsSampleRate", "metricsSampleRate", "mobilefuse-sdk-telemetry_release"})
public final class SampleRatesManager {
    @NotNull
    private final String sdkVersion;
    @NotNull
    private URL serverURL;
    private final ExceptionHandler exceptionHandler;
    private final LogsHandler logsHandler;
    private final MetricsHandler metricsHandler;

    @NotNull
    public final String getSdkVersion() {
        return this.sdkVersion;
    }

    @VisibleForTesting
    public static /* synthetic */ void getServerURL$mobilefuse_sdk_telemetry_release$annotations() {
    }

    @NotNull
    public final URL getServerURL$mobilefuse_sdk_telemetry_release() {
        return this.serverURL;
    }

    public final void setServerURL$mobilefuse_sdk_telemetry_release(@NotNull URL uRL) {
        Intrinsics.checkNotNullParameter((Object)uRL, (String)"<set-?>");
        this.serverURL = uRL;
    }

    public final void updateSampleRateFromServer() {
        SchedulersKt.safelyRunOnBgThread$default(null, (Function0)((Function0)new Function0<Unit>(this){
            final /* synthetic */ SampleRatesManager this$0;

            public final void invoke() {
                SampleRatesManager.access$getSampleRates(this.this$0);
            }
            {
                this.this$0 = sampleRatesManager;
                super(0);
            }
        }), (int)1, null);
    }

    private final void getSampleRates() {
        SchedulersKt.safelyRunOnBgThread$default(null, (Function0)((Function0)new Function0<Unit>(this){
            final /* synthetic */ SampleRatesManager this$0;

            public final void invoke() {
                URL uRL = this.this$0.getServerURL$mobilefuse_sdk_telemetry_release();
                Charset charset = Charsets.UTF_8;
                byte[] byArray = TextStreamsKt.readBytes((URL)uRL);
                String response = new String(byArray, charset);
                SampleRatesManager.access$parseJsonSampleRateResponse(this.this$0, response);
            }
            {
                this.this$0 = sampleRatesManager;
                super(0);
            }
        }), (int)1, null);
    }

    private final void parseJsonSampleRateResponse(String response) {
        try {
            JSONObject json = new JSONObject(response);
            double exceptionSampleRate = json.optDouble("e", 0.0);
            double logsSampleRate = json.optDouble("l", 0.0);
            double metricsSampleRate = json.optDouble("m", 0.0);
            this.updateSampleRates(exceptionSampleRate, logsSampleRate, metricsSampleRate);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private final void updateSampleRates(double exceptionSampleRate, double logsSampleRate, double metricsSampleRate) {
        this.exceptionHandler.updateSampleRate(exceptionSampleRate);
        this.logsHandler.updateSampleRate(logsSampleRate);
        this.metricsHandler.updateSampleRate(metricsSampleRate);
        this.logsHandler.reportSampleRateBreadcrumb(exceptionSampleRate, logsSampleRate, metricsSampleRate);
    }

    public SampleRatesManager(@NotNull ExceptionHandler exceptionHandler, @NotNull LogsHandler logsHandler, @NotNull MetricsHandler metricsHandler) {
        Intrinsics.checkNotNullParameter((Object)exceptionHandler, (String)"exceptionHandler");
        Intrinsics.checkNotNullParameter((Object)logsHandler, (String)"logsHandler");
        Intrinsics.checkNotNullParameter((Object)metricsHandler, (String)"metricsHandler");
        this.exceptionHandler = exceptionHandler;
        this.logsHandler = logsHandler;
        this.metricsHandler = metricsHandler;
        this.sdkVersion = (String)StringsKt.split$default((CharSequence)"1.9.0", (String[])new String[]{"-"}, (boolean)false, (int)0, (int)6, null).get(0);
        this.serverURL = new URL("https://cdn.mobilefuse.com/sdk/sample-rate/android/" + this.sdkVersion);
    }

    public static final /* synthetic */ void access$getSampleRates(SampleRatesManager $this) {
        $this.getSampleRates();
    }

    public static final /* synthetic */ void access$parseJsonSampleRateResponse(SampleRatesManager $this, String response) {
        $this.parseJsonSampleRateResponse(response);
    }
}

