/*
 * Decompiled with CFR 0.152.
 */
package com.mobilefuse.sdk.telemetry.mfxlogs;

import androidx.annotation.VisibleForTesting;
import com.mobilefuse.sdk.DebuggingKt;
import com.mobilefuse.sdk.concurrency.SchedulersKt;
import com.mobilefuse.sdk.telemetry.LogLevel;
import com.mobilefuse.sdk.telemetry.LogLevelKt;
import com.mobilefuse.sdk.telemetry.TelemetryBreadcrumb;
import com.mobilefuse.sdk.telemetry.TelemetryEventsMfxService;
import com.mobilefuse.sdk.telemetry.loggers.MfxRequestManager;
import com.mobilefuse.sdk.telemetry.mfxlogs.EventTypes;
import com.mobilefuse.sdk.telemetry.mfxlogs.TelemetryEventsMfxImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J.\u0010\u0019\u001a\u00020\u001a2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00140\u001c2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00140\u001cJ\u001e\u0010\u001e\u001a\u0004\u0018\u00010\u00052\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020 0\u001cH\u0016J\u0018\u0010!\u001a\u0004\u0018\u00010\u00142\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00020\"H\u0017J\u0006\u0010#\u001a\u00020\u0010J\u0006\u0010$\u001a\u00020\u0018J\u000e\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0010J\u0016\u0010(\u001a\u00020\u001a2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00020\"H\u0002J\u0016\u0010*\u001a\u00020\u001a2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00020\"H\u0016R&\u0010\u0004\u001a\u0004\u0018\u00010\u00058\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0006\u0010\u0003\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/mobilefuse/sdk/telemetry/mfxlogs/TelemetryEventsMfxImpl;", "Lcom/mobilefuse/sdk/telemetry/TelemetryEventsMfxService;", "Lcom/mobilefuse/sdk/telemetry/TelemetryBreadcrumb;", "()V", "appInfoJson", "Lorg/json/JSONObject;", "getAppInfoJson$mobilefuse_sdk_telemetry_release$annotations", "getAppInfoJson$mobilefuse_sdk_telemetry_release", "()Lorg/json/JSONObject;", "setAppInfoJson$mobilefuse_sdk_telemetry_release", "(Lorg/json/JSONObject;)V", "globalIndex", "", "initialLogReported", "Ljava/util/concurrent/atomic/AtomicBoolean;", "initialTimeOffset", "", "requestManager", "Lcom/mobilefuse/sdk/telemetry/loggers/MfxRequestManager;", "sdkVersion", "", "getSdkVersion", "()Ljava/lang/String;", "uuid", "Ljava/util/UUID;", "createInitialLog", "", "modules", "", "variables", "createJson", "data", "", "createJsonLines", "", "getCurrentTimeMillis", "getSessionId", "getTimeOffset", "", "currentTime", "markEventsAsReported", "breadcrumbs", "reportEvents", "mobilefuse-sdk-telemetry_release"})
public final class TelemetryEventsMfxImpl
implements TelemetryEventsMfxService<TelemetryBreadcrumb> {
    private final UUID uuid;
    private final MfxRequestManager requestManager;
    private int globalIndex;
    private AtomicBoolean initialLogReported;
    @Nullable
    private JSONObject appInfoJson;
    private final long initialTimeOffset;
    @NotNull
    private final String sdkVersion;

    @VisibleForTesting
    public static /* synthetic */ void getAppInfoJson$mobilefuse_sdk_telemetry_release$annotations() {
    }

    @Nullable
    public final JSONObject getAppInfoJson$mobilefuse_sdk_telemetry_release() {
        return this.appInfoJson;
    }

    public final void setAppInfoJson$mobilefuse_sdk_telemetry_release(@Nullable JSONObject jSONObject) {
        this.appInfoJson = jSONObject;
    }

    @NotNull
    public final String getSdkVersion() {
        return this.sdkVersion;
    }

    public final void createInitialLog(@NotNull Map<String, String> modules, @NotNull Map<String, String> variables) {
        Intrinsics.checkNotNullParameter(modules, (String)"modules");
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        Map sdkVersionMap = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"sdk.version", (Object)this.sdkVersion), TuplesKt.to((Object)"device.os", (Object)"android")});
        Map appInfoMap = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"uuid", (Object)this.uuid.toString()), TuplesKt.to((Object)"level", (Object)LogLevelKt.toLowerCase(LogLevel.INFO)), TuplesKt.to((Object)"category", (Object)"telemetry"), TuplesKt.to((Object)"type", (Object)EventTypes.SDK_INIT.getValue()), TuplesKt.to((Object)"msg", (Object)("SDK " + this.sdkVersion + " initialized for " + variables.get("app.bundle") + " on android")), TuplesKt.to((Object)"detail", (Object)MapsKt.plus((Map)MapsKt.plus(modules, variables), (Map)sdkVersionMap)), TuplesKt.to((Object)"time_offset", (Object)Float.valueOf(this.getTimeOffset(this.getCurrentTimeMillis())))});
        this.appInfoJson = this.createJson(appInfoMap);
    }

    public final long getCurrentTimeMillis() {
        return System.currentTimeMillis();
    }

    public final float getTimeOffset(long currentTime) {
        return (float)(currentTime - this.initialTimeOffset) / 1000.0f;
    }

    @Override
    public void reportEvents(@NotNull List<TelemetryBreadcrumb> data) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        String string = this.createJsonLines(data);
        if (string == null) {
            return;
        }
        String jsonLines = string;
        this.requestManager.sendRequest("https://mfx.mobilefuse.com/log", jsonLines, (Function0<Unit>)((Function0)new Function0<Unit>(this, data){
            final /* synthetic */ TelemetryEventsMfxImpl this$0;
            final /* synthetic */ List $data;

            public final void invoke() {
                TelemetryEventsMfxImpl.access$markEventsAsReported(this.this$0, this.$data);
            }
            {
                this.this$0 = telemetryEventsMfxImpl;
                this.$data = list;
                super(0);
            }
        }));
        DebuggingKt.logDebug$default((Object)this, (String)("Telemetry session id: " + this.uuid), null, (int)2, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @VisibleForTesting
    @Nullable
    public String createJsonLines(@NotNull List<TelemetryBreadcrumb> data) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        try {
            List jsonLines = new ArrayList();
            if (this.initialLogReported.compareAndSet(false, true)) {
                JSONObject jSONObject = this.appInfoJson;
                if (jSONObject != null) {
                    JSONObject jSONObject2;
                    JSONObject it = jSONObject2 = jSONObject;
                    boolean bl = false;
                    jsonLines.add(it);
                }
            }
            Iterable $this$forEachIndexed$iv = data;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                JSONObject jSONObject;
                void telemetryBreadcrumb;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                TelemetryBreadcrumb telemetryBreadcrumb2 = (TelemetryBreadcrumb)item$iv;
                int $noName_0 = n;
                boolean bl = false;
                Map map = MapsKt.mutableMapOf((Pair[])new Pair[]{TuplesKt.to((Object)"uuid", (Object)this.uuid.toString()), TuplesKt.to((Object)"level", (Object)LogLevelKt.toLowerCase(telemetryBreadcrumb.getLogLevel())), TuplesKt.to((Object)"category", (Object)telemetryBreadcrumb.getCategory()), TuplesKt.to((Object)"msg", (Object)telemetryBreadcrumb.getMessage()), TuplesKt.to((Object)"time_offset", (Object)Float.valueOf(this.getTimeOffset(telemetryBreadcrumb.getTimestamp()))), TuplesKt.to((Object)"type", (Object)telemetryBreadcrumb.getLogType())});
                if (telemetryBreadcrumb.getData() != null) {
                    Map<String, Object> map2;
                    Map<String, Object> it = map2;
                    boolean bl2 = false;
                    map.put("detail", it);
                }
                JSONObject jsonData = this.createJson(map);
                if (jsonData == null) continue;
                JSONObject it = jSONObject;
                boolean bl3 = false;
                jsonLines.add(it);
            }
            return CollectionsKt.joinToString$default((Iterable)jsonLines, (CharSequence)"\n", null, null, (int)0, null, (Function1)createJsonLines.3.INSTANCE, (int)30, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    @Nullable
    public JSONObject createJson(@NotNull Map<String, ? extends Object> data) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        try {
            JSONObject jSONObject;
            Map<String, ? extends Object> map;
            Map<String, ? extends Object> it = map = data;
            boolean bl = false;
            ++this.globalIndex;
            JSONObject $this$apply = jSONObject = new JSONObject(it);
            boolean bl2 = false;
            $this$apply.put("index", this.globalIndex);
            return jSONObject;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private final void markEventsAsReported(List<TelemetryBreadcrumb> breadcrumbs) {
        SchedulersKt.safelyRunOnBgThread$default(null, (Function0)((Function0)new Function0<Unit>(breadcrumbs){
            final /* synthetic */ List $breadcrumbs;

            public final void invoke() {
                Iterable $this$forEach$iv = this.$breadcrumbs;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    TelemetryBreadcrumb it = (TelemetryBreadcrumb)element$iv;
                    boolean bl = false;
                    it.setWasReported(true);
                }
            }
            {
                this.$breadcrumbs = list;
                super(0);
            }
        }), (int)1, null);
    }

    @NotNull
    public final UUID getSessionId() {
        return this.uuid;
    }

    public TelemetryEventsMfxImpl() {
        UUID uUID = UUID.randomUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"UUID.randomUUID()");
        this.uuid = uUID;
        this.requestManager = new MfxRequestManager();
        this.initialLogReported = new AtomicBoolean(false);
        this.initialTimeOffset = this.getCurrentTimeMillis();
        this.sdkVersion = (String)StringsKt.split$default((CharSequence)"1.9.0", (String[])new String[]{"-"}, (boolean)false, (int)0, (int)6, null).get(0);
    }

    public static final /* synthetic */ void access$markEventsAsReported(TelemetryEventsMfxImpl $this, List breadcrumbs) {
        $this.markEventsAsReported(breadcrumbs);
    }
}

