/*
 * Decompiled with CFR 0.152.
 */
package com.mobilefuse.sdk.vast;

import android.content.Context;
import android.graphics.Point;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ProgressBar;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.mobilefuse.sdk.AdLifecycleEvent;
import com.mobilefuse.sdk.AdRendererConfig;
import com.mobilefuse.sdk.AdRendererContainer;
import com.mobilefuse.sdk.AdRendererListener;
import com.mobilefuse.sdk.BaseAdRenderer;
import com.mobilefuse.sdk.ExtendedAdType;
import com.mobilefuse.sdk.StabilityHelper;
import com.mobilefuse.sdk.Utils;
import com.mobilefuse.sdk.ad.rendering.omniad.ThumbnailAdController;
import com.mobilefuse.sdk.ad.rendering.omniad.thumbnail.GetThumbnailInitSizeKt;
import com.mobilefuse.sdk.config.ObservableConfigKey;
import com.mobilefuse.sdk.internal.RtbLossReason;
import com.mobilefuse.sdk.omid.OmidFriendlyObstructionPurpose;
import com.mobilefuse.sdk.omid.VastOmidBridge;
import com.mobilefuse.sdk.omid.viewtree.ViewTreeInspector;
import com.mobilefuse.sdk.rtb.Protocol;
import com.mobilefuse.sdk.vast.R;
import com.mobilefuse.sdk.vast.endcard.EndCardSchedulerHelper;
import com.mobilefuse.sdk.video.ClickthroughBehaviour;
import com.mobilefuse.videoplayer.VideoPlayer;
import com.mobilefuse.videoplayer.VideoPlayerSettings;
import com.mobilefuse.videoplayer.model.DataRegulation;
import com.mobilefuse.videoplayer.model.VastError;
import java.util.ArrayList;
import java.util.List;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;

public class VastAdRenderer
extends BaseAdRenderer<VastOmidBridge> {
    public static final long END_CARD_AUTO_CLOSE_DELAY = 10000L;
    public static final int DEFAULT_MAX_END_CARDS = 1;
    public static final float DEFAULT_END_CARD_CLOSE_SECONDS = 0.0f;
    private ProgressBar loaderView;
    private VideoPlayer videoPlayer;
    @Nullable
    private ViewTreeInspector viewTreeInspector;

    public VastAdRenderer(Context context, AdRendererConfig config, AdRendererListener listener) throws Throwable {
        super(context, config, listener);
        this.initialize();
    }

    protected void initialize() throws Throwable {
        this.createContainer();
        this.initUi();
        this.videoPlayer = (VideoPlayer)this.contentContainer.findViewById(R.id.vastPlayer);
        VideoPlayerSettings.setDeviceIp((String)this.config.getDeviceIp());
        VideoPlayerSettings.setAdvertisingId((String)this.config.getAdvertisingId());
        VideoPlayerSettings.setLimitTrackingEnabled((boolean)this.config.isLimitTrackingEnabled());
        if (this.config.isSubjectToCoppa()) {
            VideoPlayerSettings.addApplicableDataRegulations((DataRegulation)DataRegulation.COPPA);
        }
        if (this.observableConfig != null) {
            float value;
            Object behaviour;
            if (this.observableConfig.getBooleanValue(ObservableConfigKey.MUTE_ENABLED)) {
                this.videoPlayer.setMuteAllowed();
                this.videoPlayer.setMuted(this.observableConfig.getBooleanValue(ObservableConfigKey.MUTED));
                this.videoPlayer.setMuteChangedListener(muted -> {
                    try {
                        this.observableConfig.setValue(ObservableConfigKey.MUTED, (Object)muted);
                    }
                    catch (Throwable e) {
                        StabilityHelper.logException((Object)((Object)this), (Throwable)e);
                    }
                });
            }
            boolean lastEndCardCloseable = true;
            if (this.observableConfig.hasValue(ObservableConfigKey.ENDCARD_CLOSABLE)) {
                lastEndCardCloseable = this.observableConfig.getBooleanValue(ObservableConfigKey.ENDCARD_CLOSABLE);
            }
            float endCardCloseButtonDelaySeconds = this.observableConfig.getFloatValue(ObservableConfigKey.END_CARD_CLOSE_SECONDS, 0.0f);
            if (this.extendedAdType == VastExtendedAdType.THUMBNAIL) {
                EndCardSchedulerHelper.applyThumbnailScheduler(this.videoPlayer, endCardCloseButtonDelaySeconds, 10000L);
            } else {
                EndCardSchedulerHelper.applyBaseVastScheduler(this.videoPlayer, endCardCloseButtonDelaySeconds, lastEndCardCloseable);
            }
            int maxEndCards = this.observableConfig.getIntValue(ObservableConfigKey.MAX_END_CARDS, 1);
            if (maxEndCards >= 0) {
                this.videoPlayer.setMaxEndCardsToShow(maxEndCards);
            }
            if (this.observableConfig.hasValue(ObservableConfigKey.VIDEO_CLICK_THROUGH_BEHAVIOUR) && (behaviour = this.observableConfig.getValue(ObservableConfigKey.VIDEO_CLICK_THROUGH_BEHAVIOUR)) instanceof ClickthroughBehaviour) {
                this.videoPlayer.setClickthroughBehaviour((ClickthroughBehaviour)behaviour);
            }
            if (this.observableConfig.hasValue(ObservableConfigKey.FORCE_SKIP_SECONDS) && (value = this.observableConfig.getFloatValue(ObservableConfigKey.FORCE_SKIP_SECONDS, -1.0f)) > -1.0f) {
                this.videoPlayer.setForceSkipSeconds(value);
            }
            if (this.observableConfig.hasValue(ObservableConfigKey.BLOCK_SKIP_SECONDS) && (value = this.observableConfig.getFloatValue(ObservableConfigKey.BLOCK_SKIP_SECONDS, -1.0f)) > -1.0f) {
                this.videoPlayer.setBlockSkipSeconds(value);
            }
        }
        this.startActivityLifecycleChecking();
    }

    protected void createContainer() throws Throwable {
        int heightDp = this.config.getAdHeight();
        if (heightDp != -1) {
            heightDp = Utils.convertDpToPx((Context)this.context, (int)this.config.getAdHeight());
        }
        LayoutInflater layoutInflater = (LayoutInflater)this.context.getSystemService("layout_inflater");
        this.contentContainer = (AdRendererContainer)layoutInflater.inflate(R.layout.mobilefuse_vast_player_view, null);
        ViewGroup.LayoutParams inlineContainerParams = new ViewGroup.LayoutParams(-1, heightDp);
        this.contentContainer.setAttachedToWindowCallback(() -> {
            try {
                if (this.viewTreeInspector != null) {
                    this.viewTreeInspector.startObstructionsChecking();
                }
            }
            catch (Throwable e) {
                StabilityHelper.logException((Object)((Object)this), (Throwable)e);
            }
        });
        this.contentContainer.setDetachedFromWindowCallback(() -> {
            try {
                if (this.viewTreeInspector != null) {
                    this.viewTreeInspector.stopObstructionsChecking();
                }
            }
            catch (Throwable e) {
                StabilityHelper.logException((Object)((Object)this), (Throwable)e);
            }
        });
        if (this.extendedAdType != VastExtendedAdType.THUMBNAIL) {
            this.contentContainer.setBackgroundColor(-16777216);
        }
        this.contentContainer.setLayoutParams(inlineContainerParams);
    }

    void initUi() throws Throwable {
        this.loaderView = (ProgressBar)this.contentContainer.findViewById(R.id.loaderView);
    }

    public View getAdView() throws Throwable {
        return this.contentContainer;
    }

    protected void preloadAdmImpl(String adm) throws Throwable {
        this.videoPlayer.setOmidBridge((VastOmidBridge)this.omidBridge);
        this.videoPlayer.loadVast(adm, new VideoPlayer.LoadListener(){

            public void onVideoLoaded() {
                try {
                    VastAdRenderer.this.onAdLifecycleEvent(VastAdLifecycleEvent.VAST_VIDEO_LOADED);
                    VastAdRenderer.this.onAdPreloaded();
                }
                catch (Throwable e) {
                    StabilityHelper.logException((Object)this, (Throwable)e);
                }
            }

            public void onError(VastError error) {
                try {
                    if (error == VastError.XML_PARSING_FAILED) {
                        VastAdRenderer.this.onAdRuntimeError(RtbLossReason.INVALID_MARKUP);
                    } else if (error == VastError.WRAPPER_LIMIT_REACHED) {
                        VastAdRenderer.this.onAdRuntimeError(RtbLossReason.WRAPPER_TOO_DEEP);
                    } else if (error == VastError.MEDIAFILES_UNSUPPORTED) {
                        VastAdRenderer.this.onAdRuntimeError(RtbLossReason.UNSUPPORTED_MEDIA_FILE);
                    } else if (error == VastError.MEDIAFILE_TIMEOUT) {
                        VastAdRenderer.this.onAdRuntimeError(RtbLossReason.ASSET_LOAD_TIMEOUT);
                    } else if (error == VastError.MEDIAFILE_NOT_FOUND) {
                        VastAdRenderer.this.onAdRuntimeError(RtbLossReason.MEDIA_FILE_NOT_FOUND);
                    } else {
                        VastAdRenderer.this.onAdRuntimeError(RtbLossReason.CREATIVE_GENERAL);
                    }
                }
                catch (Throwable e) {
                    StabilityHelper.logException((Object)this, (Throwable)e);
                }
            }
        });
    }

    private void createExternalController() throws Throwable {
        if (this.extendedAdType == VastExtendedAdType.THUMBNAIL) {
            if (this.renderingActivity == null) {
                return;
            }
            Point maxThumbnailSize = new Point(this.config.getAdWidth(), this.config.getAdHeight());
            Point mediaFileSize = this.videoPlayer.getCurrentMediaFileSizeDp();
            if (mediaFileSize == null) {
                mediaFileSize = maxThumbnailSize;
            }
            Point scaledSize = GetThumbnailInitSizeKt.getThumbnailInitSize((Point)maxThumbnailSize, (Point)mediaFileSize);
            this.extendedController = new ThumbnailAdController(this.renderingActivity, (View)this.contentContainer, scaledSize);
            this.extendedController.setAdWidth(scaledSize.x);
            this.extendedController.setAdHeight(scaledSize.y);
            this.videoPlayer.setFullscreenAllowed();
            this.videoPlayer.setEnterFullscreenOnVideoTap(true);
            this.videoPlayer.setFullscreenChangedListener(fullscreen -> {
                try {
                    if (this.listener != null) {
                        this.listener.onFullscreenChanged(fullscreen);
                    }
                }
                catch (Throwable e) {
                    StabilityHelper.logException((Object)((Object)this), (Throwable)e);
                }
            });
            this.videoPlayer.enableExternalFullscreenControl((changeToFullscreen, completeAction) -> {
                if (this.extendedController == null) {
                    return;
                }
                ((ThumbnailAdController)this.extendedController).requestFullscreenChange(changeToFullscreen, (Function0<Unit>)completeAction);
            });
            if (this.observableConfig != null && this.observableConfig.hasValue(ObservableConfigKey.POSITION) && this.extendedAdType == VastExtendedAdType.THUMBNAIL) {
                ((ThumbnailAdController)this.extendedController).setAnchor(this.observableConfig.getIntValue(ObservableConfigKey.POSITION, 3));
            }
        }
    }

    public void renderAdmImpl() throws Throwable {
        this.initViewTreeInspector();
        this.createExternalController();
        if (this.extendedController != null) {
            this.extendedController.bindContent((View)this.contentContainer, this.renderingActivity);
        }
        this.videoPlayer.setOnVideoSkipButtonVisible(() -> {
            this.dispatchSkipAdAvailability();
            return Unit.INSTANCE;
        });
        this.videoPlayer.play(this.renderingActivity, new VideoPlayer.PlaybackListener(){

            public void onVideoStarted() {
                try {
                    VastAdRenderer.this.loaderView.setVisibility(8);
                    VastAdRenderer.this.onAdLifecycleEvent(VastAdLifecycleEvent.VAST_VIDEO_STARTED);
                }
                catch (Throwable e) {
                    StabilityHelper.logException((Object)((Object)this), (Throwable)e);
                }
            }

            public void onVideoPlaying() {
                super.onVideoPlaying();
            }

            public void onVideoPaused() {
                super.onVideoPaused();
            }

            public void onAdImpression() {
                VastAdRenderer.this.reportAdImpression();
            }

            public void onVideoCompleted() {
                try {
                    VastAdRenderer.this.finishOmidSession();
                    VastAdRenderer.this.dispatchSkipAdAvailability();
                }
                catch (Throwable e) {
                    StabilityHelper.logException((Object)((Object)this), (Throwable)e);
                }
            }

            public void onAdCompleted() {
                try {
                    VastAdRenderer.this.onAdLifecycleEvent(VastAdLifecycleEvent.VAST_VIDEO_COMPLETED);
                    VastAdRenderer.this.onAdClosed();
                }
                catch (Throwable e) {
                    StabilityHelper.logException((Object)((Object)this), (Throwable)e);
                }
            }

            public void onVideoFirstQuartile() {
                try {
                    VastAdRenderer.this.onAdLifecycleEvent(VastAdLifecycleEvent.VAST_VIDEO_FIRST_QUARTILE);
                }
                catch (Throwable e) {
                    StabilityHelper.logException((Object)((Object)this), (Throwable)e);
                }
            }

            public void onVideoMidpoint() {
                try {
                    VastAdRenderer.this.onAdLifecycleEvent(VastAdLifecycleEvent.VAST_VIDEO_MIDPOINT);
                }
                catch (Throwable e) {
                    StabilityHelper.logException((Object)((Object)this), (Throwable)e);
                }
            }

            public void onVideoThirdQuartile() {
                try {
                    VastAdRenderer.this.onAdLifecycleEvent(VastAdLifecycleEvent.VAST_VIDEO_THIRD_QUARTILE);
                }
                catch (Throwable e) {
                    StabilityHelper.logException((Object)((Object)this), (Throwable)e);
                }
            }

            public void onVideoError() {
                try {
                    VastAdRenderer.this.onAdRuntimeError(RtbLossReason.CREATIVE_GENERAL);
                }
                catch (Throwable e) {
                    StabilityHelper.logException((Object)((Object)this), (Throwable)e);
                }
            }

            public void onEndCardError() {
                try {
                    VastAdRenderer.this.onAdRuntimeError(RtbLossReason.CREATIVE_GENERAL);
                }
                catch (Throwable e) {
                    StabilityHelper.logException((Object)((Object)this), (Throwable)e);
                }
            }

            public void onVideoSkipped() {
                try {
                    VastAdRenderer.this.finishOmidSession();
                    VastAdRenderer.this.onAdLifecycleEvent(VastAdLifecycleEvent.VAST_VIDEO_SKIPPED);
                    VastAdRenderer.this.dispatchSkipAdAvailability();
                }
                catch (Throwable e) {
                    StabilityHelper.logException((Object)((Object)this), (Throwable)e);
                }
            }

            public void onClicked() {
                try {
                    VastAdRenderer.this.listener.onAdClicked();
                }
                catch (Throwable e) {
                    StabilityHelper.logException((Object)((Object)this), (Throwable)e);
                }
            }
        });
    }

    private void initViewTreeInspector() throws Throwable {
        if (this.viewTreeInspector != null) {
            return;
        }
        if (this.hasOmidBridge()) {
            ((VastOmidBridge)this.omidBridge).setAdSessionInitCompleteListener(() -> {
                try {
                    if (((VastOmidBridge)this.omidBridge).getVideoView() == null) {
                        return;
                    }
                    this.viewTreeInspector = new ViewTreeInspector(((VastOmidBridge)this.omidBridge).getVideoView(), friendlyObstructions -> {
                        if (this.omidBridge == null) {
                            return;
                        }
                        ((VastOmidBridge)this.omidBridge).removeAllFriendlyObstructions();
                        for (View friendlyObstruction : friendlyObstructions) {
                            if (friendlyObstruction == this.loaderView) continue;
                            ((VastOmidBridge)this.omidBridge).addFriendlyObstruction(friendlyObstruction, OmidFriendlyObstructionPurpose.NOT_VISIBLE, null);
                        }
                        this.addProgressBarAsOmidFriendlyObstruction();
                    });
                    this.addProgressBarAsOmidFriendlyObstruction();
                    this.viewTreeInspector.startObstructionsChecking();
                }
                catch (Throwable e) {
                    StabilityHelper.logException((Object)((Object)this), (Throwable)e);
                }
            });
        }
    }

    private void finishOmidSession() throws Throwable {
        this.destroyOmidBridge();
        this.destroyViewTreeInspector();
    }

    private void addProgressBarAsOmidFriendlyObstruction() {
        try {
            if (!this.hasOmidBridge()) {
                return;
            }
            ProgressBar progressBar = this.loaderView;
            if (progressBar == null) {
                return;
            }
            if (progressBar.getVisibility() != 0) {
                return;
            }
            ((VastOmidBridge)this.omidBridge).addFriendlyObstruction((View)progressBar, OmidFriendlyObstructionPurpose.OTHER, null);
        }
        catch (Throwable e) {
            StabilityHelper.logException((Object)((Object)this), (Throwable)e);
        }
    }

    protected void onConfigPropertyChanged(ObservableConfigKey key, Object value) throws Throwable {
        try {
            switch (key) {
                case MUTED: {
                    if (!this.videoPlayer.isMuteAllowed()) break;
                    this.videoPlayer.setMuted(((Boolean)value).booleanValue());
                    break;
                }
                case FULLSCREEN: {
                    this.videoPlayer.setFullscreen(((Boolean)value).booleanValue());
                    break;
                }
                case POSITION: {
                    if (!(this.extendedController instanceof ThumbnailAdController)) break;
                    ((ThumbnailAdController)this.extendedController).setAnchor((Integer)value);
                }
            }
        }
        catch (Throwable ex) {
            StabilityHelper.logException((Object)((Object)this), (Throwable)ex);
        }
    }

    protected View.OnLayoutChangeListener getOnLayoutChangeListener(Context context) throws Throwable {
        return new View.OnLayoutChangeListener(){

            @RequiresApi(api=19)
            public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                try {
                    if (right == oldRight && bottom == oldBottom) {
                        return;
                    }
                    Log.d((String)"MF", (String)("onLayoutChange [left: " + left + ", top: " + top + ", right: " + right + ", bottom: " + bottom + "]"));
                    if (VastAdRenderer.this.extendedController != null) {
                        VastAdRenderer.this.extendedController.invalidateLayout();
                    }
                }
                catch (Throwable e) {
                    StabilityHelper.logException((Object)this, (Throwable)e);
                }
            }
        };
    }

    protected void onActivityResumeImpl() throws Throwable {
        if (this.videoPlayer != null) {
            this.videoPlayer.onActivityResume();
        }
        if (this.viewTreeInspector != null) {
            this.viewTreeInspector.startObstructionsChecking();
        }
    }

    protected void onActivityPauseImpl() throws Throwable {
        if (this.viewTreeInspector != null) {
            this.viewTreeInspector.stopObstructionsChecking();
        }
        if (this.videoPlayer != null) {
            this.videoPlayer.onActivityPause();
        }
    }

    protected boolean onAdCloseRequested() {
        if (this.videoPlayer != null) {
            this.videoPlayer.pause();
        }
        return true;
    }

    private void destroyViewTreeInspector() throws Throwable {
        if (this.viewTreeInspector != null) {
            this.viewTreeInspector.stopObstructionsChecking();
            this.viewTreeInspector = null;
        }
    }

    public void destroy() throws Throwable {
        try {
            this.finishOmidSession();
            if (this.videoPlayer != null) {
                this.videoPlayer.destroy();
                this.videoPlayer = null;
            }
            if (this.loaderView != null) {
                this.loaderView.setVisibility(8);
            }
            if (this.extendedController != null) {
                this.extendedController.unbindContent();
                this.extendedController = null;
            }
            super.destroy();
        }
        catch (Throwable ex) {
            StabilityHelper.logException((Object)((Object)this), (Throwable)ex);
        }
    }

    public void onActivityDestroy() throws Throwable {
        this.destroy();
    }

    public static List<Protocol> getSupportedProtocols() {
        ArrayList<Protocol> list = new ArrayList<Protocol>();
        list.add(Protocol.VAST2);
        list.add(Protocol.VAST2_WRAPPER);
        list.add(Protocol.VAST3);
        list.add(Protocol.VAST3_WRAPPER);
        list.add(Protocol.VAST4);
        list.add(Protocol.VAST4_WRAPPER);
        return list;
    }

    public static enum VastExtendedAdType implements ExtendedAdType
    {
        THUMBNAIL;

    }

    public static enum VastAdLifecycleEvent implements AdLifecycleEvent
    {
        VAST_VIDEO_LOADED,
        VAST_VIDEO_STARTED,
        VAST_VIDEO_SKIPPED,
        VAST_VIDEO_FIRST_QUARTILE,
        VAST_VIDEO_MIDPOINT,
        VAST_VIDEO_THIRD_QUARTILE,
        VAST_VIDEO_COMPLETED;

    }
}

