/*
 * Decompiled with CFR 0.152.
 */
package com.mobilefuse.videoplayer;

import android.content.Context;
import android.os.AsyncTask;
import android.util.Pair;
import com.mobilefuse.videoplayer.model.VastError;
import com.mobilefuse.videoplayer.utils.DiskCacheUtil;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u0014\u0015B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0013\u001a\u00020\u0007R \u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/mobilefuse/videoplayer/VideoDownloader;", "", "()V", "LOADING_LIST", "", "", "", "Lcom/mobilefuse/videoplayer/VideoDownloader$Listener;", "VIDEO_MAX_SIZE", "", "activeTasks", "", "Ljava/lang/ref/WeakReference;", "Lcom/mobilefuse/videoplayer/VideoDownloader$VideoDownloaderTask;", "cache", "", "context", "Landroid/content/Context;", "url", "listener", "Listener", "VideoDownloaderTask", "mobilefuse-video-player_release"})
public final class VideoDownloader {
    private static final int VIDEO_MAX_SIZE = 0x2300000;
    private static final List<WeakReference<VideoDownloaderTask>> activeTasks;
    private static final Map<String, Set<Listener>> LOADING_LIST;
    @NotNull
    public static final VideoDownloader INSTANCE;

    public final void cache(@NotNull Context context, @Nullable String url, @NotNull Listener listener) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        try {
            if (url == null) {
                listener.onError(VastError.UNIDENTIFIED);
                return;
            }
            DiskCacheUtil.initialize(context);
            if (LOADING_LIST.containsKey(url)) {
                Set<Listener> listenerSet;
                Set<Listener> set = listenerSet = LOADING_LIST.get(url);
                if (set != null) {
                    set.add(listener);
                }
                return;
            }
            Set listenerSet = new LinkedHashSet();
            listenerSet.add(listener);
            LOADING_LIST.put(url, listenerSet);
            VideoDownloaderTask videoDownloaderTask = new VideoDownloaderTask(url, listener);
            try {
                videoDownloaderTask.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Unit[0]);
            }
            catch (Throwable e) {
                listener.onError(VastError.UNIDENTIFIED);
                e.printStackTrace();
            }
        }
        catch (Throwable e) {
            listener.onError(VastError.UNIDENTIFIED);
            e.printStackTrace();
        }
    }

    private VideoDownloader() {
    }

    static {
        VideoDownloader videoDownloader;
        INSTANCE = videoDownloader = new VideoDownloader();
        activeTasks = new ArrayList();
        LOADING_LIST = new LinkedHashMap();
    }

    public static final /* synthetic */ List access$getActiveTasks$p(VideoDownloader $this) {
        VideoDownloader videoDownloader = $this;
        return activeTasks;
    }

    public static final /* synthetic */ Map access$getLOADING_LIST$p(VideoDownloader $this) {
        VideoDownloader videoDownloader = $this;
        return LOADING_LIST;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0005\b\u0002\u0018\u00002$\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0014\u0012\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00030\u0001B\u0015\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ1\u0010\f\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00032\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u000e\"\u00020\u0002H\u0014\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0010\u001a\u00020\u0002H\u0014J \u0010\u0011\u001a\u00020\u00022\u0016\u0010\u0012\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0003H\u0014R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00000\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/mobilefuse/videoplayer/VideoDownloader$VideoDownloaderTask;", "Landroid/os/AsyncTask;", "", "Landroid/util/Pair;", "", "Lcom/mobilefuse/videoplayer/model/VastError;", "url", "listener", "Lcom/mobilefuse/videoplayer/VideoDownloader$Listener;", "(Ljava/lang/String;Lcom/mobilefuse/videoplayer/VideoDownloader$Listener;)V", "weakSelfTask", "Ljava/lang/ref/WeakReference;", "doInBackground", "params", "", "([Lkotlin/Unit;)Landroid/util/Pair;", "onCancelled", "onPostExecute", "result", "mobilefuse-video-player_release"})
    private static final class VideoDownloaderTask
    extends AsyncTask<Unit, Unit, Pair<String, VastError>> {
        private final WeakReference<VideoDownloaderTask> weakSelfTask;
        private final String url;
        private final Listener listener;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        protected Pair<String, VastError> doInBackground(Unit ... params) {
            Pair pair;
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            HttpURLConnection urlConnection = null;
            InputStream inputStream = null;
            try {
                String string;
                URLConnection uRLConnection = new URL(this.url).openConnection();
                if (uRLConnection == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.net.HttpURLConnection");
                }
                urlConnection = (HttpURLConnection)uRLConnection;
                urlConnection.setConnectTimeout(10000);
                urlConnection.setReadTimeout(20000);
                inputStream = new BufferedInputStream(urlConnection.getInputStream());
                int statusCode = urlConnection.getResponseCode();
                VastError vastError = VastError.UNIDENTIFIED;
                if (statusCode < 200 || statusCode >= 300) {
                    if (statusCode == 404) {
                        vastError = VastError.MEDIAFILE_NOT_FOUND;
                    } else if (statusCode == 408) {
                        vastError = VastError.MEDIAFILE_TIMEOUT;
                    }
                    Pair pair2 = new Pair(null, (Object)vastError);
                    return pair2;
                }
                int contentLength = urlConnection.getContentLength();
                if (contentLength > 0x2300000) {
                    Pair pair3 = new Pair(null, (Object)vastError);
                    return pair3;
                }
                if (DiskCacheUtil.cacheFile(this.url, inputStream) == null) {
                    Pair pair4 = new Pair(null, (Object)vastError);
                    return pair4;
                }
                String cachedFileKey = string;
                pair = new Pair((Object)cachedFileKey, null);
            }
            catch (Throwable e) {
                e.printStackTrace();
                pair = new Pair(null, (Object)VastError.MEDIAFILE_TIMEOUT);
            }
            finally {
                DiskCacheUtil.closeStream(inputStream);
                HttpURLConnection httpURLConnection = urlConnection;
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
            }
            return pair;
        }

        protected void onPostExecute(@NotNull Pair<String, VastError> result) {
            Intrinsics.checkNotNullParameter(result, (String)"result");
            try {
                if (this.isCancelled()) {
                    this.onCancelled();
                    return;
                }
                VideoDownloader.access$getActiveTasks$p(INSTANCE).remove(this.weakSelfTask);
                VastError error = (VastError)((Object)result.second);
                String cachedFileLruKey = (String)result.first;
                Set listenerSet = (Set)VideoDownloader.access$getLOADING_LIST$p(INSTANCE).get(this.url);
                if (listenerSet != null) {
                    Iterator iterator = listenerSet.iterator();
                    Listener listenerItem = null;
                    while (iterator.hasNext()) {
                        listenerItem = (Listener)iterator.next();
                        if (error != null) {
                            listenerItem.onError(error);
                            continue;
                        }
                        if (cachedFileLruKey == null) {
                            listenerItem.onError(VastError.COMPANION_RESOURCE_LOAD_FAILED);
                            continue;
                        }
                        listenerItem.onComplete(this.url, cachedFileLruKey);
                    }
                }
                VideoDownloader.access$getLOADING_LIST$p(INSTANCE).remove(this.url);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }

        protected void onCancelled() {
            try {
                VideoDownloader.access$getActiveTasks$p(INSTANCE).remove(this.weakSelfTask);
                this.listener.onError(VastError.UNIDENTIFIED);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }

        public VideoDownloaderTask(@NotNull String url, @NotNull Listener listener) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
            this.url = url;
            this.listener = listener;
            this.weakSelfTask = new WeakReference<VideoDownloaderTask>(this);
            VideoDownloader.access$getActiveTasks$p(INSTANCE).add(this.weakSelfTask);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H&J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH&\u00a8\u0006\n"}, d2={"Lcom/mobilefuse/videoplayer/VideoDownloader$Listener;", "", "onComplete", "", "requestedUrl", "", "cachedFileLruKey", "onError", "error", "Lcom/mobilefuse/videoplayer/model/VastError;", "mobilefuse-video-player_release"})
    public static interface Listener {
        public void onComplete(@NotNull String var1, @NotNull String var2);

        public void onError(@NotNull VastError var1);
    }
}

