/*
 * Decompiled with CFR 0.152.
 */
package com.mobilefuse.videoplayer;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.graphics.Color;
import android.graphics.Point;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.webkit.RenderProcessGoneDetail;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import androidx.annotation.RequiresApi;
import com.mobilefuse.sdk.DebuggingKt;
import com.mobilefuse.sdk.MuteChangedListener;
import com.mobilefuse.sdk.StabilityHelper;
import com.mobilefuse.sdk.Utils;
import com.mobilefuse.sdk.ad.AdSkipOffsetResolver;
import com.mobilefuse.sdk.assetsmanager.MobileFuseAssetManager;
import com.mobilefuse.sdk.exception.Either;
import com.mobilefuse.sdk.exception.ErrorResult;
import com.mobilefuse.sdk.exception.ExceptionHandlingStrategy;
import com.mobilefuse.sdk.exception.SuccessResult;
import com.mobilefuse.sdk.logging.HttpRequestTracker;
import com.mobilefuse.sdk.omid.VastOmidBridge;
import com.mobilefuse.sdk.utils.WebViewUtils;
import com.mobilefuse.sdk.video.ClickthroughBehaviour;
import com.mobilefuse.sdk.video.ClickthroughBehaviourKt;
import com.mobilefuse.videoplayer.VideoDownloader;
import com.mobilefuse.videoplayer.VideoPlayer;
import com.mobilefuse.videoplayer.VideoPlayer$WhenMappings;
import com.mobilefuse.videoplayer.VideoPlayer$createWebView$1$1$onRenderProcessGone$$inlined$handleExceptions$1$wm$TryKt$WhenMappings;
import com.mobilefuse.videoplayer.VideoPlayer$onAdCompleted$$inlined$handleExceptions$1$wm$TryKt$WhenMappings;
import com.mobilefuse.videoplayer.VideoPlayer$onVideoCompleted$$inlined$handleExceptions$1$wm$TryKt$WhenMappings;
import com.mobilefuse.videoplayer.VideoPlayer$showEndCard$$inlined$gracefullyHandleException$1$wm$TryKt$WhenMappings;
import com.mobilefuse.videoplayer.VideoPlayer$showEndCard$1$endCardPresenter$1$onClicked$$inlined$handleExceptions$1$wm$TryKt$WhenMappings;
import com.mobilefuse.videoplayer.VideoPlayer$showEndCard$1$endCardPresenter$1$onClosed$$inlined$handleExceptions$1$wm$TryKt$WhenMappings;
import com.mobilefuse.videoplayer.VideoPlayer$showEndCard$1$endCardPresenter$1$onCompleted$$inlined$handleExceptions$1$wm$TryKt$WhenMappings;
import com.mobilefuse.videoplayer.VideoPlayer$showEndCard$1$endCardPresenter$1$onError$$inlined$handleExceptions$1$wm$TryKt$WhenMappings;
import com.mobilefuse.videoplayer.VideoPlayerCapabilities;
import com.mobilefuse.videoplayer.VideoPlayerController;
import com.mobilefuse.videoplayer.controller.ExternalFullscreenControlBridge;
import com.mobilefuse.videoplayer.controller.FullscreenChangedListener;
import com.mobilefuse.videoplayer.controller.FullscreenController;
import com.mobilefuse.videoplayer.controller.FullscreenControllerImpl;
import com.mobilefuse.videoplayer.controller.MuteController;
import com.mobilefuse.videoplayer.controller.MuteControllerImpl;
import com.mobilefuse.videoplayer.controller.PlaybackController;
import com.mobilefuse.videoplayer.endcard.EndCardListener;
import com.mobilefuse.videoplayer.endcard.EndCardPresenter;
import com.mobilefuse.videoplayer.endcard.scheduler.BaseEndCardScheduler;
import com.mobilefuse.videoplayer.endcard.scheduler.EndCardScheduler;
import com.mobilefuse.videoplayer.media.MediaPlayerState;
import com.mobilefuse.videoplayer.media.MobileFusePlayer;
import com.mobilefuse.videoplayer.media.ViewType;
import com.mobilefuse.videoplayer.model.AdAutoplay;
import com.mobilefuse.videoplayer.model.VastClickThrough;
import com.mobilefuse.videoplayer.model.VastCompanion;
import com.mobilefuse.videoplayer.model.VastDataModelExtensionsKt;
import com.mobilefuse.videoplayer.model.VastError;
import com.mobilefuse.videoplayer.model.VastIcon;
import com.mobilefuse.videoplayer.model.VastMediaFile;
import com.mobilefuse.videoplayer.model.VastPlayerCapability;
import com.mobilefuse.videoplayer.model.VastTime;
import com.mobilefuse.videoplayer.model.VastTrackingEventType;
import com.mobilefuse.videoplayer.model.utils.StringEncodingAndFormattingKt;
import com.mobilefuse.videoplayer.network.NetworkUtils;
import com.mobilefuse.videoplayer.utils.DiskCacheUtil;
import com.mobilefuse.videoplayer.utils.MediaUtilsKt;
import com.mobilefuse.videoplayer.view.ViewCloseTrigger;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u00b8\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 \u00ea\u00012\u00020\u00012\u00020\u00022\u00020\u0003:\b\u00ea\u0001\u00eb\u0001\u00ec\u0001\u00ed\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0019\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tB!\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fB=\b\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u0012\b\b\u0002\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J\u0013\u0010\u009d\u0001\u001a\u00020p2\b\u0010\u009e\u0001\u001a\u00030\u009f\u0001H\u0002J\t\u0010\u00a0\u0001\u001a\u00020pH\u0002J\t\u0010\u00a1\u0001\u001a\u00020pH\u0002J\t\u0010\u00a2\u0001\u001a\u00020pH\u0002J\t\u0010\u00a3\u0001\u001a\u00020\u001cH\u0002J\u0019\u0010\u00a4\u0001\u001a\u00020p2\b\u0010\u00a5\u0001\u001a\u00030\u00a6\u0001H\u0000\u00a2\u0006\u0003\b\u00a7\u0001J\u0013\u0010\u00a8\u0001\u001a\u00020p2\b\u0010\u00a9\u0001\u001a\u00030\u008c\u0001H\u0002J\u0018\u0010\u00aa\u0001\u001a\u00020p2\r\u0010\u00ab\u0001\u001a\b\u0012\u0004\u0012\u00020p0oH\u0003J\u0007\u0010\u00ac\u0001\u001a\u00020pJ\t\u0010\u00ad\u0001\u001a\u00020pH\u0002J\t\u0010\u00ae\u0001\u001a\u00020pH\u0002J\u0014\u0010\u00af\u0001\u001a\u00020p2\b\u0010\u00b0\u0001\u001a\u00030\u00b1\u0001H\u0096\u0001J\u0007\u0010\u00b2\u0001\u001a\u00020\u000eJ\n\u0010\u00b3\u0001\u001a\u0005\u0018\u00010\u00b4\u0001J\n\u0010\u00b5\u0001\u001a\u0005\u0018\u00010\u00b4\u0001J\u0013\u0010\u00b6\u0001\u001a\u00020p2\b\u0010\u00b7\u0001\u001a\u00030\u00b8\u0001H\u0002J\u0018\u0010\u00b9\u0001\u001a\u00020p2\r\u0010\u00ab\u0001\u001a\b\u0012\u0004\u0012\u00020p0oH\u0002J\n\u0010\u00ba\u0001\u001a\u00020\u000eH\u0096\u0001J\u0007\u0010\u00bb\u0001\u001a\u00020\u000eJ\u0019\u0010\u00bc\u0001\u001a\u00020p2\b\u0010\u00bd\u0001\u001a\u00030\u00a6\u00012\u0006\u0010W\u001a\u00020XJ\u0007\u0010\u00be\u0001\u001a\u00020pJ\u0007\u0010\u00bf\u0001\u001a\u00020pJ\t\u0010\u00c0\u0001\u001a\u00020pH\u0002J\t\u0010\u00c1\u0001\u001a\u00020pH\u0014J\t\u0010\u00c2\u0001\u001a\u00020pH\u0014J\t\u0010\u00c3\u0001\u001a\u00020pH\u0002J6\u0010\u00c4\u0001\u001a\u00020p2\u0007\u0010\u00c5\u0001\u001a\u00020\u000e2\u0007\u0010\u00c6\u0001\u001a\u00020\u000b2\u0007\u0010\u00c7\u0001\u001a\u00020\u000b2\u0007\u0010\u00c8\u0001\u001a\u00020\u000b2\u0007\u0010\u00c9\u0001\u001a\u00020\u000bH\u0014J\u0014\u0010\u00ca\u0001\u001a\u00020p2\t\u0010\u00cb\u0001\u001a\u0004\u0018\u00010,H\u0002J\t\u0010\u00cc\u0001\u001a\u00020pH\u0002J \u0010\u00cd\u0001\u001a\u00020p2\u0007\u0010\u00ce\u0001\u001a\u00020\u000e2\f\b\u0002\u0010\u00cf\u0001\u001a\u0005\u0018\u00010\u00d0\u0001H\u0002J\u0013\u0010\u00d1\u0001\u001a\u00020p2\b\u0010\u00d2\u0001\u001a\u00030\u00d3\u0001H\u0002J\t\u0010\u00d4\u0001\u001a\u00020pH\u0002J\t\u0010\u00d5\u0001\u001a\u00020pH\u0002J\u0007\u0010\u00d6\u0001\u001a\u00020pJ\u001b\u0010\u00d7\u0001\u001a\u00020p2\n\u0010\u00d8\u0001\u001a\u0005\u0018\u00010\u0091\u00012\u0006\u0010z\u001a\u00020{J\t\u0010\u00d9\u0001\u001a\u00020pH\u0002J\u0007\u0010\u00da\u0001\u001a\u00020pJ\u0013\u0010\u00db\u0001\u001a\u00020p2\b\u0010\u00dc\u0001\u001a\u00030\u00dd\u0001H\u0002J\u0012\u0010\u00de\u0001\u001a\u00020p2\u0006\u0010G\u001a\u00020\u000eH\u0096\u0001J\n\u0010\u00df\u0001\u001a\u00020pH\u0096\u0001J\n\u0010\u00e0\u0001\u001a\u00020pH\u0096\u0001J\u0013\u0010\u00e1\u0001\u001a\u00020p2\u0007\u0010\u00e2\u0001\u001a\u00020\u000eH\u0096\u0001J\u0013\u0010\u00e3\u0001\u001a\u00020p2\n\u0010\u00e4\u0001\u001a\u0005\u0018\u00010\u00e5\u0001J\u0013\u0010\u00e6\u0001\u001a\u00020p2\b\u0010\u00d2\u0001\u001a\u00030\u00d3\u0001H\u0002J\t\u0010\u00e7\u0001\u001a\u00020pH\u0002J\t\u0010\u00e8\u0001\u001a\u00020pH\u0002J\t\u0010\u00e9\u0001\u001a\u00020pH\u0002R$\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0015@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u00020\"X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u0014\u0010'\u001a\u00020(X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0010\u0010+\u001a\u0004\u0018\u00010,X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010-\u001a\u0004\u0018\u00010.8F\u00a2\u0006\u0006\u001a\u0004\b/\u00100R\u0011\u00101\u001a\u0002028F\u00a2\u0006\u0006\u001a\u0004\b3\u00104R\"\u00106\u001a\u0004\u0018\u0001052\b\u0010\u0014\u001a\u0004\u0018\u000105@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u00108R\u001a\u00109\u001a\u00020:X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u0010<\"\u0004\b=\u0010>R\u0018\u0010?\u001a\u00020\u000eX\u0096\u000f\u00a2\u0006\f\u001a\u0004\b@\u0010A\"\u0004\bB\u0010CR\u001a\u0010D\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bE\u0010\u001e\"\u0004\bF\u0010 R\u0012\u0010G\u001a\u00020\u000eX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bH\u0010AR\u0012\u0010I\u001a\u00020\u000eX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bJ\u0010AR\u001a\u0010K\u001a\u0004\u0018\u00010LX\u0096\u000f\u00a2\u0006\f\u001a\u0004\bM\u0010N\"\u0004\bO\u0010PR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010Q\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010R\u001a\u00020\u000e8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\bS\u0010AR\u0012\u0010T\u001a\u00020\u000eX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bT\u0010AR\u000e\u0010U\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010V\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010W\u001a\u0004\u0018\u00010XX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010Y\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bZ\u0010[R\u001a\u0010\\\u001a\u00020]X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b^\u0010_\"\u0004\b`\u0010aR$\u0010c\u001a\u00020\u000b2\u0006\u0010b\u001a\u00020\u000b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bd\u0010e\"\u0004\bf\u0010gR\u001a\u0010h\u001a\u0004\u0018\u00010iX\u0096\u000f\u00a2\u0006\f\u001a\u0004\bj\u0010k\"\u0004\bl\u0010mR\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010n\u001a\n\u0012\u0004\u0012\u00020p\u0018\u00010oX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bq\u0010r\"\u0004\bs\u0010tR\u000e\u0010u\u001a\u000202X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010v\u001a\u00020wX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010x\u001a\u0002022\u0006\u0010\u0014\u001a\u000202@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\by\u00104R\u001c\u0010z\u001a\u0004\u0018\u00010{X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b|\u0010}\"\u0004\b~\u0010\u007fR\u0018\u0010\u0080\u0001\u001a\u00030\u0081\u0001X\u0080\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u0082\u0001\u0010\u0083\u0001R\u0015\u0010\u0084\u0001\u001a\u00030\u0085\u0001\u00a2\u0006\n\n\u0000\u001a\u0006\b\u0086\u0001\u0010\u0087\u0001R\u0018\u0010\u0088\u0001\u001a\u00030\u0089\u0001X\u0080\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u008a\u0001\u0010\u008b\u0001R#\u0010\u008d\u0001\u001a\u00030\u008c\u00012\u0007\u0010\u0014\u001a\u00030\u008c\u0001@BX\u0086\u000e\u00a2\u0006\n\n\u0000\u001a\u0006\b\u008e\u0001\u0010\u008f\u0001R\"\u0010\u0090\u0001\u001a\u0005\u0018\u00010\u0091\u0001X\u0080\u000e\u00a2\u0006\u0012\n\u0000\u001a\u0006\b\u0092\u0001\u0010\u0093\u0001\"\u0006\b\u0094\u0001\u0010\u0095\u0001R\u000f\u0010\u0096\u0001\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u0097\u0001\u001a\u0005\u0018\u00010\u0098\u0001X\u0080\u000e\u00a2\u0006\u0012\n\u0000\u001a\u0006\b\u0099\u0001\u0010\u009a\u0001\"\u0006\b\u009b\u0001\u0010\u009c\u0001\u00a8\u0006\u00ee\u0001"}, d2={"Lcom/mobilefuse/videoplayer/VideoPlayer;", "Landroid/widget/FrameLayout;", "Lcom/mobilefuse/videoplayer/controller/FullscreenController;", "Lcom/mobilefuse/videoplayer/controller/MuteController;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "primary", "", "fullscreenController", "Lcom/mobilefuse/videoplayer/controller/FullscreenControllerImpl;", "muteController", "Lcom/mobilefuse/videoplayer/controller/MuteControllerImpl;", "(Landroid/content/Context;Landroid/util/AttributeSet;IZLcom/mobilefuse/videoplayer/controller/FullscreenControllerImpl;Lcom/mobilefuse/videoplayer/controller/MuteControllerImpl;)V", "<set-?>", "Lcom/mobilefuse/videoplayer/model/AdAutoplay;", "adAutoplay", "getAdAutoplay", "()Lcom/mobilefuse/videoplayer/model/AdAutoplay;", "setAdAutoplay$mobilefuse_video_player_release", "(Lcom/mobilefuse/videoplayer/model/AdAutoplay;)V", "blockSkipSeconds", "", "getBlockSkipSeconds", "()F", "setBlockSkipSeconds", "(F)V", "clickthroughBehaviour", "Lcom/mobilefuse/sdk/video/ClickthroughBehaviour;", "getClickthroughBehaviour", "()Lcom/mobilefuse/sdk/video/ClickthroughBehaviour;", "setClickthroughBehaviour", "(Lcom/mobilefuse/sdk/video/ClickthroughBehaviour;)V", "controller", "Lcom/mobilefuse/videoplayer/VideoPlayerController;", "getController$mobilefuse_video_player_release", "()Lcom/mobilefuse/videoplayer/VideoPlayerController;", "currentMediaFile", "Lcom/mobilefuse/videoplayer/model/VastMediaFile;", "currentMediaFileSizeDp", "Landroid/graphics/Point;", "getCurrentMediaFileSizeDp", "()Landroid/graphics/Point;", "currentPlaybackPositionMillis", "", "getCurrentPlaybackPositionMillis", "()J", "Lcom/mobilefuse/videoplayer/endcard/EndCardPresenter;", "endCardPresenter", "getEndCardPresenter$mobilefuse_video_player_release", "()Lcom/mobilefuse/videoplayer/endcard/EndCardPresenter;", "endCardScheduler", "Lcom/mobilefuse/videoplayer/endcard/scheduler/EndCardScheduler;", "getEndCardScheduler", "()Lcom/mobilefuse/videoplayer/endcard/scheduler/EndCardScheduler;", "setEndCardScheduler", "(Lcom/mobilefuse/videoplayer/endcard/scheduler/EndCardScheduler;)V", "enterFullscreenOnVideoTap", "getEnterFullscreenOnVideoTap", "()Z", "setEnterFullscreenOnVideoTap", "(Z)V", "forceSkipSeconds", "getForceSkipSeconds", "setForceSkipSeconds", "fullscreen", "getFullscreen", "fullscreenAllowed", "getFullscreenAllowed", "fullscreenChangedListener", "Lcom/mobilefuse/videoplayer/controller/FullscreenChangedListener;", "getFullscreenChangedListener", "()Lcom/mobilefuse/videoplayer/controller/FullscreenChangedListener;", "setFullscreenChangedListener", "(Lcom/mobilefuse/videoplayer/controller/FullscreenChangedListener;)V", "initialized", "isDestroyed", "isDestroyed$mobilefuse_video_player_release", "isMuteAllowed", "layoutHeight", "layoutWidth", "loadListener", "Lcom/mobilefuse/videoplayer/VideoPlayer$LoadListener;", "mainContainer", "getMainContainer$mobilefuse_video_player_release", "()Landroid/widget/FrameLayout;", "mainContainerParams", "Landroid/view/ViewGroup$LayoutParams;", "getMainContainerParams$mobilefuse_video_player_release", "()Landroid/view/ViewGroup$LayoutParams;", "setMainContainerParams$mobilefuse_video_player_release", "(Landroid/view/ViewGroup$LayoutParams;)V", "value", "maxEndCardsToShow", "getMaxEndCardsToShow", "()I", "setMaxEndCardsToShow", "(I)V", "muteChangedListener", "Lcom/mobilefuse/sdk/MuteChangedListener;", "getMuteChangedListener", "()Lcom/mobilefuse/sdk/MuteChangedListener;", "setMuteChangedListener", "(Lcom/mobilefuse/sdk/MuteChangedListener;)V", "onVideoSkipButtonVisible", "Lkotlin/Function0;", "", "getOnVideoSkipButtonVisible", "()Lkotlin/jvm/functions/Function0;", "setOnVideoSkipButtonVisible", "(Lkotlin/jvm/functions/Function0;)V", "pausedVideoPosition", "playbackController", "Lcom/mobilefuse/videoplayer/controller/PlaybackController;", "playbackDurationMillis", "getPlaybackDurationMillis", "playbackListener", "Lcom/mobilefuse/videoplayer/VideoPlayer$PlaybackListener;", "getPlaybackListener$mobilefuse_video_player_release", "()Lcom/mobilefuse/videoplayer/VideoPlayer$PlaybackListener;", "setPlaybackListener$mobilefuse_video_player_release", "(Lcom/mobilefuse/videoplayer/VideoPlayer$PlaybackListener;)V", "player", "Lcom/mobilefuse/videoplayer/media/MobileFusePlayer;", "getPlayer$mobilefuse_video_player_release", "()Lcom/mobilefuse/videoplayer/media/MobileFusePlayer;", "playerCapabilities", "Lcom/mobilefuse/videoplayer/VideoPlayerCapabilities;", "getPlayerCapabilities", "()Lcom/mobilefuse/videoplayer/VideoPlayerCapabilities;", "playerHandler", "Landroid/os/Handler;", "getPlayerHandler$mobilefuse_video_player_release", "()Landroid/os/Handler;", "Lcom/mobilefuse/videoplayer/VideoPlayer$PlayerState;", "playerState", "getPlayerState", "()Lcom/mobilefuse/videoplayer/VideoPlayer$PlayerState;", "renderingActivity", "Landroid/app/Activity;", "getRenderingActivity$mobilefuse_video_player_release", "()Landroid/app/Activity;", "setRenderingActivity$mobilefuse_video_player_release", "(Landroid/app/Activity;)V", "videoStarted", "webView", "Landroid/webkit/WebView;", "getWebView$mobilefuse_video_player_release", "()Landroid/webkit/WebView;", "setWebView$mobilefuse_video_player_release", "(Landroid/webkit/WebView;)V", "addIcon", "icon", "Lcom/mobilefuse/videoplayer/model/VastIcon;", "addIcons", "addPlayerInstance", "bindCurrentMediaFileToPlayerInstance", "calculateSkipOffset", "callJsBridgeCmd", "js", "", "callJsBridgeCmd$mobilefuse_video_player_release", "changePlayerState", "newPlayerState", "createWebView", "initializationListener", "destroy", "destroyEndCard", "destroyVideoPlayer", "enableExternalFullscreenControl", "bridge", "Lcom/mobilefuse/videoplayer/controller/ExternalFullscreenControlBridge;", "fillsEntireScreen", "getSizeInDp", "", "getSizeInPixels", "handleVastBridgeCall", "callUri", "Landroid/net/Uri;", "initializePlayer", "isMuted", "isPlaying", "loadVast", "xml", "onActivityPause", "onActivityResume", "onAdCompleted", "onAttachedToWindow", "onDetachedFromWindow", "onEndCardError", "onLayout", "changed", "left", "top", "right", "bottom", "onMediaFileSelected", "mediaFile", "onPrepared", "onVastDataLoaded", "success", "error", "Lcom/mobilefuse/videoplayer/model/VastError;", "onVideoCompleted", "closeTrigger", "Lcom/mobilefuse/videoplayer/view/ViewCloseTrigger;", "onVideoError", "onVideoFileCached", "pause", "play", "activity", "removePlayerUi", "resume", "sendTrackingEvent", "eventType", "Lcom/mobilefuse/videoplayer/model/VastTrackingEventType;", "setFullscreen", "setFullscreenAllowed", "setMuteAllowed", "setMuted", "muted", "setOmidBridge", "omidBridge", "Lcom/mobilefuse/sdk/omid/VastOmidBridge;", "showEndCard", "skipVideo", "startVideoTimer", "stopVideoTimer", "Companion", "LoadListener", "PlaybackListener", "PlayerState", "mobilefuse-video-player_release"})
public final class VideoPlayer
extends FrameLayout
implements FullscreenController,
MuteController {
    @NotNull
    private final Handler playerHandler;
    @Nullable
    private Activity renderingActivity;
    private boolean initialized;
    private int layoutWidth;
    private int layoutHeight;
    @NotNull
    private final MobileFusePlayer player;
    private final PlaybackController playbackController;
    @NotNull
    private final FrameLayout mainContainer;
    @NotNull
    private ViewGroup.LayoutParams mainContainerParams;
    private long playbackDurationMillis;
    private long pausedVideoPosition;
    @Nullable
    private WebView webView;
    @NotNull
    private final VideoPlayerController controller;
    private VastMediaFile currentMediaFile;
    private LoadListener loadListener;
    @Nullable
    private PlaybackListener playbackListener;
    @Nullable
    private Function0<Unit> onVideoSkipButtonVisible;
    @NotNull
    private PlayerState playerState;
    private boolean videoStarted;
    @NotNull
    private final VideoPlayerCapabilities playerCapabilities;
    @NotNull
    private AdAutoplay adAutoplay;
    private float forceSkipSeconds;
    private float blockSkipSeconds;
    private int maxEndCardsToShow;
    @NotNull
    private EndCardScheduler endCardScheduler;
    @Nullable
    private EndCardPresenter endCardPresenter;
    @NotNull
    private ClickthroughBehaviour clickthroughBehaviour;
    private final FullscreenControllerImpl fullscreenController;
    private final MuteControllerImpl muteController;
    private static final Map<String, Set<VideoPlayer>> MEDIA_FILES_IN_USE;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final Handler getPlayerHandler$mobilefuse_video_player_release() {
        return this.playerHandler;
    }

    @Nullable
    public final Activity getRenderingActivity$mobilefuse_video_player_release() {
        return this.renderingActivity;
    }

    public final void setRenderingActivity$mobilefuse_video_player_release(@Nullable Activity activity) {
        this.renderingActivity = activity;
    }

    @NotNull
    public final MobileFusePlayer getPlayer$mobilefuse_video_player_release() {
        return this.player;
    }

    @NotNull
    public final FrameLayout getMainContainer$mobilefuse_video_player_release() {
        return this.mainContainer;
    }

    @NotNull
    public final ViewGroup.LayoutParams getMainContainerParams$mobilefuse_video_player_release() {
        return this.mainContainerParams;
    }

    public final void setMainContainerParams$mobilefuse_video_player_release(@NotNull ViewGroup.LayoutParams layoutParams) {
        Intrinsics.checkNotNullParameter((Object)layoutParams, (String)"<set-?>");
        this.mainContainerParams = layoutParams;
    }

    public final long getPlaybackDurationMillis() {
        return this.playbackDurationMillis;
    }

    @Nullable
    public final WebView getWebView$mobilefuse_video_player_release() {
        return this.webView;
    }

    public final void setWebView$mobilefuse_video_player_release(@Nullable WebView webView) {
        this.webView = webView;
    }

    @NotNull
    public final VideoPlayerController getController$mobilefuse_video_player_release() {
        return this.controller;
    }

    @Nullable
    public final PlaybackListener getPlaybackListener$mobilefuse_video_player_release() {
        return this.playbackListener;
    }

    public final void setPlaybackListener$mobilefuse_video_player_release(@Nullable PlaybackListener playbackListener) {
        this.playbackListener = playbackListener;
    }

    @Nullable
    public final Function0<Unit> getOnVideoSkipButtonVisible() {
        return this.onVideoSkipButtonVisible;
    }

    public final void setOnVideoSkipButtonVisible(@Nullable Function0<Unit> function0) {
        this.onVideoSkipButtonVisible = function0;
    }

    @NotNull
    public final PlayerState getPlayerState() {
        return this.playerState;
    }

    @NotNull
    public final VideoPlayerCapabilities getPlayerCapabilities() {
        return this.playerCapabilities;
    }

    @NotNull
    public final AdAutoplay getAdAutoplay() {
        return this.adAutoplay;
    }

    public final void setAdAutoplay$mobilefuse_video_player_release(@NotNull AdAutoplay adAutoplay) {
        Intrinsics.checkNotNullParameter((Object)((Object)adAutoplay), (String)"<set-?>");
        this.adAutoplay = adAutoplay;
    }

    public final float getForceSkipSeconds() {
        return this.forceSkipSeconds;
    }

    public final void setForceSkipSeconds(float f) {
        this.forceSkipSeconds = f;
    }

    public final float getBlockSkipSeconds() {
        return this.blockSkipSeconds;
    }

    public final void setBlockSkipSeconds(float f) {
        this.blockSkipSeconds = f;
    }

    public final int getMaxEndCardsToShow() {
        return this.maxEndCardsToShow;
    }

    public final void setMaxEndCardsToShow(int value) {
        if (this.maxEndCardsToShow < 0) {
            return;
        }
        this.maxEndCardsToShow = value;
    }

    @NotNull
    public final EndCardScheduler getEndCardScheduler() {
        return this.endCardScheduler;
    }

    public final void setEndCardScheduler(@NotNull EndCardScheduler endCardScheduler) {
        Intrinsics.checkNotNullParameter((Object)endCardScheduler, (String)"<set-?>");
        this.endCardScheduler = endCardScheduler;
    }

    @Nullable
    public final EndCardPresenter getEndCardPresenter$mobilefuse_video_player_release() {
        return this.endCardPresenter;
    }

    @NotNull
    public final ClickthroughBehaviour getClickthroughBehaviour() {
        return this.clickthroughBehaviour;
    }

    public final void setClickthroughBehaviour(@NotNull ClickthroughBehaviour clickthroughBehaviour) {
        Intrinsics.checkNotNullParameter((Object)clickthroughBehaviour, (String)"<set-?>");
        this.clickthroughBehaviour = clickthroughBehaviour;
    }

    private final void addPlayerInstance() {
        try {
            this.mainContainer.setBackgroundColor((int)0xFF000000L);
            this.addView((View)this.mainContainer, this.mainContainerParams);
            ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(-1, -1);
            this.mainContainer.addView((View)this.player, params);
            this.player.setPlayerStateChangeListener((Function1<? super MediaPlayerState, Unit>)((Function1)new Function1<MediaPlayerState, Unit>(this){
                final /* synthetic */ VideoPlayer this$0;

                public final void invoke(@NotNull MediaPlayerState state) {
                    Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
                    try {
                        PlayerState newState;
                        switch (VideoPlayer$WhenMappings.$EnumSwitchMapping$0[state.ordinal()]) {
                            case 1: {
                                PlayerState playerState = PlayerState.PLAYING;
                                break;
                            }
                            case 2: {
                                PlayerState playerState = PlayerState.PAUSED;
                                break;
                            }
                            case 3: {
                                PlayerState playerState = PlayerState.ERROR;
                                break;
                            }
                            default: {
                                PlayerState playerState = newState = null;
                            }
                        }
                        if (newState != null) {
                            VideoPlayer.access$changePlayerState(this.this$0, newState);
                        }
                    }
                    catch (Throwable e) {
                        StabilityHelper.logException((Object)this.this$0, (Throwable)e);
                    }
                }
                {
                    this.this$0 = videoPlayer;
                    super(1);
                }
            }));
            this.player.setPlaybackCompletionListener((Function0<Unit>)((Function0)new Function0<Unit>(this){
                final /* synthetic */ VideoPlayer this$0;

                public final void invoke() {
                    try {
                        VideoPlayer.access$onVideoCompleted(this.this$0, ViewCloseTrigger.AUTO_CLOSE);
                    }
                    catch (Throwable e) {
                        StabilityHelper.logException((Object)this.this$0, (Throwable)e);
                    }
                }
                {
                    this.this$0 = videoPlayer;
                    super(0);
                }
            }));
        }
        catch (Throwable e) {
            StabilityHelper.logException((Object)this, (Throwable)e);
        }
    }

    public final void setOmidBridge(@Nullable VastOmidBridge omidBridge) {
        this.controller.setOmidBridge(omidBridge);
    }

    public final void loadVast(@NotNull String xml, @NotNull LoadListener loadListener) {
        Intrinsics.checkNotNullParameter((Object)xml, (String)"xml");
        Intrinsics.checkNotNullParameter((Object)loadListener, (String)"loadListener");
        try {
            this.loadListener = loadListener;
            this.controller.loadVastTag(xml, (Function2<? super Boolean, ? super VastError, Unit>)((Function2)new Function2<Boolean, VastError, Unit>(this){

                public final void invoke(boolean p1, @Nullable VastError p2) {
                    VideoPlayer.access$onVastDataLoaded((VideoPlayer)this.receiver, p1, p2);
                }
            }));
        }
        catch (Throwable e) {
            StabilityHelper.logException((Object)this, (Throwable)e);
        }
    }

    private final void onVastDataLoaded(boolean success, VastError error) {
        if (this.isDestroyed$mobilefuse_video_player_release()) {
            return;
        }
        try {
            if (!success) {
                DebuggingKt.logError$default((Object)this, (String)"VAST xml tag can't be loaded or parsed", null, (int)2, null);
                LoadListener loadListener = this.loadListener;
                if (loadListener != null) {
                    loadListener.onError(error);
                }
                return;
            }
            Context context = this.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
            if (NetworkUtils.INSTANCE.getNetworkType(context) == null) {
                VideoPlayer videoPlayer;
                VideoPlayer $this$run = videoPlayer = this;
                boolean bl = false;
                DebuggingKt.logError$default((Object)$this$run, (String)"Can't proceed with media file loading due to no active network connection.", null, (int)2, null);
                LoadListener loadListener = $this$run.loadListener;
                if (loadListener != null) {
                    loadListener.onError(VastError.MEDIAFILE_TIMEOUT);
                }
                return;
            }
            DiskCacheUtil.initialize(this.getContext());
            Context context2 = this.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context");
            int[] screenSize = MediaUtilsKt.getScreenSizeAsPixels(context2);
            this.controller.selectBestMediaFile(screenSize, (Function1<? super VastMediaFile, Unit>)((Function1)new Function1<VastMediaFile, Unit>(this){

                public final void invoke(@Nullable VastMediaFile p1) {
                    VideoPlayer.access$onMediaFileSelected((VideoPlayer)this.receiver, p1);
                }
            }));
        }
        catch (Throwable e) {
            StabilityHelper.logException((Object)this, (Throwable)e);
        }
    }

    static /* synthetic */ void onVastDataLoaded$default(VideoPlayer videoPlayer, boolean bl, VastError vastError, int n, Object object) {
        if ((n & 2) != 0) {
            vastError = null;
        }
        videoPlayer.onVastDataLoaded(bl, vastError);
    }

    private final void onMediaFileSelected(VastMediaFile mediaFile) {
        if (this.isDestroyed$mobilefuse_video_player_release()) {
            return;
        }
        try {
            VastMediaFile vastMediaFile = this.currentMediaFile = mediaFile;
            if (vastMediaFile == null) {
                VideoPlayer videoPlayer;
                VideoPlayer $this$run = videoPlayer = this;
                boolean bl = false;
                LoadListener loadListener = $this$run.loadListener;
                if (loadListener != null) {
                    loadListener.onError(VastError.MEDIAFILE_NOT_FOUND);
                }
                return;
            }
            VastMediaFile currentMediaFile = vastMediaFile;
            this.changePlayerState(PlayerState.VIDEO_LOADING);
            boolean alreadyCached = DiskCacheUtil.containsFileCache(currentMediaFile.getUrl());
            if (alreadyCached) {
                this.onVideoFileCached();
            } else {
                Context context = this.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
                VideoDownloader.INSTANCE.cache(context, currentMediaFile.getUrl(), new VideoDownloader.Listener(this){
                    final /* synthetic */ VideoPlayer this$0;

                    public void onComplete(@NotNull String requestedUrl, @NotNull String cachedFileLruKey) {
                        Intrinsics.checkNotNullParameter((Object)requestedUrl, (String)"requestedUrl");
                        Intrinsics.checkNotNullParameter((Object)cachedFileLruKey, (String)"cachedFileLruKey");
                        try {
                            this.this$0.getPlayerHandler$mobilefuse_video_player_release().post(new Runnable(this){
                                final /* synthetic */ onMediaFileSelected.1 this$0;

                                public final void run() {
                                    VideoPlayer.access$onVideoFileCached(this.this$0.this$0);
                                }
                                {
                                    this.this$0 = var1_1;
                                }
                            });
                        }
                        catch (Throwable e) {
                            StabilityHelper.logException((Object)this, (Throwable)e);
                        }
                    }

                    public void onError(@NotNull VastError error) {
                        block1: {
                            Intrinsics.checkNotNullParameter((Object)((Object)error), (String)"error");
                            if (this.this$0.isDestroyed$mobilefuse_video_player_release()) {
                                return;
                            }
                            this.this$0.getController$mobilefuse_video_player_release().sendErrorEvent(error);
                            LoadListener loadListener = VideoPlayer.access$getLoadListener$p(this.this$0);
                            if (loadListener == null) break block1;
                            loadListener.onError(error);
                        }
                    }
                    {
                        this.this$0 = this$0;
                    }
                });
            }
        }
        catch (Throwable e) {
            StabilityHelper.logException((Object)this, (Throwable)e);
        }
    }

    private final void onVideoFileCached() {
        if (this.isDestroyed$mobilefuse_video_player_release()) {
            return;
        }
        try {
            this.bindCurrentMediaFileToPlayerInstance();
            Object object = this.currentMediaFile;
            if (object == null || (object = ((VastMediaFile)object).getUrl()) == null) {
                return;
            }
            Object mediaFileUrl = object;
            String string = DiskCacheUtil.getCachedFilePath((String)mediaFileUrl);
            if (string == null) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DiskCacheUtil.getCachedF\u2026h(mediaFileUrl) ?: return");
            String videoDiskPath = string;
            VastMediaFile vastMediaFile = this.currentMediaFile;
            if (vastMediaFile != null) {
                VastMediaFile vastMediaFile2;
                VastMediaFile it = vastMediaFile2 = vastMediaFile;
                boolean bl = false;
                it.setUrl(videoDiskPath);
                this.changePlayerState(PlayerState.VIDEO_CACHED);
                LoadListener loadListener = this.loadListener;
                if (loadListener != null) {
                    loadListener.onVideoLoaded();
                }
            }
        }
        catch (Throwable e) {
            StabilityHelper.logException((Object)this, (Throwable)e);
        }
    }

    private final void bindCurrentMediaFileToPlayerInstance() {
        try {
            Set<VideoPlayer> vastPlayersForMediaFile;
            Object object = this.currentMediaFile;
            if (object == null || (object = ((VastMediaFile)object).getOriginalUrl()) == null) {
                return;
            }
            Object originalUrl = object;
            if (!MEDIA_FILES_IN_USE.containsKey(originalUrl)) {
                MEDIA_FILES_IN_USE.put((String)originalUrl, new LinkedHashSet());
            }
            Set<VideoPlayer> set = vastPlayersForMediaFile = MEDIA_FILES_IN_USE.get(originalUrl);
            if (set != null) {
                set.add(this);
            }
        }
        catch (Throwable e) {
            StabilityHelper.logException((Object)this, (Throwable)e);
        }
    }

    private final void initializePlayer(Function0<Unit> initializationListener) {
        try {
            if (this.initialized) {
                return;
            }
            this.initialized = true;
            this.createWebView(initializationListener);
        }
        catch (Throwable e) {
            StabilityHelper.logException((Object)this, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @SuppressLint(value={"SetJavaScriptEnabled"})
    private final void createWebView(Function0<Unit> initializationListener) {
        void $this$apply;
        WebView webView;
        if (this.isDestroyed$mobilefuse_video_player_release()) {
            return;
        }
        WebView webView2 = webView = new WebView(this.getContext());
        VideoPlayer videoPlayer = this;
        boolean bl = false;
        WebSettings webSettings = $this$apply.getSettings();
        Intrinsics.checkNotNullExpressionValue((Object)webSettings, (String)"settings");
        webSettings.setJavaScriptEnabled(true);
        WebSettings webSettings2 = $this$apply.getSettings();
        Intrinsics.checkNotNullExpressionValue((Object)webSettings2, (String)"settings");
        webSettings2.setAllowContentAccess(true);
        WebSettings webSettings3 = $this$apply.getSettings();
        Intrinsics.checkNotNullExpressionValue((Object)webSettings3, (String)"settings");
        webSettings3.setAllowFileAccess(true);
        WebSettings webSettings4 = $this$apply.getSettings();
        Intrinsics.checkNotNullExpressionValue((Object)webSettings4, (String)"settings");
        webSettings4.setAllowFileAccessFromFileURLs(true);
        WebSettings webSettings5 = $this$apply.getSettings();
        Intrinsics.checkNotNullExpressionValue((Object)webSettings5, (String)"settings");
        webSettings5.setAllowUniversalAccessFromFileURLs(true);
        $this$apply.setBackgroundColor(Color.argb((int)0, (int)255, (int)255, (int)255));
        $this$apply.setLayerType(2, null);
        String assetName = "vast_controls.html";
        Object object = MobileFuseAssetManager.INSTANCE.getSpecificAssetContent(assetName);
        if (object == null) {
            InputStream inputStream;
            void var6_7;
            void $this$run = var6_7 = $this$apply;
            boolean bl2 = false;
            Context context = $this$run.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
            InputStream inputStream2 = context.getAssets().open("mobilefuse/" + assetName);
            Intrinsics.checkNotNullExpressionValue((Object)inputStream2, (String)"context.assets.open(\"mobilefuse/${assetName}\")");
            Closeable closeable = inputStream = inputStream2;
            Object object2 = Charsets.UTF_8;
            Object object3 = new InputStreamReader((InputStream)closeable, (Charset)object2);
            int n = 8192;
            closeable = object3 instanceof BufferedReader ? (BufferedReader)object3 : new BufferedReader((Reader)object3, n);
            object2 = null;
            try {
                BufferedReader it = (BufferedReader)closeable;
                boolean bl3 = false;
                object3 = TextStreamsKt.readText((Reader)it);
                object = object3;
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)object2);
            }
        }
        String content = object;
        $this$apply.loadDataWithBaseURL("https://sdk-webview.mobilefuse.com/vast/", content, "text/html", "UTF-8", null);
        $this$apply.setWebViewClient(new WebViewClient((WebView)$this$apply, this, initializationListener){
            final /* synthetic */ WebView $this_apply;
            final /* synthetic */ VideoPlayer this$0;
            final /* synthetic */ Function0 $initializationListener$inlined;
            {
                this.$this_apply = $receiver;
                this.this$0 = videoPlayer;
                this.$initializationListener$inlined = function0;
            }

            @Deprecated(message="Deprecated in Java")
            public boolean shouldOverrideUrlLoading(@NotNull WebView view, @NotNull String url) {
                Intrinsics.checkNotNullParameter((Object)view, (String)"view");
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                try {
                    Uri parsed;
                    Uri uri = parsed = Uri.parse((String)url);
                    Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"parsed");
                    if (Intrinsics.areEqual((Object)uri.getScheme(), (Object)"vast") ^ true) {
                        return super.shouldOverrideUrlLoading(view, url);
                    }
                    VideoPlayer.access$handleVastBridgeCall(this.this$0, parsed);
                }
                catch (Throwable e) {
                    StabilityHelper.logException((Object)((Object)this), (Throwable)e);
                }
                return true;
            }

            public void onPageFinished(@NotNull WebView view, @NotNull String url) {
                Intrinsics.checkNotNullParameter((Object)view, (String)"view");
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                try {
                    this.$initializationListener$inlined.invoke();
                }
                catch (Throwable e) {
                    StabilityHelper.logException((Object)((Object)this), (Throwable)e);
                }
                super.onPageFinished(view, url);
            }

            public void onLoadResource(@Nullable WebView view, @NotNull String url) {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                try {
                    HttpRequestTracker.logHttpRequest((String)url);
                }
                catch (Throwable e) {
                    StabilityHelper.logException((Object)((Object)this), (Throwable)e);
                }
                super.onLoadResource(view, url);
            }

            /*
             * WARNING - void declaration
             */
            public boolean onRenderProcessGone(@Nullable WebView view, @Nullable RenderProcessGoneDetail detail) {
                Log.w((String)"Video Player", (String)"WebView Render Process has gone.");
                if (view != this.this$0.getWebView$mobilefuse_video_player_release()) {
                    return true;
                }
                boolean $i$f$handleExceptions = false;
                String string = "[Automatically caught]";
                ExceptionHandlingStrategy strategy$iv$iv = ExceptionHandlingStrategy.LogAndIgnore;
                boolean $i$f$handleExceptions2 = false;
                try {
                    boolean bl = false;
                    WebView webView = this.this$0.getWebView$mobilefuse_video_player_release();
                    if (webView != null) {
                        WebView webView2;
                        WebView it = webView2 = webView;
                        boolean bl2 = false;
                        ViewParent viewParent = it.getParent();
                        if (!(viewParent instanceof ViewGroup)) {
                            viewParent = null;
                        }
                        ViewGroup viewGroup = (ViewGroup)viewParent;
                        if (viewGroup != null) {
                            viewGroup.removeView((View)it);
                        }
                    }
                    this.this$0.getController$mobilefuse_video_player_release().sendErrorEvent(VastError.GENERAL_PLAYBACK_FAILURE);
                    VideoPlayer.access$onVideoError(this.this$0);
                }
                catch (Throwable e$iv$iv) {
                    switch (VideoPlayer$createWebView$1$1$onRenderProcessGone$$inlined$handleExceptions$1$wm$TryKt$WhenMappings.$EnumSwitchMapping$0[strategy$iv$iv.ordinal()]) {
                        case 1: {
                            void source$iv$iv;
                            StabilityHelper.logException((Object)source$iv$iv, (Throwable)e$iv$iv);
                            break;
                        }
                        case 2: {
                            break;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                }
                return true;
            }

            @RequiresApi(value=21)
            @Nullable
            public WebResourceResponse shouldInterceptRequest(@Nullable WebView view, @Nullable WebResourceRequest request) {
                try {
                    if (request == null) {
                        return null;
                    }
                    return WebViewUtils.shouldInterceptRequest((Context)this.$this_apply.getContext(), (Uri)request.getUrl());
                }
                catch (Throwable e) {
                    StabilityHelper.logException((Object)((Object)this), (Throwable)e);
                    return super.shouldInterceptRequest(view, request);
                }
            }

            @Deprecated(message="Deprecated in Java")
            @Nullable
            public WebResourceResponse shouldInterceptRequest(@Nullable WebView view, @Nullable String url) {
                try {
                    Uri requestUri = Uri.parse((String)url);
                    return WebViewUtils.shouldInterceptRequest((Context)this.$this_apply.getContext(), (Uri)requestUri);
                }
                catch (Throwable e) {
                    StabilityHelper.logException((Object)((Object)this), (Throwable)e);
                    return super.shouldInterceptRequest(view, url);
                }
            }
        });
        Unit unit = Unit.INSTANCE;
        videoPlayer.webView = webView;
        this.mainContainer.addView((View)this.webView, 1);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (this.isDestroyed$mobilefuse_video_player_release()) {
            return;
        }
        try {
            if (!changed) {
                return;
            }
            this.layoutWidth = right - left;
            this.layoutHeight = bottom - top;
        }
        catch (Throwable e) {
            StabilityHelper.logException((Object)this, (Throwable)e);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void handleVastBridgeCall(Uri callUri) {
        if (this.isDestroyed$mobilefuse_video_player_release()) {
            return;
        }
        command = callUri.getHost();
        DebuggingKt.logDebug$default((Object)this, (String)("Call: " + command), null, (int)2, null);
        v0 = command;
        if (v0 == null) ** GOTO lbl-1000
        var3_3 = v0;
        tmp = -1;
        switch (var3_3.hashCode()) {
            case -356709944: {
                if (!var3_3.equals("closeButtonVisible")) break;
                tmp = 1;
                break;
            }
            case 1984790939: {
                if (!var3_3.equals("setMute")) break;
                tmp = 2;
                break;
            }
            case 586449341: {
                if (!var3_3.equals("setFullscreen")) break;
                tmp = 3;
                break;
            }
            case -737868098: {
                if (!var3_3.equals("iconView")) break;
                tmp = 4;
                break;
            }
            case 94750088: {
                if (!var3_3.equals("click")) break;
                tmp = 5;
                break;
            }
            case 94756344: {
                if (!var3_3.equals("close")) break;
                tmp = 6;
                break;
            }
            case -1416528753: {
                if (!var3_3.equals("iconClick")) break;
                tmp = 7;
                break;
            }
        }
        switch (tmp) {
            case 5: {
                if (this.getEnterFullscreenOnVideoTap() && this.getFullscreenAllowed() && !this.getFullscreen()) {
                    this.setFullscreen(true);
                    break;
                }
                v1 = callUri.getQueryParameter("source");
                if (v1 != null) {
                    it = var5_4 = v1;
                    $i$a$-let-VideoPlayer$handleVastBridgeCall$acceptClickThrough$1 = false;
                    v2 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"it");
                    v3 = ClickthroughBehaviourKt.canAcceptSource((ClickthroughBehaviour)this.clickthroughBehaviour, (String)v2);
                } else {
                    v3 = acceptClickThrough = true;
                }
                if (!acceptClickThrough) break;
                v4 = this.playbackListener;
                if (v4 != null) {
                    v4.onClicked();
                }
                this.controller.onVideoClickThrough();
                break;
            }
            case 6: {
                this.skipVideo();
                break;
            }
            case 7: {
                v5 = callUri.getQueryParameter("payload");
                if (v5 != null) {
                    it = acceptClickThrough = v5;
                    $i$a$-let-VideoPlayer$handleVastBridgeCall$1 = false;
                    v6 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"it");
                    this.controller.onIconClick(v6);
                }
                break;
            }
            case 4: {
                v7 = callUri.getQueryParameter("payload");
                if (v7 != null) {
                    it = acceptClickThrough = v7;
                    $i$a$-let-VideoPlayer$handleVastBridgeCall$2 = false;
                    v8 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"it");
                    this.controller.onIconView(v8);
                }
                break;
            }
            case 2: {
                this.muteController.setMuteFromWebView(callUri.getBooleanQueryParameter("muted", false));
                this.controller.onMuteChanged();
                v9 = this.getMuteChangedListener();
                if (v9 != null) {
                    v9.onMutedChanged(this.muteController.getMuted());
                }
                break;
            }
            case 3: {
                fullscreenValue = callUri.getBooleanQueryParameter("fullscreen", false);
                this.setFullscreen(fullscreenValue);
                break;
            }
            case 1: {
                this.playerCapabilities.changeCapability(VastPlayerCapability.SKIP, true);
                v10 = this.onVideoSkipButtonVisible;
                if (v10 != null) {
                    (Unit)v10.invoke();
                }
                break;
            }
            default: lbl-1000:
            // 2 sources

            {
                Log.w((String)"VAST", (String)("Unimplemented command called: " + command));
            }
        }
        this.callJsBridgeCmd$mobilefuse_video_player_release("vast.bridge.nativeCallComplete();");
    }

    public final void callJsBridgeCmd$mobilefuse_video_player_release(@NotNull String js) {
        Intrinsics.checkNotNullParameter((Object)js, (String)"js");
        if (this.isDestroyed$mobilefuse_video_player_release()) {
            return;
        }
        if (this.webView == null) {
            return;
        }
        this.playerHandler.post(new Runnable(this, js){
            final /* synthetic */ VideoPlayer this$0;
            final /* synthetic */ String $js;

            public final void run() {
                try {
                    if (Build.VERSION.SDK_INT >= 19) {
                        WebView webView = this.this$0.getWebView$mobilefuse_video_player_release();
                        if (webView != null) {
                            webView.evaluateJavascript(this.$js, null);
                        }
                    } else {
                        WebView webView = this.this$0.getWebView$mobilefuse_video_player_release();
                        if (webView != null) {
                            webView.loadUrl("javascript:" + this.$js);
                        }
                    }
                }
                catch (Throwable e) {
                    StabilityHelper.logException((Object)this.this$0, (Throwable)e);
                }
            }
            {
                this.this$0 = videoPlayer;
                this.$js = string;
            }
        });
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        try {
            this.resume();
        }
        catch (Throwable e) {
            StabilityHelper.logException((Object)this, (Throwable)e);
        }
    }

    protected void onDetachedFromWindow() {
        try {
            this.pause();
        }
        catch (Throwable e) {
            StabilityHelper.logException((Object)this, (Throwable)e);
        }
        super.onDetachedFromWindow();
    }

    public final void play(@Nullable Activity activity, @NotNull PlaybackListener playbackListener) {
        Intrinsics.checkNotNullParameter((Object)playbackListener, (String)"playbackListener");
        if (this.isDestroyed$mobilefuse_video_player_release()) {
            return;
        }
        try {
            this.renderingActivity = activity;
            Object object = this.currentMediaFile;
            if (object == null || (object = ((VastMediaFile)object).getUrl()) == null) {
                return;
            }
            Object mediaFileUrl = object;
            if (this.playerState != PlayerState.VIDEO_CACHED) {
                DebuggingKt.logError$default((Object)this, (String)"Can't play video because is not cached.", null, (int)2, null);
                return;
            }
            this.playbackListener = playbackListener;
            this.controller.initOmid$mobilefuse_video_player_release();
            this.controller.callOmidLoadedEvent$mobilefuse_video_player_release();
            this.adAutoplay = this.muteController.getMuted() ? AdAutoplay.MUTED_AUTOPLAY : AdAutoplay.UNMUTED_AUTOPLAY;
            this.changePlayerState(PlayerState.INITIALIZING);
            this.initializePlayer((Function0<Unit>)((Function0)new Function0<Unit>(this, (String)mediaFileUrl){
                final /* synthetic */ VideoPlayer this$0;
                final /* synthetic */ String $mediaFileUrl;

                public final void invoke() {
                    this.this$0.getPlayer$mobilefuse_video_player_release().prepare(this.$mediaFileUrl, ViewType.SURFACE_VIEW, (Function0<Unit>)((Function0)new Function0<Unit>(this){
                        final /* synthetic */ play.1 this$0;

                        public final void invoke() {
                            DebuggingKt.logDebug$default((Object)this.this$0.this$0, (String)"on video player prepared", null, (int)2, null);
                            VideoPlayer.access$onPrepared(this.this$0.this$0);
                        }
                        {
                            this.this$0 = var1_1;
                            super(0);
                        }
                    }));
                }
                {
                    this.this$0 = videoPlayer;
                    this.$mediaFileUrl = string;
                    super(0);
                }
            }));
        }
        catch (Throwable e) {
            StabilityHelper.logException((Object)this, (Throwable)e);
        }
    }

    private final float calculateSkipOffset() {
        VastTime vastTime = this.controller.getAdSkipOffset();
        return AdSkipOffsetResolver.resolveAdSkipOffset((Float)(vastTime != null ? Float.valueOf(vastTime.getValueInFloatSeconds()) : null), (float)this.forceSkipSeconds, (float)this.blockSkipSeconds);
    }

    private final void onPrepared() {
        if (this.isDestroyed$mobilefuse_video_player_release()) {
            return;
        }
        try {
            VastTime adDuration;
            DebuggingKt.logDebug$default((Object)this, (String)"vast player ready", null, (int)2, null);
            if (this.getEnterFullscreenOnVideoTap()) {
                this.callJsBridgeCmd$mobilefuse_video_player_release("vast.bridge.setEnterFullscreenOnVideoTap(true);");
            }
            VastTime vastTime = adDuration = this.controller.getAdDuration();
            if (vastTime != null) {
                VastTime vastTime2;
                VastTime it = vastTime2 = vastTime;
                boolean bl = false;
                this.callJsBridgeCmd$mobilefuse_video_player_release("vast.bridge.setVideoDuration(" + it.getValueInSeconds() + ");");
            }
            float skipOffset = this.calculateSkipOffset();
            if (skipOffset != -1.0f) {
                this.callJsBridgeCmd$mobilefuse_video_player_release("vast.bridge.setSkipTime(" + skipOffset + ");");
            }
            String ctaLabel = StringEncodingAndFormattingKt.encodeUriComponent("Learn More");
            this.callJsBridgeCmd$mobilefuse_video_player_release("vast.bridge.setCtaText(\"" + ctaLabel + "\");");
            if (this.isMuteAllowed()) {
                this.muteController.enableMuteButton$mobilefuse_video_player_release();
            }
            if (this.getFullscreenAllowed()) {
                this.fullscreenController.enableFullscreenButton$mobilefuse_video_player_release();
            }
            this.addIcons();
            DebuggingKt.logDebug$default((Object)this, (String)"vast player playing", null, (int)2, null);
            this.playbackDurationMillis = this.player.getDuration();
            this.player.play();
            this.startVideoTimer();
            PlaybackListener playbackListener = this.playbackListener;
            if (playbackListener != null) {
                playbackListener.onAdImpression();
            }
        }
        catch (Throwable e) {
            StabilityHelper.logException((Object)this, (Throwable)e);
        }
    }

    private final void addIcons() {
        List<VastIcon> icons = this.controller.getIcons();
        for (VastIcon icon : icons) {
            this.addIcon(icon);
        }
    }

    private final void addIcon(VastIcon icon) {
        try {
            int it;
            Object object;
            Object object2 = icon.getResource();
            if (object2 == null || (object2 = object2.getContent()) == null) {
                return;
            }
            String jsType = "IconResourceType." + icon.getResource().getResourceType().name();
            JSONObject json = new JSONObject();
            Integer n = icon.getWidth();
            if (n != null) {
                object = n;
                it = ((Number)object).intValue();
                boolean bl = false;
                json.put("width", it);
            }
            Integer n2 = icon.getHeight();
            if (n2 != null) {
                object = n2;
                it = ((Number)object).intValue();
                boolean bl = false;
                json.put("height", it);
            }
            VastTime vastTime = icon.getOffset();
            if (vastTime != null) {
                Object it2 = object = vastTime;
                boolean bl = false;
                json.put("offset", (double)((VastTime)it2).getValueInFloatSeconds());
            }
            VastTime vastTime2 = icon.getDuration();
            if (vastTime2 != null) {
                Object it3 = object = vastTime2;
                boolean bl = false;
                json.put("duration", (double)((VastTime)it3).getValueInFloatSeconds());
            }
            json.put("clickPayload", (Object)icon.getUid());
            json.put("viewPayload", (Object)icon.getUid());
            json.put("resource", (Object)icon.getResource().getContent());
            this.callJsBridgeCmd$mobilefuse_video_player_release("vast.bridge.addIcon(" + jsType + ", " + json + ");");
        }
        catch (Throwable e) {
            StabilityHelper.logException((Object)this, (Throwable)e);
        }
    }

    public final boolean fillsEntireScreen() {
        if (this.isDestroyed$mobilefuse_video_player_release()) {
            return false;
        }
        try {
            if (this.getFullscreenAllowed()) {
                return this.getFullscreen();
            }
            View view = this.getRootView();
            if (view == null) {
                return false;
            }
            View rootView = view;
            View view2 = rootView.findViewById(0x1020002);
            if (view2 == null) {
                return false;
            }
            View contentView = view2;
            if (contentView.getWidth() == this.mainContainer.getWidth() && contentView.getHeight() == this.mainContainer.getHeight()) {
                return true;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final void onVideoCompleted(ViewCloseTrigger closeTrigger) {
        boolean $i$f$handleExceptions = false;
        String string = "[Automatically caught]";
        ExceptionHandlingStrategy strategy$iv$iv = ExceptionHandlingStrategy.LogAndIgnore;
        boolean $i$f$handleExceptions2 = false;
        try {
            boolean bl = false;
            if (this.isDestroyed$mobilefuse_video_player_release()) {
                return;
            }
            DebuggingKt.logDebug$default((Object)this, (String)"onVideoCompleted", null, (int)2, null);
            this.stopVideoTimer();
            if (closeTrigger == ViewCloseTrigger.AUTO_CLOSE) {
                this.sendTrackingEvent(VastTrackingEventType.complete);
                PlaybackListener playbackListener = this.playbackListener;
                if (playbackListener != null) {
                    playbackListener.onVideoCompleted();
                }
            }
            this.showEndCard(closeTrigger);
        }
        catch (Throwable e$iv$iv) {
            switch (VideoPlayer$onVideoCompleted$$inlined$handleExceptions$1$wm$TryKt$WhenMappings.$EnumSwitchMapping$0[strategy$iv$iv.ordinal()]) {
                case 1: {
                    void source$iv$iv;
                    StabilityHelper.logException((Object)source$iv$iv, (Throwable)e$iv$iv);
                    break;
                }
                case 2: {
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
    }

    private final void onVideoError() {
        block0: {
            DebuggingKt.logDebug$default((Object)this, (String)"onVideoError", null, (int)2, null);
            PlaybackListener playbackListener = this.playbackListener;
            if (playbackListener == null) break block0;
            playbackListener.onVideoError();
        }
    }

    private final void onEndCardError() {
        block0: {
            DebuggingKt.logDebug$default((Object)this, (String)"onEndCardError", null, (int)2, null);
            PlaybackListener playbackListener = this.playbackListener;
            if (playbackListener == null) break block0;
            playbackListener.onEndCardError();
        }
    }

    private final void startVideoTimer() {
        if (this.isDestroyed$mobilefuse_video_player_release()) {
            return;
        }
        this.playbackController.startUpdating((Function2<? super Long, ? super Long, Unit>)((Function2)new Function2<Long, Long, Unit>(this){
            final /* synthetic */ VideoPlayer this$0;

            public final void invoke(long progress, long duration) {
                this.this$0.callJsBridgeCmd$mobilefuse_video_player_release("vast.bridge.setVideoDuration(" + (float)duration / 1000.0f + ");");
                this.this$0.callJsBridgeCmd$mobilefuse_video_player_release("vast.bridge.setCurrentTime(" + (float)progress / 1000.0f + ");");
            }
            {
                this.this$0 = videoPlayer;
                super(2);
            }
        }));
    }

    private final void stopVideoTimer() {
        this.playbackController.stopUpdating();
    }

    private final void changePlayerState(PlayerState newPlayerState) {
        if (this.isDestroyed$mobilefuse_video_player_release()) {
            return;
        }
        if (this.playerState == newPlayerState) {
            return;
        }
        this.playerState = newPlayerState;
        DebuggingKt.logDebug$default((Object)this, (String)("changePlayerState [newState: " + (Object)((Object)newPlayerState) + ']'), null, (int)2, null);
        try {
            switch (VideoPlayer$WhenMappings.$EnumSwitchMapping$1[this.playerState.ordinal()]) {
                case 1: {
                    this.controller.sendErrorEvent(VastError.GENERAL_PLAYBACK_FAILURE);
                    this.onVideoError();
                    break;
                }
                case 2: {
                    if (!this.videoStarted) {
                        this.videoStarted = true;
                        PlaybackListener playbackListener = this.playbackListener;
                        if (playbackListener != null) {
                            playbackListener.onVideoStarted();
                        }
                        this.controller.sendTrackingEvent(VastTrackingEventType.start);
                        this.controller.sendImpressionEvent$mobilefuse_video_player_release();
                    } else {
                        this.controller.sendTrackingEvent(VastTrackingEventType.resume);
                    }
                    PlaybackListener playbackListener = this.playbackListener;
                    if (playbackListener != null) {
                        playbackListener.onVideoPlaying();
                    }
                    break;
                }
                case 3: {
                    PlaybackListener playbackListener = this.playbackListener;
                    if (playbackListener != null) {
                        playbackListener.onVideoPaused();
                    }
                    this.controller.sendTrackingEvent(VastTrackingEventType.pause);
                    break;
                }
            }
        }
        catch (Throwable e) {
            StabilityHelper.logException((Object)this, (Throwable)e);
        }
    }

    private final void skipVideo() {
        if (this.isDestroyed$mobilefuse_video_player_release()) {
            return;
        }
        try {
            this.controller.onSkipped();
            this.pause();
            PlaybackListener playbackListener = this.playbackListener;
            if (playbackListener != null) {
                playbackListener.onVideoSkipped();
            }
            this.onVideoCompleted(ViewCloseTrigger.USER);
        }
        catch (Throwable e) {
            StabilityHelper.logException((Object)this, (Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void showEndCard(ViewCloseTrigger closeTrigger) {
        Either either;
        boolean $i$f$gracefullyHandleException = false;
        String string = "[Automatically caught]";
        ExceptionHandlingStrategy strategy$iv$iv = ExceptionHandlingStrategy.LogAndIgnore;
        boolean $i$f$gracefullyHandleException2 = false;
        try {
            Unit unit;
            boolean bl = false;
            if (this.isDestroyed$mobilefuse_video_player_release()) {
                return;
            }
            this.changePlayerState(PlayerState.END_CARD);
            this.destroyVideoPlayer();
            DebuggingKt.logDebug$default((Object)this, (String)"Show EndCard", null, (int)2, null);
            Context context = this.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
            int[] screenSize = MediaUtilsKt.getScreenSizeAsPixels(context);
            List<VastCompanion> companions = this.controller.selectCompanionAds(screenSize);
            if (companions.isEmpty()) {
                this.onAdCompleted();
                return;
            }
            Context context2 = this.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context");
            Object object = new EndCardListener(this, closeTrigger){
                final /* synthetic */ VideoPlayer this$0;
                final /* synthetic */ ViewCloseTrigger $closeTrigger$inlined;
                {
                    this.this$0 = videoPlayer;
                    this.$closeTrigger$inlined = viewCloseTrigger;
                }

                /*
                 * WARNING - void declaration
                 */
                public void onClosed(@NotNull VastCompanion companion, @NotNull ViewCloseTrigger closeTrigger) {
                    Intrinsics.checkNotNullParameter((Object)companion, (String)"companion");
                    Intrinsics.checkNotNullParameter((Object)((Object)closeTrigger), (String)"closeTrigger");
                    boolean $i$f$handleExceptions = false;
                    String string = "[Automatically caught]";
                    ExceptionHandlingStrategy strategy$iv$iv = ExceptionHandlingStrategy.LogAndIgnore;
                    boolean $i$f$handleExceptions2 = false;
                    try {
                        boolean bl = false;
                    }
                    catch (Throwable e$iv$iv) {
                        switch (VideoPlayer$showEndCard$1$endCardPresenter$1$onClosed$$inlined$handleExceptions$1$wm$TryKt$WhenMappings.$EnumSwitchMapping$0[strategy$iv$iv.ordinal()]) {
                            case 1: {
                                void source$iv$iv;
                                StabilityHelper.logException((Object)source$iv$iv, (Throwable)e$iv$iv);
                                break;
                            }
                            case 2: {
                                break;
                            }
                            default: {
                                throw new NoWhenBranchMatchedException();
                            }
                        }
                    }
                }

                /*
                 * WARNING - void declaration
                 */
                public void onCompleted() {
                    boolean $i$f$handleExceptions = false;
                    String string = "[Automatically caught]";
                    ExceptionHandlingStrategy strategy$iv$iv = ExceptionHandlingStrategy.LogAndIgnore;
                    boolean $i$f$handleExceptions2 = false;
                    try {
                        boolean bl = false;
                        VideoPlayer.access$onAdCompleted(this.this$0);
                    }
                    catch (Throwable e$iv$iv) {
                        switch (VideoPlayer$showEndCard$1$endCardPresenter$1$onCompleted$$inlined$handleExceptions$1$wm$TryKt$WhenMappings.$EnumSwitchMapping$0[strategy$iv$iv.ordinal()]) {
                            case 1: {
                                void source$iv$iv;
                                StabilityHelper.logException((Object)source$iv$iv, (Throwable)e$iv$iv);
                                break;
                            }
                            case 2: {
                                break;
                            }
                            default: {
                                throw new NoWhenBranchMatchedException();
                            }
                        }
                    }
                }

                /*
                 * WARNING - void declaration
                 */
                public void onClicked(@NotNull VastCompanion companion, @Nullable VastClickThrough clickThrough2) {
                    Intrinsics.checkNotNullParameter((Object)companion, (String)"companion");
                    boolean $i$f$handleExceptions = false;
                    String string = "[Automatically caught]";
                    ExceptionHandlingStrategy strategy$iv$iv = ExceptionHandlingStrategy.LogAndIgnore;
                    boolean $i$f$handleExceptions2 = false;
                    try {
                        boolean bl = false;
                        this.this$0.getController$mobilefuse_video_player_release().sendCompanionAdClickTrackingEvent(companion);
                        VastClickThrough vastClickThrough = clickThrough2;
                        if (vastClickThrough != null) {
                            Context context = this.this$0.getContext();
                            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
                            VastDataModelExtensionsKt.openUrl(vastClickThrough, context, this.this$0.getController$mobilefuse_video_player_release().getEventTracker(), null);
                        }
                        PlaybackListener playbackListener = this.this$0.getPlaybackListener$mobilefuse_video_player_release();
                        if (playbackListener != null) {
                            playbackListener.onClicked();
                        }
                    }
                    catch (Throwable e$iv$iv) {
                        switch (VideoPlayer$showEndCard$1$endCardPresenter$1$onClicked$$inlined$handleExceptions$1$wm$TryKt$WhenMappings.$EnumSwitchMapping$0[strategy$iv$iv.ordinal()]) {
                            case 1: {
                                void source$iv$iv;
                                StabilityHelper.logException((Object)source$iv$iv, (Throwable)e$iv$iv);
                                break;
                            }
                            case 2: {
                                break;
                            }
                            default: {
                                throw new NoWhenBranchMatchedException();
                            }
                        }
                    }
                }

                /*
                 * WARNING - void declaration
                 */
                public void onError(@NotNull VastError error) {
                    Intrinsics.checkNotNullParameter((Object)((Object)error), (String)"error");
                    boolean $i$f$handleExceptions = false;
                    String string = "[Automatically caught]";
                    ExceptionHandlingStrategy strategy$iv$iv = ExceptionHandlingStrategy.LogAndIgnore;
                    boolean $i$f$handleExceptions2 = false;
                    try {
                        boolean bl = false;
                        this.this$0.getController$mobilefuse_video_player_release().sendErrorEvent(error);
                        VideoPlayer.access$onEndCardError(this.this$0);
                    }
                    catch (Throwable e$iv$iv) {
                        switch (VideoPlayer$showEndCard$1$endCardPresenter$1$onError$$inlined$handleExceptions$1$wm$TryKt$WhenMappings.$EnumSwitchMapping$0[strategy$iv$iv.ordinal()]) {
                            case 1: {
                                void source$iv$iv;
                                StabilityHelper.logException((Object)source$iv$iv, (Throwable)e$iv$iv);
                                break;
                            }
                            case 2: {
                                break;
                            }
                            default: {
                                throw new NoWhenBranchMatchedException();
                            }
                        }
                    }
                }

                public void onTrackingEvent(@NotNull VastCompanion companion, @NotNull VastTrackingEventType eventType) {
                    Intrinsics.checkNotNullParameter((Object)companion, (String)"companion");
                    Intrinsics.checkNotNullParameter((Object)((Object)eventType), (String)"eventType");
                    this.this$0.getController$mobilefuse_video_player_release().sendCompanionAdTrackingEvent(companion, eventType);
                }
            };
            boolean bl2 = this.getFullscreen();
            List<VastCompanion> list = companions;
            EndCardScheduler endCardScheduler = this.endCardScheduler;
            FrameLayout frameLayout = this.mainContainer;
            Activity activity = this.renderingActivity;
            Context context3 = context2;
            Object it = object = new EndCardPresenter(frameLayout, context3, activity, endCardScheduler, list, bl2, (EndCardListener)object);
            boolean bl3 = false;
            this.endCardPresenter = it;
            Object endCardPresenter = object;
            boolean endCardRendering = ((EndCardPresenter)endCardPresenter).showNextEndCard(closeTrigger);
            if (!endCardRendering) {
                this.controller.sendErrorEvent(VastError.UNABLE_TO_DISPLAY_REQUIRED_COMPANION);
            }
            Unit unit2 = unit = Unit.INSTANCE;
            either = (Either)new SuccessResult((Object)unit2);
        }
        catch (Throwable e$iv$iv) {
            switch (VideoPlayer$showEndCard$$inlined$gracefullyHandleException$1$wm$TryKt$WhenMappings.$EnumSwitchMapping$1[strategy$iv$iv.ordinal()]) {
                case 1: {
                    void source$iv$iv;
                    StabilityHelper.logException((Object)source$iv$iv, (Throwable)e$iv$iv);
                }
            }
            either = (Either)new ErrorResult((Object)e$iv$iv);
        }
        Either $this$withErrorFallback$iv = either;
        boolean $i$f$withErrorFallback = false;
        Either either2 = $this$withErrorFallback$iv;
        if (either2 instanceof ErrorResult) {
            Throwable it = (Throwable)((ErrorResult)$this$withErrorFallback$iv).getValue();
            boolean bl = false;
            this.onEndCardError();
        } else if (either2 instanceof SuccessResult) {
            ((SuccessResult)$this$withErrorFallback$iv).getValue();
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    private final void sendTrackingEvent(VastTrackingEventType eventType) {
        this.controller.sendTrackingEvent(eventType);
    }

    public final boolean isPlaying() {
        return this.playerState == PlayerState.PLAYING;
    }

    public final long getCurrentPlaybackPositionMillis() {
        try {
            if (this.playerState != PlayerState.PLAYING && this.playerState != PlayerState.PAUSED) {
                return -1L;
            }
            return this.player.getCurrentPosition();
        }
        catch (Throwable e) {
            StabilityHelper.logException((Object)this, (Throwable)e);
            return -1L;
        }
    }

    @Nullable
    public final int[] getSizeInPixels() {
        if (!this.player.isDestroyed()) {
            return new int[]{this.player.getWidth(), this.player.getHeight()};
        }
        return null;
    }

    @Nullable
    public final int[] getSizeInDp() {
        int[] nArray = this.getSizeInPixels();
        if (nArray == null) {
            return null;
        }
        int[] size = nArray;
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        MediaUtilsKt.convertFromPixelsToDp(context, size);
        return size;
    }

    @Nullable
    public final Point getCurrentMediaFileSizeDp() {
        VastMediaFile vastMediaFile = this.currentMediaFile;
        if (vastMediaFile == null) {
            return null;
        }
        VastMediaFile mediaFile = vastMediaFile;
        Integer n = mediaFile.getWidth();
        if (n == null) {
            return null;
        }
        int width = n;
        Integer n2 = mediaFile.getHeight();
        if (n2 == null) {
            return null;
        }
        int height = n2;
        return new Point(width, height);
    }

    /*
     * WARNING - void declaration
     */
    private final void onAdCompleted() {
        boolean $i$f$handleExceptions = false;
        String string = "[Automatically caught]";
        ExceptionHandlingStrategy strategy$iv$iv = ExceptionHandlingStrategy.LogAndIgnore;
        boolean $i$f$handleExceptions2 = false;
        try {
            boolean bl = false;
            this.fullscreenController.executeFullscreenExit$mobilefuse_video_player_release();
            PlaybackListener playbackListener = this.playbackListener;
            if (playbackListener != null) {
                playbackListener.onAdCompleted();
            }
        }
        catch (Throwable e$iv$iv) {
            switch (VideoPlayer$onAdCompleted$$inlined$handleExceptions$1$wm$TryKt$WhenMappings.$EnumSwitchMapping$0[strategy$iv$iv.ordinal()]) {
                case 1: {
                    void source$iv$iv;
                    StabilityHelper.logException((Object)source$iv$iv, (Throwable)e$iv$iv);
                    break;
                }
                case 2: {
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
    }

    public final boolean isDestroyed$mobilefuse_video_player_release() {
        return this.playerState == PlayerState.DESTROYED;
    }

    public final void destroy() {
        try {
            if (this.isDestroyed$mobilefuse_video_player_release()) {
                return;
            }
            this.changePlayerState(PlayerState.DESTROYED);
            this.destroyVideoPlayer();
            this.destroyEndCard();
            this.setFullscreenChangedListener(null);
            this.controller.destroy();
            this.renderingActivity = null;
        }
        catch (Throwable e) {
            StabilityHelper.logException((Object)this, (Throwable)e);
        }
    }

    private final void removePlayerUi() {
        try {
            this.stopVideoTimer();
            WebView webView = this.webView;
            if (webView != null) {
                WebView webView2;
                WebView it = webView2 = webView;
                boolean bl = false;
                if (it.getParent() != null) {
                    ViewParent viewParent = it.getParent();
                    if (viewParent == null) {
                        throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup");
                    }
                    ((ViewGroup)viewParent).removeView((View)this.webView);
                }
                it.stopLoading();
                it.destroy();
                this.webView = null;
            }
        }
        catch (Throwable e) {
            StabilityHelper.logException((Object)this, (Throwable)e);
        }
    }

    private final void destroyVideoPlayer() {
        try {
            Set<VideoPlayer> vastPlayersForMediaFile;
            String mediaFileUrl;
            this.setMuteChangedListener(null);
            this.removePlayerUi();
            this.player.destroy();
            ViewParent viewParent = this.player.getParent();
            if (viewParent != null) {
                ViewParent viewParent2;
                ViewParent it = viewParent2 = viewParent;
                boolean bl = false;
                ViewParent viewParent3 = it;
                if (viewParent3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup");
                }
                ((ViewGroup)viewParent3).removeView((View)this.player);
            }
            VastMediaFile vastMediaFile = this.currentMediaFile;
            String string = mediaFileUrl = vastMediaFile != null ? vastMediaFile.getOriginalUrl() : null;
            if (mediaFileUrl != null && (vastPlayersForMediaFile = MEDIA_FILES_IN_USE.get(mediaFileUrl)) != null) {
                vastPlayersForMediaFile.remove(this);
                if (vastPlayersForMediaFile.isEmpty()) {
                    MEDIA_FILES_IN_USE.remove(mediaFileUrl);
                    DiskCacheUtil.deleteFile(mediaFileUrl);
                }
            }
            this.currentMediaFile = null;
        }
        catch (Throwable e) {
            StabilityHelper.logException((Object)this, (Throwable)e);
        }
    }

    private final void destroyEndCard() {
        try {
            EndCardPresenter endCardPresenter = this.endCardPresenter;
            if (endCardPresenter != null) {
                endCardPresenter.destroy();
            }
            this.endCardPresenter = null;
        }
        catch (Throwable e) {
            StabilityHelper.logException((Object)this, (Throwable)e);
        }
    }

    public final void resume() {
        try {
            if (!this.player.getCanPlay()) {
                return;
            }
            if (!Utils.isAttachedToWindow((View)((View)this))) {
                return;
            }
            this.player.play();
            this.startVideoTimer();
        }
        catch (Throwable e) {
            StabilityHelper.logException((Object)this, (Throwable)e);
        }
    }

    public final void pause() {
        try {
            if (!this.player.getCanPause()) {
                return;
            }
            this.player.pause();
            this.pausedVideoPosition = this.player.getCurrentPosition();
            this.stopVideoTimer();
        }
        catch (Exception e) {
            StabilityHelper.logException((Object)this, (Throwable)e);
        }
    }

    public final void onActivityResume() {
        this.resume();
    }

    public final void onActivityPause() {
        this.pause();
    }

    private VideoPlayer(Context context, AttributeSet attrs, int defStyleAttr, boolean primary, FullscreenControllerImpl fullscreenController, MuteControllerImpl muteController) {
        super(context, attrs, defStyleAttr);
        this.fullscreenController = fullscreenController;
        this.muteController = muteController;
        this.playerHandler = new Handler(Looper.getMainLooper());
        this.layoutWidth = -1;
        this.layoutHeight = -1;
        this.player = new MobileFusePlayer(context);
        this.playbackController = new PlaybackController();
        this.mainContainer = new FrameLayout(context);
        this.mainContainerParams = new ViewGroup.LayoutParams(-1, -1);
        this.playbackDurationMillis = -1L;
        this.controller = new VideoPlayerController(context, this);
        this.playerState = PlayerState.IDLE;
        this.playerCapabilities = new VideoPlayerCapabilities();
        this.adAutoplay = AdAutoplay.UNMUTED_AUTOPLAY;
        this.forceSkipSeconds = -1.0f;
        this.blockSkipSeconds = -1.0f;
        this.maxEndCardsToShow = 1;
        this.endCardScheduler = new BaseEndCardScheduler();
        this.clickthroughBehaviour = ClickthroughBehaviour.CTA_AND_VIDEO;
        this.playbackController.initialize(this);
        this.muteController.initialize(this);
        this.fullscreenController.initialize(this);
        this.addPlayerInstance();
    }

    /* synthetic */ VideoPlayer(Context context, AttributeSet attributeSet, int n, boolean bl, FullscreenControllerImpl fullscreenControllerImpl, MuteControllerImpl muteControllerImpl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x10) != 0) {
            fullscreenControllerImpl = new FullscreenControllerImpl();
        }
        if ((n2 & 0x20) != 0) {
            muteControllerImpl = new MuteControllerImpl();
        }
        this(context, attributeSet, n, bl, fullscreenControllerImpl, muteControllerImpl);
    }

    public VideoPlayer(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, true, null, null, 48, null);
    }

    public VideoPlayer(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, true, null, null, 48, null);
    }

    public VideoPlayer(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, defStyleAttr, true, null, null, 48, null);
    }

    static {
        Companion = new Companion(null);
        MEDIA_FILES_IN_USE = new LinkedHashMap();
    }

    @Override
    public boolean getEnterFullscreenOnVideoTap() {
        return this.fullscreenController.getEnterFullscreenOnVideoTap();
    }

    @Override
    public void setEnterFullscreenOnVideoTap(boolean bl) {
        this.fullscreenController.setEnterFullscreenOnVideoTap(bl);
    }

    @Override
    public boolean getFullscreen() {
        return this.fullscreenController.getFullscreen();
    }

    @Override
    public boolean getFullscreenAllowed() {
        return this.fullscreenController.getFullscreenAllowed();
    }

    @Override
    @Nullable
    public FullscreenChangedListener getFullscreenChangedListener() {
        return this.fullscreenController.getFullscreenChangedListener();
    }

    @Override
    public void setFullscreenChangedListener(@Nullable FullscreenChangedListener fullscreenChangedListener) {
        this.fullscreenController.setFullscreenChangedListener(fullscreenChangedListener);
    }

    @Override
    public void enableExternalFullscreenControl(@NotNull ExternalFullscreenControlBridge bridge) {
        Intrinsics.checkNotNullParameter((Object)bridge, (String)"bridge");
        this.fullscreenController.enableExternalFullscreenControl(bridge);
    }

    @Override
    public void setFullscreen(boolean fullscreen) {
        this.fullscreenController.setFullscreen(fullscreen);
    }

    @Override
    public void setFullscreenAllowed() {
        this.fullscreenController.setFullscreenAllowed();
    }

    @Override
    public boolean isMuteAllowed() {
        return this.muteController.isMuteAllowed();
    }

    @Override
    @Nullable
    public MuteChangedListener getMuteChangedListener() {
        return this.muteController.getMuteChangedListener();
    }

    @Override
    public void setMuteChangedListener(@Nullable MuteChangedListener muteChangedListener) {
        this.muteController.setMuteChangedListener(muteChangedListener);
    }

    @Override
    public boolean isMuted() {
        return this.muteController.isMuted();
    }

    @Override
    public void setMuteAllowed() {
        this.muteController.setMuteAllowed();
    }

    @Override
    public void setMuted(boolean muted) {
        this.muteController.setMuted(muted);
    }

    public static final /* synthetic */ void access$changePlayerState(VideoPlayer $this, PlayerState newPlayerState) {
        $this.changePlayerState(newPlayerState);
    }

    public static final /* synthetic */ void access$onVideoCompleted(VideoPlayer $this, ViewCloseTrigger closeTrigger) {
        $this.onVideoCompleted(closeTrigger);
    }

    public static final /* synthetic */ void access$onVastDataLoaded(VideoPlayer $this, boolean success, VastError error) {
        $this.onVastDataLoaded(success, error);
    }

    public static final /* synthetic */ void access$onMediaFileSelected(VideoPlayer $this, VastMediaFile mediaFile) {
        $this.onMediaFileSelected(mediaFile);
    }

    public static final /* synthetic */ void access$onVideoFileCached(VideoPlayer $this) {
        $this.onVideoFileCached();
    }

    public static final /* synthetic */ LoadListener access$getLoadListener$p(VideoPlayer $this) {
        return $this.loadListener;
    }

    public static final /* synthetic */ void access$setLoadListener$p(VideoPlayer $this, LoadListener loadListener) {
        $this.loadListener = loadListener;
    }

    public static final /* synthetic */ void access$handleVastBridgeCall(VideoPlayer $this, Uri callUri) {
        $this.handleVastBridgeCall(callUri);
    }

    public static final /* synthetic */ void access$onVideoError(VideoPlayer $this) {
        $this.onVideoError();
    }

    public static final /* synthetic */ void access$onPrepared(VideoPlayer $this) {
        $this.onPrepared();
    }

    public static final /* synthetic */ void access$onAdCompleted(VideoPlayer $this) {
        $this.onAdCompleted();
    }

    public static final /* synthetic */ void access$onEndCardError(VideoPlayer $this) {
        $this.onEndCardError();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0012\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H&J\b\u0010\u0006\u001a\u00020\u0003H&\u00a8\u0006\u0007"}, d2={"Lcom/mobilefuse/videoplayer/VideoPlayer$LoadListener;", "", "onError", "", "error", "Lcom/mobilefuse/videoplayer/model/VastError;", "onVideoLoaded", "mobilefuse-video-player_release"})
    public static interface LoadListener {
        public void onVideoLoaded();

        public void onError(@Nullable VastError var1);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\r\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\u0005\u001a\u00020\u0004H\u0016J\b\u0010\u0006\u001a\u00020\u0004H\u0016J\b\u0010\u0007\u001a\u00020\u0004H\u0016J\b\u0010\b\u001a\u00020\u0004H\u0016J\b\u0010\t\u001a\u00020\u0004H\u0016J\b\u0010\n\u001a\u00020\u0004H\u0016J\b\u0010\u000b\u001a\u00020\u0004H\u0016J\b\u0010\f\u001a\u00020\u0004H\u0016J\b\u0010\r\u001a\u00020\u0004H\u0016J\b\u0010\u000e\u001a\u00020\u0004H\u0016J\b\u0010\u000f\u001a\u00020\u0004H\u0016J\b\u0010\u0010\u001a\u00020\u0004H\u0016\u00a8\u0006\u0011"}, d2={"Lcom/mobilefuse/videoplayer/VideoPlayer$PlaybackListener;", "", "()V", "onAdCompleted", "", "onAdImpression", "onClicked", "onEndCardError", "onVideoCompleted", "onVideoError", "onVideoFirstQuartile", "onVideoMidpoint", "onVideoPaused", "onVideoPlaying", "onVideoSkipped", "onVideoStarted", "onVideoThirdQuartile", "mobilefuse-video-player_release"})
    public static class PlaybackListener {
        public void onVideoStarted() {
        }

        public void onVideoPlaying() {
        }

        public void onVideoPaused() {
        }

        public void onVideoCompleted() {
        }

        public void onAdImpression() {
        }

        public void onAdCompleted() {
        }

        public void onVideoFirstQuartile() {
        }

        public void onVideoMidpoint() {
        }

        public void onVideoThirdQuartile() {
        }

        public void onVideoError() {
        }

        public void onVideoSkipped() {
        }

        public void onClicked() {
        }

        public void onEndCardError() {
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u000b\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lcom/mobilefuse/videoplayer/VideoPlayer$PlayerState;", "", "(Ljava/lang/String;I)V", "IDLE", "VIDEO_LOADING", "VIDEO_CACHED", "INITIALIZING", "PLAYING", "PAUSED", "END_CARD", "ERROR", "DESTROYED", "mobilefuse-video-player_release"})
    public static final class PlayerState
    extends Enum<PlayerState> {
        public static final /* enum */ PlayerState IDLE;
        public static final /* enum */ PlayerState VIDEO_LOADING;
        public static final /* enum */ PlayerState VIDEO_CACHED;
        public static final /* enum */ PlayerState INITIALIZING;
        public static final /* enum */ PlayerState PLAYING;
        public static final /* enum */ PlayerState PAUSED;
        public static final /* enum */ PlayerState END_CARD;
        public static final /* enum */ PlayerState ERROR;
        public static final /* enum */ PlayerState DESTROYED;
        private static final /* synthetic */ PlayerState[] $VALUES;

        static {
            PlayerState[] playerStateArray = new PlayerState[9];
            PlayerState[] playerStateArray2 = playerStateArray;
            playerStateArray[0] = IDLE = new PlayerState();
            playerStateArray[1] = VIDEO_LOADING = new PlayerState();
            playerStateArray[2] = VIDEO_CACHED = new PlayerState();
            playerStateArray[3] = INITIALIZING = new PlayerState();
            playerStateArray[4] = PLAYING = new PlayerState();
            playerStateArray[5] = PAUSED = new PlayerState();
            playerStateArray[6] = END_CARD = new PlayerState();
            playerStateArray[7] = ERROR = new PlayerState();
            playerStateArray[8] = DESTROYED = new PlayerState();
            $VALUES = playerStateArray;
        }

        public static PlayerState[] values() {
            return (PlayerState[])$VALUES.clone();
        }

        public static PlayerState valueOf(String string) {
            return Enum.valueOf(PlayerState.class, string);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R \u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/mobilefuse/videoplayer/VideoPlayer$Companion;", "", "()V", "MEDIA_FILES_IN_USE", "", "", "", "Lcom/mobilefuse/videoplayer/VideoPlayer;", "mobilefuse-video-player_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

