/*
 * Decompiled with CFR 0.152.
 */
package com.mobilefuse.videoplayer.controller;

import com.mobilefuse.sdk.MuteChangedListener;
import com.mobilefuse.sdk.StabilityHelper;
import com.mobilefuse.videoplayer.VideoPlayer;
import com.mobilefuse.videoplayer.controller.BaseModuleController;
import com.mobilefuse.videoplayer.controller.MuteController;
import com.mobilefuse.videoplayer.model.VastPlayerCapability;
import kotlin.Metadata;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0010\u001a\u00020\u0011H\u0002J\r\u0010\u0012\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b\u0013J\b\u0010\u0014\u001a\u00020\u0005H\u0016J\b\u0010\u0015\u001a\u00020\u0011H\u0016J\u000e\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0005J\u0010\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u0005H\u0016R\u001e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001e\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0007\u00a8\u0006\u0019"}, d2={"Lcom/mobilefuse/videoplayer/controller/MuteControllerImpl;", "Lcom/mobilefuse/videoplayer/controller/BaseModuleController;", "Lcom/mobilefuse/videoplayer/controller/MuteController;", "()V", "<set-?>", "", "isMuteAllowed", "()Z", "muteChangedListener", "Lcom/mobilefuse/sdk/MuteChangedListener;", "getMuteChangedListener", "()Lcom/mobilefuse/sdk/MuteChangedListener;", "setMuteChangedListener", "(Lcom/mobilefuse/sdk/MuteChangedListener;)V", "muted", "getMuted", "applyMuteToPlayer", "", "enableMuteButton", "enableMuteButton$mobilefuse_video_player_release", "isMuted", "setMuteAllowed", "setMuteFromWebView", "mutedValue", "setMuted", "mobilefuse-video-player_release"})
public final class MuteControllerImpl
extends BaseModuleController
implements MuteController {
    private boolean isMuteAllowed;
    private boolean muted;
    @Nullable
    private MuteChangedListener muteChangedListener;

    @Override
    public boolean isMuteAllowed() {
        return this.isMuteAllowed;
    }

    public final boolean getMuted() {
        return this.muted;
    }

    @Override
    @Nullable
    public MuteChangedListener getMuteChangedListener() {
        return this.muteChangedListener;
    }

    @Override
    public void setMuteChangedListener(@Nullable MuteChangedListener muteChangedListener) {
        this.muteChangedListener = muteChangedListener;
    }

    @Override
    public void setMuteAllowed() {
        if (this.getVideoPlayer().isDestroyed$mobilefuse_video_player_release()) {
            return;
        }
        try {
            this.isMuteAllowed = true;
            this.getVideoPlayer().getPlayerCapabilities().changeCapability(VastPlayerCapability.MUTE, true);
            if (this.getPlayerState() == VideoPlayer.PlayerState.PLAYING || this.getPlayerState() == VideoPlayer.PlayerState.PAUSED) {
                this.enableMuteButton$mobilefuse_video_player_release();
            }
        }
        catch (Throwable e) {
            StabilityHelper.logException((Object)this, (Throwable)e);
        }
    }

    public final void setMuteFromWebView(boolean mutedValue) {
        this.muted = mutedValue;
        this.applyMuteToPlayer();
    }

    public final void enableMuteButton$mobilefuse_video_player_release() {
        if (this.getVideoPlayer().isDestroyed$mobilefuse_video_player_release()) {
            return;
        }
        try {
            if (!this.isMuteAllowed()) {
                return;
            }
            this.callJsBridgeCmd("vast.bridge.setMuteAllowed();");
            this.setMuted(this.muted);
        }
        catch (Throwable e) {
            StabilityHelper.logException((Object)this, (Throwable)e);
        }
    }

    @Override
    public void setMuted(boolean muted) {
        if (this.getVideoPlayer().isDestroyed$mobilefuse_video_player_release()) {
            return;
        }
        try {
            if (this.muted != muted) {
                this.muted = muted;
                if (this.getVideoPlayer().getCurrentPlaybackPositionMillis() > 0L && (this.getPlayerState() == VideoPlayer.PlayerState.PLAYING || this.getPlayerState() == VideoPlayer.PlayerState.PAUSED)) {
                    this.getVideoPlayer().getController$mobilefuse_video_player_release().onMuteChanged();
                }
            }
            this.callJsBridgeCmd("vast.bridge.setMuted(" + muted + ");");
            this.applyMuteToPlayer();
        }
        catch (Throwable e) {
            StabilityHelper.logException((Object)this, (Throwable)e);
        }
    }

    @Override
    public boolean isMuted() {
        return this.muted;
    }

    private final void applyMuteToPlayer() {
        if (this.getVideoPlayer().isDestroyed$mobilefuse_video_player_release()) {
            return;
        }
        try {
            this.getVideoPlayer().getPlayer$mobilefuse_video_player_release().setVolume(this.muted ? 0.0f : 1.0f);
        }
        catch (Throwable e) {
            StabilityHelper.logException((Object)this, (Throwable)e);
        }
    }
}

