/*
 * Decompiled with CFR 0.152.
 */
package com.mobilefuse.videoplayer.media;

import android.annotation.SuppressLint;
import android.content.Context;
import android.media.MediaPlayer;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import com.mobilefuse.sdk.StabilityHelper;
import com.mobilefuse.videoplayer.media.VideoViewInterface;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\b\u0007\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0014J(\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0011H\u0016J\u0010\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\fH\u0016J\u0010\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\fH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/mobilefuse/videoplayer/media/MobileFuseVideoSurfaceView;", "Landroid/view/SurfaceView;", "Landroid/view/SurfaceHolder$Callback;", "Lcom/mobilefuse/videoplayer/media/VideoViewInterface;", "context", "Landroid/content/Context;", "mediaPlayer", "Landroid/media/MediaPlayer;", "(Landroid/content/Context;Landroid/media/MediaPlayer;)V", "surface", "Landroid/view/Surface;", "surfaceHolder", "Landroid/view/SurfaceHolder;", "destroy", "", "onMeasure", "widthMeasureSpec", "", "heightMeasureSpec", "surfaceChanged", "holder", "format", "width", "height", "surfaceCreated", "surfaceDestroyed", "mobilefuse-video-player_release"})
@SuppressLint(value={"ViewConstructor"})
public final class MobileFuseVideoSurfaceView
extends SurfaceView
implements SurfaceHolder.Callback,
VideoViewInterface {
    private final SurfaceHolder surfaceHolder;
    private Surface surface;
    private final MediaPlayer mediaPlayer;

    public void surfaceCreated(@NotNull SurfaceHolder holder) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        this.surface = holder.getSurface();
        this.mediaPlayer.setDisplay(holder);
    }

    public void surfaceChanged(@NotNull SurfaceHolder holder, int format, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        this.mediaPlayer.setDisplay(holder);
    }

    public void surfaceDestroyed(@NotNull SurfaceHolder holder) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        this.surface = null;
        this.mediaPlayer.setDisplay(null);
    }

    @Override
    public void destroy() {
        try {
            this.surfaceHolder.removeCallback((SurfaceHolder.Callback)this);
        }
        catch (Exception e) {
            StabilityHelper.logException((Object)this, (Throwable)e);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        try {
            int videoWidth = this.mediaPlayer.getVideoWidth();
            int videoHeight = this.mediaPlayer.getVideoHeight();
            int width = 0;
            int height = 0;
            if (videoWidth == 0 || videoHeight == 0) {
                width = SurfaceView.getDefaultSize((int)videoWidth, (int)widthMeasureSpec);
                height = SurfaceView.getDefaultSize((int)videoHeight, (int)heightMeasureSpec);
                this.setMeasuredDimension(width, height);
                return;
            }
            int widthSpecMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
            int widthSpecSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
            int heightSpecMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
            int heightSpecSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
            if (widthSpecMode == 0x40000000 && heightSpecMode == 0x40000000) {
                height = heightSpecSize;
                width = widthSpecSize;
                if (videoWidth * height < width * videoHeight) {
                    width = height * videoWidth / videoHeight;
                } else if (videoWidth * height > width * videoHeight) {
                    height = width * videoHeight / videoWidth;
                }
            } else if (widthSpecMode == 0x40000000) {
                width = widthSpecSize;
                height = width * videoHeight / videoWidth;
                if (heightSpecMode == Integer.MIN_VALUE && height > heightSpecSize) {
                    height = heightSpecSize | 0x1000000;
                }
            } else if (heightSpecMode == 0x40000000) {
                height = heightSpecSize;
                width = height * videoWidth / videoHeight;
                if (widthSpecMode == Integer.MIN_VALUE && width > widthSpecSize) {
                    width = widthSpecSize | 0x1000000;
                }
            } else {
                width = videoWidth;
                height = videoHeight;
                if (heightSpecMode == Integer.MIN_VALUE && height > heightSpecSize) {
                    height = heightSpecSize;
                    width = height * videoWidth / videoHeight;
                }
                if (widthSpecMode == Integer.MIN_VALUE && width > widthSpecSize) {
                    width = widthSpecSize;
                    height = width * videoHeight / videoWidth;
                }
            }
            this.setMeasuredDimension(width, height);
        }
        catch (Exception e) {
            StabilityHelper.logException((Object)this, (Throwable)e);
        }
    }

    public MobileFuseVideoSurfaceView(@NotNull Context context, @NotNull MediaPlayer mediaPlayer) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)mediaPlayer, (String)"mediaPlayer");
        super(context);
        this.mediaPlayer = mediaPlayer;
        SurfaceHolder surfaceHolder = this.getHolder();
        Intrinsics.checkNotNullExpressionValue((Object)surfaceHolder, (String)"holder");
        this.surfaceHolder = surfaceHolder;
        this.setZOrderMediaOverlay(true);
        this.surfaceHolder.addCallback((SurfaceHolder.Callback)this);
    }
}

