/*
 * Decompiled with CFR 0.152.
 */
package com.mobilefuse.videoplayer.model;

import android.content.Context;
import com.mobilefuse.sdk.StabilityHelper;
import com.mobilefuse.sdk.exception.Either;
import com.mobilefuse.sdk.exception.ErrorResult;
import com.mobilefuse.sdk.exception.SuccessResult;
import com.mobilefuse.sdk.logging.HttpRequestTracker;
import com.mobilefuse.sdk.network.client.HttpClient;
import com.mobilefuse.sdk.network.client.HttpClientKt;
import com.mobilefuse.sdk.network.client.HttpFlowKt;
import com.mobilefuse.sdk.network.client.HttpResponse;
import com.mobilefuse.sdk.rx.Flow;
import com.mobilefuse.sdk.rx.FlowCollector;
import com.mobilefuse.sdk.rx.FlowKt;
import com.mobilefuse.videoplayer.model.EventType;
import com.mobilefuse.videoplayer.model.VastAd;
import com.mobilefuse.videoplayer.model.VastAdContent;
import com.mobilefuse.videoplayer.model.VastBaseResource;
import com.mobilefuse.videoplayer.model.VastBaseVerificationResource;
import com.mobilefuse.videoplayer.model.VastClickThrough;
import com.mobilefuse.videoplayer.model.VastCompanion;
import com.mobilefuse.videoplayer.model.VastCreative;
import com.mobilefuse.videoplayer.model.VastDataModelExtensionsKt;
import com.mobilefuse.videoplayer.model.VastDataModelFromXmlKt;
import com.mobilefuse.videoplayer.model.VastError;
import com.mobilefuse.videoplayer.model.VastEvent;
import com.mobilefuse.videoplayer.model.VastIcon;
import com.mobilefuse.videoplayer.model.VastInline;
import com.mobilefuse.videoplayer.model.VastJavaScriptResource;
import com.mobilefuse.videoplayer.model.VastLinear;
import com.mobilefuse.videoplayer.model.VastMediaFile;
import com.mobilefuse.videoplayer.model.VastModel;
import com.mobilefuse.videoplayer.model.VastTag;
import com.mobilefuse.videoplayer.model.VastTime;
import com.mobilefuse.videoplayer.model.VastUniversalAdId;
import com.mobilefuse.videoplayer.model.VastVerification;
import com.mobilefuse.videoplayer.model.VastWrapper;
import com.mobilefuse.videoplayer.model.VastXmlParser;
import com.mobilefuse.videoplayer.model.utils.XmlParsingExtensionsKt;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000\u00bc\u0001\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a.\u0010\u0007\u001a\u00020\u00012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0004H\u0002\u001a\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0004H\u0002\u001a\u007f\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00170\u00192S\u0010\u001a\u001aO\u0012\u0013\u0012\u00110\u001c\u00a2\u0006\f\b\u001d\u0012\b\b\u001e\u0012\u0004\b\b(\u001f\u0012\u0015\u0012\u0013\u0018\u00010 \u00a2\u0006\f\b\u001d\u0012\b\b\u001e\u0012\u0004\b\b(!\u0012\u0015\u0012\u0013\u0018\u00010\"\u00a2\u0006\f\b\u001d\u0012\b\b\u001e\u0012\u0004\b\b(#\u0012\u0004\u0012\u00020\u00130\u001bj\u0002`$\u001aL\u0010%\u001a\u00020\u00132\u0006\u0010&\u001a\u00020\u00172:\u0010'\u001a6\u0012\u0015\u0012\u0013\u0018\u00010)\u00a2\u0006\f\b\u001d\u0012\b\b\u001e\u0012\u0004\b\b(*\u0012\u0015\u0012\u0013\u0018\u00010\"\u00a2\u0006\f\b\u001d\u0012\b\b\u001e\u0012\u0004\b\b(#\u0012\u0004\u0012\u00020\u00130(H\u0002\u001aL\u0010+\u001a\u00020\u00132\u0006\u0010,\u001a\u00020\u00172:\u0010'\u001a6\u0012\u0015\u0012\u0013\u0018\u00010\u0017\u00a2\u0006\f\b\u001d\u0012\b\b\u001e\u0012\u0004\b\b(\u0016\u0012\u0015\u0012\u0013\u0018\u00010\"\u00a2\u0006\f\b\u001d\u0012\b\b\u001e\u0012\u0004\b\b(#\u0012\u0004\u0012\u00020\u00130(H\u0002\u001a\u001e\u0010-\u001a\b\u0012\u0004\u0012\u00020/0.2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0004H\u0002\u001a\u001a\u00100\u001a\u0004\u0018\u0001012\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0004H\u0002\u001a&\u00102\u001a\u00020\u00132\f\u00103\u001a\b\u0012\u0004\u0012\u000205042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0004H\u0002\u001a\u001e\u00106\u001a\b\u0012\u0004\u0012\u0002070.2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0004H\u0002\u001a\u001e\u00108\u001a\b\u0012\u0004\u0012\u0002090.2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0004H\u0002\u001a\u001e\u0010:\u001a\b\u0012\u0004\u0012\u00020;0.2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0004H\u0002\u001a\u001e\u0010<\u001a\b\u0012\u0004\u0012\u00020=0.2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0004H\u0002\u001a\u001a\u0010>\u001a\u0004\u0018\u00010?2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0004H\u0002\u001a\u0085\u0001\u0010@\u001a\u00020\u0013*\u00020A2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00170\u00192S\u0010\u001a\u001aO\u0012\u0013\u0012\u00110\u001c\u00a2\u0006\f\b\u001d\u0012\b\b\u001e\u0012\u0004\b\b(\u001f\u0012\u0015\u0012\u0013\u0018\u00010 \u00a2\u0006\f\b\u001d\u0012\b\b\u001e\u0012\u0004\b\b(!\u0012\u0015\u0012\u0013\u0018\u00010\"\u00a2\u0006\f\b\u001d\u0012\b\b\u001e\u0012\u0004\b\b(#\u0012\u0004\u0012\u00020\u00130\u001bj\u0002`$H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0002\u001a\u0004\u0018\u00010\u0003*\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006*\u009c\u0001\u0010B\"K\u0012\u0013\u0012\u00110\u001c\u00a2\u0006\f\b\u001d\u0012\b\b\u001e\u0012\u0004\b\b(\u001f\u0012\u0015\u0012\u0013\u0018\u00010 \u00a2\u0006\f\b\u001d\u0012\b\b\u001e\u0012\u0004\b\b(!\u0012\u0015\u0012\u0013\u0018\u00010\"\u00a2\u0006\f\b\u001d\u0012\b\b\u001e\u0012\u0004\b\b(#\u0012\u0004\u0012\u00020\u00130\u001b2K\u0012\u0013\u0012\u00110\u001c\u00a2\u0006\f\b\u001d\u0012\b\b\u001e\u0012\u0004\b\b(\u001f\u0012\u0015\u0012\u0013\u0018\u00010 \u00a2\u0006\f\b\u001d\u0012\b\b\u001e\u0012\u0004\b\b(!\u0012\u0015\u0012\u0013\u0018\u00010\"\u00a2\u0006\f\b\u001d\u0012\b\b\u001e\u0012\u0004\b\b(#\u0012\u0004\u0012\u00020\u00130\u001b\u00a8\u0006C"}, d2={"VAST_MAX_REDIRECTS_COUNT", "", "vastClickThroughOrNull", "Lcom/mobilefuse/videoplayer/model/VastClickThrough;", "Lorg/w3c/dom/Node;", "getVastClickThroughOrNull", "(Lorg/w3c/dom/Node;)Lcom/mobilefuse/videoplayer/model/VastClickThrough;", "addVastEvents", "events", "", "Lcom/mobilefuse/videoplayer/model/VastEvent;", "eventType", "Lcom/mobilefuse/videoplayer/model/EventType;", "xpath", "Ljavax/xml/xpath/XPath;", "rootNode", "createVastAdFromXml", "Lcom/mobilefuse/videoplayer/model/VastAd;", "createVastModelFromXml", "", "context", "Landroid/content/Context;", "adm", "", "macroProcessorFn", "Lkotlin/Function1;", "loadListener", "Lkotlin/Function3;", "", "Lkotlin/ParameterName;", "name", "success", "Lcom/mobilefuse/videoplayer/model/VastModel;", "vatsModel", "Lcom/mobilefuse/videoplayer/model/VastError;", "error", "Lcom/mobilefuse/videoplayer/model/VastTagLoadListener;", "createVastTagFromXml", "xml", "completedAction", "Lkotlin/Function2;", "Lcom/mobilefuse/videoplayer/model/VastTag;", "vastTag", "loadWrapperVast", "url", "parseAdCompanions", "", "Lcom/mobilefuse/videoplayer/model/VastCompanion;", "parseAdLinear", "Lcom/mobilefuse/videoplayer/model/VastLinear;", "parseAdVerifications", "list", "", "Lcom/mobilefuse/videoplayer/model/VastVerification;", "parseCreatives", "Lcom/mobilefuse/videoplayer/model/VastCreative;", "parseIcons", "Lcom/mobilefuse/videoplayer/model/VastIcon;", "parseMediaFiles", "Lcom/mobilefuse/videoplayer/model/VastMediaFile;", "parseUniversalAdIdList", "Lcom/mobilefuse/videoplayer/model/VastUniversalAdId;", "parseVastResource", "Lcom/mobilefuse/videoplayer/model/VastBaseResource;", "parseVastXml", "Lcom/mobilefuse/videoplayer/model/VastXmlParser;", "VastTagLoadListener", "mobilefuse-video-player_release"})
public final class VastDataModelFromXmlKt {
    public static final int VAST_MAX_REDIRECTS_COUNT = 10;

    public static final void createVastModelFromXml(@NotNull Context context, @NotNull String adm, @NotNull Function1<? super String, String> macroProcessorFn, @NotNull Function3<? super Boolean, ? super VastModel, ? super VastError, Unit> loadListener) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)adm, (String)"adm");
        Intrinsics.checkNotNullParameter(macroProcessorFn, (String)"macroProcessorFn");
        Intrinsics.checkNotNullParameter(loadListener, (String)"loadListener");
        VastXmlParser parser = new VastXmlParser();
        VastDataModelFromXmlKt.parseVastXml(parser, context, adm, macroProcessorFn, loadListener);
    }

    private static final void parseVastXml(VastXmlParser $this$parseVastXml, Context context, String adm, Function1<? super String, String> macroProcessorFn, Function3<? super Boolean, ? super VastModel, ? super VastError, Unit> loadListener) {
        VastDataModelFromXmlKt.createVastTagFromXml(adm, (Function2<? super VastTag, ? super VastError, Unit>)((Function2)new Function2<VastTag, VastError, Unit>($this$parseVastXml, macroProcessorFn, loadListener, context){
            final /* synthetic */ VastXmlParser $this_parseVastXml;
            final /* synthetic */ Function1 $macroProcessorFn;
            final /* synthetic */ Function3 $loadListener;
            final /* synthetic */ Context $context;

            public final void invoke(@Nullable VastTag vastTag, @Nullable VastError error) {
                if (vastTag != null) {
                    VastAdContent firstAdContent;
                    Collection collection = this.$this_parseVastXml.getVastTagChain();
                    collection.add(vastTag);
                    VastAd vastAd = VastDataModelExtensionsKt.getFirstAd(vastTag);
                    VastAdContent vastAdContent = firstAdContent = vastAd != null ? vastAd.getContent() : null;
                    if (firstAdContent instanceof VastWrapper) {
                        String wrapperUrl = ((VastWrapper)firstAdContent).getVastAdTagUri();
                        if (wrapperUrl != null && this.$this_parseVastXml.getVastTagChain().size() < 10) {
                            String resolvedWrapperUrl = (String)this.$macroProcessorFn.invoke((Object)wrapperUrl);
                            HttpRequestTracker.logHttpRequest((String)resolvedWrapperUrl);
                            VastDataModelFromXmlKt.access$loadWrapperVast(resolvedWrapperUrl, (Function2)new Function2<String, VastError, Unit>(this){
                                final /* synthetic */ parseVastXml.1 this$0;

                                public final void invoke(@Nullable String wrapperAdm, @Nullable VastError wrapperError) {
                                    if (wrapperError != null) {
                                        this.this$0.$loadListener.invoke((Object)false, null, (Object)((Object)VastError.URI_UNAVAILABLE_OR_TIMEOUT));
                                        return;
                                    }
                                    if (wrapperAdm == null) {
                                        this.this$0.$loadListener.invoke((Object)false, null, (Object)((Object)VastError.VAST_VALIDATION_FAILED));
                                        return;
                                    }
                                    VastDataModelFromXmlKt.access$parseVastXml(this.this$0.$this_parseVastXml, this.this$0.$context, wrapperAdm, this.this$0.$macroProcessorFn, this.this$0.$loadListener);
                                }
                                {
                                    this.this$0 = var1_1;
                                    super(2);
                                }
                            });
                        } else {
                            this.$loadListener.invoke((Object)false, null, (Object)((Object)VastError.WRAPPER_LIMIT_REACHED));
                        }
                    } else {
                        VastModel model = new VastModel(CollectionsKt.reversed((Iterable)this.$this_parseVastXml.getVastTagChain()));
                        if (VastDataModelExtensionsKt.getHasAdContentToPlay(model)) {
                            this.$loadListener.invoke((Object)true, (Object)model, null);
                        } else {
                            this.$loadListener.invoke((Object)false, (Object)model, (Object)((Object)VastError.NO_VAST_RESPONSE));
                        }
                    }
                } else {
                    Boolean bl = false;
                    VastError vastError = error;
                    if (vastError == null) {
                        vastError = VastError.XML_PARSING_FAILED;
                    }
                    this.$loadListener.invoke((Object)bl, null, (Object)((Object)vastError));
                }
            }
            {
                this.$this_parseVastXml = vastXmlParser;
                this.$macroProcessorFn = function1;
                this.$loadListener = function3;
                this.$context = context;
                super(2);
            }
        }));
    }

    private static final void createVastTagFromXml(String xml, Function2<? super VastTag, ? super VastError, Unit> completedAction) {
        Document document;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            Document document2 = factory.newDocumentBuilder().parse(new InputSource(new StringReader(xml)));
            Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"factory.newDocumentBuild\u2026ource(StringReader(xml)))");
            document = document2;
        }
        catch (Exception e) {
            e.printStackTrace();
            completedAction.invoke(null, (Object)VastError.XML_PARSING_FAILED);
            return;
        }
        Document doc = document;
        XPath xpath = XPathFactory.newInstance().newXPath();
        try {
            Set events = new LinkedHashSet();
            XPath xPath = xpath;
            Intrinsics.checkNotNullExpressionValue((Object)xPath, (String)"xpath");
            Node node = (Node)XmlParsingExtensionsKt.evaluateNodeOrNull(xPath, "/VAST", doc, (Function1)new Function1<Node, Node>(events, xpath){
                final /* synthetic */ Set $events;
                final /* synthetic */ XPath $xpath;

                @NotNull
                public final Node invoke(@NotNull Node it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    XPath xPath = this.$xpath;
                    Intrinsics.checkNotNullExpressionValue((Object)xPath, (String)"xpath");
                    VastDataModelFromXmlKt.access$addVastEvents(this.$events, EventType.Error, xPath, it);
                    return it;
                }
                {
                    this.$events = set;
                    this.$xpath = xPath;
                    super(1);
                }
            });
            if (node == null) {
                boolean bl = false;
                completedAction.invoke(null, (Object)VastError.XML_PARSING_FAILED);
                return;
            }
            Node rootNode2 = node;
            String vastVersion = XmlParsingExtensionsKt.getStringNodeAttribute("version", rootNode2);
            List adList = new ArrayList();
            if ((Unit)XmlParsingExtensionsKt.evaluateNodesOrNull(xpath, "/VAST/Ad", doc, (Function1)new Function1<NodeList, Unit>(xpath, adList){
                final /* synthetic */ XPath $xpath;
                final /* synthetic */ List $adList;

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull NodeList itNodes) {
                    Intrinsics.checkNotNullParameter((Object)itNodes, (String)"itNodes");
                    int n = 0;
                    int n2 = itNodes.getLength();
                    while (n < n2) {
                        void i;
                        if (itNodes.item((int)i) != null) {
                            Node node;
                            XPath xPath = this.$xpath;
                            Intrinsics.checkNotNullExpressionValue((Object)xPath, (String)"xpath");
                            VastAd ad = VastDataModelFromXmlKt.access$createVastAdFromXml(xPath, node);
                            if (ad != null) {
                                this.$adList.add(ad);
                            }
                        }
                        ++i;
                    }
                }
                {
                    this.$xpath = xPath;
                    this.$adList = list;
                    super(1);
                }
            }) == null) {
                boolean bl = false;
                completedAction.invoke(null, (Object)VastError.XML_PARSING_FAILED);
                return;
            }
            VastTag vastTag = new VastTag(vastVersion, events, adList);
            completedAction.invoke((Object)vastTag, null);
        }
        catch (Throwable e) {
            StabilityHelper.logException((Object)"createVastTagFromXml", (Throwable)e);
            completedAction.invoke(null, (Object)VastError.XML_PARSING_FAILED);
        }
    }

    private static final void loadWrapperVast(String url, Function2<? super String, ? super VastError, Unit> completedAction) {
        Flow $this$collectResult$iv = HttpFlowKt.requestHttpGet((Flow)FlowKt.flowSingle((Object)url), (long)10000L, (Map)MapsKt.emptyMap(), (boolean)false, (HttpClient)HttpClientKt.getDefaultHttpClient());
        boolean $i$f$collectResult = false;
        $this$collectResult$iv.collect(new FlowCollector(completedAction){
            final /* synthetic */ Function2 $completedAction$inlined;
            {
                this.$completedAction$inlined = function2;
            }

            public final void emit(@NotNull Either<? extends Throwable, ? extends T> result) {
                Intrinsics.checkNotNullParameter(result, (String)"result");
                if (result instanceof SuccessResult) {
                    Either it = (Either)((SuccessResult)result).getValue();
                    boolean bl = false;
                    Either either = it;
                    if (either instanceof SuccessResult) {
                        this.$completedAction$inlined.invoke((Object)((HttpResponse)((SuccessResult)it).getValue()).getBody(), null);
                    } else if (either instanceof ErrorResult) {
                        this.$completedAction$inlined.invoke(null, (Object)((Object)VastError.URI_UNAVAILABLE_OR_TIMEOUT));
                    }
                }
            }

            public void emitSuccess(T value) {
                FlowCollector.DefaultImpls.emitSuccess((FlowCollector)this, value);
            }

            public void emitError(@NotNull Throwable error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                FlowCollector.DefaultImpls.emitError((FlowCollector)this, (Throwable)error);
            }
        });
    }

    private static final VastAd createVastAdFromXml(XPath xpath, Node rootNode2) {
        Node wrapperNode2 = (Node)XmlParsingExtensionsKt.evaluateNodeOrNull(xpath, "Wrapper", rootNode2, createVastAdFromXml.wrapperNode.1.INSTANCE);
        Node inlineNode2 = (Node)XmlParsingExtensionsKt.evaluateNodeOrNull(xpath, "InLine", rootNode2, createVastAdFromXml.inlineNode.1.INSTANCE);
        Node node = wrapperNode2;
        if (node == null) {
            node = inlineNode2;
        }
        if (node == null) {
            return null;
        }
        Node contentNode = node;
        Set events = new LinkedHashSet();
        VastDataModelFromXmlKt.addVastEvents(events, EventType.Impression, xpath, contentNode);
        VastDataModelFromXmlKt.addVastEvents(events, EventType.Error, xpath, contentNode);
        List list = (List)XmlParsingExtensionsKt.evaluateNodeOrNull(xpath, "Creatives", contentNode, (Function1)new Function1<Node, List<? extends VastCreative>>(xpath){
            final /* synthetic */ XPath $xpath;

            @NotNull
            public final List<VastCreative> invoke(@NotNull Node it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return VastDataModelFromXmlKt.access$parseCreatives(this.$xpath, it);
            }
            {
                this.$xpath = xPath;
                super(1);
            }
        });
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        List creativesList2 = list;
        List adVerificationsList = new ArrayList();
        XmlParsingExtensionsKt.evaluateNodesOrNull(xpath, "AdVerifications|Extensions/Extension[@type='AdVerifications']/AdVerifications", contentNode, (Function1)new Function1<NodeList, Unit>(adVerificationsList, xpath){
            final /* synthetic */ List $adVerificationsList;
            final /* synthetic */ XPath $xpath;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull NodeList it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                int n = 0;
                int n2 = it.getLength();
                while (n < n2) {
                    void i;
                    Node node = it.item((int)i);
                    Intrinsics.checkNotNullExpressionValue((Object)node, (String)"it.item(i)");
                    VastDataModelFromXmlKt.access$parseAdVerifications(this.$adVerificationsList, this.$xpath, node);
                    ++i;
                }
            }
            {
                this.$adVerificationsList = list;
                this.$xpath = xPath;
                super(1);
            }
        });
        VastInline vastInline = new VastInline(XmlParsingExtensionsKt.getStringNodeValue("AdSystem", xpath, contentNode), XmlParsingExtensionsKt.getStringNodeValue("AdTitle", xpath, contentNode), XmlParsingExtensionsKt.getStringNodeValue("AdServingId", xpath, contentNode), XmlParsingExtensionsKt.getStringNodeValue("Description", xpath, contentNode), XmlParsingExtensionsKt.getStringNodeValue("Advertiser", xpath, contentNode), events, creativesList2, adVerificationsList);
        VastAdContent adContent = vastInline;
        if (wrapperNode2 != null) {
            VastWrapper vastWrapper2 = new VastWrapper(vastInline, XmlParsingExtensionsKt.getBoolNodeAttribute("followAdditionalWrappers", contentNode), XmlParsingExtensionsKt.getBoolNodeAttribute("allowMultipleAds", contentNode), XmlParsingExtensionsKt.getBoolNodeAttribute("fallbackOnNoAd", contentNode), (String)XmlParsingExtensionsKt.evaluateNodeOrNull(xpath, "VASTAdTagURI", contentNode, createVastAdFromXml.vastWrapper.1.INSTANCE));
            adContent = vastWrapper2;
        }
        String string = XmlParsingExtensionsKt.getStringNodeAttribute("id", rootNode2);
        Integer n = XmlParsingExtensionsKt.getIntNodeAttribute("sequence", rootNode2);
        String string2 = XmlParsingExtensionsKt.getStringNodeAttribute("adType", rootNode2);
        if (string2 == null) {
            string2 = "video";
        }
        return new VastAd(string, n, string2, adContent);
    }

    private static final List<VastCreative> parseCreatives(XPath xpath, Node rootNode2) {
        List list = new ArrayList();
        XmlParsingExtensionsKt.evaluateNodesOrNull(xpath, "Creative", rootNode2, (Function1)new Function1<NodeList, Unit>(xpath, list){
            final /* synthetic */ XPath $xpath;
            final /* synthetic */ List $list;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull NodeList itNodes) {
                Intrinsics.checkNotNullParameter((Object)itNodes, (String)"itNodes");
                int n = 0;
                int n2 = itNodes.getLength();
                while (n < n2) {
                    void i;
                    Node node;
                    Node node2 = node = itNodes.item((int)i);
                    Intrinsics.checkNotNullExpressionValue((Object)node2, (String)"node");
                    String companionAdsRequiredMode2 = (String)XmlParsingExtensionsKt.evaluateNodeOrNull(this.$xpath, "CompanionAds", node2, parseCreatives.companionAdsRequiredMode.1.INSTANCE);
                    VastCreative creative = new VastCreative(XmlParsingExtensionsKt.getStringNodeAttribute("id", node), XmlParsingExtensionsKt.getStringNodeAttribute("adId", node), XmlParsingExtensionsKt.getIntNodeAttribute("sequence", node), XmlParsingExtensionsKt.getStringNodeAttribute("apiFramework", node), VastDataModelFromXmlKt.access$parseUniversalAdIdList(this.$xpath, node), VastDataModelFromXmlKt.access$parseAdLinear(this.$xpath, node), VastDataModelFromXmlKt.access$parseAdCompanions(this.$xpath, node), companionAdsRequiredMode2);
                    this.$list.add(creative);
                    ++i;
                }
            }
            {
                this.$xpath = xPath;
                this.$list = list;
                super(1);
            }
        });
        return list;
    }

    private static final List<VastUniversalAdId> parseUniversalAdIdList(XPath xpath, Node rootNode2) {
        List list = (List)XmlParsingExtensionsKt.evaluateNodesOrNull(xpath, "UniversalAdId", rootNode2, parseUniversalAdIdList.1.INSTANCE);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private static final VastLinear parseAdLinear(XPath xpath, Node rootNode2) {
        return (VastLinear)XmlParsingExtensionsKt.evaluateNodeOrNull(xpath, "Linear", rootNode2, (Function1)new Function1<Node, VastLinear>(xpath){
            final /* synthetic */ XPath $xpath;

            @NotNull
            public final VastLinear invoke(@NotNull Node itLinearNode) {
                Intrinsics.checkNotNullParameter((Object)itLinearNode, (String)"itLinearNode");
                Set events = new LinkedHashSet<E>();
                XmlParsingExtensionsKt.evaluateNodeOrNull(this.$xpath, "VideoClicks", itLinearNode, (Function1)new Function1<Node, Integer>(this, events){
                    final /* synthetic */ parseAdLinear.1 this$0;
                    final /* synthetic */ Set $events;

                    public final int invoke(@NotNull Node it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        VastDataModelFromXmlKt.access$addVastEvents(this.$events, EventType.ClickTracking, this.this$0.$xpath, it);
                        return VastDataModelFromXmlKt.access$addVastEvents(this.$events, EventType.CustomClick, this.this$0.$xpath, it);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$events = set;
                        super(1);
                    }
                });
                XmlParsingExtensionsKt.evaluateNodeOrNull(this.$xpath, "TrackingEvents", itLinearNode, (Function1)new Function1<Node, Integer>(this, events){
                    final /* synthetic */ parseAdLinear.1 this$0;
                    final /* synthetic */ Set $events;

                    public final int invoke(@NotNull Node it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return VastDataModelFromXmlKt.access$addVastEvents(this.$events, EventType.Tracking, this.this$0.$xpath, it);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$events = set;
                        super(1);
                    }
                });
                List list = (List)XmlParsingExtensionsKt.evaluateNodeOrNull(this.$xpath, "MediaFiles", itLinearNode, (Function1)new Function1<Node, List<? extends VastMediaFile>>(this){
                    final /* synthetic */ parseAdLinear.1 this$0;

                    @NotNull
                    public final List<VastMediaFile> invoke(@NotNull Node it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return VastDataModelFromXmlKt.access$parseMediaFiles(this.this$0.$xpath, it);
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                });
                if (list == null) {
                    list = CollectionsKt.emptyList();
                }
                List mediaFiles2 = list;
                List<VastMediaFile> verifiedMediaFiles = VastDataModelExtensionsKt.verifyMediaFiles(mediaFiles2);
                XmlParsingExtensionsKt.evaluateNodeOrNull(this.$xpath, "Icons", itLinearNode, (Function1)new Function1<Node, List<? extends VastIcon>>(this){
                    final /* synthetic */ parseAdLinear.1 this$0;

                    @NotNull
                    public final List<VastIcon> invoke(@NotNull Node it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return VastDataModelFromXmlKt.access$parseIcons(this.this$0.$xpath, it);
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                });
                VastClickThrough clickThrough2 = (VastClickThrough)XmlParsingExtensionsKt.evaluateNodeOrNull(this.$xpath, "VideoClicks/ClickThrough", itLinearNode, parseAdLinear.clickThrough.1.INSTANCE);
                return new VastLinear(VastTime.Companion.create(XmlParsingExtensionsKt.getStringNodeAttribute("skipoffset", itLinearNode)), VastTime.Companion.create(XmlParsingExtensionsKt.getStringNodeValue("Duration", this.$xpath, itLinearNode)), clickThrough2, events, mediaFiles2, verifiedMediaFiles, VastDataModelFromXmlKt.access$parseIcons(this.$xpath, itLinearNode));
            }
            {
                this.$xpath = xPath;
                super(1);
            }
        });
    }

    private static final List<VastCompanion> parseAdCompanions(XPath xpath, Node rootNode2) {
        List list = (List)XmlParsingExtensionsKt.evaluateNodesOrNull(xpath, "CompanionAds/Companion", rootNode2, (Function1)new Function1<NodeList, List<VastCompanion>>(xpath){
            final /* synthetic */ XPath $xpath;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<VastCompanion> invoke(@NotNull NodeList itNodes) {
                void var2_2;
                Intrinsics.checkNotNullParameter((Object)itNodes, (String)"itNodes");
                List list = new ArrayList<E>();
                int n = 0;
                int n2 = itNodes.getLength();
                while (n < n2) {
                    void i;
                    Node node = itNodes.item((int)i);
                    Set events = new LinkedHashSet<E>();
                    Node node2 = node;
                    Intrinsics.checkNotNullExpressionValue((Object)node2, (String)"node");
                    VastDataModelFromXmlKt.access$addVastEvents(events, EventType.CompanionClickTracking, this.$xpath, node2);
                    XmlParsingExtensionsKt.evaluateNodeOrNull(this.$xpath, "TrackingEvents", node, (Function1)new Function1<Node, Integer>(this, events){
                        final /* synthetic */ parseAdCompanions.1 this$0;
                        final /* synthetic */ Set $events;

                        public final int invoke(@NotNull Node it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            return VastDataModelFromXmlKt.access$addVastEvents(this.$events, EventType.Tracking, this.this$0.$xpath, it);
                        }
                        {
                            this.this$0 = var1_1;
                            this.$events = set;
                            super(1);
                        }
                    });
                    VastClickThrough clickThrough2 = (VastClickThrough)XmlParsingExtensionsKt.evaluateNodeOrNull(this.$xpath, "CompanionClickThrough", node, parseAdCompanions.clickThrough.1.INSTANCE);
                    VastCompanion companion = new VastCompanion(XmlParsingExtensionsKt.getStringNodeAttribute("id", node), XmlParsingExtensionsKt.getIntNodeAttribute("width", node), XmlParsingExtensionsKt.getIntNodeAttribute("height", node), XmlParsingExtensionsKt.getIntNodeAttribute("assetWidth", node), XmlParsingExtensionsKt.getIntNodeAttribute("assetHeight", node), XmlParsingExtensionsKt.getIntNodeAttribute("expandedWidth", node), XmlParsingExtensionsKt.getIntNodeAttribute("expandedHeight", node), XmlParsingExtensionsKt.getStringNodeAttribute("apiFramework", node), XmlParsingExtensionsKt.getStringNodeAttribute("adSlotId", node), XmlParsingExtensionsKt.getIntNodeAttribute("pxratio", node), XmlParsingExtensionsKt.getStringNodeAttribute("renderingMode", node), XmlParsingExtensionsKt.getStringNodeValue("AltText", this.$xpath, node), clickThrough2, events, VastDataModelFromXmlKt.access$parseVastResource(this.$xpath, node));
                    if (VastDataModelExtensionsKt.isValid(companion)) {
                        list.add(companion);
                    }
                    ++i;
                }
                return var2_2;
            }
            {
                this.$xpath = xPath;
                super(1);
            }
        });
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private static final List<VastMediaFile> parseMediaFiles(XPath xpath, Node rootNode2) {
        List list = (List)XmlParsingExtensionsKt.evaluateNodesOrNull(xpath, "MediaFile", rootNode2, parseMediaFiles.1.INSTANCE);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private static final List<VastIcon> parseIcons(XPath xpath, Node rootNode2) {
        List list = (List)XmlParsingExtensionsKt.evaluateNodesOrNull(xpath, "Icons/Icon", rootNode2, (Function1)new Function1<NodeList, List<VastIcon>>(xpath){
            final /* synthetic */ XPath $xpath;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<VastIcon> invoke(@NotNull NodeList itNodes) {
                void var2_2;
                Intrinsics.checkNotNullParameter((Object)itNodes, (String)"itNodes");
                List list = new ArrayList<E>();
                int n = 0;
                int n2 = itNodes.getLength();
                while (n < n2) {
                    void i;
                    Node node = itNodes.item((int)i);
                    Set events = new LinkedHashSet<E>();
                    Node node2 = node;
                    Intrinsics.checkNotNullExpressionValue((Object)node2, (String)"node");
                    VastDataModelFromXmlKt.access$addVastEvents(events, EventType.IconViewTracking, this.$xpath, node2);
                    XmlParsingExtensionsKt.evaluateNodeOrNull(this.$xpath, "IconClicks", node, (Function1)new Function1<Node, Integer>(this, events){
                        final /* synthetic */ parseIcons.1 this$0;
                        final /* synthetic */ Set $events;

                        public final int invoke(@NotNull Node it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            return VastDataModelFromXmlKt.access$addVastEvents(this.$events, EventType.IconClickTracking, this.this$0.$xpath, it);
                        }
                        {
                            this.this$0 = var1_1;
                            this.$events = set;
                            super(1);
                        }
                    });
                    VastClickThrough clickThrough2 = (VastClickThrough)XmlParsingExtensionsKt.evaluateNodeOrNull(this.$xpath, "IconClicks/IconClickThrough", node, parseIcons.clickThrough.1.INSTANCE);
                    VastBaseResource vastBaseResource = VastDataModelFromXmlKt.access$parseVastResource(this.$xpath, node);
                    VastClickThrough vastClickThrough = clickThrough2;
                    Set set = events;
                    VastTime vastTime = VastTime.Companion.create(XmlParsingExtensionsKt.getStringNodeAttribute("duration", node));
                    VastTime vastTime2 = VastTime.Companion.create(XmlParsingExtensionsKt.getStringNodeAttribute("offset", node));
                    Integer n3 = XmlParsingExtensionsKt.getIntNodeAttribute("height", node);
                    Integer n4 = XmlParsingExtensionsKt.getIntNodeAttribute("width", node);
                    VastIcon icon = new VastIcon(XmlParsingExtensionsKt.getStringNodeAttribute("program", node), vastClickThrough, set, vastBaseResource, n4, n3, vastTime2, vastTime);
                    list.add(icon);
                    ++i;
                }
                return var2_2;
            }
            {
                this.$xpath = xPath;
                super(1);
            }
        });
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private static final VastBaseResource parseVastResource(XPath xpath, Node rootNode2) {
        return (VastBaseResource)XmlParsingExtensionsKt.evaluateNodeOrNull(xpath, "IFrameResource|StaticResource|HTMLResource", rootNode2, parseVastResource.1.INSTANCE);
    }

    private static final void parseAdVerifications(List<VastVerification> list, XPath xpath, Node rootNode2) {
        XmlParsingExtensionsKt.evaluateNodesOrNull(xpath, "Verification", rootNode2, (Function1)new Function1<NodeList, Unit>(xpath, list){
            final /* synthetic */ XPath $xpath;
            final /* synthetic */ List $list;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull NodeList itNodes) {
                Intrinsics.checkNotNullParameter((Object)itNodes, (String)"itNodes");
                int n = 0;
                int n2 = itNodes.getLength();
                while (n < n2) {
                    String verificationParameters2;
                    void i;
                    Node node = itNodes.item((int)i);
                    Set events = new LinkedHashSet<E>();
                    Node node2 = node;
                    Intrinsics.checkNotNullExpressionValue((Object)node2, (String)"node");
                    XmlParsingExtensionsKt.evaluateNodeOrNull(this.$xpath, "TrackingEvents", node2, (Function1)new Function1<Node, Integer>(this, events){
                        final /* synthetic */ parseAdVerifications.1 this$0;
                        final /* synthetic */ Set $events;

                        public final int invoke(@NotNull Node it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            return VastDataModelFromXmlKt.access$addVastEvents(this.$events, EventType.Tracking, this.this$0.$xpath, it);
                        }
                        {
                            this.this$0 = var1_1;
                            this.$events = set;
                            super(1);
                        }
                    });
                    VastJavaScriptResource resource2 = (VastJavaScriptResource)XmlParsingExtensionsKt.evaluateNodeOrNull(this.$xpath, "JavaScriptResource", node, parseAdVerifications.resource.1.INSTANCE);
                    String string = verificationParameters2 = (String)XmlParsingExtensionsKt.evaluateNodeOrNull(this.$xpath, "VerificationParameters", node, parseAdVerifications.verificationParameters.1.INSTANCE);
                    Set set = events;
                    VastBaseVerificationResource vastBaseVerificationResource = resource2;
                    VastVerification vastVerification = new VastVerification(XmlParsingExtensionsKt.getStringNodeAttribute("vendor", node), set, vastBaseVerificationResource, string);
                    this.$list.add(vastVerification);
                    ++i;
                }
            }
            {
                this.$xpath = xPath;
                this.$list = list;
                super(1);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private static final int addVastEvents(Set<VastEvent> events, EventType eventType, XPath xpath, Node rootNode2) {
        try {
            void addedEventsCount;
            Ref.IntRef intRef = new Ref.IntRef();
            intRef.element = 0;
            XmlParsingExtensionsKt.evaluateNodesOrNull(xpath, eventType.toString(), rootNode2, (Function1)new Function1<NodeList, Unit>(eventType, events, (Ref.IntRef)addedEventsCount){
                final /* synthetic */ EventType $eventType;
                final /* synthetic */ Set $events;
                final /* synthetic */ Ref.IntRef $addedEventsCount;

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull NodeList itNodes) {
                    Intrinsics.checkNotNullParameter((Object)itNodes, (String)"itNodes");
                    int n = 0;
                    int n2 = itNodes.getLength();
                    while (n < n2) {
                        void i;
                        Node node;
                        Node node2 = node = itNodes.item((int)i);
                        Intrinsics.checkNotNullExpressionValue((Object)node2, (String)"node");
                        VastTime vastTime = VastTime.Companion.create(XmlParsingExtensionsKt.getStringNodeAttribute("offset", node));
                        String string = XmlParsingExtensionsKt.getElementValue(node);
                        VastEvent event = new VastEvent(this.$eventType, XmlParsingExtensionsKt.getStringNodeAttribute("event", node2), XmlParsingExtensionsKt.getStringNodeAttribute("id", node), vastTime, string);
                        this.$events.add(event);
                        int n3 = this.$addedEventsCount.element;
                        this.$addedEventsCount.element = n3 + 1;
                        ++i;
                    }
                }
                {
                    this.$eventType = eventType;
                    this.$events = set;
                    this.$addedEventsCount = intRef;
                    super(1);
                }
            });
            return addedEventsCount.element;
        }
        catch (Throwable e) {
            StabilityHelper.logException((Object)"addVastEvents", (Throwable)e);
            return 0;
        }
    }

    private static final VastClickThrough getVastClickThroughOrNull(Node $this$vastClickThroughOrNull) {
        String string = XmlParsingExtensionsKt.getElementValue($this$vastClickThroughOrNull);
        if (string == null) {
            return null;
        }
        String url = string;
        return new VastClickThrough(XmlParsingExtensionsKt.getStringNodeAttribute("id", $this$vastClickThroughOrNull), url);
    }

    public static final /* synthetic */ void access$loadWrapperVast(String url, Function2 completedAction) {
        VastDataModelFromXmlKt.loadWrapperVast(url, (Function2<? super String, ? super VastError, Unit>)completedAction);
    }

    public static final /* synthetic */ void access$parseVastXml(VastXmlParser $this$access_u24parseVastXml, Context context, String adm, Function1 macroProcessorFn, Function3 loadListener) {
        VastDataModelFromXmlKt.parseVastXml($this$access_u24parseVastXml, context, adm, (Function1<? super String, String>)macroProcessorFn, (Function3<? super Boolean, ? super VastModel, ? super VastError, Unit>)loadListener);
    }

    public static final /* synthetic */ int access$addVastEvents(Set events, EventType eventType, XPath xpath, Node rootNode2) {
        return VastDataModelFromXmlKt.addVastEvents(events, eventType, xpath, rootNode2);
    }

    public static final /* synthetic */ VastAd access$createVastAdFromXml(XPath xpath, Node rootNode2) {
        return VastDataModelFromXmlKt.createVastAdFromXml(xpath, rootNode2);
    }

    public static final /* synthetic */ List access$parseCreatives(XPath xpath, Node rootNode2) {
        return VastDataModelFromXmlKt.parseCreatives(xpath, rootNode2);
    }

    public static final /* synthetic */ void access$parseAdVerifications(List list, XPath xpath, Node rootNode2) {
        VastDataModelFromXmlKt.parseAdVerifications(list, xpath, rootNode2);
    }

    public static final /* synthetic */ List access$parseUniversalAdIdList(XPath xpath, Node rootNode2) {
        return VastDataModelFromXmlKt.parseUniversalAdIdList(xpath, rootNode2);
    }

    public static final /* synthetic */ VastLinear access$parseAdLinear(XPath xpath, Node rootNode2) {
        return VastDataModelFromXmlKt.parseAdLinear(xpath, rootNode2);
    }

    public static final /* synthetic */ List access$parseAdCompanions(XPath xpath, Node rootNode2) {
        return VastDataModelFromXmlKt.parseAdCompanions(xpath, rootNode2);
    }

    public static final /* synthetic */ List access$parseMediaFiles(XPath xpath, Node rootNode2) {
        return VastDataModelFromXmlKt.parseMediaFiles(xpath, rootNode2);
    }

    public static final /* synthetic */ List access$parseIcons(XPath xpath, Node rootNode2) {
        return VastDataModelFromXmlKt.parseIcons(xpath, rootNode2);
    }

    public static final /* synthetic */ VastClickThrough access$getVastClickThroughOrNull$p(Node $this$access_u24vastClickThroughOrNull_u24p) {
        return VastDataModelFromXmlKt.getVastClickThroughOrNull($this$access_u24vastClickThroughOrNull_u24p);
    }

    public static final /* synthetic */ VastBaseResource access$parseVastResource(XPath xpath, Node rootNode2) {
        return VastDataModelFromXmlKt.parseVastResource(xpath, rootNode2);
    }
}

