/*
 * Decompiled with CFR 0.152.
 */
package com.mobilefuse.videoplayer.network;

import android.annotation.SuppressLint;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Handler;
import android.os.Looper;
import com.mobilefuse.sdk.DebuggingKt;
import com.mobilefuse.sdk.StabilityHelper;
import com.mobilefuse.sdk.exception.BaseError;
import com.mobilefuse.sdk.exception.Either;
import com.mobilefuse.sdk.exception.ErrorResult;
import com.mobilefuse.sdk.exception.SuccessResult;
import com.mobilefuse.sdk.network.client.HttpClientKt;
import com.mobilefuse.sdk.network.client.HttpError;
import com.mobilefuse.sdk.rx.Flow;
import com.mobilefuse.sdk.rx.FlowCollector;
import com.mobilefuse.sdk.rx.FlowKt;
import com.mobilefuse.videoplayer.model.VastError;
import com.mobilefuse.videoplayer.model.VastMediaFile;
import com.mobilefuse.videoplayer.network.NetworkType;
import com.mobilefuse.videoplayer.network.ProbeMediaFilesFlowKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007JP\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2:\u0010\u000e\u001a6\u0012\u0015\u0012\u0013\u0018\u00010\r\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\u0015\u0012\u0013\u0018\u00010\u0013\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0014\u0012\u0004\u0012\u00020\n0\u000fJ\f\u0010\u0015\u001a\u00020\u0013*\u00020\u0016H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/mobilefuse/videoplayer/network/NetworkUtils;", "", "()V", "handler", "Landroid/os/Handler;", "getNetworkType", "Lcom/mobilefuse/videoplayer/network/NetworkType;", "context", "Landroid/content/Context;", "probeMediaFiles", "", "mediaFiles", "", "Lcom/mobilefuse/videoplayer/model/VastMediaFile;", "completeCallback", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "result", "Lcom/mobilefuse/videoplayer/model/VastError;", "error", "toVastError", "Lcom/mobilefuse/sdk/exception/BaseError;", "mobilefuse-video-player_release"})
public final class NetworkUtils {
    private static final Handler handler;
    @NotNull
    public static final NetworkUtils INSTANCE;

    @SuppressLint(value={"MissingPermission"})
    @Nullable
    public final NetworkType getNetworkType(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            if (connectivityManager == null) {
                return null;
            }
            ConnectivityManager cm = connectivityManager;
            NetworkInfo networkInfo = cm.getActiveNetworkInfo();
            if (networkInfo == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)networkInfo, (String)"cm.activeNetworkInfo ?: return null");
            NetworkInfo info = networkInfo;
            if (!info.isConnected()) {
                return null;
            }
            if (info.getType() == 1) {
                return NetworkType.WIFI;
            }
            if (info.getType() == 0) {
                NetworkType networkType;
                switch (info.getSubtype()) {
                    case 1: 
                    case 2: 
                    case 4: 
                    case 7: 
                    case 11: 
                    case 16: {
                        networkType = NetworkType.MOBILE_2G;
                        break;
                    }
                    case 3: 
                    case 5: 
                    case 6: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 12: 
                    case 14: 
                    case 15: 
                    case 17: {
                        networkType = NetworkType.MOBILE_3G;
                        break;
                    }
                    case 13: 
                    case 18: 
                    case 19: {
                        networkType = NetworkType.MOBILE_4G;
                        break;
                    }
                    case 20: {
                        networkType = NetworkType.MOBILE_5G;
                        break;
                    }
                    default: {
                        networkType = NetworkType.UNKNOWN;
                    }
                }
                return networkType;
            }
        }
        catch (Throwable e) {
            StabilityHelper.logException((Object)this, (Throwable)e);
        }
        return NetworkType.UNKNOWN;
    }

    public final void probeMediaFiles(@NotNull List<VastMediaFile> mediaFiles2, @NotNull Function2<? super VastMediaFile, ? super VastError, Unit> completeCallback) {
        Intrinsics.checkNotNullParameter(mediaFiles2, (String)"mediaFiles");
        Intrinsics.checkNotNullParameter(completeCallback, (String)"completeCallback");
        Flow<Either<BaseError, VastMediaFile>> $this$collectResult$iv = ProbeMediaFilesFlowKt.probeMediaFiles((Flow<? extends List<VastMediaFile>>)FlowKt.flowSingle(mediaFiles2), HttpClientKt.getDefaultHttpClient());
        boolean $i$f$collectResult = false;
        $this$collectResult$iv.collect(new FlowCollector(completeCallback){
            final /* synthetic */ Function2 $completeCallback$inlined;
            {
                this.$completeCallback$inlined = function2;
            }

            public final void emit(@NotNull Either<? extends Throwable, ? extends T> result) {
                Intrinsics.checkNotNullParameter(result, (String)"result");
                if (result instanceof SuccessResult) {
                    Either result2 = (Either)((SuccessResult)result).getValue();
                    boolean bl = false;
                    DebuggingKt.logDebug$default((Object)NetworkUtils.INSTANCE, (String)("Probe media files result -> " + result2), null, (int)2, null);
                    Either either = result2;
                    if (either instanceof SuccessResult) {
                        this.$completeCallback$inlined.invoke(((SuccessResult)result2).getValue(), null);
                    } else if (either instanceof ErrorResult) {
                        this.$completeCallback$inlined.invoke(null, (Object)((Object)NetworkUtils.access$toVastError(NetworkUtils.INSTANCE, (BaseError)((ErrorResult)result2).getValue())));
                    }
                }
            }

            public void emitSuccess(T value) {
                FlowCollector.DefaultImpls.emitSuccess((FlowCollector)this, value);
            }

            public void emitError(@NotNull Throwable error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                FlowCollector.DefaultImpls.emitError((FlowCollector)this, (Throwable)error);
            }
        });
    }

    private final VastError toVastError(BaseError $this$toVastError) {
        VastError vastError;
        BaseError error = $this$toVastError;
        if (error instanceof HttpError.ConnectionError) {
            switch (((HttpError.ConnectionError)error).getStatusCode()) {
                case 404: {
                    vastError = VastError.MEDIAFILE_NOT_FOUND;
                    break;
                }
                case 408: {
                    vastError = VastError.MEDIAFILE_TIMEOUT;
                    break;
                }
                default: {
                    vastError = VastError.UNIDENTIFIED;
                    break;
                }
            }
        } else {
            vastError = VastError.UNIDENTIFIED;
        }
        return vastError;
    }

    private NetworkUtils() {
    }

    static {
        NetworkUtils networkUtils;
        INSTANCE = networkUtils = new NetworkUtils();
        handler = new Handler(Looper.getMainLooper());
    }

    public static final /* synthetic */ VastError access$toVastError(NetworkUtils $this, BaseError $this$access_u24toVastError) {
        return $this.toVastError($this$access_u24toVastError);
    }
}

