/*
 * Decompiled with CFR 0.152.
 */
package com.mobilefuse.videoplayer;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.view.View;
import com.mobilefuse.sdk.StabilityHelper;
import com.mobilefuse.sdk.concurrency.SchedulersKt;
import com.mobilefuse.sdk.device.GetDeviceScreenDensityKt;
import com.mobilefuse.sdk.exception.Either;
import com.mobilefuse.sdk.exception.ErrorResult;
import com.mobilefuse.sdk.exception.ExceptionHandlingStrategy;
import com.mobilefuse.sdk.exception.SuccessResult;
import com.mobilefuse.sdk.omid.VastOmidBridge;
import com.mobilefuse.videoplayer.VideoPlayer;
import com.mobilefuse.videoplayer.VideoPlayerCapabilities;
import com.mobilefuse.videoplayer.VideoPlayerController;
import com.mobilefuse.videoplayer.VideoPlayerController$WhenMappings;
import com.mobilefuse.videoplayer.VideoPlayerController$loadVastTag$$inlined$gracefullyHandleException$1$wm$TryKt$WhenMappings;
import com.mobilefuse.videoplayer.VideoPlayerController$sendErrorEvent$$inlined$handleExceptions$1$wm$TryKt$WhenMappings;
import com.mobilefuse.videoplayer.VideoPlayerController$sendImpressionEvent$1$$special$$inlined$handleExceptions$1$wm$TryKt$WhenMappings;
import com.mobilefuse.videoplayer.model.EventType;
import com.mobilefuse.videoplayer.model.VastAd;
import com.mobilefuse.videoplayer.model.VastAdContent;
import com.mobilefuse.videoplayer.model.VastBaseVerificationResource;
import com.mobilefuse.videoplayer.model.VastClickThrough;
import com.mobilefuse.videoplayer.model.VastCompanion;
import com.mobilefuse.videoplayer.model.VastCreative;
import com.mobilefuse.videoplayer.model.VastDataModelExtensionsKt;
import com.mobilefuse.videoplayer.model.VastDataModelFromXmlKt;
import com.mobilefuse.videoplayer.model.VastError;
import com.mobilefuse.videoplayer.model.VastEvent;
import com.mobilefuse.videoplayer.model.VastIcon;
import com.mobilefuse.videoplayer.model.VastJavaScriptResource;
import com.mobilefuse.videoplayer.model.VastLinear;
import com.mobilefuse.videoplayer.model.VastMediaFile;
import com.mobilefuse.videoplayer.model.VastModel;
import com.mobilefuse.videoplayer.model.VastTag;
import com.mobilefuse.videoplayer.model.VastTime;
import com.mobilefuse.videoplayer.model.VastTrackingEventType;
import com.mobilefuse.videoplayer.model.VastVerification;
import com.mobilefuse.videoplayer.model.VastVerificationError;
import com.mobilefuse.videoplayer.model.VastVerificationResourceType;
import com.mobilefuse.videoplayer.model.VerificationApiFramework;
import com.mobilefuse.videoplayer.network.NetworkUtils;
import com.mobilefuse.videoplayer.tracking.VastEventTracker;
import com.mobilefuse.videoplayer.utils.EnumExtensionsKt;
import com.mobilefuse.videoplayer.utils.MediaUtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u00f0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 r2\u00020\u0001:\u0001rB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\r\u00101\u001a\u000202H\u0000\u00a2\u0006\u0002\b3J\u0006\u00104\u001a\u000202J\b\u00105\u001a\u0004\u0018\u000106J\b\u00107\u001a\u0004\u0018\u000106J\b\u00108\u001a\u0004\u0018\u000109J\u0012\u0010:\u001a\u0004\u0018\u00010\u00132\u0006\u0010;\u001a\u00020<H\u0002J\f\u0010=\u001a\b\u0012\u0004\u0012\u00020\u00130>J\u000e\u0010?\u001a\b\u0012\u0004\u0012\u00020\t0@H\u0002J\u0006\u0010A\u001a\u00020BJ\u0016\u0010C\u001a\b\u0012\u0004\u0012\u00020\t0@2\u0006\u0010D\u001a\u00020EH\u0002J\r\u0010F\u001a\u000202H\u0000\u00a2\u0006\u0002\bGJ*\u0010H\u001a\u0002022\u0006\u0010I\u001a\u00020<2\u001a\u0010J\u001a\u0016\u0012\u0004\u0012\u00020\u001f\u0012\u0006\u0012\u0004\u0018\u00010L\u0012\u0004\u0012\u0002020KJ\u0006\u0010M\u001a\u000202J\u000e\u0010N\u001a\u0002022\u0006\u0010;\u001a\u00020<J\u000e\u0010O\u001a\u0002022\u0006\u0010;\u001a\u00020<J\u0006\u0010P\u001a\u000202J\u000e\u0010Q\u001a\u0002022\u0006\u0010R\u001a\u00020#J\u0006\u0010S\u001a\u000202J\u0006\u0010T\u001a\u000202J\u0006\u0010U\u001a\u000202J3\u0010V\u001a\u0002022\u0006\u0010W\u001a\u00020X2#\u0010Y\u001a\u001f\u0012\u0015\u0012\u0013\u0018\u00010\u0014\u00a2\u0006\f\b[\u0012\b\b\\\u0012\u0004\b\b(]\u0012\u0004\u0012\u0002020ZJ\u0014\u0010^\u001a\b\u0012\u0004\u0012\u00020_0>2\u0006\u0010W\u001a\u00020XJ\u0018\u0010`\u001a\u0002022\u0006\u0010a\u001a\u00020b2\u0006\u0010c\u001a\u00020dH\u0002J\b\u0010e\u001a\u000202H\u0002J\b\u0010f\u001a\u000202H\u0002J\u000e\u0010g\u001a\u0002022\u0006\u0010h\u001a\u00020_J\u0016\u0010i\u001a\u0002022\u0006\u0010h\u001a\u00020_2\u0006\u0010D\u001a\u00020jJ\u000e\u0010k\u001a\u0002022\u0006\u0010c\u001a\u00020LJ\u001b\u0010l\u001a\u0002022\f\u0010m\u001a\b\u0012\u0004\u0012\u0002020nH\u0000\u00a2\u0006\u0002\boJ\u000e\u0010p\u001a\u0002022\u0006\u0010D\u001a\u00020jJ\b\u0010q\u001a\u000202H\u0002R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\f\u001a\u0004\u0018\u00010\u000b2\b\u0010\n\u001a\u0004\u0018\u00010\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0015\u001a\u0004\u0018\u00010\u00142\b\u0010\n\u001a\u0004\u0018\u00010\u0014@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010 \u001a\u00020\u001f2\u0006\u0010\n\u001a\u00020\u001f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u000e\u0010\"\u001a\u00020#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010%\u001a\u0004\u0018\u00010&X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R \u0010-\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020\t0.0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u000200X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006s"}, d2={"Lcom/mobilefuse/videoplayer/VideoPlayerController;", "", "context", "Landroid/content/Context;", "player", "Lcom/mobilefuse/videoplayer/VideoPlayer;", "(Landroid/content/Context;Lcom/mobilefuse/videoplayer/VideoPlayer;)V", "contentErrorEvents", "", "Lcom/mobilefuse/videoplayer/model/VastEvent;", "<set-?>", "Lcom/mobilefuse/videoplayer/model/VastAd;", "currentAd", "getCurrentAd", "()Lcom/mobilefuse/videoplayer/model/VastAd;", "currentAdLinear", "Lcom/mobilefuse/videoplayer/model/VastLinear;", "currentIcons", "", "Lcom/mobilefuse/videoplayer/model/VastIcon;", "Lcom/mobilefuse/videoplayer/model/VastMediaFile;", "currentMediaFile", "getCurrentMediaFile", "()Lcom/mobilefuse/videoplayer/model/VastMediaFile;", "eventTracker", "Lcom/mobilefuse/videoplayer/tracking/VastEventTracker;", "getEventTracker", "()Lcom/mobilefuse/videoplayer/tracking/VastEventTracker;", "handler", "Landroid/os/Handler;", "impressionEvents", "", "isAdSkippable", "()Z", "nextProgressEventPosition", "", "noAdResponseErrorEvents", "omidBridge", "Lcom/mobilefuse/sdk/omid/VastOmidBridge;", "getOmidBridge", "()Lcom/mobilefuse/sdk/omid/VastOmidBridge;", "setOmidBridge", "(Lcom/mobilefuse/sdk/omid/VastOmidBridge;)V", "getPlayer", "()Lcom/mobilefuse/videoplayer/VideoPlayer;", "progressTrackingEvents", "Landroid/util/Pair;", "vastModel", "Lcom/mobilefuse/videoplayer/model/VastModel;", "callOmidLoadedEvent", "", "callOmidLoadedEvent$mobilefuse_video_player_release", "destroy", "getAdDuration", "Lcom/mobilefuse/videoplayer/model/VastTime;", "getAdSkipOffset", "getClickThrough", "Lcom/mobilefuse/videoplayer/model/VastClickThrough;", "getCurrentIconByUid", "iconUid", "", "getIcons", "", "getNoAdResponseErrorEvents", "", "getPlayerCapabilities", "Lcom/mobilefuse/videoplayer/VideoPlayerCapabilities;", "getVastContentEvents", "eventType", "Lcom/mobilefuse/videoplayer/model/EventType;", "initOmid", "initOmid$mobilefuse_video_player_release", "loadVastTag", "vastXml", "loadListener", "Lkotlin/Function2;", "Lcom/mobilefuse/videoplayer/model/VastError;", "onFullscreenChanged", "onIconClick", "onIconView", "onMuteChanged", "onPlaying", "position", "onSkipped", "onVideoClickThrough", "prepareProgressTrackingEvents", "selectBestMediaFile", "playerContainerSize", "", "selectMediaFileListener", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "mediaFile", "selectCompanionAds", "Lcom/mobilefuse/videoplayer/model/VastCompanion;", "sendAdVerificationError", "vastVerification", "Lcom/mobilefuse/videoplayer/model/VastVerification;", "error", "Lcom/mobilefuse/videoplayer/model/VastVerificationError;", "sendAwaitingProgressEvents", "sendClickTrackingEvent", "sendCompanionAdClickTrackingEvent", "vastCompanion", "sendCompanionAdTrackingEvent", "Lcom/mobilefuse/videoplayer/model/VastTrackingEventType;", "sendErrorEvent", "sendImpressionEvent", "onComplete", "Lkotlin/Function0;", "sendImpressionEvent$mobilefuse_video_player_release", "sendTrackingEvent", "updateNextProgressEventPosition", "Companion", "mobilefuse-video-player_release"})
public final class VideoPlayerController {
    private final Handler handler;
    private final Context context;
    private final List<android.util.Pair<Long, VastEvent>> progressTrackingEvents;
    @NotNull
    private final VastEventTracker eventTracker;
    private VastModel vastModel;
    @Nullable
    private VastOmidBridge omidBridge;
    @Nullable
    private VastAd currentAd;
    private VastLinear currentAdLinear;
    @Nullable
    private VastMediaFile currentMediaFile;
    private final List<VastIcon> currentIcons;
    private boolean isAdSkippable;
    private final Set<VastEvent> noAdResponseErrorEvents;
    private final Set<VastEvent> contentErrorEvents;
    private final Set<VastEvent> impressionEvents;
    private long nextProgressEventPosition;
    @NotNull
    private final VideoPlayer player;
    public static final long OM_IMPRESSION_EVENT_DELAY_MILLIS = 200L;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final VastEventTracker getEventTracker() {
        return this.eventTracker;
    }

    @Nullable
    public final VastOmidBridge getOmidBridge() {
        return this.omidBridge;
    }

    public final void setOmidBridge(@Nullable VastOmidBridge vastOmidBridge) {
        this.omidBridge = vastOmidBridge;
    }

    @Nullable
    public final VastAd getCurrentAd() {
        return this.currentAd;
    }

    @Nullable
    public final VastMediaFile getCurrentMediaFile() {
        return this.currentMediaFile;
    }

    public final boolean isAdSkippable() {
        return this.isAdSkippable;
    }

    /*
     * WARNING - void declaration
     */
    public final void loadVastTag(@NotNull String vastXml, @NotNull Function2<? super Boolean, ? super VastError, Unit> loadListener) {
        Either either;
        Intrinsics.checkNotNullParameter((Object)vastXml, (String)"vastXml");
        Intrinsics.checkNotNullParameter(loadListener, (String)"loadListener");
        boolean $i$f$gracefullyHandleException = false;
        String string = "[Automatically caught]";
        ExceptionHandlingStrategy strategy$iv$iv = ExceptionHandlingStrategy.LogAndIgnore;
        boolean $i$f$gracefullyHandleException2 = false;
        try {
            Unit unit;
            Either<VastError, VastModel> result2;
            boolean bl = false;
            Either<VastError, VastModel> either2 = result2 = VastDataModelFromXmlKt.createVastModelFromXml(this.context, vastXml, (Function1<? super String, String>)((Function1)new Function1<String, String>(this.eventTracker){

                @NotNull
                public final String invoke(@NotNull String p1) {
                    Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                    return ((VastEventTracker)this.receiver).simpleParseMacro(p1);
                }
            }));
            if (either2 instanceof SuccessResult) {
                this.vastModel = (VastModel)((SuccessResult)result2).getValue();
                this.noAdResponseErrorEvents.addAll((Collection<VastEvent>)this.getNoAdResponseErrorEvents());
                this.contentErrorEvents.addAll((Collection<VastEvent>)this.getVastContentEvents(EventType.Error));
                this.impressionEvents.addAll((Collection<VastEvent>)this.getVastContentEvents(EventType.Impression));
                loadListener.invoke((Object)true, null);
            } else if (either2 instanceof ErrorResult) {
                this.sendErrorEvent((VastError)((Object)((ErrorResult)result2).getValue()));
                loadListener.invoke((Object)false, ((ErrorResult)result2).getValue());
            }
            Unit unit2 = unit = Unit.INSTANCE;
            either = (Either)new SuccessResult((Object)unit2);
        }
        catch (Throwable e$iv$iv) {
            switch (VideoPlayerController$loadVastTag$$inlined$gracefullyHandleException$1$wm$TryKt$WhenMappings.$EnumSwitchMapping$1[strategy$iv$iv.ordinal()]) {
                case 1: {
                    void source$iv$iv;
                    StabilityHelper.logException((Object)source$iv$iv, (Throwable)e$iv$iv);
                }
            }
            either = (Either)new ErrorResult((Object)e$iv$iv);
        }
        Either $this$withErrorFallback$iv = either;
        boolean $i$f$withErrorFallback = false;
        Either either3 = $this$withErrorFallback$iv;
        if (either3 instanceof ErrorResult) {
            Throwable it = (Throwable)((ErrorResult)$this$withErrorFallback$iv).getValue();
            boolean bl = false;
            this.sendErrorEvent(VastError.XML_PARSING_FAILED);
            loadListener.invoke((Object)false, (Object)VastError.XML_PARSING_FAILED);
        } else if (either3 instanceof SuccessResult) {
            ((SuccessResult)$this$withErrorFallback$iv).getValue();
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    public final void selectBestMediaFile(@NotNull int[] playerContainerSize, @NotNull Function1<? super VastMediaFile, Unit> selectMediaFileListener) {
        List<VastMediaFile> mediaFiles2;
        VastTime adDuration;
        Intrinsics.checkNotNullParameter((Object)playerContainerSize, (String)"playerContainerSize");
        Intrinsics.checkNotNullParameter(selectMediaFileListener, (String)"selectMediaFileListener");
        Function0 selectFailureCallback2 = (Function0)new Function0<Unit>(selectMediaFileListener){
            final /* synthetic */ Function1 $selectMediaFileListener;

            public final void invoke() {
                this.$selectMediaFileListener.invoke(null);
            }
            {
                this.$selectMediaFileListener = function1;
                super(0);
            }
        };
        VastModel vastModel = this.vastModel;
        if (vastModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"vastModel");
        }
        VastAd vastAd = vastModel.getSelectedAd();
        if (vastAd == null) {
            VideoPlayerController videoPlayerController;
            VideoPlayerController videoPlayerController2 = videoPlayerController = this;
            VideoPlayerController videoPlayerController3 = this;
            boolean bl = false;
            selectFailureCallback2.invoke();
            return;
        }
        this.currentAd = vastAd;
        Object object = this.currentAd;
        if (object == null || (object = VastDataModelExtensionsKt.getFirstAdLinear((VastAd)object)) == null) {
            VideoPlayerController videoPlayerController;
            VideoPlayerController $this$run = videoPlayerController = this;
            VideoPlayerController videoPlayerController4 = this;
            boolean bl = false;
            selectFailureCallback2.invoke();
            return;
        }
        this.currentAdLinear = object;
        this.isAdSkippable = false;
        VastLinear vastLinear = this.currentAdLinear;
        VastTime vastTime = adDuration = vastLinear != null ? vastLinear.getDuration() : null;
        if (adDuration != null) {
            long skipOffsetValue;
            long l;
            long duration = adDuration.getValueInMillis();
            VastTime skipOffset = this.getAdSkipOffset();
            if (skipOffset != null && 1L <= (l = (skipOffsetValue = skipOffset.getValueInMillisForDuration(duration))) && duration > l) {
                this.isAdSkippable = true;
            }
        }
        VastLinear vastLinear2 = this.currentAdLinear;
        List<VastMediaFile> list = mediaFiles2 = vastLinear2 != null ? VastDataModelExtensionsKt.getSupportedMediaFiles(vastLinear2, this.context, playerContainerSize) : null;
        if (list == null || list.isEmpty()) {
            this.sendErrorEvent(VastError.MEDIAFILES_UNSUPPORTED);
            selectFailureCallback2.invoke();
            return;
        }
        NetworkUtils.INSTANCE.probeMediaFiles(mediaFiles2, (Function2<? super VastMediaFile, ? super VastError, Unit>)((Function2)new Function2<VastMediaFile, VastError, Unit>(this, selectMediaFileListener){
            final /* synthetic */ VideoPlayerController this$0;
            final /* synthetic */ Function1 $selectMediaFileListener;

            public final void invoke(@Nullable VastMediaFile result2, @Nullable VastError error) {
                try {
                    VideoPlayerController.access$setCurrentMediaFile$p(this.this$0, result2);
                    VastError vastError = error;
                    if (vastError != null) {
                        VastError vastError2;
                        VastError it = vastError2 = vastError;
                        boolean bl = false;
                        this.this$0.sendErrorEvent(it);
                    }
                    this.$selectMediaFileListener.invoke((Object)result2);
                }
                catch (Throwable e) {
                    StabilityHelper.logException((Object)this.this$0, (Throwable)e);
                }
            }
            {
                this.this$0 = videoPlayerController;
                this.$selectMediaFileListener = function1;
                super(2);
            }
        }));
    }

    @NotNull
    public final List<VastCompanion> selectCompanionAds(@NotNull int[] playerContainerSize) {
        Intrinsics.checkNotNullParameter((Object)playerContainerSize, (String)"playerContainerSize");
        VastModel vastModel = this.vastModel;
        if (vastModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"vastModel");
        }
        Iterator<VastAd> iterator = VastDataModelExtensionsKt.getAdsChainIterator(vastModel, false);
        List allCreativesList = new ArrayList();
        while (iterator.hasNext()) {
            List<VastCreative> creatives = VastDataModelExtensionsKt.getAllCreativesWithCompanionAds(iterator.next());
            allCreativesList.addAll((Collection)creatives);
        }
        if (allCreativesList.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        return MediaUtilsKt.selectEndCardCompanions(MediaUtilsKt.getAllCompanionsFromVastCreatives(allCreativesList), this.player.getMaxEndCardsToShow(), playerContainerSize, GetDeviceScreenDensityKt.getDeviceScreenDensity((Context)this.context));
    }

    @NotNull
    public final List<VastIcon> getIcons() {
        this.currentIcons.clear();
        VastLinear vastLinear = this.currentAdLinear;
        if (vastLinear == null) {
            return this.currentIcons;
        }
        VastLinear vastAdLinear = vastLinear;
        List excludedPrograms = new ArrayList();
        this.currentIcons.addAll((Collection<VastIcon>)VastDataModelExtensionsKt.getIcons(vastAdLinear, excludedPrograms));
        VastModel vastModel = this.vastModel;
        if (vastModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"vastModel");
        }
        Iterator<VastAd> iterator = VastDataModelExtensionsKt.getAdsChainIterator(vastModel, true);
        while (iterator.hasNext()) {
            VastLinear vastLinear2;
            if (VastDataModelExtensionsKt.getFirstAdLinear(iterator.next()) == null) continue;
            this.currentIcons.addAll((Collection<VastIcon>)VastDataModelExtensionsKt.getIcons(vastLinear2, excludedPrograms));
        }
        return this.currentIcons;
    }

    public final void onIconView(@NotNull String iconUid) {
        Intrinsics.checkNotNullParameter((Object)iconUid, (String)"iconUid");
        VastIcon vastIcon = this.getCurrentIconByUid(iconUid);
        if (vastIcon == null) {
            return;
        }
        VastIcon icon = vastIcon;
        VastEventTracker.sendEvents$default(this.eventTracker, icon.getEvents(EventType.IconViewTracking), null, 2, null);
    }

    public final void onIconClick(@NotNull String iconUid) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)iconUid, (String)"iconUid");
            VastIcon vastIcon = this.getCurrentIconByUid(iconUid);
            if (vastIcon == null) {
                return;
            }
            VastIcon icon = vastIcon;
            VastEventTracker.sendEvents$default(this.eventTracker, icon.getEvents(EventType.IconClickTracking), null, 2, null);
            VastClickThrough vastClickThrough = icon.getClickThrough();
            if (vastClickThrough == null) break block1;
            VastDataModelExtensionsKt.openUrl(vastClickThrough, this.context, this.eventTracker, (Function0<Unit>)((Function0)onIconClick.1.INSTANCE));
        }
    }

    public final void onVideoClickThrough() {
        try {
            VastClickThrough vastClickThrough = this.getClickThrough();
            if (vastClickThrough == null) {
                return;
            }
            VastClickThrough clickThrough2 = vastClickThrough;
            VastDataModelExtensionsKt.openUrl(clickThrough2, this.context, this.eventTracker, (Function0<Unit>)((Function0)onVideoClickThrough.1.INSTANCE));
            this.sendClickTrackingEvent();
            VastOmidBridge vastOmidBridge = this.omidBridge;
            if (vastOmidBridge != null) {
                vastOmidBridge.adUserInteractionClick();
            }
        }
        catch (Throwable e) {
            StabilityHelper.logException((Object)this, (Throwable)e);
        }
    }

    private final VastIcon getCurrentIconByUid(String iconUid) {
        for (VastIcon icon : this.currentIcons) {
            if (!Intrinsics.areEqual((Object)icon.getUid(), (Object)iconUid)) continue;
            return icon;
        }
        return null;
    }

    public final void onMuteChanged() {
        VastTrackingEventType eventType = this.player.isMuted() ? VastTrackingEventType.mute : VastTrackingEventType.unmute;
        this.sendTrackingEvent(eventType);
    }

    public final void onFullscreenChanged() {
        if (this.player.getFullscreen()) {
            this.sendTrackingEvent(VastTrackingEventType.playerExpand);
            this.sendTrackingEvent(VastTrackingEventType.fullscreen);
        } else {
            this.sendTrackingEvent(VastTrackingEventType.playerCollapse);
            this.sendTrackingEvent(VastTrackingEventType.exitFullscreen);
        }
    }

    public final void onPlaying(long position) {
        if (this.nextProgressEventPosition <= position) {
            this.sendAwaitingProgressEvents();
        }
    }

    public final void onSkipped() {
        this.sendTrackingEvent(VastTrackingEventType.skip);
    }

    public final void initOmid$mobilefuse_video_player_release() {
        try {
            Iterator<VastAd> iterator;
            if (this.omidBridge == null) {
                return;
            }
            if (this.currentAd == null) {
                return;
            }
            List vastVerificationList = new ArrayList();
            VastModel vastModel = this.vastModel;
            if (vastModel == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"vastModel");
            }
            Iterator<VastAd> $this$forEach$iv = iterator = VastDataModelExtensionsKt.getAdsChainIterator(vastModel, false);
            boolean $i$f$forEach = false;
            Iterator<VastAd> iterator2 = $this$forEach$iv;
            while (iterator2.hasNext()) {
                Object object;
                VastAd element$iv;
                VastAd vastAd = element$iv = iterator2.next();
                boolean bl = false;
                Object object2 = vastAd.getContent();
                if (object2 == null || (object2 = object2.getVerificationList()) == null) continue;
                Object it = object = object2;
                boolean bl2 = false;
                Collection collection = vastVerificationList;
                CollectionsKt.addAll((Collection)collection, (Iterable)((Iterable)it));
            }
            for (VastVerification vastVerification : vastVerificationList) {
                VastJavaScriptResource javaScriptResource;
                VastBaseVerificationResource vastBaseVerificationResource = vastVerification.getResource();
                if ((vastBaseVerificationResource != null ? vastBaseVerificationResource.getResourceType() : null) != VastVerificationResourceType.JAVASCRIPT) {
                    this.sendAdVerificationError(vastVerification, VastVerificationError.NOT_SUPPORTED);
                    continue;
                }
                if ((VastJavaScriptResource)vastVerification.getResource() == null || javaScriptResource.getUri() == null) continue;
                if (javaScriptResource.getApiFramework() != VerificationApiFramework.OMID) {
                    this.sendAdVerificationError(vastVerification, VastVerificationError.NOT_SUPPORTED);
                    continue;
                }
                VastOmidBridge vastOmidBridge = this.omidBridge;
                if (vastOmidBridge == null) continue;
                vastOmidBridge.registerVerificationScript(vastVerification.getVendor(), javaScriptResource.getUri(), vastVerification.getVerificationParameters());
            }
            VastOmidBridge vastOmidBridge = this.omidBridge;
            if (vastOmidBridge != null) {
                vastOmidBridge.initAdSession(this.context, (View)this.player);
            }
            VastOmidBridge vastOmidBridge2 = this.omidBridge;
            if (vastOmidBridge2 != null) {
                vastOmidBridge2.startAdSession();
            }
        }
        catch (Throwable e) {
            StabilityHelper.logException((Object)this, (Throwable)e);
        }
    }

    private final void sendAdVerificationError(VastVerification vastVerification, VastVerificationError error) {
        try {
            Set<VastEvent> events = vastVerification.getEvents(EventType.Tracking, VastTrackingEventType.verificationNotExecuted.name());
            Map customMacros2 = MapsKt.mapOf((Pair)TuplesKt.to((Object)"REASON", (Object)new Function1<VastError, String>(error){
                final /* synthetic */ VastVerificationError $error;

                @NotNull
                public final String invoke(@Nullable VastError it) {
                    return String.valueOf(this.$error.getErrorCode());
                }
                {
                    this.$error = vastVerificationError;
                    super(1);
                }
            }));
            this.eventTracker.sendEvents(events, customMacros2);
        }
        catch (Throwable e) {
            StabilityHelper.logException((Object)this, (Throwable)e);
        }
    }

    public final void callOmidLoadedEvent$mobilefuse_video_player_release() {
        if (this.omidBridge == null) {
            return;
        }
        try {
            VastTime vastTime = this.getAdSkipOffset();
            int skipOffsetValue = vastTime != null ? vastTime.getValueInSeconds() : 0;
            VastOmidBridge vastOmidBridge = this.omidBridge;
            if (vastOmidBridge != null) {
                vastOmidBridge.signalAdLoadedEvent(this.isAdSkippable, (float)skipOffsetValue, EnumExtensionsKt.isAutoplayed(this.player.getAdAutoplay()));
            }
        }
        catch (Throwable e) {
            StabilityHelper.logException((Object)this, (Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void sendErrorEvent(@NotNull VastError error) {
        Intrinsics.checkNotNullParameter((Object)((Object)error), (String)"error");
        boolean $i$f$handleExceptions = false;
        String string = "[Automatically caught]";
        ExceptionHandlingStrategy strategy$iv$iv = ExceptionHandlingStrategy.LogAndIgnore;
        boolean $i$f$handleExceptions2 = false;
        try {
            boolean bl = false;
            Set<VastEvent> events = error == VastError.NO_VAST_RESPONSE ? this.noAdResponseErrorEvents : this.contentErrorEvents;
            this.eventTracker.sendErrorEvents(error, events);
        }
        catch (Throwable e$iv$iv) {
            switch (VideoPlayerController$sendErrorEvent$$inlined$handleExceptions$1$wm$TryKt$WhenMappings.$EnumSwitchMapping$0[strategy$iv$iv.ordinal()]) {
                case 1: {
                    void source$iv$iv;
                    StabilityHelper.logException((Object)source$iv$iv, (Throwable)e$iv$iv);
                    break;
                }
                case 2: {
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
    }

    public final void sendImpressionEvent$mobilefuse_video_player_release(@NotNull Function0<Unit> onComplete) {
        Intrinsics.checkNotNullParameter(onComplete, (String)"onComplete");
        SchedulersKt.getGlobalHandler().postDelayed(new Runnable(this, onComplete){
            final /* synthetic */ VideoPlayerController this$0;
            final /* synthetic */ Function0 $onComplete;

            /*
             * WARNING - void declaration
             */
            public final void run() {
                boolean $i$f$handleExceptions = false;
                String string = "[Automatically caught]";
                ExceptionHandlingStrategy strategy$iv$iv = ExceptionHandlingStrategy.LogAndIgnore;
                boolean $i$f$handleExceptions2 = false;
                try {
                    boolean bl = false;
                    VastEventTracker.sendEvents$default(this.this$0.getEventTracker(), VideoPlayerController.access$getImpressionEvents$p(this.this$0), null, 2, null);
                    VastOmidBridge vastOmidBridge = this.this$0.getOmidBridge();
                    if (vastOmidBridge != null) {
                        vastOmidBridge.signalAdImpressionEvent();
                    }
                    this.$onComplete.invoke();
                }
                catch (Throwable e$iv$iv) {
                    switch (VideoPlayerController$sendImpressionEvent$1$$special$$inlined$handleExceptions$1$wm$TryKt$WhenMappings.$EnumSwitchMapping$0[strategy$iv$iv.ordinal()]) {
                        case 1: {
                            void source$iv$iv;
                            StabilityHelper.logException((Object)source$iv$iv, (Throwable)e$iv$iv);
                            break;
                        }
                        case 2: {
                            break;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                }
            }
            {
                this.this$0 = videoPlayerController;
                this.$onComplete = function0;
            }
        }, 200L);
    }

    private final void sendClickTrackingEvent() {
        try {
            Object object = this.currentAdLinear;
            if (object == null || (object = ((VastLinear)object).getEvents(EventType.ClickTracking)) == null || (object = CollectionsKt.toMutableSet((Iterable)((Iterable)object))) == null) {
                return;
            }
            Object events = object;
            VastModel vastModel = this.vastModel;
            if (vastModel == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"vastModel");
            }
            Iterator<VastAd> parentAdsIterator = VastDataModelExtensionsKt.getAdsChainIterator(vastModel, true);
            while (parentAdsIterator.hasNext()) {
                VastLinear vastLinear;
                VastAd ad = parentAdsIterator.next();
                if (VastDataModelExtensionsKt.getFirstAdLinear(ad) == null) continue;
                VastLinear it = vastLinear;
                boolean bl = false;
                events.addAll((Collection)it.getEvents(EventType.ClickTracking));
            }
            VastEventTracker.sendEvents$default(this.eventTracker, (Set)events, null, 2, null);
        }
        catch (Throwable e) {
            StabilityHelper.logException((Object)this, (Throwable)e);
        }
    }

    public final void sendTrackingEvent(@NotNull VastTrackingEventType eventType) {
        block27: {
            Intrinsics.checkNotNullParameter((Object)((Object)eventType), (String)"eventType");
            try {
                Object object = this.currentAdLinear;
                if (object == null || (object = ((VastLinear)object).getEvents(EventType.Tracking, eventType.name())) == null || (object = CollectionsKt.toMutableSet((Iterable)((Iterable)object))) == null) {
                    return;
                }
                Object events = object;
                VastModel vastModel = this.vastModel;
                if (vastModel == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"vastModel");
                }
                Iterator<VastAd> parentAdsIterator = VastDataModelExtensionsKt.getAdsChainIterator(vastModel, true);
                while (parentAdsIterator.hasNext()) {
                    VastLinear vastLinear;
                    VastAd ad = parentAdsIterator.next();
                    if (VastDataModelExtensionsKt.getFirstAdLinear(ad) == null) continue;
                    VastLinear it = vastLinear;
                    boolean bl = false;
                    events.addAll((Collection)it.getEvents(EventType.Tracking, eventType.name()));
                }
                VastEventTracker.sendEvents$default(this.eventTracker, (Set)events, null, 2, null);
                if (this.omidBridge == null) break block27;
                switch (VideoPlayerController$WhenMappings.$EnumSwitchMapping$0[eventType.ordinal()]) {
                    case 1: {
                        VastOmidBridge vastOmidBridge = this.omidBridge;
                        if (vastOmidBridge != null) {
                            vastOmidBridge.start((float)this.player.getPlaybackDurationMillis() / 1000.0f, 1.0f);
                        }
                        break;
                    }
                    case 2: {
                        VastOmidBridge vastOmidBridge = this.omidBridge;
                        if (vastOmidBridge != null) {
                            vastOmidBridge.pause();
                        }
                        break;
                    }
                    case 3: {
                        VastOmidBridge vastOmidBridge = this.omidBridge;
                        if (vastOmidBridge != null) {
                            vastOmidBridge.resume();
                        }
                        break;
                    }
                    case 4: {
                        VastOmidBridge vastOmidBridge = this.omidBridge;
                        if (vastOmidBridge != null) {
                            vastOmidBridge.firstQuartile();
                        }
                        break;
                    }
                    case 5: {
                        VastOmidBridge vastOmidBridge = this.omidBridge;
                        if (vastOmidBridge != null) {
                            vastOmidBridge.midpoint();
                        }
                        break;
                    }
                    case 6: {
                        VastOmidBridge vastOmidBridge = this.omidBridge;
                        if (vastOmidBridge != null) {
                            vastOmidBridge.thirdQuartile();
                        }
                        break;
                    }
                    case 7: {
                        VastOmidBridge vastOmidBridge = this.omidBridge;
                        if (vastOmidBridge != null) {
                            vastOmidBridge.complete();
                        }
                        break;
                    }
                    case 8: {
                        VastOmidBridge vastOmidBridge = this.omidBridge;
                        if (vastOmidBridge != null) {
                            vastOmidBridge.skipped();
                        }
                        break;
                    }
                    case 9: {
                        VastOmidBridge vastOmidBridge = this.omidBridge;
                        if (vastOmidBridge != null) {
                            vastOmidBridge.mute();
                        }
                        break;
                    }
                    case 10: {
                        VastOmidBridge vastOmidBridge = this.omidBridge;
                        if (vastOmidBridge != null) {
                            vastOmidBridge.unmute();
                        }
                        break;
                    }
                    default: {
                        break;
                    }
                }
            }
            catch (Throwable e) {
                StabilityHelper.logException((Object)this, (Throwable)e);
            }
        }
    }

    public final void sendCompanionAdTrackingEvent(@NotNull VastCompanion vastCompanion, @NotNull VastTrackingEventType eventType) {
        Intrinsics.checkNotNullParameter((Object)vastCompanion, (String)"vastCompanion");
        Intrinsics.checkNotNullParameter((Object)((Object)eventType), (String)"eventType");
        try {
            Set<VastEvent> events = vastCompanion.getEvents(EventType.Tracking, eventType.name());
            VastEventTracker.sendEvents$default(this.eventTracker, events, null, 2, null);
        }
        catch (Throwable e) {
            StabilityHelper.logException((Object)this, (Throwable)e);
        }
    }

    public final void sendCompanionAdClickTrackingEvent(@NotNull VastCompanion vastCompanion) {
        Intrinsics.checkNotNullParameter((Object)vastCompanion, (String)"vastCompanion");
        try {
            Set<VastEvent> events = vastCompanion.getEvents(EventType.CompanionClickTracking);
            VastEventTracker.sendEvents$default(this.eventTracker, events, null, 2, null);
        }
        catch (Throwable e) {
            StabilityHelper.logException((Object)this, (Throwable)e);
        }
    }

    public final void prepareProgressTrackingEvents() {
        if (this.currentAd == null) {
            return;
        }
        if (this.currentAdLinear == null) {
            return;
        }
        try {
            this.progressTrackingEvents.clear();
            Object object = this.currentAdLinear;
            if (object == null || (object = ((VastLinear)object).getEvents(EventType.Tracking, VastTrackingEventType.progress.name())) == null || (object = CollectionsKt.toMutableSet((Iterable)((Iterable)object))) == null) {
                return;
            }
            Object events = object;
            VastModel vastModel = this.vastModel;
            if (vastModel == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"vastModel");
            }
            Iterator<VastAd> parentAdsIterator = VastDataModelExtensionsKt.getAdsChainIterator(vastModel, true);
            while (parentAdsIterator.hasNext()) {
                VastLinear vastLinear;
                VastAd ad = parentAdsIterator.next();
                if (VastDataModelExtensionsKt.getFirstAdLinear(ad) == null) continue;
                VastLinear it = vastLinear;
                boolean bl = false;
                events.addAll((Collection)it.getEvents(EventType.Tracking, VastTrackingEventType.progress.name()));
            }
            long videoDuration = this.player.getPlaybackDurationMillis();
            Iterator iterator = events.iterator();
            while (iterator.hasNext()) {
                VastTime offset;
                VastEvent event = (VastEvent)iterator.next();
                if (event.getOffset() == null) continue;
                long keyTime = offset.getValueInMillisForDuration(videoDuration);
                this.progressTrackingEvents.add((android.util.Pair<Long, VastEvent>)new android.util.Pair((Object)keyTime, (Object)event));
            }
            this.updateNextProgressEventPosition();
        }
        catch (Throwable e) {
            StabilityHelper.logException((Object)this, (Throwable)e);
        }
    }

    private final void updateNextProgressEventPosition() {
        try {
            if (this.progressTrackingEvents.isEmpty()) {
                this.nextProgressEventPosition = Long.MAX_VALUE;
                return;
            }
            long lowestPosition = Long.MAX_VALUE;
            for (android.util.Pair<Long, VastEvent> item : this.progressTrackingEvents) {
                Long position = (Long)item.first;
                if (position >= lowestPosition) continue;
                Long l = position;
                Intrinsics.checkNotNullExpressionValue((Object)l, (String)"position");
                lowestPosition = l;
            }
            this.nextProgressEventPosition = lowestPosition;
        }
        catch (Throwable e) {
            StabilityHelper.logException((Object)this, (Throwable)e);
        }
    }

    private final void sendAwaitingProgressEvents() {
        try {
            Set eventsToSend = new LinkedHashSet();
            Set events = new LinkedHashSet();
            for (android.util.Pair<Long, VastEvent> pair : this.progressTrackingEvents) {
                if (((Number)pair.first).longValue() > this.nextProgressEventPosition) continue;
                eventsToSend.add(pair);
            }
            if (eventsToSend.isEmpty()) {
                return;
            }
            for (android.util.Pair pair : eventsToSend) {
                this.progressTrackingEvents.remove(pair);
                Object object = pair.second;
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"item.second");
                events.add(object);
            }
            VastEventTracker.sendEvents$default(this.eventTracker, events, null, 2, null);
            this.updateNextProgressEventPosition();
        }
        catch (Throwable e) {
            StabilityHelper.logException((Object)this, (Throwable)e);
        }
    }

    private final Set<VastEvent> getVastContentEvents(EventType eventType) {
        Set events = new LinkedHashSet();
        try {
            VastModel vastModel = this.vastModel;
            if (vastModel == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"vastModel");
            }
            List<VastTag> tagChain = vastModel.getVastTagChain();
            for (VastTag tag : tagChain) {
                VastAdContent vastAdContent;
                VastAd vastAd;
                if (VastDataModelExtensionsKt.getFirstAd(tag) == null) continue;
                if (vastAd.getContent() == null) continue;
                VastAdContent it = vastAdContent;
                boolean bl = false;
                events.addAll((Collection)it.getEvents(eventType));
            }
        }
        catch (Throwable e) {
            StabilityHelper.logException((Object)this, (Throwable)e);
        }
        return events;
    }

    private final Set<VastEvent> getNoAdResponseErrorEvents() {
        Set events = new LinkedHashSet();
        try {
            VastModel vastModel = this.vastModel;
            if (vastModel == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"vastModel");
            }
            for (VastTag tag : vastModel.getVastTagChain()) {
                events.addAll((Collection)tag.getEvents(EventType.Error));
            }
        }
        catch (Throwable e) {
            StabilityHelper.logException((Object)this, (Throwable)e);
        }
        return events;
    }

    @Nullable
    public final VastClickThrough getClickThrough() {
        try {
            Object object = this.currentAdLinear;
            if (object != null && (object = ((VastLinear)object).getClickThrough()) != null) {
                Object object2;
                Object it = object2 = object;
                boolean bl = false;
                return it;
            }
            VastClickThrough clickThrough2 = null;
            VastModel vastModel = this.vastModel;
            if (vastModel == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"vastModel");
            }
            Iterator<VastAd> parentAdsIterator = VastDataModelExtensionsKt.getAdsChainIterator(vastModel, true);
            while (parentAdsIterator.hasNext()) {
                VastClickThrough vastClickThrough;
                VastAd parentAd = parentAdsIterator.next();
                VastLinear vastLinear = VastDataModelExtensionsKt.getFirstAdLinear(parentAd);
                VastClickThrough vastClickThrough2 = clickThrough2 = vastLinear != null ? vastLinear.getClickThrough() : null;
                if (vastClickThrough2 == null) continue;
                VastClickThrough it = vastClickThrough = vastClickThrough2;
                boolean bl = false;
                return it;
            }
        }
        catch (Throwable e) {
            StabilityHelper.logException((Object)this, (Throwable)e);
        }
        return null;
    }

    @Nullable
    public final VastTime getAdDuration() {
        VastLinear vastLinear = this.currentAdLinear;
        return vastLinear != null ? vastLinear.getDuration() : null;
    }

    @Nullable
    public final VastTime getAdSkipOffset() {
        try {
            Object object = this.currentAdLinear;
            if (object != null && (object = ((VastLinear)object).getSkipOffset()) != null) {
                Object object2;
                Object it = object2 = object;
                boolean bl = false;
                return it;
            }
            VastModel vastModel = this.vastModel;
            if (vastModel == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"vastModel");
            }
            List<VastTag> tagChain = vastModel.getVastTagChain();
            for (VastTag vastTag : tagChain) {
                Object object3 = VastDataModelExtensionsKt.getFirstAd(vastTag);
                VastTime skipOffset = object3 != null && (object3 = VastDataModelExtensionsKt.getFirstAdLinear((VastAd)object3)) != null ? ((VastLinear)object3).getSkipOffset() : null;
                if (skipOffset == null) continue;
                return skipOffset;
            }
        }
        catch (Throwable e) {
            StabilityHelper.logException((Object)this, (Throwable)e);
        }
        return null;
    }

    public final void destroy() {
        if (this.omidBridge != null) {
            this.omidBridge = null;
        }
    }

    @NotNull
    public final VideoPlayerCapabilities getPlayerCapabilities() {
        return this.player.getPlayerCapabilities();
    }

    @NotNull
    public final VideoPlayer getPlayer() {
        return this.player;
    }

    public VideoPlayerController(@NotNull Context context, @NotNull VideoPlayer player) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        this.player = player;
        this.handler = new Handler(Looper.getMainLooper());
        this.progressTrackingEvents = new ArrayList();
        this.currentIcons = new ArrayList();
        this.noAdResponseErrorEvents = new LinkedHashSet();
        this.contentErrorEvents = new LinkedHashSet();
        this.impressionEvents = new LinkedHashSet();
        this.nextProgressEventPosition = Long.MAX_VALUE;
        Context context2 = context.getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context.applicationContext");
        this.context = context2;
        this.eventTracker = new VastEventTracker(context, this);
    }

    public static final /* synthetic */ VastMediaFile access$getCurrentMediaFile$p(VideoPlayerController $this) {
        return $this.currentMediaFile;
    }

    public static final /* synthetic */ void access$setCurrentMediaFile$p(VideoPlayerController $this, VastMediaFile vastMediaFile) {
        $this.currentMediaFile = vastMediaFile;
    }

    public static final /* synthetic */ Set access$getImpressionEvents$p(VideoPlayerController $this) {
        return $this.impressionEvents;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/mobilefuse/videoplayer/VideoPlayerController$Companion;", "", "()V", "OM_IMPRESSION_EVENT_DELAY_MILLIS", "", "mobilefuse-video-player_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

