/*
 * Decompiled with CFR 0.152.
 */
package com.mobilefuse.videoplayer.controller;

import android.app.Activity;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.webkit.WebView;
import android.widget.PopupWindow;
import com.mobilefuse.sdk.DebuggingKt;
import com.mobilefuse.sdk.StabilityHelper;
import com.mobilefuse.videoplayer.VideoPlayer;
import com.mobilefuse.videoplayer.controller.BaseModuleController;
import com.mobilefuse.videoplayer.controller.ExternalFullscreenControlBridge;
import com.mobilefuse.videoplayer.controller.FullscreenChangedListener;
import com.mobilefuse.videoplayer.controller.FullscreenController;
import com.mobilefuse.videoplayer.controller.FullscreenControllerImpl$setExternalFullscreen$;
import com.mobilefuse.videoplayer.endcard.EndCardPresenter;
import com.mobilefuse.videoplayer.model.VastPlayerCapability;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\r\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u0005H\u0002J\u0010\u0010\u001f\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\fH\u0016J\r\u0010!\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\b\"J\b\u0010#\u001a\u00020\u001cH\u0002J\r\u0010$\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\b%J\u0010\u0010&\u001a\u00020\u001c2\u0006\u0010\u000e\u001a\u00020\u0005H\u0002J\u0010\u0010'\u001a\u00020\u001c2\u0006\u0010\u000e\u001a\u00020\u0005H\u0016J\b\u0010(\u001a\u00020\u001cH\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000e\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0007R$\u0010\u0010\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005@PX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0007\"\u0004\b\u0012\u0010\tR\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/mobilefuse/videoplayer/controller/FullscreenControllerImpl;", "Lcom/mobilefuse/videoplayer/controller/BaseModuleController;", "Lcom/mobilefuse/videoplayer/controller/FullscreenController;", "()V", "enterFullscreenOnVideoTap", "", "getEnterFullscreenOnVideoTap", "()Z", "setEnterFullscreenOnVideoTap", "(Z)V", "externalFullscreenControl", "externalFullscreenControlBridge", "Lcom/mobilefuse/videoplayer/controller/ExternalFullscreenControlBridge;", "<set-?>", "fullscreen", "getFullscreen", "fullscreenAllowed", "getFullscreenAllowed", "setFullscreenAllowed$mobilefuse_video_player_release", "fullscreenChangedListener", "Lcom/mobilefuse/videoplayer/controller/FullscreenChangedListener;", "getFullscreenChangedListener", "()Lcom/mobilefuse/videoplayer/controller/FullscreenChangedListener;", "setFullscreenChangedListener", "(Lcom/mobilefuse/videoplayer/controller/FullscreenChangedListener;)V", "fullscreenWindow", "Landroid/widget/PopupWindow;", "applyFullscreenToPlayer", "", "changeFullscreenState", "changedToFullscreen", "enableExternalFullscreenControl", "bridge", "enableFullscreenButton", "enableFullscreenButton$mobilefuse_video_player_release", "executeFullscreenEnter", "executeFullscreenExit", "executeFullscreenExit$mobilefuse_video_player_release", "setExternalFullscreen", "setFullscreen", "setFullscreenAllowed", "mobilefuse-video-player_release"})
public final class FullscreenControllerImpl
extends BaseModuleController
implements FullscreenController {
    @Nullable
    private FullscreenChangedListener fullscreenChangedListener;
    private boolean fullscreenAllowed;
    private boolean fullscreen;
    private boolean enterFullscreenOnVideoTap;
    private boolean externalFullscreenControl;
    private ExternalFullscreenControlBridge externalFullscreenControlBridge;
    private PopupWindow fullscreenWindow;

    @Override
    @Nullable
    public FullscreenChangedListener getFullscreenChangedListener() {
        return this.fullscreenChangedListener;
    }

    @Override
    public void setFullscreenChangedListener(@Nullable FullscreenChangedListener fullscreenChangedListener) {
        this.fullscreenChangedListener = fullscreenChangedListener;
    }

    @Override
    public boolean getFullscreenAllowed() {
        return this.fullscreenAllowed;
    }

    public void setFullscreenAllowed$mobilefuse_video_player_release(boolean bl) {
        this.fullscreenAllowed = bl;
    }

    @Override
    public boolean getFullscreen() {
        return this.fullscreen;
    }

    @Override
    public boolean getEnterFullscreenOnVideoTap() {
        return this.enterFullscreenOnVideoTap;
    }

    @Override
    public void setEnterFullscreenOnVideoTap(boolean bl) {
        this.enterFullscreenOnVideoTap = bl;
    }

    @Override
    public void enableExternalFullscreenControl(@NotNull ExternalFullscreenControlBridge bridge) {
        Intrinsics.checkNotNullParameter((Object)bridge, (String)"bridge");
        this.externalFullscreenControl = true;
        this.externalFullscreenControlBridge = bridge;
    }

    @Override
    public void setFullscreen(boolean fullscreen) {
        if (this.getVideoPlayer().isDestroyed$mobilefuse_video_player_release()) {
            return;
        }
        try {
            if (fullscreen && this.getEndCardPresenter() != null) {
                return;
            }
            if (this.externalFullscreenControl) {
                this.setExternalFullscreen(fullscreen);
                return;
            }
            this.changeFullscreenState(fullscreen);
            this.applyFullscreenToPlayer();
        }
        catch (Throwable e) {
            StabilityHelper.logException((Object)this, (Throwable)e);
        }
    }

    @Override
    public void setFullscreenAllowed() {
        if (this.getVideoPlayer().isDestroyed$mobilefuse_video_player_release()) {
            return;
        }
        try {
            this.setFullscreenAllowed$mobilefuse_video_player_release(true);
            this.getVideoPlayer().getPlayerCapabilities().changeCapability(VastPlayerCapability.FULLSCREEN, true);
            if (this.getPlayerState() == VideoPlayer.PlayerState.PLAYING || this.getPlayerState() == VideoPlayer.PlayerState.PAUSED) {
                this.enableFullscreenButton$mobilefuse_video_player_release();
            }
        }
        catch (Throwable e) {
            StabilityHelper.logException((Object)this, (Throwable)e);
        }
    }

    private final void setExternalFullscreen(boolean fullscreen) {
        if (this.getVideoPlayer().isDestroyed$mobilefuse_video_player_release()) {
            return;
        }
        try {
            WebView it;
            Object object;
            if (this.externalFullscreenControlBridge == null) {
                return;
            }
            WebView webView = this.getWebView();
            if (webView != null) {
                it = object = webView;
                boolean bl = false;
                it.setVisibility(4);
            }
            ExternalFullscreenControlBridge externalFullscreenControlBridge = this.externalFullscreenControlBridge;
            if (externalFullscreenControlBridge != null) {
                it = object = externalFullscreenControlBridge;
                boolean bl = false;
                it.onFullscreenChangeStarted(fullscreen, (Function0<Unit>)((Function0)new Function0<Unit>(this, fullscreen){
                    final /* synthetic */ FullscreenControllerImpl this$0;
                    final /* synthetic */ boolean $fullscreen$inlined;
                    {
                        this.this$0 = fullscreenControllerImpl;
                        this.$fullscreen$inlined = bl;
                        super(0);
                    }

                    public final void invoke() {
                        try {
                            if (this.this$0.getVideoPlayer().isDestroyed$mobilefuse_video_player_release()) {
                                return;
                            }
                            FullscreenControllerImpl.access$changeFullscreenState(this.this$0, this.$fullscreen$inlined);
                            WebView webView = this.this$0.getWebView();
                            if (webView != null) {
                                WebView webView2;
                                WebView itWebView = webView2 = webView;
                                boolean bl = false;
                                itWebView.setAlpha(0.0f);
                                itWebView.setVisibility(0);
                            }
                            this.this$0.getVideoPlayer().getPlayerHandler$mobilefuse_video_player_release().postDelayed(new Runnable(this){
                                final /* synthetic */ setExternalFullscreen$$inlined$let$lambda$1 this$0;
                                {
                                    this.this$0 = var1_1;
                                }

                                public final void run() {
                                    try {
                                        WebView webView = this.this$0.this$0.getWebView();
                                        if (webView != null) {
                                            WebView webView2;
                                            WebView itWebView = webView2 = webView;
                                            boolean bl = false;
                                            itWebView.setAlpha(1.0f);
                                        }
                                    }
                                    catch (Throwable e) {
                                        StabilityHelper.logException((Object)this.this$0.this$0, (Throwable)e);
                                    }
                                }
                            }, 300L);
                        }
                        catch (Throwable e) {
                            StabilityHelper.logException((Object)this.this$0, (Throwable)e);
                        }
                    }
                }));
            }
        }
        catch (Throwable e) {
            StabilityHelper.logException((Object)this, (Throwable)e);
        }
    }

    public final void enableFullscreenButton$mobilefuse_video_player_release() {
        try {
            if (this.getVideoPlayer().isDestroyed$mobilefuse_video_player_release()) {
                return;
            }
            if (!this.getFullscreenAllowed()) {
                return;
            }
            this.callJsBridgeCmd("vast.bridge.setFullscreenAllowed();");
            if (this.getFullscreen()) {
                this.setFullscreen(this.getFullscreen());
            }
        }
        catch (Throwable e) {
            StabilityHelper.logException((Object)this, (Throwable)e);
        }
    }

    private final void applyFullscreenToPlayer() {
        if (this.getVideoPlayer().isDestroyed$mobilefuse_video_player_release()) {
            return;
        }
        try {
            DebuggingKt.logDebug$default((Object)this, (String)("Apply fullscreen: " + this.getFullscreen()), null, (int)2, null);
            if (!this.getVideoPlayer().getPlayer$mobilefuse_video_player_release().getCanApplyFullscreen()) {
                return;
            }
            if (this.getFullscreen()) {
                this.executeFullscreenEnter();
            } else {
                this.executeFullscreenExit$mobilefuse_video_player_release();
            }
        }
        catch (Throwable e) {
            StabilityHelper.logException((Object)this, (Throwable)e);
        }
    }

    private final void changeFullscreenState(boolean changedToFullscreen) {
        if (this.getVideoPlayer().isDestroyed$mobilefuse_video_player_release()) {
            return;
        }
        try {
            if (this.getFullscreen() == changedToFullscreen) {
                return;
            }
            this.fullscreen = changedToFullscreen;
            this.getVideoPlayer().getController$mobilefuse_video_player_release().onFullscreenChanged();
            EndCardPresenter endCardPresenter = this.getEndCardPresenter();
            if (endCardPresenter != null) {
                endCardPresenter.onFullscreenChanged$mobilefuse_video_player_release(changedToFullscreen);
            }
            FullscreenChangedListener fullscreenChangedListener = this.getFullscreenChangedListener();
            if (fullscreenChangedListener != null) {
                fullscreenChangedListener.onFullscreenChanged(this.getFullscreen());
            }
            this.callJsBridgeCmd("vast.bridge.setFullscreen(" + this.getFullscreen() + ");");
        }
        catch (Throwable e) {
            StabilityHelper.logException((Object)this, (Throwable)e);
        }
    }

    private final void executeFullscreenEnter() {
        if (this.getVideoPlayer().isDestroyed$mobilefuse_video_player_release()) {
            return;
        }
        try {
            PopupWindow window;
            if (this.fullscreenWindow != null) {
                return;
            }
            Activity activity = this.getVideoPlayer().getRenderingActivity$mobilefuse_video_player_release();
            if (activity == null) {
                return;
            }
            Activity renderingActivity = activity;
            VideoPlayer videoPlayer = this.getVideoPlayer();
            ViewGroup.LayoutParams layoutParams = this.getVideoPlayer().getMainContainer$mobilefuse_video_player_release().getLayoutParams();
            Intrinsics.checkNotNullExpressionValue((Object)layoutParams, (String)"videoPlayer.mainContainer.layoutParams");
            videoPlayer.setMainContainerParams$mobilefuse_video_player_release(layoutParams);
            this.getVideoPlayer().removeView((View)this.getVideoPlayer().getMainContainer$mobilefuse_video_player_release());
            this.fullscreenWindow = window = new PopupWindow((View)this.getVideoPlayer().getMainContainer$mobilefuse_video_player_release(), -1, -1);
            Window window2 = renderingActivity.getWindow();
            Intrinsics.checkNotNullExpressionValue((Object)window2, (String)"renderingActivity.window");
            View view = window2.getDecorView();
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"renderingActivity.window.decorView");
            View view2 = view.getRootView();
            Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"renderingActivity.window.decorView.rootView");
            View rootView = view2;
            window.showAtLocation(rootView, 48, 0, 0);
            this.getVideoPlayer().setVisibility(4);
        }
        catch (Throwable e) {
            StabilityHelper.logException((Object)this, (Throwable)e);
        }
    }

    public final void executeFullscreenExit$mobilefuse_video_player_release() {
        if (this.getVideoPlayer().isDestroyed$mobilefuse_video_player_release()) {
            return;
        }
        try {
            PopupWindow popupWindow = this.fullscreenWindow;
            if (popupWindow == null) {
                return;
            }
            PopupWindow fullscreenWindow = popupWindow;
            fullscreenWindow.dismiss();
            this.fullscreenWindow = null;
            this.getVideoPlayer().addView((View)this.getVideoPlayer().getMainContainer$mobilefuse_video_player_release(), this.getVideoPlayer().getMainContainerParams$mobilefuse_video_player_release());
            this.getVideoPlayer().setVisibility(0);
        }
        catch (Throwable e) {
            StabilityHelper.logException((Object)this, (Throwable)e);
        }
    }

    public static final /* synthetic */ void access$changeFullscreenState(FullscreenControllerImpl $this, boolean changedToFullscreen) {
        $this.changeFullscreenState(changedToFullscreen);
    }
}

