/*
 * Decompiled with CFR 0.152.
 */
package com.mobilefuse.videoplayer.controller;

import android.os.Handler;
import android.os.Looper;
import com.mobilefuse.sdk.StabilityHelper;
import com.mobilefuse.videoplayer.VideoPlayer;
import com.mobilefuse.videoplayer.VideoPlayerController;
import com.mobilefuse.videoplayer.controller.BaseModuleController;
import com.mobilefuse.videoplayer.controller.PlaybackController;
import com.mobilefuse.videoplayer.model.VastTrackingEventType;
import java.util.Timer;
import java.util.TimerTask;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\fJ>\u0010\u0018\u001a\u00020\u001526\u0010\u0019\u001a2\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b(\u001d\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b(\u0017\u0012\u0004\u0012\u00020\u00150\u001aJ\u0006\u0010\u001e\u001a\u00020\u0015R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0010\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/mobilefuse/videoplayer/controller/PlaybackController;", "Lcom/mobilefuse/videoplayer/controller/BaseModuleController;", "()V", "firstQuartile", "", "handler", "Landroid/os/Handler;", "getHandler", "()Landroid/os/Handler;", "midpoint", "thirdQuartile", "<set-?>", "", "videoDuration", "getVideoDuration", "()J", "videoPosition", "getVideoPosition", "videoWatcher", "Ljava/util/Timer;", "onVideoProgress", "", "position", "duration", "startUpdating", "updateBlock", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "progress", "stopUpdating", "mobilefuse-video-player_release"})
public final class PlaybackController
extends BaseModuleController {
    @NotNull
    private final Handler handler = new Handler(Looper.getMainLooper());
    private long videoDuration = -1L;
    private long videoPosition;
    private boolean firstQuartile;
    private boolean midpoint;
    private boolean thirdQuartile;
    private Timer videoWatcher;

    @NotNull
    public final Handler getHandler() {
        return this.handler;
    }

    public final long getVideoDuration() {
        return this.videoDuration;
    }

    public final long getVideoPosition() {
        return this.videoPosition;
    }

    public final void startUpdating(@NotNull Function2<? super Long, ? super Long, Unit> updateBlock) {
        block0: {
            Intrinsics.checkNotNullParameter(updateBlock, (String)"updateBlock");
            Timer timer = this.videoWatcher = new Timer();
            if (timer == null) break block0;
            timer.schedule(new TimerTask(this, updateBlock){
                final /* synthetic */ PlaybackController this$0;
                final /* synthetic */ Function2 $updateBlock;

                public void run() {
                    this.this$0.getHandler().post(new Runnable(this){
                        final /* synthetic */ startUpdating.1 this$0;

                        public final void run() {
                            try {
                                if (this.this$0.this$0.getPlayerState() != VideoPlayer.PlayerState.PLAYING) {
                                    return;
                                }
                                this.this$0.this$0.onVideoProgress(this.this$0.this$0.getVideoPlayer().getCurrentPlaybackPositionMillis(), this.this$0.this$0.getVideoPlayer().getPlaybackDurationMillis());
                                this.this$0.$updateBlock.invoke((Object)this.this$0.this$0.getVideoPosition(), (Object)this.this$0.this$0.getVideoDuration());
                            }
                            catch (Throwable e) {
                                StabilityHelper.logException((Object)this.this$0, (Throwable)e);
                            }
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    });
                }
                {
                    this.this$0 = this$0;
                    this.$updateBlock = $captured_local_variable$1;
                }
            }, 0L, 50L);
        }
    }

    public final void stopUpdating() {
        Timer timer = this.videoWatcher;
        if (timer != null) {
            Timer timer2;
            Timer $this$apply = timer2 = timer;
            boolean bl = false;
            $this$apply.cancel();
            $this$apply.purge();
        }
        this.videoWatcher = null;
    }

    public final void onVideoProgress(long position, long duration) {
        block6: {
            this.videoPosition = position;
            VideoPlayerController controller = this.getVideoPlayer().getController$mobilefuse_video_player_release();
            if (this.videoDuration == -1L) {
                this.videoDuration = duration;
                controller.prepareProgressTrackingEvents();
            }
            controller.onPlaying(this.videoPosition);
            float percentComplete = (float)this.videoPosition / (float)duration;
            if (percentComplete > 0.25f && !this.firstQuartile) {
                this.firstQuartile = true;
                controller.sendTrackingEvent(VastTrackingEventType.firstQuartile);
                VideoPlayer.PlaybackListener playbackListener = this.getVideoPlayer().getPlaybackListener$mobilefuse_video_player_release();
                if (playbackListener != null) {
                    playbackListener.onVideoFirstQuartile();
                }
            }
            if (percentComplete > 0.5f && !this.midpoint) {
                this.midpoint = true;
                controller.sendTrackingEvent(VastTrackingEventType.midpoint);
                VideoPlayer.PlaybackListener playbackListener = this.getVideoPlayer().getPlaybackListener$mobilefuse_video_player_release();
                if (playbackListener != null) {
                    playbackListener.onVideoMidpoint();
                }
            }
            if (!(percentComplete > 0.75f) || this.thirdQuartile) break block6;
            this.thirdQuartile = true;
            controller.sendTrackingEvent(VastTrackingEventType.thirdQuartile);
            VideoPlayer.PlaybackListener playbackListener = this.getVideoPlayer().getPlaybackListener$mobilefuse_video_player_release();
            if (playbackListener != null) {
                playbackListener.onVideoThirdQuartile();
            }
        }
    }

    public static final /* synthetic */ long access$getVideoPosition$p(PlaybackController $this) {
        return $this.videoPosition;
    }

    public static final /* synthetic */ void access$setVideoPosition$p(PlaybackController $this, long l) {
        $this.videoPosition = l;
    }

    public static final /* synthetic */ long access$getVideoDuration$p(PlaybackController $this) {
        return $this.videoDuration;
    }

    public static final /* synthetic */ void access$setVideoDuration$p(PlaybackController $this, long l) {
        $this.videoDuration = l;
    }
}

