/*
 * Decompiled with CFR 0.152.
 */
package com.mobilefuse.videoplayer.media;

import android.content.Context;
import android.media.AudioAttributes;
import android.media.MediaPlayer;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.FrameLayout;
import com.mobilefuse.sdk.DebuggingKt;
import com.mobilefuse.sdk.StabilityHelper;
import com.mobilefuse.sdk.concurrency.SchedulersKt;
import com.mobilefuse.videoplayer.media.MediaPlayerState;
import com.mobilefuse.videoplayer.media.MobileFuseVideoSurfaceView;
import com.mobilefuse.videoplayer.media.MobileFuseVideoTextureView;
import com.mobilefuse.videoplayer.media.VideoViewInterface;
import com.mobilefuse.videoplayer.media.ViewType;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0007\n\u0002\b\u0010\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010;\u001a\u00020\u0018H\u0002J\u0010\u0010<\u001a\u00020\u00062\u0006\u0010=\u001a\u00020\u001eH\u0002J\u0006\u0010>\u001a\u00020\u0018J\u0006\u0010?\u001a\u00020\u0018J\u0006\u0010@\u001a\u00020\u0018J\b\u0010A\u001a\u00020\u0018H\u0002J\u0006\u0010B\u001a\u00020\u0018J\u0006\u0010C\u001a\u00020\u0018J&\u0010D\u001a\u00020\u00182\u0006\u0010E\u001a\u00020F2\b\b\u0002\u0010.\u001a\u00020-2\f\u0010G\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u0011\u0010\u000b\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\bR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010R\u0011\u0010\u0013\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\bR\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001e\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u001d\u001a\u00020\u001e@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R(\u0010\"\u001a\u0010\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u0018\u0018\u00010#X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u0010\u0010(\u001a\u0004\u0018\u00010)X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010.\u001a\u00020-2\u0006\u0010,\u001a\u00020-@FX\u0086\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b/\u00100\u001a\u0004\b1\u00102\"\u0004\b3\u00104R$\u00106\u001a\u0002052\u0006\u0010,\u001a\u000205@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u00108\"\u0004\b9\u0010:\u00a8\u0006H"}, d2={"Lcom/mobilefuse/videoplayer/media/MobileFusePlayer;", "Landroid/widget/FrameLayout;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "canApplyFullscreen", "", "getCanApplyFullscreen", "()Z", "canPause", "getCanPause", "canPlay", "getCanPlay", "currentPosition", "", "getCurrentPosition", "()I", "duration", "getDuration", "isDestroyed", "mediaPlayer", "Landroid/media/MediaPlayer;", "playbackCompletionListener", "Lkotlin/Function0;", "", "getPlaybackCompletionListener", "()Lkotlin/jvm/functions/Function0;", "setPlaybackCompletionListener", "(Lkotlin/jvm/functions/Function0;)V", "<set-?>", "Lcom/mobilefuse/videoplayer/media/MediaPlayerState;", "playerState", "getPlayerState", "()Lcom/mobilefuse/videoplayer/media/MediaPlayerState;", "playerStateChangeListener", "Lkotlin/Function1;", "getPlayerStateChangeListener", "()Lkotlin/jvm/functions/Function1;", "setPlayerStateChangeListener", "(Lkotlin/jvm/functions/Function1;)V", "videoView", "Lcom/mobilefuse/videoplayer/media/VideoViewInterface;", "videoViewParams", "Landroid/widget/FrameLayout$LayoutParams;", "value", "Lcom/mobilefuse/videoplayer/media/ViewType;", "viewType", "getViewType$annotations", "()V", "getViewType", "()Lcom/mobilefuse/videoplayer/media/ViewType;", "setViewType", "(Lcom/mobilefuse/videoplayer/media/ViewType;)V", "", "volume", "getVolume", "()F", "setVolume", "(F)V", "applyViewType", "changePlayerState", "newState", "destroy", "onBecameInvisible", "onBecameVisible", "onMediaPlayerPrepared", "pause", "play", "prepare", "uri", "", "prepareCompletedAction", "mobilefuse-video-player_release"})
public final class MobileFusePlayer
extends FrameLayout {
    @NotNull
    private MediaPlayerState playerState;
    private final MediaPlayer mediaPlayer;
    private VideoViewInterface videoView;
    private final FrameLayout.LayoutParams videoViewParams;
    @Nullable
    private Function0<Unit> playbackCompletionListener;
    @Nullable
    private Function1<? super MediaPlayerState, Unit> playerStateChangeListener;
    @NotNull
    private ViewType viewType;
    private float volume;

    @NotNull
    public final MediaPlayerState getPlayerState() {
        return this.playerState;
    }

    @Nullable
    public final Function0<Unit> getPlaybackCompletionListener() {
        return this.playbackCompletionListener;
    }

    public final void setPlaybackCompletionListener(@Nullable Function0<Unit> function0) {
        this.playbackCompletionListener = function0;
    }

    @Nullable
    public final Function1<MediaPlayerState, Unit> getPlayerStateChangeListener() {
        return this.playerStateChangeListener;
    }

    public final void setPlayerStateChangeListener(@Nullable Function1<? super MediaPlayerState, Unit> function1) {
        this.playerStateChangeListener = function1;
    }

    public final void prepare(@NotNull String uri, @NotNull ViewType viewType, @NotNull Function0<Unit> prepareCompletedAction) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter((Object)((Object)viewType), (String)"viewType");
        Intrinsics.checkNotNullParameter(prepareCompletedAction, (String)"prepareCompletedAction");
        if (!this.changePlayerState(MediaPlayerState.PREPARING)) {
            return;
        }
        this.setViewType(viewType);
        try {
            if (Build.VERSION.SDK_INT > 21) {
                this.mediaPlayer.setAudioAttributes(new AudioAttributes.Builder().setContentType(3).setUsage(1).build());
            }
            this.mediaPlayer.setOnErrorListener(new MediaPlayer.OnErrorListener(this){
                final /* synthetic */ MobileFusePlayer this$0;

                public final boolean onError(MediaPlayer mp, int what, int extra) {
                    DebuggingKt.logDebug$default((Object)((Object)this.this$0), (String)"MediaPlayer onError", null, (int)2, null);
                    return MobileFusePlayer.access$changePlayerState(this.this$0, MediaPlayerState.ERROR);
                }
                {
                    this.this$0 = mobileFusePlayer;
                }
            });
            this.mediaPlayer.setOnCompletionListener(new MediaPlayer.OnCompletionListener(this){
                final /* synthetic */ MobileFusePlayer this$0;

                public final void onCompletion(MediaPlayer it) {
                    block0: {
                        MobileFusePlayer.access$changePlayerState(this.this$0, MediaPlayerState.COMPLETED);
                        Function0<Unit> function0 = this.this$0.getPlaybackCompletionListener();
                        if (function0 == null) break block0;
                        Unit cfr_ignored_0 = (Unit)function0.invoke();
                    }
                }
                {
                    this.this$0 = mobileFusePlayer;
                }
            });
            this.mediaPlayer.setOnPreparedListener(new MediaPlayer.OnPreparedListener(this, prepareCompletedAction){
                final /* synthetic */ MobileFusePlayer this$0;
                final /* synthetic */ Function0 $prepareCompletedAction;

                public final void onPrepared(MediaPlayer it) {
                    if (this.this$0.isDestroyed()) {
                        return;
                    }
                    MobileFusePlayer.access$onMediaPlayerPrepared(this.this$0);
                    this.$prepareCompletedAction.invoke();
                }
                {
                    this.this$0 = mobileFusePlayer;
                    this.$prepareCompletedAction = function0;
                }
            });
            this.mediaPlayer.setScreenOnWhilePlaying(true);
            SchedulersKt.safelyRunOnBgThread$default(null, (Function0)((Function0)new Function0<Unit>(this, uri){
                final /* synthetic */ MobileFusePlayer this$0;
                final /* synthetic */ String $uri;

                public final void invoke() {
                    MobileFusePlayer.access$getMediaPlayer$p(this.this$0).setDataSource(this.$uri);
                    MobileFusePlayer.access$getMediaPlayer$p(this.this$0).prepareAsync();
                }
                {
                    this.this$0 = mobileFusePlayer;
                    this.$uri = string;
                    super(0);
                }
            }), (int)1, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static /* synthetic */ void prepare$default(MobileFusePlayer mobileFusePlayer, String string, ViewType viewType, Function0 function0, int n, Object object) {
        if ((n & 2) != 0) {
            viewType = ViewType.SURFACE_VIEW;
        }
        mobileFusePlayer.prepare(string, viewType, (Function0<Unit>)function0);
    }

    private final void onMediaPlayerPrepared() {
        if (!this.changePlayerState(MediaPlayerState.PREPARED)) {
            return;
        }
        this.applyViewType();
    }

    public static /* synthetic */ void getViewType$annotations() {
    }

    @NotNull
    public final ViewType getViewType() {
        return this.viewType;
    }

    public final void setViewType(@NotNull ViewType value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        if (this.viewType == value) {
            return;
        }
        this.viewType = value;
        this.applyViewType();
    }

    private final void applyViewType() {
        VideoViewInterface videoViewInterface;
        if (!this.getCanPlay() && !this.getCanPause()) {
            return;
        }
        VideoViewInterface videoViewInterface2 = this.videoView;
        if (videoViewInterface2 != null) {
            VideoViewInterface videoViewInterface3;
            VideoViewInterface it = videoViewInterface3 = videoViewInterface2;
            boolean bl = false;
            this.mediaPlayer.setDisplay(null);
            this.mediaPlayer.setSurface(null);
            it.destroy();
            VideoViewInterface videoViewInterface4 = it;
            if (videoViewInterface4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.view.View");
            }
            this.removeView((View)videoViewInterface4);
            this.videoView = null;
        }
        if (this.viewType == ViewType.SURFACE_VIEW) {
            Context context = this.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
            videoViewInterface = new MobileFuseVideoSurfaceView(context, this.mediaPlayer);
        } else {
            Context context = this.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
            videoViewInterface = new MobileFuseVideoTextureView(context, this.mediaPlayer);
        }
        this.videoView = videoViewInterface;
    }

    public final void onBecameInvisible() {
        block3: {
            VideoViewInterface videoViewInterface = this.videoView;
            if (!(videoViewInterface instanceof View)) {
                videoViewInterface = null;
            }
            View view = (View)videoViewInterface;
            if (view == null) {
                return;
            }
            View view2 = view;
            ViewParent viewParent = view2.getParent();
            if (!(viewParent instanceof ViewGroup)) {
                viewParent = null;
            }
            ViewGroup viewGroup = (ViewGroup)viewParent;
            if (viewGroup == null) break block3;
            viewGroup.removeView(view2);
        }
    }

    public final void onBecameVisible() {
        VideoViewInterface videoViewInterface = this.videoView;
        if (!(videoViewInterface instanceof View)) {
            videoViewInterface = null;
        }
        View view = (View)videoViewInterface;
        if (view == null) {
            return;
        }
        View view2 = view;
        if (view2.getParent() != null) {
            return;
        }
        VideoViewInterface videoViewInterface2 = this.videoView;
        if (videoViewInterface2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.view.View");
        }
        this.addView((View)videoViewInterface2, (ViewGroup.LayoutParams)this.videoViewParams);
    }

    private final boolean changePlayerState(MediaPlayerState newState) {
        block1: {
            if (newState == this.playerState) {
                return false;
            }
            DebuggingKt.logDebug$default((Object)((Object)this), (String)("Changed Player state from " + (Object)((Object)this.playerState) + " to " + (Object)((Object)newState)), null, (int)2, null);
            this.playerState = newState;
            Function1<? super MediaPlayerState, Unit> function1 = this.playerStateChangeListener;
            if (function1 == null) break block1;
            Unit cfr_ignored_0 = (Unit)function1.invoke((Object)this.playerState);
        }
        return true;
    }

    public final boolean getCanPlay() {
        return this.playerState == MediaPlayerState.PREPARED || this.playerState == MediaPlayerState.PAUSED;
    }

    public final boolean getCanPause() {
        return this.playerState == MediaPlayerState.PREPARED || this.playerState == MediaPlayerState.PLAYING;
    }

    public final boolean getCanApplyFullscreen() {
        return this.getCanPlay() || this.getCanPause();
    }

    public final boolean isDestroyed() {
        return this.playerState == MediaPlayerState.DESTROYED;
    }

    public final void play() {
        if (!this.getCanPlay()) {
            return;
        }
        this.mediaPlayer.start();
        this.changePlayerState(MediaPlayerState.PLAYING);
    }

    public final void pause() {
        if (!this.getCanPause()) {
            return;
        }
        this.mediaPlayer.pause();
        this.changePlayerState(MediaPlayerState.PAUSED);
    }

    public final int getCurrentPosition() {
        int n;
        try {
            n = this.mediaPlayer.getCurrentPosition();
        }
        catch (Exception e) {
            e.printStackTrace();
            n = 0;
        }
        return n;
    }

    public final int getDuration() {
        int n;
        try {
            n = this.mediaPlayer.getDuration();
        }
        catch (Exception e) {
            e.printStackTrace();
            n = 0;
        }
        return n;
    }

    public final float getVolume() {
        return this.volume;
    }

    public final void setVolume(float value) {
        try {
            this.volume = value;
            this.mediaPlayer.setVolume(value, value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public final void destroy() {
        try {
            if (!this.changePlayerState(MediaPlayerState.DESTROYED)) {
                return;
            }
            this.mediaPlayer.reset();
            this.mediaPlayer.release();
            VideoViewInterface videoViewInterface = this.videoView;
            if (videoViewInterface != null) {
                VideoViewInterface videoViewInterface2;
                VideoViewInterface it = videoViewInterface2 = videoViewInterface;
                boolean bl = false;
                it.destroy();
                VideoViewInterface videoViewInterface3 = it;
                if (videoViewInterface3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type android.view.View");
                }
                this.removeView((View)videoViewInterface3);
                this.videoView = null;
            }
        }
        catch (Exception e) {
            StabilityHelper.logException((Object)((Object)this), (Throwable)e);
        }
    }

    public MobileFusePlayer(@NotNull Context context) {
        FrameLayout.LayoutParams layoutParams;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.playerState = MediaPlayerState.IDLE;
        this.mediaPlayer = new MediaPlayer();
        FrameLayout.LayoutParams layoutParams2 = layoutParams = new FrameLayout.LayoutParams(-1, -1);
        MobileFusePlayer mobileFusePlayer = this;
        boolean bl = false;
        $this$apply.gravity = 17;
        Unit unit = Unit.INSTANCE;
        mobileFusePlayer.videoViewParams = layoutParams;
        this.viewType = ViewType.SURFACE_VIEW;
        this.volume = 1.0f;
    }

    public static final /* synthetic */ boolean access$changePlayerState(MobileFusePlayer $this, MediaPlayerState newState) {
        return $this.changePlayerState(newState);
    }

    public static final /* synthetic */ void access$onMediaPlayerPrepared(MobileFusePlayer $this) {
        $this.onMediaPlayerPrepared();
    }

    public static final /* synthetic */ MediaPlayer access$getMediaPlayer$p(MobileFusePlayer $this) {
        return $this.mediaPlayer;
    }
}

