/*
 * Decompiled with CFR 0.152.
 */
package com.mobilefuse.videoplayer.media;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.media.MediaPlayer;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import com.mobilefuse.sdk.StabilityHelper;
import com.mobilefuse.videoplayer.media.VideoViewInterface;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0014J \u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u000fH\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J \u0010\u0018\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u000fH\u0016J\u0010\u0010\u0019\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/mobilefuse/videoplayer/media/MobileFuseVideoTextureView;", "Landroid/view/TextureView;", "Landroid/view/TextureView$SurfaceTextureListener;", "Lcom/mobilefuse/videoplayer/media/VideoViewInterface;", "context", "Landroid/content/Context;", "mediaPlayer", "Landroid/media/MediaPlayer;", "(Landroid/content/Context;Landroid/media/MediaPlayer;)V", "surface", "Landroid/view/Surface;", "destroy", "", "onMeasure", "widthMeasureSpec", "", "heightMeasureSpec", "onSurfaceTextureAvailable", "surfaceTexture", "Landroid/graphics/SurfaceTexture;", "width", "height", "onSurfaceTextureDestroyed", "", "onSurfaceTextureSizeChanged", "onSurfaceTextureUpdated", "mobilefuse-video-player_release"})
@SuppressLint(value={"ViewConstructor"})
public final class MobileFuseVideoTextureView
extends TextureView
implements TextureView.SurfaceTextureListener,
VideoViewInterface {
    private Surface surface;
    private final MediaPlayer mediaPlayer;

    public void onSurfaceTextureAvailable(@NotNull SurfaceTexture surfaceTexture, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)surfaceTexture, (String)"surfaceTexture");
        this.surface = new Surface(surfaceTexture);
        this.mediaPlayer.setSurface(this.surface);
    }

    public void onSurfaceTextureSizeChanged(@NotNull SurfaceTexture surfaceTexture, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)surfaceTexture, (String)"surfaceTexture");
        this.surface = new Surface(surfaceTexture);
        this.mediaPlayer.setSurface(this.surface);
    }

    public boolean onSurfaceTextureDestroyed(@NotNull SurfaceTexture surfaceTexture) {
        Intrinsics.checkNotNullParameter((Object)surfaceTexture, (String)"surfaceTexture");
        this.surface = null;
        return true;
    }

    public void onSurfaceTextureUpdated(@NotNull SurfaceTexture surfaceTexture) {
        Intrinsics.checkNotNullParameter((Object)surfaceTexture, (String)"surfaceTexture");
        this.surface = new Surface(surfaceTexture);
        this.mediaPlayer.setSurface(this.surface);
    }

    @Override
    public void destroy() {
        try {
            Surface surface = this.surface;
            if (surface != null) {
                surface.release();
            }
        }
        catch (Exception e) {
            StabilityHelper.logException((Object)this, (Throwable)e);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        try {
            int videoWidth = this.mediaPlayer.getVideoWidth();
            int videoHeight = this.mediaPlayer.getVideoHeight();
            int width = 0;
            int height = 0;
            if (videoWidth == 0 || videoHeight == 0) {
                width = TextureView.getDefaultSize((int)videoWidth, (int)widthMeasureSpec);
                height = TextureView.getDefaultSize((int)videoHeight, (int)heightMeasureSpec);
                this.setMeasuredDimension(width, height);
                return;
            }
            int widthSpecMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
            int widthSpecSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
            int heightSpecMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
            int heightSpecSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
            if (widthSpecMode == 0x40000000 && heightSpecMode == 0x40000000) {
                height = heightSpecSize;
                width = widthSpecSize;
                if (videoWidth * height < width * videoHeight) {
                    width = height * videoWidth / videoHeight;
                } else if (videoWidth * height > width * videoHeight) {
                    height = width * videoHeight / videoWidth;
                }
            } else if (widthSpecMode == 0x40000000) {
                width = widthSpecSize;
                height = width * videoHeight / videoWidth;
                if (heightSpecMode == Integer.MIN_VALUE && height > heightSpecSize) {
                    height = heightSpecSize | 0x1000000;
                }
            } else if (heightSpecMode == 0x40000000) {
                height = heightSpecSize;
                width = height * videoWidth / videoHeight;
                if (widthSpecMode == Integer.MIN_VALUE && width > widthSpecSize) {
                    width = widthSpecSize | 0x1000000;
                }
            } else {
                width = videoWidth;
                height = videoHeight;
                if (heightSpecMode == Integer.MIN_VALUE && height > heightSpecSize) {
                    height = heightSpecSize;
                    width = height * videoWidth / videoHeight;
                }
                if (widthSpecMode == Integer.MIN_VALUE && width > widthSpecSize) {
                    width = widthSpecSize;
                    height = width * videoHeight / videoWidth;
                }
            }
            this.setMeasuredDimension(width, height);
        }
        catch (Exception e) {
            StabilityHelper.logException((Object)this, (Throwable)e);
        }
    }

    public MobileFuseVideoTextureView(@NotNull Context context, @NotNull MediaPlayer mediaPlayer) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)mediaPlayer, (String)"mediaPlayer");
        super(context);
        this.mediaPlayer = mediaPlayer;
        this.setSurfaceTextureListener(this);
    }
}

