/*
 * Decompiled with CFR 0.152.
 */
package com.mobilefuse.videoplayer.model;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import com.mobilefuse.videoplayer.VideoPlayerSettings;
import com.mobilefuse.videoplayer.model.VastAd;
import com.mobilefuse.videoplayer.model.VastClickThrough;
import com.mobilefuse.videoplayer.model.VastCompanion;
import com.mobilefuse.videoplayer.model.VastCreative;
import com.mobilefuse.videoplayer.model.VastIcon;
import com.mobilefuse.videoplayer.model.VastLinear;
import com.mobilefuse.videoplayer.model.VastMediaFile;
import com.mobilefuse.videoplayer.model.VastMediaFileDelivery;
import com.mobilefuse.videoplayer.model.VastModel;
import com.mobilefuse.videoplayer.model.VastResourceType;
import com.mobilefuse.videoplayer.model.VastTag;
import com.mobilefuse.videoplayer.tracking.VastEventTracker;
import com.mobilefuse.videoplayer.utils.MediaUtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000z\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010(\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001c\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0000\u001a\u0018\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00030!*\u00020\u00102\u0006\u0010\"\u001a\u00020\u000f\u001a\u001e\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u001d*\u00020\u000b2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\u0001\u001a\u0014\u0010'\u001a\u0004\u0018\u00010\u0007*\u00020\u00102\u0006\u0010(\u001a\u00020\u0007\u001a \u0010)\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d*\u00020\u000b2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-\u001a*\u0010.\u001a\u00020/*\u0002002\u0006\u0010*\u001a\u00020+2\u0006\u00101\u001a\u0002022\u000e\u00103\u001a\n\u0012\u0004\u0012\u00020/\u0018\u000104\"\u001b\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\"\u0017\u0010\u0006\u001a\u0004\u0018\u00010\u0003*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\"\u0017\u0010\n\u001a\u0004\u0018\u00010\u000b*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\"\u0015\u0010\u000e\u001a\u00020\u000f*\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\"\u0015\u0010\u0013\u001a\u00020\u000f*\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\"\u0018\u0010\u0016\u001a\u00020\u000f*\u00020\u00178@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0018\"\u0015\u0010\u0019\u001a\u00020\u0007*\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u00065"}, d2={"allCreativesWithCompanionAds", "", "Lcom/mobilefuse/videoplayer/model/VastCreative;", "Lcom/mobilefuse/videoplayer/model/VastAd;", "getAllCreativesWithCompanionAds", "(Lcom/mobilefuse/videoplayer/model/VastAd;)Ljava/util/List;", "firstAd", "Lcom/mobilefuse/videoplayer/model/VastTag;", "getFirstAd", "(Lcom/mobilefuse/videoplayer/model/VastTag;)Lcom/mobilefuse/videoplayer/model/VastAd;", "firstAdLinear", "Lcom/mobilefuse/videoplayer/model/VastLinear;", "getFirstAdLinear", "(Lcom/mobilefuse/videoplayer/model/VastAd;)Lcom/mobilefuse/videoplayer/model/VastLinear;", "hasAdContentToPlay", "", "Lcom/mobilefuse/videoplayer/model/VastModel;", "getHasAdContentToPlay", "(Lcom/mobilefuse/videoplayer/model/VastModel;)Z", "hasAnyMediaFile", "getHasAnyMediaFile", "(Lcom/mobilefuse/videoplayer/model/VastLinear;)Z", "isValid", "Lcom/mobilefuse/videoplayer/model/VastCompanion;", "(Lcom/mobilefuse/videoplayer/model/VastCompanion;)Z", "mainVastTag", "getMainVastTag", "(Lcom/mobilefuse/videoplayer/model/VastModel;)Lcom/mobilefuse/videoplayer/model/VastTag;", "verifyMediaFiles", "", "Lcom/mobilefuse/videoplayer/model/VastMediaFile;", "mediaFiles", "getAdsChainIterator", "", "onlyParentAds", "getIcons", "Lcom/mobilefuse/videoplayer/model/VastIcon;", "excludedPrograms", "", "getParentTag", "tag", "getSupportedMediaFiles", "context", "Landroid/content/Context;", "containerSize", "", "openUrl", "", "Lcom/mobilefuse/videoplayer/model/VastClickThrough;", "eventTracker", "Lcom/mobilefuse/videoplayer/tracking/VastEventTracker;", "onOpenCallback", "Lkotlin/Function0;", "mobilefuse-video-player_release"})
public final class VastDataModelExtensionsKt {
    @NotNull
    public static final VastTag getMainVastTag(@NotNull VastModel $this$mainVastTag) {
        Intrinsics.checkNotNullParameter((Object)$this$mainVastTag, (String)"$this$mainVastTag");
        return (VastTag)CollectionsKt.first($this$mainVastTag.getVastTagChain());
    }

    @Nullable
    public static final VastTag getParentTag(@NotNull VastModel $this$getParentTag, @NotNull VastTag tag) {
        Intrinsics.checkNotNullParameter((Object)$this$getParentTag, (String)"$this$getParentTag");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        int index = $this$getParentTag.getVastTagChain().indexOf(tag) + 1;
        if (index >= $this$getParentTag.getVastTagChain().size()) {
            return null;
        }
        return $this$getParentTag.getVastTagChain().get(index);
    }

    public static final boolean getHasAdContentToPlay(@NotNull VastModel $this$hasAdContentToPlay) {
        Intrinsics.checkNotNullParameter((Object)$this$hasAdContentToPlay, (String)"$this$hasAdContentToPlay");
        for (VastTag tag : $this$hasAdContentToPlay.getVastTagChain()) {
            Object object = VastDataModelExtensionsKt.getFirstAd(tag);
            if (object == null || (object = VastDataModelExtensionsKt.getFirstAdLinear((VastAd)object)) == null) continue;
            if (!VastDataModelExtensionsKt.getHasAnyMediaFile((VastLinear)object)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static final Iterator<VastAd> getAdsChainIterator(@NotNull VastModel $this$getAdsChainIterator, boolean onlyParentAds) {
        Intrinsics.checkNotNullParameter((Object)$this$getAdsChainIterator, (String)"$this$getAdsChainIterator");
        return new Iterator<VastAd>($this$getAdsChainIterator, onlyParentAds){
            @Nullable
            private VastTag itAd;
            final /* synthetic */ VastModel $this_getAdsChainIterator;
            final /* synthetic */ boolean $onlyParentAds;

            @Nullable
            public final VastTag getItAd() {
                return this.itAd;
            }

            public final void setItAd(@Nullable VastTag vastTag) {
                this.itAd = vastTag;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean hasNext() {
                if (this.itAd == null) return false;
                VastTag vastTag = this.itAd;
                if (vastTag == null) return false;
                VastAd vastAd = VastDataModelExtensionsKt.getFirstAd(vastTag);
                if (vastAd == null) return false;
                return true;
            }

            @NotNull
            public VastAd next() {
                VastTag vastTag = this.itAd;
                Intrinsics.checkNotNull((Object)vastTag);
                VastTag adToReturn = vastTag;
                this.itAd = VastDataModelExtensionsKt.getParentTag(this.$this_getAdsChainIterator, adToReturn);
                VastAd vastAd = VastDataModelExtensionsKt.getFirstAd(adToReturn);
                Intrinsics.checkNotNull((Object)vastAd);
                return vastAd;
            }
            {
                this.$this_getAdsChainIterator = $receiver;
                this.$onlyParentAds = $captured_local_variable$1;
                this.itAd = $captured_local_variable$1 ? VastDataModelExtensionsKt.getParentTag(this.$this_getAdsChainIterator, VastDataModelExtensionsKt.getMainVastTag(this.$this_getAdsChainIterator)) : VastDataModelExtensionsKt.getMainVastTag(this.$this_getAdsChainIterator);
            }

            public void remove() {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }
        };
    }

    @Nullable
    public static final VastAd getFirstAd(@NotNull VastTag $this$firstAd) {
        Intrinsics.checkNotNullParameter((Object)$this$firstAd, (String)"$this$firstAd");
        return (VastAd)CollectionsKt.firstOrNull($this$firstAd.getAdList());
    }

    @Nullable
    public static final VastLinear getFirstAdLinear(@NotNull VastAd $this$firstAdLinear) {
        Intrinsics.checkNotNullParameter((Object)$this$firstAdLinear, (String)"$this$firstAdLinear");
        Object object = $this$firstAdLinear.getContent();
        if (object == null || (object = object.getCreativeList()) == null || object.isEmpty()) {
            return null;
        }
        for (VastCreative vastCreative : $this$firstAdLinear.getContent().getCreativeList()) {
            if (vastCreative.getLinear() == null) continue;
            return vastCreative.getLinear();
        }
        return null;
    }

    @NotNull
    public static final List<VastCreative> getAllCreativesWithCompanionAds(@NotNull VastAd $this$allCreativesWithCompanionAds) {
        Intrinsics.checkNotNullParameter((Object)$this$allCreativesWithCompanionAds, (String)"$this$allCreativesWithCompanionAds");
        List list = new ArrayList();
        Object object = $this$allCreativesWithCompanionAds.getContent();
        if (object == null || (object = object.getCreativeList()) == null || object.isEmpty()) {
            return list;
        }
        for (VastCreative vastCreative : $this$allCreativesWithCompanionAds.getContent().getCreativeList()) {
            Collection collection = vastCreative.getCompanionList();
            if (!(!collection.isEmpty())) continue;
            list.add(vastCreative);
        }
        return list;
    }

    public static final boolean getHasAnyMediaFile(@NotNull VastLinear $this$hasAnyMediaFile) {
        Intrinsics.checkNotNullParameter((Object)$this$hasAnyMediaFile, (String)"$this$hasAnyMediaFile");
        Collection collection = $this$hasAnyMediaFile.getMediaFiles();
        return !collection.isEmpty();
    }

    @NotNull
    public static final List<VastMediaFile> getSupportedMediaFiles(@NotNull VastLinear $this$getSupportedMediaFiles, @NotNull Context context, @NotNull int[] containerSize) {
        Intrinsics.checkNotNullParameter((Object)$this$getSupportedMediaFiles, (String)"$this$getSupportedMediaFiles");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)containerSize, (String)"containerSize");
        List list = new ArrayList();
        list.addAll((Collection)$this$getSupportedMediaFiles.getVerifiedMediaFiles());
        return MediaUtilsKt.enqueueMediaFilesByCompatibility(context, list, containerSize);
    }

    @NotNull
    public static final List<VastIcon> getIcons(@NotNull VastLinear $this$getIcons, @NotNull List<String> excludedPrograms) {
        Intrinsics.checkNotNullParameter((Object)$this$getIcons, (String)"$this$getIcons");
        Intrinsics.checkNotNullParameter(excludedPrograms, (String)"excludedPrograms");
        List list = new ArrayList();
        for (VastIcon icon : $this$getIcons.getIcons()) {
            Locale locale;
            if (icon.getProgram() == null || excludedPrograms.isEmpty()) {
                list.add(icon);
                continue;
            }
            String string = icon.getProgram();
            Intrinsics.checkNotNullExpressionValue((Object)Locale.getDefault(), (String)"Locale.getDefault()");
            String string2 = string.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(locale)");
            if (excludedPrograms.contains(string2)) continue;
            list.add(icon);
            string = icon.getProgram();
            Locale locale2 = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"Locale.getDefault()");
            locale = locale2;
            String string3 = string.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(locale)");
            excludedPrograms.add(string3);
        }
        return list;
    }

    @NotNull
    public static final List<VastMediaFile> verifyMediaFiles(@NotNull List<VastMediaFile> mediaFiles2) {
        Intrinsics.checkNotNullParameter(mediaFiles2, (String)"mediaFiles");
        List verifiedMediaFiles = new ArrayList();
        Set<String> supportedMimeTypes = VideoPlayerSettings.Companion.getSupportedVideoContainers();
        for (VastMediaFile mediaFile : mediaFiles2) {
            String string = mediaFile.getUrl();
            if (string == null) continue;
            CharSequence charSequence = string;
            if (!(charSequence.length() > 0)) {
                continue;
            }
            if (Intrinsics.areEqual((Object)VastMediaFileDelivery.PROGRESSIVE.getValue(), (Object)mediaFile.getDelivery()) ^ true || !CollectionsKt.contains((Iterable)supportedMimeTypes, (Object)mediaFile.getType())) continue;
            verifiedMediaFiles.add(mediaFile);
        }
        return verifiedMediaFiles;
    }

    public static final boolean isValid(@NotNull VastCompanion $this$isValid) {
        Intrinsics.checkNotNullParameter((Object)$this$isValid, (String)"$this$isValid");
        if ($this$isValid.getWidth() == null || $this$isValid.getHeight() == null) {
            return false;
        }
        if ($this$isValid.getResource() == null) {
            return false;
        }
        return $this$isValid.getResource().getResourceType() != VastResourceType.STATIC || $this$isValid.getClickThrough() != null;
    }

    public static final void openUrl(@NotNull VastClickThrough $this$openUrl, @NotNull Context context, @NotNull VastEventTracker eventTracker, @Nullable Function0<Unit> onOpenCallback) {
        Intrinsics.checkNotNullParameter((Object)$this$openUrl, (String)"$this$openUrl");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)eventTracker, (String)"eventTracker");
        String urlWithMacros = eventTracker.parseMacro($this$openUrl.getUrl(), null, null);
        if (onOpenCallback != null) {
            try {
                onOpenCallback.invoke();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        try {
            Uri uri = Uri.parse((String)urlWithMacros);
            Intent intent = new Intent("android.intent.action.VIEW", uri);
            intent.addFlags(0x10000000);
            context.startActivity(intent);
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            // empty catch block
        }
    }
}

