/*
 * Decompiled with CFR 0.152.
 */
package com.mobilefuse.videoplayer.model;

import com.mobilefuse.sdk.StabilityHelper;
import com.mobilefuse.videoplayer.model.utils.StringEncodingAndFormattingKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.math.MathKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001b"}, d2={"Lcom/mobilefuse/videoplayer/model/VastTime;", "", "formattedValue", "", "(Ljava/lang/String;)V", "getFormattedValue", "()Ljava/lang/String;", "isPercentageMode", "", "()Z", "percentageValue", "", "getPercentageValue", "()F", "valueInFloatSeconds", "getValueInFloatSeconds", "valueInMillis", "", "getValueInMillis", "()J", "valueInSeconds", "", "getValueInSeconds", "()I", "getValueInMillisForDuration", "duration", "Companion", "mobilefuse-video-player_release"})
public final class VastTime {
    private final long valueInMillis;
    private final int valueInSeconds;
    private final float valueInFloatSeconds;
    private final boolean isPercentageMode;
    private final float percentageValue;
    @NotNull
    private final String formattedValue;
    @NotNull
    public static final Companion Companion = new Companion(null);

    public final long getValueInMillis() {
        return this.valueInMillis;
    }

    public final int getValueInSeconds() {
        return this.valueInSeconds;
    }

    public final float getValueInFloatSeconds() {
        return this.valueInFloatSeconds;
    }

    public final boolean isPercentageMode() {
        return this.isPercentageMode;
    }

    public final float getPercentageValue() {
        return this.percentageValue;
    }

    public final long getValueInMillisForDuration(long duration) {
        return !this.isPercentageMode ? this.valueInMillis : (long)(this.percentageValue * (float)duration);
    }

    @NotNull
    public final String getFormattedValue() {
        return this.formattedValue;
    }

    private VastTime(String formattedValue) {
        this.formattedValue = formattedValue;
        if (StringsKt.endsWith$default((String)this.formattedValue, (String)"%", (boolean)false, (int)2, null)) {
            String tmpValue;
            this.isPercentageMode = true;
            this.valueInFloatSeconds = 0.0f;
            this.valueInSeconds = 0;
            this.valueInMillis = 0L;
            String string = tmpValue = StringsKt.replace$default((String)this.formattedValue, (String)"%", (String)"", (boolean)false, (int)4, null);
            this.percentageValue = Float.parseFloat(string) / 100.0f;
        } else {
            this.isPercentageMode = false;
            this.percentageValue = 0.0f;
            Long l = StringEncodingAndFormattingKt.formattedTimeToMillis(this.formattedValue);
            if (l == null) {
                throw (Throwable)new NumberFormatException("Can't format " + this.formattedValue + " to milliseconds");
            }
            this.valueInMillis = l;
            this.valueInFloatSeconds = (float)this.valueInMillis / 1000.0f;
            this.valueInSeconds = MathKt.roundToInt((float)this.valueInFloatSeconds);
        }
    }

    public /* synthetic */ VastTime(String formattedValue, DefaultConstructorMarker $constructor_marker) {
        this(formattedValue);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/mobilefuse/videoplayer/model/VastTime$Companion;", "", "()V", "create", "Lcom/mobilefuse/videoplayer/model/VastTime;", "formattedValue", "", "mobilefuse-video-player_release"})
    public static final class Companion {
        @Nullable
        public final VastTime create(@Nullable String formattedValue) {
            if (formattedValue == null) {
                return null;
            }
            CharSequence charSequence = formattedValue;
            if (charSequence.length() == 0) {
                return null;
            }
            try {
                return new VastTime(formattedValue, null);
            }
            catch (Throwable e) {
                StabilityHelper.logException((Object)this, (Throwable)e);
                return null;
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

