/*
 * Decompiled with CFR 0.152.
 */
package com.mobilefuse.videoplayer.model.utils;

import android.text.TextUtils;
import com.mobilefuse.sdk.StabilityHelper;
import com.mobilefuse.sdk.exception.Either;
import com.mobilefuse.sdk.exception.ErrorResult;
import com.mobilefuse.sdk.exception.ExceptionHandlingStrategy;
import com.mobilefuse.sdk.exception.SuccessResult;
import com.mobilefuse.videoplayer.model.EnumWithValue;
import com.mobilefuse.videoplayer.model.utils.StringEncodingAndFormattingKt$formattedTimeToMillis$$inlined$gracefullyHandleException$1$wm$TryKt$WhenMappings;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001\u001a\u0014\u0010\u0000\u001a\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00010\u0004\u001a\u0018\u0010\u0005\u001a\u00020\u00012\u0010\u0010\u0003\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0004\u001a\u0015\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\n\u001a\u0006\u0010\u000b\u001a\u00020\u0001\u001a\u000e\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\b\u00a8\u0006\u000e"}, d2={"encodeUriComponent", "", "value", "collection", "", "enumCollectionToString", "Lcom/mobilefuse/videoplayer/model/EnumWithValue;", "formattedTimeToMillis", "", "formattedTime", "(Ljava/lang/String;)Ljava/lang/Long;", "getIso8601Timestamp", "millisToFormattedTime", "millis", "mobilefuse-video-player_release"})
public final class StringEncodingAndFormattingKt {
    @NotNull
    public static final String encodeUriComponent(@NotNull String value) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        try {
            String string = URLEncoder.encode(value, "UTF-8");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"URLEncoder.encode(value, \"UTF-8\")");
            charSequence = string;
            String string2 = "\\+";
            string2 = new Regex(string2);
            String string3 = "%20";
            charSequence = string2.replace(charSequence, string3);
            string2 = "%21";
            string2 = new Regex(string2);
            string3 = "!";
            charSequence = string2.replace(charSequence, string3);
            string2 = "%27";
            string2 = new Regex(string2);
            string3 = "'";
            charSequence = string2.replace(charSequence, string3);
            string2 = "%28";
            string2 = new Regex(string2);
            string3 = "(";
            charSequence = string2.replace(charSequence, string3);
            string2 = "%29";
            string2 = new Regex(string2);
            string3 = ")";
            charSequence = string2.replace(charSequence, string3);
            string2 = "%7E";
            string2 = new Regex(string2);
            string3 = "~";
            charSequence = string2.replace(charSequence, string3);
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
            charSequence = value;
        }
        return charSequence;
    }

    @NotNull
    public static final String encodeUriComponent(@NotNull Collection<String> collection) {
        Intrinsics.checkNotNullParameter(collection, (String)"collection");
        if (collection.isEmpty()) {
            return "";
        }
        List encodedItems = new ArrayList();
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            encodedItems.add(StringEncodingAndFormattingKt.encodeUriComponent(it));
        }
        String string = TextUtils.join((CharSequence)",", (Iterable)encodedItems);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TextUtils.join(\",\", encodedItems)");
        return string;
    }

    @NotNull
    public static final String enumCollectionToString(@NotNull Collection<? extends EnumWithValue<?>> collection) {
        Intrinsics.checkNotNullParameter(collection, (String)"collection");
        if (collection.isEmpty()) {
            return "";
        }
        List values = new ArrayList();
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EnumWithValue it = (EnumWithValue)element$iv;
            boolean bl = false;
            values.add(it.getStringValue());
        }
        String string = TextUtils.join((CharSequence)",", (Iterable)values);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TextUtils.join(\",\", values)");
        return string;
    }

    @NotNull
    public static final String getIso8601Timestamp() {
        DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ", Locale.getDefault());
        String string = dateFormat.format(new Date());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dateFormat.format(Date())");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final Long formattedTimeToMillis(@NotNull String formattedTime) {
        Object object;
        Either either;
        Intrinsics.checkNotNullParameter((Object)formattedTime, (String)"formattedTime");
        boolean $i$f$gracefullyHandleException = false;
        String string = "[Automatically caught]";
        ExceptionHandlingStrategy strategy$iv$iv = ExceptionHandlingStrategy.LogAndIgnore;
        boolean $i$f$gracefullyHandleException2 = false;
        try {
            Long l;
            void $this$foldRight$iv;
            boolean bl = false;
            List formattedTimeParts = StringsKt.split$default((CharSequence)formattedTime, (String[])new String[]{"."}, (boolean)false, (int)0, (int)6, null);
            if (formattedTimeParts.isEmpty()) {
                return null;
            }
            Object object2 = (String)CollectionsKt.getOrNull((List)formattedTimeParts, (int)1);
            int millis = object2 != null && (object2 = StringsKt.toIntOrNull((String)object2)) != null ? (Integer)object2 : 0;
            List timeSlices = StringsKt.split$default((CharSequence)((CharSequence)formattedTimeParts.get(0)), (String[])new String[]{":"}, (boolean)false, (int)0, (int)6, null);
            if (timeSlices.isEmpty()) {
                return null;
            }
            List list = timeSlices;
            Pair initial$iv = new Pair((Object)1, (Object)0L);
            boolean $i$f$foldRight = false;
            Pair accumulator$iv = initial$iv;
            if (!$this$foldRight$iv.isEmpty()) {
                ListIterator iterator$iv = $this$foldRight$iv.listIterator($this$foldRight$iv.size());
                while (iterator$iv.hasPrevious()) {
                    void acc;
                    Pair pair = accumulator$iv;
                    String timeSlice = (String)iterator$iv.previous();
                    boolean bl2 = false;
                    String string2 = timeSlice;
                    int slice = Integer.parseInt(string2);
                    if (slice < 0) {
                        return null;
                    }
                    if (slice > 59) {
                        return null;
                    }
                    accumulator$iv = new Pair((Object)(((Number)acc.getFirst()).intValue() * 60), (Object)(((Number)acc.getSecond()).longValue() + (long)(slice * ((Number)acc.getFirst()).intValue())));
                }
            }
            Long l2 = l = Long.valueOf(((Number)accumulator$iv.getSecond()).longValue() * (long)1000 + (long)millis);
            either = (Either)new SuccessResult((Object)l2);
        }
        catch (Throwable e$iv$iv) {
            switch (StringEncodingAndFormattingKt$formattedTimeToMillis$$inlined$gracefullyHandleException$1$wm$TryKt$WhenMappings.$EnumSwitchMapping$1[strategy$iv$iv.ordinal()]) {
                case 1: {
                    void source$iv$iv;
                    StabilityHelper.logException((Object)source$iv$iv, (Throwable)e$iv$iv);
                }
            }
            either = (Either)new ErrorResult((Object)e$iv$iv);
        }
        Either $this$withErrorFallback$iv = either;
        boolean $i$f$withErrorFallback = false;
        Either either2 = $this$withErrorFallback$iv;
        if (either2 instanceof ErrorResult) {
            Throwable it = (Throwable)((ErrorResult)$this$withErrorFallback$iv).getValue();
            boolean bl = false;
            object = null;
        } else if (either2 instanceof SuccessResult) {
            object = ((SuccessResult)$this$withErrorFallback$iv).getValue();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return (Long)object;
    }

    @NotNull
    public static final String millisToFormattedTime(long millis) {
        DateFormat dateFormat = new SimpleDateFormat("HH:mm:ss.SSS", Locale.getDefault());
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        String string = dateFormat.format(millis);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dateFormat.format(millis)");
        return string;
    }
}

