/*
 * Decompiled with CFR 0.152.
 */
package com.mobilefuse.videoplayer.utils;

import android.content.Context;
import android.os.Build;
import android.os.StatFs;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mobilefuse.sdk.StabilityHelper;
import com.mobilefuse.sdk.crypto.Crypto;
import com.mobilefuse.videoplayer.utils.lrucache.DiskLruCache;
import com.mobilefuse.videoplayer.utils.lrucache.Util;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class DiskCacheUtil {
    private static final boolean CLEAR_CACHE_WHEN_INIT = true;
    private static boolean initialized;
    static final String MF_CACHE_DIR_NAME = "mobilefuse_lrucache";
    private static final int LRUCACHE_APP_VERSION = 1;
    private static final int LRUCACHE_VALUE_COUNT = 1;
    private static final int LRUCACHE_DISK_CACHE_INDEX = 0;
    private static DiskLruCache diskLruCache;
    private static final int MIN_DISK_CACHE_SIZE = 0x2600000;
    private static final int MAX_DISK_CACHE_SIZE = 0x7800000;

    private DiskCacheUtil() {
    }

    public static synchronized void initialize(Context context) {
        if (initialized) {
            return;
        }
        initialized = true;
        DiskCacheUtil.initLruDiskCache(context);
    }

    private static boolean initLruDiskCache(Context context) {
        if (context == null) {
            return false;
        }
        if (diskLruCache == null) {
            File cacheDirectory = DiskCacheUtil.getCacheDirectory(context);
            if (cacheDirectory == null) {
                return false;
            }
            try {
                Util.deleteContents(cacheDirectory);
            }
            catch (Throwable e) {
                StabilityHelper.logException(DiskCacheUtil.class, (Throwable)e);
            }
            long diskCacheSize = DiskCacheUtil.getCacheDirectorySize(cacheDirectory);
            try {
                diskLruCache = DiskLruCache.open(cacheDirectory, 1, 1, diskCacheSize);
            }
            catch (Throwable e) {
                StabilityHelper.logException(DiskCacheUtil.class, (Throwable)e);
                return false;
            }
        }
        return true;
    }

    private static long getCacheDirectorySize(File dir) {
        long deviceSize = 0x2600000L;
        try {
            StatFs statFs = new StatFs(dir.getAbsolutePath());
            long availableBytes = 0L;
            availableBytes = Build.VERSION.SDK_INT >= 18 ? statFs.getAvailableBytes() : (long)statFs.getAvailableBlocks() * (long)statFs.getBlockSize();
            deviceSize = availableBytes / 5L;
        }
        catch (IllegalArgumentException ex) {
            StabilityHelper.logException(DiskCacheUtil.class, (Throwable)ex);
        }
        return Math.max(0x2600000L, Math.min(0x7800000L, deviceSize));
    }

    private static String createFileCacheKey(String key) throws Throwable {
        return Crypto.sha1((String)key);
    }

    private static File getCacheDirectory(Context context) {
        File cacheDir = context.getCacheDir();
        if (cacheDir == null) {
            return null;
        }
        String cachePath = cacheDir.getPath();
        File mfCacheDir = new File(cachePath + File.separator + MF_CACHE_DIR_NAME);
        if (!mfCacheDir.exists()) {
            mfCacheDir.mkdirs();
        }
        return mfCacheDir;
    }

    public static synchronized String cacheFile(String key, InputStream content) {
        if (diskLruCache == null) {
            return null;
        }
        String cachedFileKey = null;
        DiskLruCache.Editor editor = null;
        try {
            cachedFileKey = DiskCacheUtil.createFileCacheKey(key);
            editor = diskLruCache.edit(cachedFileKey);
            if (editor == null) {
                return null;
            }
            BufferedOutputStream outputStream = new BufferedOutputStream(editor.newOutputStream(0));
            DiskCacheUtil.copyContent(content, outputStream);
            ((OutputStream)outputStream).flush();
            ((OutputStream)outputStream).close();
            diskLruCache.flush();
            editor.commit();
        }
        catch (Throwable e) {
            try {
                if (editor != null) {
                    editor.abort();
                }
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
            return null;
        }
        return cachedFileKey;
    }

    public static synchronized boolean deleteFile(String key) {
        String cachedFileKey = null;
        try {
            cachedFileKey = DiskCacheUtil.createFileCacheKey(key);
            if (diskLruCache == null) {
                return false;
            }
            diskLruCache.remove(cachedFileKey);
            diskLruCache.flush();
            return true;
        }
        catch (Throwable e) {
            StabilityHelper.logException(DiskCacheUtil.class, (Throwable)e);
            return false;
        }
    }

    public static synchronized boolean containsFileCache(String key) {
        if (diskLruCache == null) {
            return false;
        }
        try {
            DiskLruCache.Snapshot snapshot = diskLruCache.get(DiskCacheUtil.createFileCacheKey(key));
            return snapshot != null;
        }
        catch (Throwable e) {
            return false;
        }
    }

    @Nullable
    public static String getCachedFilePath(@NonNull String key) throws Throwable {
        if (diskLruCache == null) {
            return null;
        }
        return diskLruCache.getDirectory() + File.separator + DiskCacheUtil.createFileCacheKey(key) + "." + 0;
    }

    public static void closeStream(Closeable stream) {
        if (stream == null) {
            return;
        }
        try {
            stream.close();
        }
        catch (Throwable e) {
            StabilityHelper.logException(DiskCacheUtil.class, (Throwable)e);
        }
    }

    static void copyContent(InputStream inputStream, OutputStream outputStream) throws IOException {
        int length;
        if (inputStream == null || outputStream == null) {
            throw new IOException("A stream can't be null.");
        }
        byte[] buffer = new byte[16384];
        while ((length = inputStream.read(buffer)) != -1) {
            outputStream.write(buffer, 0, length);
        }
    }
}

