/*
 * Decompiled with CFR 0.152.
 */
package com.mobilefuse.videoplayer.utils;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Point;
import android.util.Pair;
import android.view.Display;
import android.view.WindowManager;
import com.mobilefuse.videoplayer.model.VastCompanion;
import com.mobilefuse.videoplayer.model.VastCreative;
import com.mobilefuse.videoplayer.model.VastMediaFile;
import com.mobilefuse.videoplayer.network.NetworkType;
import com.mobilefuse.videoplayer.network.NetworkUtils;
import com.mobilefuse.videoplayer.utils.MediaUtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000V\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0016\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a*\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000b2\u0006\u0010\f\u001a\u00020\u0005\u001a\u001c\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\bH\u0000\u001a\u000e\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0003\u001a\"\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\u000b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000b2\u0006\u0010\u0014\u001a\u00020\u0015\u001a4\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000e0\b2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000e0\b2\u0006\u0010\u0018\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u001aH\u0000\u001a4\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\t0\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000b2\u0006\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u001eH\u0002\u001a\u0018\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000e0\b*\b\u0012\u0004\u0012\u00020\u000e0\bH\u0000\u001a,\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000e0\b*\b\u0012\u0004\u0012\u00020\u000e0\b2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u001e0\"H\u0000\u001a0\u0010#\u001a\b\u0012\u0004\u0012\u00020\u000e0\b*\b\u0012\u0004\u0012\u00020\u000e0\b2\u0006\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001eH\u0000\u00a8\u0006$"}, d2={"convertFromDpToPixels", "", "context", "Landroid/content/Context;", "pixels", "", "convertFromPixelsToDp", "enqueueMediaFilesByCompatibility", "", "Lcom/mobilefuse/videoplayer/model/VastMediaFile;", "mediaFiles", "", "containerSize", "getAllCompanionsFromVastCreatives", "Lcom/mobilefuse/videoplayer/model/VastCompanion;", "creatives", "Lcom/mobilefuse/videoplayer/model/VastCreative;", "getScreenSizeAsDp", "getScreenSizeAsPixels", "removeMediaFilesWithHigherBitrate", "bitrateLimit", "", "selectEndCardCompanions", "companions", "maxCompanionsNumToSelect", "screenDensity", "", "sortMediaFilesByPlayerSizeProximity", "playerContainerSize", "usePixels", "", "getMultipleExplicitEndCardsOrSingle", "preferCompanionAds", "block", "Lkotlin/Function1;", "sortCompanionAdsByPlayerSizeProximity", "mobilefuse-video-player_release"})
public final class MediaUtilsKt {
    /*
     * WARNING - void declaration
     */
    public static final void convertFromPixelsToDp(@NotNull Context context, @NotNull int[] pixels) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)pixels, (String)"pixels");
        Resources resources = context.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"context.resources");
        float scale = resources.getDisplayMetrics().density;
        int n = 0;
        int n2 = pixels.length;
        while (n < n2) {
            void i;
            pixels[i] = (int)((float)pixels[i] / scale + 0.5f);
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void convertFromDpToPixels(@NotNull Context context, @NotNull int[] pixels) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)pixels, (String)"pixels");
        Resources resources = context.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"context.resources");
        float scale = resources.getDisplayMetrics().density;
        int n = 0;
        int n2 = pixels.length;
        while (n < n2) {
            void i;
            pixels[i] = (int)((float)pixels[i] * scale + 0.5f);
            ++i;
        }
    }

    @NotNull
    public static final int[] getScreenSizeAsPixels(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("window");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.view.WindowManager");
        }
        WindowManager windowManager = (WindowManager)object;
        Display d = windowManager.getDefaultDisplay();
        Point p = new Point();
        d.getSize(p);
        return new int[]{p.x, p.y};
    }

    @NotNull
    public static final int[] getScreenSizeAsDp(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        int[] screenSize = MediaUtilsKt.getScreenSizeAsPixels(context);
        MediaUtilsKt.convertFromPixelsToDp(context, screenSize);
        return screenSize;
    }

    @NotNull
    public static final List<VastMediaFile> enqueueMediaFilesByCompatibility(@NotNull Context context, @NotNull List<VastMediaFile> mediaFiles2, @NotNull int[] containerSize) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(mediaFiles2, (String)"mediaFiles");
        Intrinsics.checkNotNullParameter((Object)containerSize, (String)"containerSize");
        int bitrateKbpsCeil480p = 2000;
        List<VastMediaFile> sortedMediaFiles = null;
        NetworkType networkType = NetworkUtils.INSTANCE.getNetworkType(context);
        boolean bitratesAreKnown = true;
        int topBitrate = 0;
        for (VastMediaFile mediaFile : mediaFiles2) {
            if (mediaFile.getBitrate() == null || mediaFile.getBitrate() < 32) {
                bitratesAreKnown = false;
                topBitrate = 0;
                break;
            }
            if (mediaFile.getBitrate() <= topBitrate) continue;
            topBitrate = mediaFile.getBitrate();
        }
        if (networkType == NetworkType.MOBILE_5G) {
            return MediaUtilsKt.sortMediaFilesByPlayerSizeProximity(context, mediaFiles2, containerSize, true);
        }
        if (networkType == NetworkType.WIFI) {
            return MediaUtilsKt.sortMediaFilesByPlayerSizeProximity(context, mediaFiles2, containerSize, false);
        }
        if (networkType == NetworkType.MOBILE_4G) {
            List<VastMediaFile> rejectedMediaFilesByBitrate;
            if (!bitratesAreKnown || topBitrate < bitrateKbpsCeil480p) {
                return MediaUtilsKt.sortMediaFilesByPlayerSizeProximity(context, mediaFiles2, containerSize, false);
            }
            sortedMediaFiles = new ArrayList(mediaFiles2);
            List<VastMediaFile> $this$sortBy$iv = rejectedMediaFilesByBitrate = MediaUtilsKt.removeMediaFilesWithHigherBitrate(sortedMediaFiles, bitrateKbpsCeil480p);
            boolean $i$f$sortBy = false;
            if ($this$sortBy$iv.size() > 1) {
                CollectionsKt.sortWith($this$sortBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        VastMediaFile it = (VastMediaFile)a;
                        boolean bl = false;
                        Comparable comparable = it.getBitrate();
                        it = (VastMediaFile)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        Integer n = it.getBitrate();
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
                    }
                });
            }
            sortedMediaFiles = MediaUtilsKt.sortMediaFilesByPlayerSizeProximity(context, sortedMediaFiles, containerSize, false);
            sortedMediaFiles.addAll((Collection<VastMediaFile>)rejectedMediaFilesByBitrate);
            return sortedMediaFiles;
        }
        if (networkType == null || networkType == NetworkType.UNKNOWN || networkType == NetworkType.MOBILE_2G || networkType == NetworkType.MOBILE_3G) {
            List<VastMediaFile> $this$sortBy$iv;
            if (bitratesAreKnown) {
                $this$sortBy$iv = mediaFiles2;
                boolean $i$f$sortBy = false;
                if ($this$sortBy$iv.size() > 1) {
                    CollectionsKt.sortWith($this$sortBy$iv, (Comparator)new Comparator(){

                        public final int compare(T a, T b) {
                            VastMediaFile it = (VastMediaFile)a;
                            boolean bl = false;
                            Comparable comparable = it.getBitrate();
                            it = (VastMediaFile)b;
                            Comparable comparable2 = comparable;
                            bl = false;
                            Integer n = it.getBitrate();
                            return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
                        }
                    });
                }
            } else {
                $this$sortBy$iv = mediaFiles2;
                boolean $i$f$sortBy = false;
                if ($this$sortBy$iv.size() > 1) {
                    CollectionsKt.sortWith($this$sortBy$iv, (Comparator)new Comparator(){

                        public final int compare(T a, T b) {
                            VastMediaFile it = (VastMediaFile)a;
                            boolean bl = false;
                            Comparable comparable = it.getPixelsCount();
                            it = (VastMediaFile)b;
                            Comparable comparable2 = comparable;
                            bl = false;
                            Integer n = it.getPixelsCount();
                            return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
                        }
                    });
                }
            }
            return mediaFiles2;
        }
        return MediaUtilsKt.sortMediaFilesByPlayerSizeProximity(context, mediaFiles2, containerSize, false);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<VastMediaFile> sortMediaFilesByPlayerSizeProximity(Context context, List<VastMediaFile> mediaFiles2, int[] playerContainerSize, boolean usePixels) {
        void $this$mapTo$iv$iv;
        Resources resources;
        float scaleFactor = usePixels ? 1.0f : ((resources = context.getResources()) != null && (resources = resources.getDisplayMetrics()) != null ? resources.density : 1.0f);
        float containerWidth = (float)playerContainerSize[0] / scaleFactor;
        float containerHeight = (float)playerContainerSize[1] / scaleFactor;
        float containerRatio = containerWidth / containerHeight;
        float sizeProximity = 0.0f;
        Pair proximityItem = null;
        List proximityItems = new ArrayList();
        for (VastMediaFile mediaFile : mediaFiles2) {
            if (mediaFile.getWidth() == null || mediaFile.getHeight() == null) continue;
            float f = containerWidth - (float)mediaFile.getWidth().intValue();
            float f2 = Math.abs(f);
            f = containerHeight - (float)mediaFile.getHeight().intValue();
            float f3 = f2 + Math.abs(f);
            f = containerRatio - mediaFile.getSizeRatio();
            sizeProximity = f3 * Math.abs(f);
            proximityItem = new Pair((Object)Float.valueOf(sizeProximity), (Object)mediaFile);
            proximityItems.add(proximityItem);
        }
        List $this$sortBy$iv = proximityItems;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Pair it = (Pair)a;
                    boolean bl = false;
                    it = (Pair)b;
                    Comparable comparable = (Float)it.first;
                    bl = false;
                    Float f = (Float)it.first;
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)f);
                }
            });
        }
        Iterable $this$map$iv = proximityItems;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            VastMediaFile vastMediaFile = (VastMediaFile)it.second;
            collection.add(vastMediaFile);
        }
        return TypeIntrinsics.asMutableList((Object)((List)destination$iv$iv));
    }

    @NotNull
    public static final List<VastMediaFile> removeMediaFilesWithHigherBitrate(@NotNull List<VastMediaFile> mediaFiles2, int bitrateLimit) {
        Intrinsics.checkNotNullParameter(mediaFiles2, (String)"mediaFiles");
        List removedMediaFiles = new ArrayList();
        Iterable $this$forEach$iv = CollectionsKt.reversed((Iterable)mediaFiles2);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VastMediaFile it = (VastMediaFile)element$iv;
            boolean bl = false;
            if (it.getBitrate() == null || it.getBitrate() <= bitrateLimit) continue;
            removedMediaFiles.add(it);
            mediaFiles2.remove(it);
        }
        return removedMediaFiles;
    }

    @NotNull
    public static final List<VastCompanion> selectEndCardCompanions(@NotNull List<VastCompanion> companions, int maxCompanionsNumToSelect, @NotNull int[] containerSize, float screenDensity) {
        Intrinsics.checkNotNullParameter(companions, (String)"companions");
        Intrinsics.checkNotNullParameter((Object)containerSize, (String)"containerSize");
        if (companions.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        if (containerSize.length != 2) {
            return CollectionsKt.emptyList();
        }
        return MediaUtilsKt.getMultipleExplicitEndCardsOrSingle(CollectionsKt.take((Iterable)MediaUtilsKt.preferCompanionAds(MediaUtilsKt.preferCompanionAds(MediaUtilsKt.sortCompanionAdsByPlayerSizeProximity(companions, containerSize, screenDensity, true), (Function1<? super VastCompanion, Boolean>)((Function1)selectEndCardCompanions.1.INSTANCE)), (Function1<? super VastCompanion, Boolean>)((Function1)selectEndCardCompanions.2.INSTANCE)), (int)maxCompanionsNumToSelect));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<VastCompanion> getMultipleExplicitEndCardsOrSingle(@NotNull List<VastCompanion> $this$getMultipleExplicitEndCardsOrSingle) {
        Collection collection;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$getMultipleExplicitEndCardsOrSingle, (String)"$this$getMultipleExplicitEndCardsOrSingle");
        List<VastCompanion> companions = $this$getMultipleExplicitEndCardsOrSingle;
        Iterable $this$filter$iv = companions;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VastCompanion it = (VastCompanion)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getRenderingMode(), (Object)"end-card")) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List explicitEndCardCompanions = (List)destination$iv$iv;
        Collection collection2 = explicitEndCardCompanions;
        if (collection2.isEmpty()) {
            boolean bl = false;
            collection = CollectionsKt.take((Iterable)companions, (int)1);
        } else {
            collection = collection2;
        }
        return (List)collection;
    }

    @NotNull
    public static final List<VastCompanion> getAllCompanionsFromVastCreatives(@NotNull List<VastCreative> creatives) {
        Intrinsics.checkNotNullParameter(creatives, (String)"creatives");
        List companionList = new ArrayList();
        for (VastCreative creative : creatives) {
            if (creative.getCompanionList().isEmpty()) continue;
            companionList.addAll((Collection)creative.getCompanionList());
        }
        return companionList;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<VastCompanion> sortCompanionAdsByPlayerSizeProximity(@NotNull List<VastCompanion> $this$sortCompanionAdsByPlayerSizeProximity, @NotNull int[] playerContainerSize, float screenDensity, boolean usePixels) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$sortCompanionAdsByPlayerSizeProximity, (String)"$this$sortCompanionAdsByPlayerSizeProximity");
        Intrinsics.checkNotNullParameter((Object)playerContainerSize, (String)"playerContainerSize");
        float scaleFactor = usePixels ? 1.0f : screenDensity;
        float containerWidth = (float)playerContainerSize[0] / scaleFactor;
        float containerHeight = (float)playerContainerSize[1] / scaleFactor;
        float containerRatio = containerWidth / containerHeight;
        float sizeProximity = 0.0f;
        Pair proximityItem = null;
        List proximityItems = new ArrayList();
        int itemWidth = 0;
        int itemHeight = 0;
        float sizeRatio = 0.0f;
        for (VastCompanion item : $this$sortCompanionAdsByPlayerSizeProximity) {
            if (item.getWidth() == null || item.getHeight() == null) continue;
            itemWidth = item.getWidth();
            if (item.getAssetWidth() != null && item.getAssetWidth() > 0) {
                itemWidth = item.getAssetWidth();
            }
            itemHeight = item.getHeight();
            if (item.getAssetHeight() != null && item.getAssetHeight() > 0) {
                itemHeight = item.getAssetHeight();
            }
            sizeRatio = (float)itemWidth / (float)itemHeight;
            float f = containerWidth - (float)itemWidth;
            float f2 = Math.abs(f);
            f = containerHeight - (float)itemHeight;
            float f3 = f2 + Math.abs(f);
            f = containerRatio - sizeRatio;
            sizeProximity = f3 * Math.abs(f);
            proximityItem = new Pair((Object)Float.valueOf(sizeProximity), (Object)item);
            proximityItems.add(proximityItem);
        }
        List $this$sortBy$iv = proximityItems;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Pair it = (Pair)a;
                    boolean bl = false;
                    it = (Pair)b;
                    Comparable comparable = (Float)it.first;
                    bl = false;
                    Float f = (Float)it.first;
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)f);
                }
            });
        }
        Iterable $this$map$iv = proximityItems;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            VastCompanion vastCompanion = (VastCompanion)it.second;
            collection.add(vastCompanion);
        }
        return TypeIntrinsics.asMutableList((Object)((List)destination$iv$iv));
    }

    @NotNull
    public static final List<VastCompanion> preferCompanionAds(@NotNull List<VastCompanion> $this$preferCompanionAds, @NotNull Function1<? super VastCompanion, Boolean> block) {
        Intrinsics.checkNotNullParameter($this$preferCompanionAds, (String)"$this$preferCompanionAds");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        List removedItems = new ArrayList();
        List list = new ArrayList();
        Iterable $this$forEach$iv = $this$preferCompanionAds;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Collection collection;
            VastCompanion it = (VastCompanion)element$iv;
            boolean bl = false;
            if (((Boolean)block.invoke((Object)it)).booleanValue()) {
                collection = list;
                collection.add(it);
                continue;
            }
            collection = removedItems;
            collection.add(it);
        }
        Collection collection = list;
        CollectionsKt.addAll((Collection)collection, (Iterable)removedItems);
        return list;
    }
}

