/*
 * Decompiled with CFR 0.152.
 */
package com.mobileia.mcdropdownmenu;

import android.content.Context;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.PopupWindow;
import android.widget.RelativeLayout;
import com.mobileia.mcdropdownmenu.OnMenuSelectedListener;
import com.mobileia.mcdropdownmenu.R;

public class MCDropdownMenu
extends RelativeLayout {
    private int mLayoutMainView = R.layout.main_view;
    private PopupWindow mPopupWindow = null;
    private ListView mListView = null;
    private OnMenuSelectedListener mListener = null;

    private void init() {
        this.initMainView();
        this.initOnClick();
        this.initPopupWindow();
    }

    private void initMainView() {
        this.removeAllViews();
        View mainView = LayoutInflater.from((Context)this.getContext()).inflate(this.mLayoutMainView, null);
        this.addView(mainView);
    }

    private void initOnClick() {
        this.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (MCDropdownMenu.this.mPopupWindow != null) {
                    MCDropdownMenu.this.mPopupWindow.showAsDropDown((View)MCDropdownMenu.this);
                }
            }
        });
    }

    private void initPopupWindow() {
        View popupView = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.popup_view, null);
        this.mPopupWindow = new PopupWindow(popupView, -1, -2, true);
        this.mPopupWindow.setTouchable(true);
        this.mPopupWindow.setOutsideTouchable(true);
        this.mPopupWindow.setBackgroundDrawable((Drawable)new BitmapDrawable());
        this.mListView = (ListView)popupView.findViewById(R.id.listView);
        this.mListView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> adapterView, View view, int position, long l) {
                if (MCDropdownMenu.this.mListener != null) {
                    MCDropdownMenu.this.mListener.onSelected((View)adapterView, position);
                }
            }
        });
        this.mListView.setDivider(null);
    }

    public void dismiss() {
        this.mPopupWindow.dismiss();
    }

    public void setLayoutMainView(int resource) {
        this.mLayoutMainView = resource;
        this.initMainView();
    }

    public void setAdapter(BaseAdapter adapter) {
        this.mListView.setAdapter((ListAdapter)adapter);
    }

    public void setOnMenuSelectedListener(OnMenuSelectedListener listener) {
        this.mListener = listener;
    }

    public ListView getListView() {
        return this.mListView;
    }

    public MCDropdownMenu(Context context) {
        super(context);
        this.init();
    }

    public MCDropdownMenu(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public MCDropdownMenu(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }
}

