/*
 * Decompiled with CFR 0.152.
 */
package org.squirrelframework.foundation.component;

import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.squirrelframework.foundation.component.SquirrelComponent;
import org.squirrelframework.foundation.component.SquirrelProvider;
import org.squirrelframework.foundation.component.SquirrelSingleton;

public class SquirrelSingletonProvider
implements SquirrelComponent,
SquirrelSingleton {
    private static SquirrelSingletonProvider instance = new SquirrelSingletonProvider();
    private Map<String, Object> instanceRegistry = new ConcurrentHashMap<String, Object>();

    public static SquirrelSingletonProvider getInstance() {
        return instance;
    }

    public static void setInstance(SquirrelSingletonProvider squirrelSingletonProvider) {
        instance = squirrelSingletonProvider;
    }

    public <T> void register(Class<T> clazz, Object object) {
        Preconditions.checkArgument((boolean)clazz.isAssignableFrom(object.getClass()));
        this.instanceRegistry.put(clazz.getName(), object);
    }

    public void unregister(Class<?> clazz) {
        this.instanceRegistry.remove(clazz.getName());
    }

    public void clearRegistry() {
        this.instanceRegistry.clear();
    }

    public <T> T get(Class<T> clazz) {
        Object object = this.instanceRegistry.get(clazz.getName());
        if (object == null) {
            try {
                object = SquirrelProvider.getInstance().newInstance(clazz);
            }
            catch (Exception exception) {
                object = null;
            }
            if (object != null) {
                this.register(clazz, object);
            }
        }
        return object != null ? (T)clazz.cast(object) : null;
    }
}

